/* %Z%%Q% */
/* %Z%$RCSfile: sdebug.h,v $ version $Revision: #3 $ created $Date: 2001/08/28 $ */

#ifndef sdebugINCLUDED
#define sdebugINCLUDED 1

/* Pre-requisite includes go here. */
#include <stdio.h>

#include <errno.h>   
#include "local_os.h"
#if !defined(_MSC_VER) && !defined(LINUX)
/* Already declared...don't need to redeclare. */
extern int sys_nerr;
extern char *sys_errlist[];
#endif

#ifdef sdebugDEFINE
#define INIT(x) = x
#define vextern
#else
#define INIT(x)
#define vextern extern
#endif /* sdebugDEFINE */

#define TraceOFF(m) 0

#ifdef DEBUG    /*(*/
#define TRACEBUF_LEN 2048

#ifdef sdebugTraceGlobal
#define sdebugTraceScope vextern
#define INITScope(x) INIT(x)
#else
#define sdebugTraceScope static
#define INITScope(x) = x
#endif

sdebugTraceScope char tracebuf[TRACEBUF_LEN];

#ifdef wtrsendINCLUDED  /*(*/
/* NOTE: wtrsend.h is a Windows tracing aid of mine that might actually */
/*       make it into the qpe source tree one of these days...  -Scott */

static char wtraceBuffer[TRACEBUF_LEN];

#define S_assert(ex) \
if (!(ex)) sprintf (wtraceBuffer,"Assertion failed: file \"%s\", line %d\n", \
                    __FILE__, __LINE__), \
           wtrace_send(wtraceBuffer, 1), exit(1)

#define TraceFMT1(fmt,a1) \
sprintf (wtraceBuffer,(fmt),(a1)), wtrace_send(wtraceBuffer, 1)
#define TraceFMT2(fmt,a1,a2) \
sprintf (wtraceBuffer,(fmt),(a1),(a2)), wtrace_send(wtraceBuffer, 1)
#define TraceFMT3(fmt,a1,a2,a3) \
sprintf (wtraceBuffer,(fmt),(a1),(a2),(a3)), wtrace_send(wtraceBuffer, 1)
#define TraceFMT4(fmt,a1,a2,a3,a4) \
sprintf (wtraceBuffer,(fmt),(a1),(a2),(a3),(a4)), wtrace_send(wtraceBuffer, 1)
#define TraceFMT5(fmt,a1,a2,a3,a4,a5) \
sprintf (wtraceBuffer,(fmt),(a1),(a2),(a3),(a4),(a5)), wtrace_send(wtraceBuffer, 1)

/* NOTE: Use of 'wsprintf' assumes Windows compiler.  If ported to UNIX/X */
/*       or something, #define it to 'sprintf' instead. */

/* I THINK the wsprintf needs to be used with Windows LPSTR types and the like. */
#define WTraceFMT1(fmt,a1) \
wsprintf (wtraceBuffer,(fmt),(a1)), wtrace_send(wtraceBuffer, 1)
#define WTraceFMT2(fmt,a1,a2) \
wsprintf (wtraceBuffer,(fmt),(a1),(a2)), wtrace_send(wtraceBuffer, 1)
#define WTraceFMT3(fmt,a1,a2,a3) \
wsprintf (wtraceBuffer,(fmt),(a1),(a2),(a3)), wtrace_send(wtraceBuffer, 1)
#define WTraceFMT4(fmt,a1,a2,a3,a4) \
wsprintf (wtraceBuffer,(fmt),(a1),(a2),(a3),(a4)), wtrace_send(wtraceBuffer, 1)
#define WTraceFMT5(fmt,a1,a2,a3,a4,a5) \
wsprintf (wtraceBuffer,(fmt),(a1),(a2),(a3),(a4),(a5)), wtrace_send(wtraceBuffer, 1)

#else   /*)(*/
 
sdebugTraceScope FILE *trace_outfile INITScope(stderr);
#define S_assert(ex) \
if (!(ex)) fprintf (trace_outfile,"Assertion failed: file \"%s\", line %d\n", \
                    __FILE__, __LINE__), fflush(trace_outfile), exit(1)

#define TraceFMT1(fmt,a1) \
fprintf(trace_outfile,(fmt),(a1))
#define TraceFMT2(fmt,a1,a2) \
fprintf(trace_outfile,(fmt),(a1),(a2))
#define TraceFMT3(fmt,a1,a2,a3) \
fprintf(trace_outfile,(fmt),(a1),(a2),(a3))
#define TraceFMT4(fmt,a1,a2,a3,a4) \
fprintf(trace_outfile,(fmt),(a1),(a2),(a3),(a4))
#define TraceFMT5(fmt,a1,a2,a3,a4,a5) \
fprintf(trace_outfile,(fmt),(a1),(a2),(a3),(a4),(a5))

#define WTraceFMT1 TraceFMT1
#define WTraceFMT2 TraceFMT2
#define WTraceFMT3 TraceFMT3
#define WTraceFMT4 TraceFMT4
#define WTraceFMT5 TraceFMT5

#endif /* ) wtrsendINCLUDED */

#else
#define S_assert(ex)
#define TraceFMT1(fmt,a1) TraceOFF(fmt)
#define TraceFMT2(fmt,a1,a2) TraceOFF(fmt)
#define TraceFMT3(fmt,a1,a2,a3) TraceOFF(fmt)
#define TraceFMT4(fmt,a1,a2,a3,a4) TraceOFF(fmt)
#define TraceFMT5(fmt,a1,a2,a3,a4,a5) TraceOFF(fmt)
#define WTraceFMT1 TraceFMT1
#define WTraceFMT2 TraceFMT2
#define WTraceFMT3 TraceFMT3
#define WTraceFMT4 TraceFMT4
#define WTraceFMT5 TraceFMT5
#endif /* ) DEBUG */

#define TraceHDR(m) TraceFMT3("%s:%d:%s",__FILE__,__LINE__,(m))
#define TraceNoNL(m) TraceFMT1("%s",(m))
#define TraceSPC(m) TraceFMT1(" %s",(m))
#define TraceSTR(m,str) TraceFMT2(" %s=%s;",(m),(str))
#define TraceINT(m,num) TraceFMT2(" %s=%d;",(m),(num))
#define TraceXINT(m,num) TraceFMT2(" %s=0x%x;",(m),(num))
#define TraceNL(m) TraceFMT1("%s\n",(m))
#define Trace(m) TraceHDR(m),TraceNL("")
#define TraceHDR1(m,fmt,a1) \
TraceHDR((m)), TraceFMT1((fmt),(a1))
#define TraceHDR2(m,fmt,a1,a2) \
TraceHDR((m)), TraceFMT2((fmt),(a1),(a2))
#define TraceHDR3(m,fmt,a1,a2,a3) \
TraceHDR((m)), TraceFMT3((fmt),(a1),(a2),(a3))
#define TraceHDR4(m,fmt,a1,a2,a3,a4) \
TraceHDR((m)), TraceFMT4((fmt),(a1),(a2),(a3),(a4))
#define TraceHDR5(m,fmt,a1,a2,a3,a4,a5) \
TraceHDR((m)), TraceFMT5((fmt),(a1),(a2),(a3),(a4),(a5))
#define Trace1(fmt,a1) \
TraceHDR1("",(fmt),(a1)), TraceNL("")
#define Trace2(fmt,a1,a2) \
TraceHDR2("",(fmt),(a1),(a2)), TraceNL("")
#define Trace3(fmt,a1,a2,a3) \
TraceHDR3("",(fmt),(a1),(a2),(a3)), TraceNL("")
#define Trace4(fmt,a1,a2,a3,a4) \
TraceHDR4("",(fmt),(a1),(a2),(a3),(a4)), TraceNL("")
#define Trace5(fmt,a1,a2,a3,a4,a5) \
TraceHDR5("",(fmt),(a1),(a2),(a3),(a4),(a5)), TraceNL("")

#define WTraceHDR1(m,fmt,a1) \
TraceHDR((m)), WTraceFMT1((fmt),(a1))
#define WTraceHDR2(m,fmt,a1,a2) \
TraceHDR((m)), WTraceFMT2((fmt),(a1),(a2))
#define WTraceHDR3(m,fmt,a1,a2,a3) \
TraceHDR((m)), WTraceFMT3((fmt),(a1),(a2),(a3))
#define WTraceHDR4(m,fmt,a1,a2,a3,a4) \
TraceHDR((m)), WTraceFMT4((fmt),(a1),(a2),(a3),(a4))
#define WTraceHDR5(m,fmt,a1,a2,a3,a4,a5) \
TraceHDR((m)), WTraceFMT5((fmt),(a1),(a2),(a3),(a4),(a5))
#define WTrace1(fmt,a1) \
WTraceHDR1("",(fmt),(a1)), TraceNL("")
#define WTrace2(fmt,a1,a2) \
WTraceHDR2("",(fmt),(a1),(a2)), TraceNL("")
#define WTrace3(fmt,a1,a2,a3) \
WTraceHDR3("",(fmt),(a1),(a2),(a3)), TraceNL("")
#define WTrace4(fmt,a1,a2,a3,a4) \
WTraceHDR4("",(fmt),(a1),(a2),(a3),(a4)), TraceNL("")
#define WTrace5(fmt,a1,a2,a3,a4,a5) \
WTraceHDR5("",(fmt),(a1),(a2),(a3),(a4),(a5)), TraceNL("")

#ifdef DEBUG  /*(*/
static int Terrno;
#define TracePerror(m) Terrno=errno, \
TraceHDR(m), \
TraceNoNL((Terrno >= 0 && Terrno < sys_nerr) ? sys_errlist[Terrno] : ""), \
TraceNoNL((sprintf(tracebuf,(Terrno >= 0 && Terrno < sys_nerr) ? \
                   "" : "unk errno=%d",Terrno), tracebuf)), \
TraceNL(""), \
((trace_outfile != stderr) ? \
 fprintf(stderr,"%s",(Terrno >= 0 && Terrno < sys_nerr) ? sys_errlist[Terrno] : "")\
 : 0)
#else
#define TracePerror(m) perror(m)
#endif /* ) DEBUG */

#undef INIT
#undef vextern

/* Sub-includes go here. */

#endif /* sdebugINCLUDED */
