/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: signed.h,v $: $Revision: #22 $, $Date: 2006/06/26 $  */
#ifndef _S_SIGNED_H_
#define _S_SIGNED_H_
#include <local_os.h>

#define is_signed(a,m) test_sign((char *)(a),m)
#if !defined(WIN32) && !defined(NEXTM) /*(*/
#if !defined(APOLLO)
#include <values.h>
#else
#include "/sys5.3/usr/include/values.h"
#endif
#endif /*)*/


/* Following depends on 2's complement for integers - so INTEGER_MAX+1 is
 * INTEGER_MIN (this latter should be defined in machine.h.
 *
 * SAB 93.06.29 Don't rely on compiler's integer overflow behavior. Changed on
 *              recommendation from Rag.
 */

#ifndef INTEGER_MIN
#define INTEGER_MIN (-INTEGER_MAX-1L)
#endif

#ifdef HAS_64BIT_LONG
#define INTEGER32_MAX 2147483647
#endif

#if defined(MIPSEL) || defined(vax) || defined(i386) || defined(OSF1_DECALPHA)
#if !defined(LINUX)
#define LITTLE_ENDIAN
#endif
#endif

#if defined(IEEE) || defined(PYRAMID) || defined(_IEEE) /*{*/
#define FMANT_BITS	0x7fffff
#define DMANTHI_BITS	0xfffff
#define FEXP_BITS	0x7f800000
#define DEXP_BITS	0x7ff00000
#define F_SIGN_BIT	0x80000000
#define D_SIGN_BIT	F_SIGN_BIT
#define L_SIGN_BIT	F_SIGN_BIT
#else /*}{ Non-IEEE format */
#if defined(vax)
#define FMANT_BITS 	0xffff007f
#define DMANTHI_BITS 	FMANT_BITS
#define FEXP_BITS 	0x00007f80
#define DEXP_BITS 	FEXP_BITS
#define F_SIGN_BIT  	0x00008000
#define D_SIGN_BIT	F_SIGN_BIT
#define L_SIGN_BIT	0x80000000
#endif
#endif /* } End non-IEEE */

#ifdef HI
#undef HI
#endif

#ifdef LO
#undef LO
#endif

#if defined(LITTLE_ENDIAN) && !defined(vax)
#define HI 1
#define LO 0
#else
#define HI 0
#define LO 1
#endif

#endif
