
#pragma warning(disable:4786)

#include <math.h>
#include <string>
#include <fstream>
#include <iostream>
#include <sys/stat.h>         // stat function
#ifdef WIN32
#include <direct.h>           //_mkdir function
#endif

#include "IMCSRCGenerator.h"

using namespace std;

#ifdef WIN32
#define mkdir(dir, ignor) _mkdir(dir)
#endif

static const int LIGLM =					0;
static const int LOGLM =					1;
static const int TREE =						2;
static const int NNET =						3;
static const int PRCOMP =					4;
static const int CLUST =					5;
static const int SURV =						6;
static const int BAYES =					7;

static const char* LIN_REGR =				"d:\\predDist\\lin_regr_model.txt";
static const char* LOG_REGR =				"d:\\predDist\\log_regr_model.txt";
static const char* CLASS_TREE =				"d:\\predDist\\class_tree_model.txt";
static const char* REGR_TREE =				"d:\\predDist\\regr_tree_model.txt";
static const char* CLASS_NNET =				"d:\\predDist\\class_nnet_model.txt";
static const char* REGR_NNET =				"d:\\predDist\\regr_nnet_model.txt";
static const char* PCOMP =					"d:\\predDist\\pcomp_model.txt";
static const char* KMEANS =					"d:\\predDist\\kmeans_model.txt";
static const char* COX_REGR =				"d:\\predDist\\cox_regr_model.txt";
static const char* NBAYES =					"d:\\predDist\\nbayes_model.txt";

static const char* FUEL_INPUT =				"d:\\predDist\\fuel_input.txt";
static const char* FUEL_COL_REORD =			"d:\\predDist\\fuel_col_reord_input.txt";
static const char* FUEL_LEV_REORD =			"d:\\predDist\\fuel_lev_reord_input.txt";
static const char* FUEL_BOTH_REORD =		"d:\\predDist\\fuel_col_lev_reord_input.txt";
static const char* FUEL_EXTRA_LEV =			"d:\\predDist\\fuel_xt_lev_input.txt";

static const char* FUEL_MULTI_INPUT =		"d:\\predDist\\fuel_multi_class_input.txt";
static const char* FUEL_MULTI_COL_REORD =	"d:\\predDist\\fuel_col_reord_multi_class_input.txt";
static const char* FUEL_MULTI_LEV_REORD =	"d:\\predDist\\fuel_lev_reord_multi_class_input.txt";
static const char* FUEL_MULTI_BOTH_REORD =	"d:\\predDist\\fuel_col_lev_reord_multi_class_input.txt";
static const char* FUEL_MULTI_EXTRA_LEV =	"d:\\predDist\\fuel_xt_lev_multi_class_input.txt";

static const char* HEART_INPUT =			"d:\\predDist\\heart_input.txt";
static const char* HEART_COL_REORD =		"d:\\predDist\\heart_col_reord_input.txt";
static const char* HEART_LEV_REORD =		"d:\\predDist\\heart_lev_reord_input.txt";
static const char* HEART_BOTH_REORD =		"d:\\predDist\\heart_col_lev_reord_input.txt";
static const char* HEART_EXTRA_LEV =		"d:\\predDist\\heart_xt_lev_input.txt";


long create_fuel_example(IMinerDataSet *input, IMinerMetaData *md);
int testFunction(bool testColReordering, bool testLevReordering, 
				 bool testBothReordered, bool testExtraLevels);

int main(int argc, char* argv[])
{
	IMinerObject ds, md;
	create_fuel_example(&ds, &md);
	return testFunction(true, true, true, true);
}

long testCase(const char *model, const char *inputFile, int type) {
	IMinerMetaData modelRead, rectReadDataInput, pOutput;
	IMinerObject_createFromFile(&modelRead, model);
	IMinerObject_createFromFile(&rectReadDataInput, inputFile);
	switch (type) {
		case LIGLM: 
			IMinerLinearRegressionModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case LOGLM: 
			IMinerLogisticRegressionModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case TREE:
			IMinerTreeModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case NNET:
			IMinerNeuralNetworkModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case PRCOMP:
			IMinerPrincipalComponentsModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case CLUST:
			IMinerKMeansClusterModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case BAYES:
			IMinerNaiveBayesModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
		case SURV:
			IMinerCoxRegressionModel_predict(&pOutput, &rectReadDataInput, NULL, &modelRead); 
			break;
	}
	IMinerDataSet_print(&pOutput);

	IMinerObject_destroy(&rectReadDataInput);
	IMinerObject_destroy(&modelRead);
	IMinerObject_destroy(&pOutput);

	return 1;
}

long generateNaiveBayes(bool testColReord=false, bool testLevReord=false, 
						bool testBothReord=false, bool testExtraLevels=false)
{
	//YB:Test
	testCase(NBAYES, FUEL_MULTI_INPUT, BAYES);
	if (testLevReord) testCase(NBAYES, FUEL_MULTI_LEV_REORD, BAYES);
	if (testColReord) testCase(NBAYES, FUEL_MULTI_COL_REORD, BAYES);
	if (testBothReord) testCase(NBAYES, FUEL_MULTI_BOTH_REORD, BAYES);
	if (testExtraLevels) testCase(NBAYES, FUEL_MULTI_EXTRA_LEV, BAYES);

	return 1L;
}

long generateTree(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	//YB:Test
	testCase(REGR_TREE, FUEL_INPUT, TREE);
	if (testLevReord) testCase(REGR_TREE, FUEL_LEV_REORD, TREE);
	if (testColReord) testCase(REGR_TREE, FUEL_COL_REORD, TREE);
	if (testBothReord) testCase(REGR_TREE, FUEL_BOTH_REORD, TREE);
	if (testExtraLevels) testCase(REGR_TREE, FUEL_EXTRA_LEV, TREE);

	testCase(CLASS_TREE, FUEL_INPUT, TREE);
	if (testLevReord) testCase(CLASS_TREE, FUEL_LEV_REORD, TREE);
	if (testColReord) testCase(CLASS_TREE, FUEL_COL_REORD, TREE);
	if (testBothReord) testCase(CLASS_TREE, FUEL_BOTH_REORD, TREE);
	if (testExtraLevels) testCase(CLASS_TREE, FUEL_EXTRA_LEV, TREE);

	return 1L;
}

long generateCoxRegression(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	//YB:Test
	testCase(COX_REGR, HEART_INPUT, SURV);
	if (testLevReord) testCase(COX_REGR, HEART_LEV_REORD, SURV);
	if (testColReord) testCase(COX_REGR, HEART_COL_REORD, SURV);
	if (testBothReord) testCase(COX_REGR, HEART_BOTH_REORD, SURV);
	if (testExtraLevels) testCase(COX_REGR, HEART_EXTRA_LEV, SURV);

	return 1L;
}

long generateNeuralNetwork(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	//YB:Test
	testCase(CLASS_NNET, FUEL_INPUT, NNET);
	if (testLevReord) testCase(CLASS_NNET, FUEL_LEV_REORD, NNET);
	if (testColReord) testCase(CLASS_NNET, FUEL_COL_REORD, NNET);
	if (testBothReord) testCase(CLASS_NNET, FUEL_BOTH_REORD, NNET);
	if (testExtraLevels) testCase(CLASS_NNET, FUEL_EXTRA_LEV, NNET);

	testCase(REGR_NNET, FUEL_INPUT, NNET);
	if (testLevReord) testCase(REGR_NNET, FUEL_LEV_REORD, NNET);
	if (testColReord) testCase(REGR_NNET, FUEL_COL_REORD, NNET);
	if (testBothReord) testCase(REGR_NNET, FUEL_BOTH_REORD, NNET);
	if (testExtraLevels) testCase(REGR_NNET, FUEL_EXTRA_LEV, NNET);

	return 1L;
}

long generatePrincipalComponents(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	long nStatus = 1L;

	// PrincipalComponents cluster
	testCase(PCOMP, FUEL_INPUT, PRCOMP);
	if (testLevReord) testCase(PCOMP, FUEL_LEV_REORD, PRCOMP);
	if (testColReord) testCase(PCOMP, FUEL_COL_REORD, PRCOMP);
	if (testBothReord) testCase(PCOMP, FUEL_BOTH_REORD, PRCOMP);
	if (testExtraLevels) testCase(PCOMP, FUEL_EXTRA_LEV, PRCOMP);

	return nStatus;
}

long generateKMeansCluster(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	long nStatus=1;

	testCase(KMEANS, FUEL_INPUT, CLUST);
	if (testLevReord) testCase(KMEANS, FUEL_LEV_REORD, CLUST);
	if (testColReord) testCase(KMEANS, FUEL_COL_REORD, CLUST);
	if (testBothReord) testCase(KMEANS, FUEL_BOTH_REORD, CLUST);
	if (testExtraLevels) testCase(KMEANS, FUEL_EXTRA_LEV, CLUST);

	return nStatus;
}

long generateLinearRegression(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	long nStatus=1;

	testCase(LIN_REGR, FUEL_INPUT, LIGLM);
	if (testLevReord) testCase(LIN_REGR, FUEL_LEV_REORD, LIGLM);
	if (testColReord) testCase(LIN_REGR, FUEL_COL_REORD, LIGLM);
	if (testBothReord) testCase(LIN_REGR, FUEL_BOTH_REORD, LIGLM);
	if (testExtraLevels) testCase(LIN_REGR, FUEL_EXTRA_LEV, LIGLM);

	return nStatus;
}

long generateLogisticRegression(bool testColReord=false, bool testLevReord=false, bool testBothReord=false, bool testExtraLevels=false)
{
	long nStatus=1;

	testCase(LOG_REGR, FUEL_MULTI_INPUT, LOGLM);
	if (testLevReord) testCase(LOG_REGR, FUEL_MULTI_LEV_REORD, LOGLM);
	if (testColReord) testCase(LOG_REGR, FUEL_MULTI_COL_REORD, LOGLM);
	if (testBothReord) testCase(LOG_REGR, FUEL_MULTI_BOTH_REORD, LOGLM);
	if (testExtraLevels) testCase(LOG_REGR, FUEL_MULTI_EXTRA_LEV, LOGLM);

	return nStatus;
}

int testFunction(bool testColReordering, bool testLevReordering, bool testBothReordered, bool testExtraLevels) 
{
	generateLinearRegression(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generateNeuralNetwork(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generateNaiveBayes(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generateTree(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generateCoxRegression(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generatePrincipalComponents(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generateKMeansCluster(testColReordering, testLevReordering, testBothReordered, testExtraLevels);
	generateLogisticRegression(testColReordering, testLevReordering, testBothReordered, testExtraLevels);


	return 0;
}


/* get the example of data */
long getInputData_Example(IMinerObject* pDataSet /* out */)
{
	long nStatus;
	IMinerVector vector;

	long numberOfRows     = 5L;
	long numberOfColumns  = 2L;
	double pdCol1 [5L] = {2560.0, 0.3, 0.2, 0.1, 0.1};
	double pdCol2 [5L] = {97.0, 2.0, 3.0, 4.0, 1.0};

	if(pDataSet == NULL)
		return IMINER_BAD_INPUT_ARGS;

	/* allocate memory for the data object */
	nStatus = IMinerDataSet_create(pDataSet, numberOfRows, numberOfColumns, NULL);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;

	/*$$CLUSTER_INPUT_DATA: fill-in an example of input data */

	/* column 1 */
	nStatus = IMinerVector_create(&vector, numberOfRows, IMINER_MODE_DOUBLE, (const void*) pdCol1);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	nStatus = IMinerDataSet_setColumnAt(pDataSet, 0L, &vector);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	IMinerVector_destroy(&vector);

	/* column 2 */
	nStatus = IMinerVector_create(&vector, numberOfRows, IMINER_MODE_DOUBLE, (const void*) pdCol2);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	nStatus = IMinerDataSet_setColumnAt(pDataSet, 1L, &vector);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	IMinerVector_destroy(&vector);

	return IMINER_SUCCESS;
}

/* get the example of data */
long getInputData_PrincipalComponents_Example(IMinerObject* pDataSet /* out */)
{
	long nStatus;
	IMinerVector vector;

	long numberOfRows     = 20L;
	long numberOfColumns  = 2L;
	double pdCol1 [20L] = {2560,2345,1845,2260,2440,2285,2275,2350,2295,1900,2390,2075,2330,3320,2885,3310,2695,2170,2710,2775};
	double pdCol2 [20L] = {97,114,81,91,113,97,97,98,109,73,97,89,109,305,153,302,133,97,125,146};

	if(pDataSet == NULL)
		return IMINER_BAD_INPUT_ARGS;

	/* allocate memory for the data object */
	nStatus = IMinerDataSet_create(pDataSet, numberOfRows, numberOfColumns, NULL);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;

	/*$$CLUSTER_INPUT_DATA: fill-in an example of input data */

	/* column 1 */
	nStatus = IMinerVector_create(&vector, numberOfRows, IMINER_MODE_DOUBLE, (const void*) pdCol1);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	nStatus = IMinerDataSet_setColumnAt(pDataSet, 0L, &vector);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	IMinerVector_destroy(&vector);

	/* column 2 */
	nStatus = IMinerVector_create(&vector, numberOfRows, IMINER_MODE_DOUBLE, (const void*) pdCol2);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	nStatus = IMinerDataSet_setColumnAt(pDataSet, 1L, &vector);
	if(nStatus != IMINER_SUCCESS)
		return nStatus;
	IMinerVector_destroy(&vector);

	return IMINER_SUCCESS;
}


/* get an example of kmeans cluster model */
long getClusterModel_Example(IMinerKMeansClusterModel* pModel, IMinerMetaData *md)
{
	long nunberOfClusters = 3L;
	long numberOfColumns  = 2L;
	double pdCenters[2L*3L] = {1.0, 1.0, 1.0, 10.0, 20.0, 30.0};
	double pdScale[2L] = {1.0, 30.0};
	long pnSize[3L] = {10, 100, 400};

	return IMinerKMeansClusterModel_create(pModel, md, nunberOfClusters, numberOfColumns, pdCenters, pdScale, pnSize);

}

/* get an example of principal components model */
long getPrincipalComponentsModel_Example(IMinerPrincipalComponentsModel* pModel, IMinerMetaData *md)
{
	long numberOfComponents = 1L;
	long numberOfColumns  = 2L;
	double pdCenter[2L] = {2900.83333333333, 152.05};
	double pdScale[2L] = {495.866102985872, 54.1609106024644};
	double pmLoading[1L * 2L] = {0.707106781186548, 0.707106781186548};

	return IMinerPrincipalComponentsModel_create(pModel, md, numberOfComponents, numberOfColumns, pdCenter, pdScale, pmLoading);

}

long create_fuel_example(IMinerDataSet *input, IMinerMetaData *md) {
	long numRows = 60;
	long nCols = 6, colNum=0;
	long modes[] = {IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_STRING, IMINER_MODE_STRING};
	double pdWeight[60] = {
		2560,2345,1845,2260,2440,2285,2275,2350,2295,1900,2390,2075,2330,3320,
		2885,3310,2695,2170,2710,2775,2840,2485,2670,2640,2655,3065,2750,2920,
		2780,2745,3110,2920,2645,2575,2935,2920,2985,3265,2880,2975,3450,3145,
		3190,3610,2885,3480,3200,2765,3220,3480,3325,3855,3850,3195,3735,3665,
		3735,3415,3185,3690
	};
	double pdDisp[60] = {
		97,114,81,91,113,97,97,98,109,73,97,89,109,305,153,302,133,97,125,146,
		107,109,121,151,133,181,141,132,133,122,181,146,151,116,135,122,141,
		163,151,153,202,180,182,232,143,180,180,151,189,180,231,305,302,151,
		202,182,181,143,146,146
	};
	double pdMileage[60] = {
		33,33,37,32,32,26,33,28,25,34,29,35,26,20,27,19,30,33,27,24,26,28,27,23,
		26,25,24,26,24,25,21,21,23,24,23,27,23,20,21,22,22,22,22,23,23,21,22,21,
		21,23,23,18,20,18,18,18,19,20,20,19
	};
	double pdFuel[60] = {
		3.03030303,3.03030303,2.702702703,3.125,3.125,3.846153846,3.03030303,3.571428571,
		4,2.941176471,3.448275862,2.857142857,3.846153846,5,3.703703704,5.263157895,3.333333333,
		3.03030303,3.703703704,4.166666667,3.846153846,3.571428571,3.703703704,4.347826087,
		3.846153846,4,4.166666667,3.846153846,4.166666667,4,4.761904762,4.761904762,4.347826087,
		4.166666667,4.347826087,3.703703704,4.347826087,5,4.761904762,4.545454545,4.545454545,
		4.545454545,4.545454545,4.347826087,4.347826087,4.761904762,4.545454545,4.761904762,
		4.761904762,4.347826087,4.347826087,5.555555556,5,5.555555556,5.555555556,5.555555556,
		5.263157895,5,5,5.263157895
	};
	char *pcType[60] = {
		"Small","Small","Small","Small","Small","Small","Small","Small","Small","Small","Small",
		"Small","Small","Sporty","Sporty","Sporty","Sporty","Sporty","Sporty","Sporty","Sporty",
		"Sporty","Compact","Compact","Compact","Compact","Compact","Compact","Compact","Compact",
		"Compact","Compact","Compact","Compact","Compact","Compact","Compact","Medium","Medium",
		"Medium","Medium","Medium","Medium","Medium","Medium","Medium","Medium","Medium","Medium",
		"Medium","Large","Large","Large","Van","Van","Van","Van","Van","Van","Van"
	};
	char *pcSimpleType[60] = {
		"Small","Small","Small","Small","Small","Small","Small","Small","Small","Small","Small",
		"Small","Small","Small","Small","Small","Small","Small","Small","Small","Small","Small",
		"Small","Small","Small","Small","Small","Small","Small","Small","Small","Small","Small",
		"Small","Small","Small","Small","Large","Large","Large","Large","Large","Large","Large",
		"Large","Large","Large","Large","Large","Large","Large","Large","Large","Large","Large",
		"Large","Large","Large","Large","Large"
	};

	IMinerDataSet_create(input, numRows, nCols, modes);

	IMinerVector vector;
	long nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)pdWeight);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)pdDisp);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)pdMileage);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)pdFuel);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_STRING, (const void*)pcType);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_STRING, (const void*)pcSimpleType);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);


	/*******************************/
	/* CHANGE ALL STRING TO FACTOR */
	/*******************************/
	for(int j=0; j<nCols; ++j)
	{
		IMinerObject *pVector = IMINER_DATASET_VECTOR_PTR(input, j);
		if(IMINER_OBJECT_MODE(pVector) == IMINER_MODE_STRING)
		{
			IMinerFactor factor;
			IMinerFactor_createFromStrings(&factor, IMINER_OBJECT_LENGTH(pVector), (const char**)IMINER_STRING_PTR(pVector));
			IMinerDataSet_setColumnAt(input, j, &factor);
		}
	}


	char *columnNames[6] = {"Weight", "Disp.", "Mileage", "Fuel", "Type", "SimpleType"};
	long numLevels[6] = {0,0,0,0,6,2};
	long maxLevels = 6;
	char *columnLevels[6][6] = {
		{"","","","","",""},
		{"","","","","",""},
		{"","","","","",""},
		{"","","","","",""},
		{"Small","Sporty","Compact","Medium","Large","Van"},
		{"Small","Large","","","",""}
	};
	char **cn=(char**)malloc(nCols*sizeof(char*));
	char ***ln=(char***)malloc(nCols*sizeof(char**));
	for (int i=0; i<nCols; i++) {
		cn[i] = columnNames[i];
		ln[i]=(char**)malloc(maxLevels*sizeof(char*));
		for (int j=0; j<maxLevels; j++) ln[i][j] = columnLevels[i][j];
	}

	IMinerMetaData_createInputDescription(md, nCols, cn, numLevels, maxLevels, ln);


	IMinerDataSet_setColumnNamesFromStrings(input, (const char**)cn);




	IMinerDataSet ds;
	void **data = (void**)malloc(nCols*sizeof(void*));
	data[0] = (void*)pdWeight;
	data[1] = (void*)pdDisp;
	data[2] = (void*)pdMileage;
	data[3] = (void*)pdFuel;
	data[4] = (void*)pcType;
	data[5] = (void*)pcSimpleType;
	IMinerDataSet_createFromInput(&ds,numRows,nCols,modes,columnNames,data); 
	IMinerDataSet_print(&ds);

	IMinerDataSet_createFromInput(&ds,0,0,0,0,0); 
	IMinerDataSet_print(&ds);

	return 1;
}

long create_survival_example(IMinerDataSet *input, IMinerMetaData *md) {
	long numRows = 172;
	long nCols = 8, colNum=0;
	long modes[8] = {IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_DOUBLE, IMINER_MODE_STRING, IMINER_MODE_STRING, IMINER_MODE_DOUBLE};
	double dpStart[172] = {
		0,0,0,1,0,36,0,0,0,51,0,0,0,12,0,26,0,0,17,0,37,0,0,28,0,0,20,0,0,18,0,8,0,12,0,3,0,83,
		0,25,0,0,0,71,0,0,16,0,0,17,0,51,0,23,0,0,46,0,19,0,4.5,0,2,0,41,0,58,0,0,0,0,1,0,2,0,
		21,0,0,36,0,83,0,32,0,0,41,0,0,10,0,67,0,0,21,0,78,0,3,0,0,0,27,0,33,0,12,0,0,57,0,3,
		0,10,0,5,0,31,0,4,0,27,0,5,0,0,46,0,0,210,0,67,0,26,0,6,0,0,32,0,37,0,0,8,0,60,0,31,0,
		139,0,160,0,0,310,0,28,0,4,0,2,0,13,0,21,0,96,0,0,38,0,0,0
	};
	double dpStop[172] = {
		50,6,1,16,36,39,18,3,51,675,40,85,12,58,26,153,8,17,81,37,1387,1,28,308,36,20,43,
		37,18,28,8,1032,12,51,3,733,83,219,25,1800,1401,263,71,72,35,16,852,16,17,77,51,
		1587,23,1572,12,46,100,19,66,4.5,5,2,53,41,1408,58,1322,3,2,40,1,45,2,996,21,72,
		9,36,1142,83,980,32,285,102,41,188,3,10,61,67,942,149,21,343,78,916,3,68,2,69,27,
		842,33,584,12,78,32,57,285,3,68,10,670,5,30,31,620,4,596,27,90,5,17,2,46,545,21,
		210,515,67,96,26,482,6,445,428,32,80,37,334,5,8,397,60,110,31,370,139,207,160,186,
		340,310,340,28,265,4,165,2,16,13,180,21,131,96,109,21,38,39,31,11,6
	};
	double dpEvent[172] = {
		1,1,0,1,0,1,1,1,0,1,1,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,0,
		1,0,1,1,0,1,1,0,1,0,0,0,0,1,0,1,0,1,0,1,0,1,0,0,0,0,1,1,1,0,1,0,1,0,1,1,0,0,0,1,0,
		1,1,0,1,1,0,1,0,0,1,0,1,0,0,0,1,1,1,0,0,0,1,0,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,1,0,1,
		1,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,0,0,1,0,1,1,0,0,0,0,0,1,0,1,0,0,0,0,
		0,0,1,0,0,0,0,1
	};
	double dpAge[172] = {
		-17.15537303,3.835728953,6.29705681,6.29705681,-7.737166324,-7.737166324,-27.21423682,
		6.595482546,2.869267625,2.869267625,-2.650239562,-0.837782341,-5.497604381,-5.497604381,
		-0.019164956,-0.019164956,5.193702943,6.57357974,6.57357974,6.012320329,6.012320329,
		5.815195072,1.448323066,1.448323066,-27.66872005,8.848733744,8.848733744,11.12388775,
		7.279945243,7.279945243,-4.657084189,-4.657084189,-5.215605749,-5.215605749,10.35728953,
		10.35728953,3.800136893,3.800136893,-14.7761807,-14.7761807,-17.46475017,-39.21423682,
		6.023271732,6.023271732,2.43394935,-3.088295688,-3.088295688,6.88569473,16.40793977,
		16.40793977,0.90349076,0.90349076,-7.446954141,-7.446954141,-4.533880903,0.925393566,
		0.925393566,13.50034223,13.50034223,-6.529774127,-6.529774127,2.518822724,2.518822724,
		0.481861739,0.481861739,-2.696783025,-2.696783025,-11.55920602,-4.607802875,-5.420944559,
		-11.816564,-11.816564,0.610540726,0.610540726,-0.900752909,-0.900752909,8.03559206,
		-11.34565366,-11.34565366,-2.113620808,-2.113620808,0.733744011,0.733744011,-6.751540041,
		-0.657084189,-0.657084189,-0.20807666,4.454483231,4.454483231,-9.256673511,-9.256673511,
		-6.735112936,0.016427105,0.016427105,-6.617385352,-6.617385352,1.054072553,1.054072553,
		4.563997262,-8.646132786,-15.34017796,-15.34017796,0.815879535,0.815879535,3.293634497,
		3.293634497,5.212867899,-28.44900753,-28.44900753,-2.759753593,-2.759753593,-0.010951403,
		-0.010951403,5.002053388,5.002053388,-0.59137577,-0.59137577,-21.27310062,-21.27310062,
		8.331279945,8.331279945,-18.83367556,-18.83367556,4.180698152,4.084873374,4.084873374,
		-6.88843258,0.703627652,0.703627652,5.782340862,5.782340862,-1.555099247,-1.555099247,
		4.892539357,4.892539357,-18.7980835,5.308692676,5.308692676,-5.281314168,-5.281314168,
		-0.019164956,0.919917864,0.919917864,-1.746748802,-1.746748802,6.362765229,6.362765229,
		3.047227926,3.047227926,4.032854209,4.032854209,-0.405201916,-3.017111567,-3.017111567,
		-0.249144422,-0.249144422,-4.158795346,-4.158795346,-7.718001369,-7.718001369,-21.34976044,
		-21.34976044,-24.38329911,-24.38329911,-19.37029432,-19.37029432,1.834360027,-12.93908282,
		-12.93908282,1.516769336,-7.608487337,-8.684462697
	};
	double dpYear[172] = {
		0.123203285,0.254620123,0.265571526,0.265571526,0.490075291,0.490075291,0.607802875,0.700889802,
		0.780287474,0.780287474,0.83504449,0.856947296,0.862422998,0.862422998,0.873374401,0.873374401,
		0.963723477,0.969199179,0.969199179,0.971937029,0.971937029,0.991101985,1.070499658,1.070499658,
		1.075975359,1.086926762,1.086926762,1.133470226,1.330595483,1.330595483,1.338809035,1.338809035,
		1.46201232,1.46201232,1.527720739,1.527720739,1.56605065,1.56605065,1.574264203,1.574264203,
		1.582477755,1.590691307,1.683778234,1.683778234,1.785078713,1.883641342,1.883641342,1.894592745,
		1.911019849,1.911019849,2.15742642,2.15742642,2.198494182,2.198494182,2.308008214,2.507871321,
		2.507871321,2.565366188,2.565366188,2.592744695,2.592744695,2.633812457,2.633812457,2.647501711,
		2.647501711,2.882956879,2.882956879,2.88843258,3.058179329,3.16495551,3.263518138,3.263518138,
		3.277207392,3.277207392,3.34017796,3.34017796,3.348391513,3.375770021,3.375770021,3.375770021,
		3.375770021,3.4770705,3.4770705,3.564681725,3.750855578,3.750855578,3.750855578,3.854893908,
		3.854893908,3.923340178,3.923340178,3.950718686,3.978097194,3.978097194,3.994524298,3.994524298,
		4.131416838,4.131416838,4.17522245,4.188911704,4.197125257,4.197125257,4.336755647,4.336755647,
		4.429842574,4.429842574,4.468172485,4.476386037,4.476386037,4.517453799,4.517453799,4.668035592,
		4.668035592,4.711841205,4.711841205,4.804928131,4.804928131,4.87063655,4.87063655,4.947296372,
		4.947296372,4.966461328,4.966461328,4.996577687,5.01026694,5.01026694,5.015742642,5.092402464,
		5.092402464,5.166324435,5.166324435,5.18275154,5.18275154,5.284052019,5.284052019,4.084873374,
		5.316906229,5.316906229,5.333333333,5.333333333,5.352498289,5.415468857,5.415468857,5.470225873,
		5.470225873,5.489390828,5.489390828,5.511293634,5.511293634,5.514031485,5.514031485,5.533196441,
		5.571526352,5.571526352,5.776865161,5.776865161,5.954825462,5.954825462,5.976728268,5.976728268,
		6.009582478,6.009582478,6.143737166,6.143737166,6.203969884,6.203969884,6.234086242,6.395619439,
		6.395619439,6.417522245,6.472279261,-0.049281314
	};
	char *dpSurgery[172] = {
		"0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0",
		"0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1","1","1","1","0","1","1","0","0","1","1","0","0","0","1","1","1","1","0","0","0","0","0","0","0",
		"0","0","0","0","1","1","1","1","0","0","0","0","0","0","1","1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1","1","0","0","0","0","0","1",
		"1","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","1","1","0","0","0","0","0","1","1","0","0","0","0","0","0","0","0","0","1","1","0","0","0"
	};
	char *dpTransplant[172] = {
		"0","0","0","1","0","1","0","0","0","1","0","0","0","1","0","1","0","0","1","0","1","0","0","1","0","0","1","0","0","1","0","1","0","1","0","1","0","1","0","1","0","0","0","1",
		"0","0","1","0","0","1","0","1","0","1","0","0","1","0","1","0","1","0","1","0","1","0","1","0","0","0","0","1","0","1","0","1","0","0","1","0","1","0","1","0","0","1","0","0",
		"1","0","1","0","0","1","0","1","0","1","0","0","0","1","0","1","0","1","0","0","1","0","1","0","1","0","1","0","1","0","1","0","1","0","1","0","0","1","0","0","1","0","1","0",
		"1","0","1","0","0","1","0","1","0","0","1","0","1","0","1","0","1","0","1","0","0","1","0","1","0","1","0","1","0","1","0","1","0","1","0","0","1","0","0","0"
	};
	double dpID[172] = {
		1,2,3,3,4,4,5,6,7,7,8,9,10,10,11,11,12,13,13,14,14,15,16,16,17,18,18,19,20,
		20,21,21,22,22,23,23,24,24,25,25,26,27,28,28,29,30,30,31,32,32,33,33,34,34,35,
		36,36,37,37,38,38,39,39,40,40,41,41,42,43,44,45,45,46,46,47,47,48,49,49,50,50,
		51,51,52,53,53,54,55,55,56,56,57,58,58,59,59,60,60,61,62,63,63,64,64,65,65,66,
		67,67,68,68,69,69,70,70,71,71,72,72,73,73,74,74,75,76,76,77,78,78,79,79,80,80,
		81,81,82,83,83,84,84,85,86,86,87,87,88,88,89,89,90,90,91,92,92,93,93,94,94,95,
		95,96,96,97,97,98,98,99,100,100,101,102,103
	};

	IMinerDataSet_create(input, numRows, nCols, modes);

	IMinerVector vector;
	long nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)dpStart);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)dpStop);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)dpEvent);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)dpAge);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)dpYear);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_STRING, (const void*)dpSurgery);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_STRING, (const void*)dpTransplant);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)dpID);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, colNum++, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);


	char *columnNames[8] = {"start", "stop.", "event", "age", "year", "surgery", "transplant", "id"};
	long numLevels[8] = {0,0,0,0,0,2,2,0};
	long maxLevels = 2;
	char *columnLevels[8][2] = {
		{"",""},
		{"",""},
		{"",""},
		{"",""},
		{"",""},
		{"1","0"},
		{"1","0"},
		{"",""}
	};
	char **cn=(char**)malloc(nCols*sizeof(char*));
	char ***ln=(char***)malloc(nCols*sizeof(char**));
	for (int i=0; i<nCols; i++) {
		cn[i] = columnNames[i];
		ln[i]=(char**)malloc(maxLevels*sizeof(char*));
		for (int j=0; j<maxLevels; j++) ln[i][j] = columnLevels[i][j];
	}

	IMinerMetaData_createInputDescription(md, nCols, cn, numLevels, maxLevels, ln);

	return 1;
}

/* get an example of linear regression model */
long getLinearRegressionModel_Example(IMinerLinearRegressionModel* pModel, IMinerMetaData *md)
{
	long numberOfCoefficients  = 2L; /* the first one is for the intercept */
	double pdCoefficients[3L] = {0.3, 2.0};

	return IMinerLinearRegressionModel_create(pModel, md, numberOfCoefficients,  pdCoefficients);
}

/* get an example of logistic regression model */
long getLogisticRegressionModel_Example(IMinerLogisticRegressionModel* pModel, IMinerMetaData *md)
{
	long numberOfCoefficients  = 2L; /* the first one is for the intercept */
	double pdCoefficients[3L] = {0.1, 0.2};

	return IMinerLogisticRegressionModel_create(pModel, md, numberOfCoefficients,  pdCoefficients);
}

long create_dummy_metadata(IMinerMetaData *md) {
	long nCols=3, i=0, j=0;
	char *emptyName = "";
	char *colNames[3] = {"apu", "homer", "willie"}, **cn, ***ln;
	char *levNames[3][5] = {
		{
			"","","","",""
		},
		{
			"homer_at_home", "homer_at_plant", "homer_at_moes", "", ""
		},
		{
			"willie_at_home", "willie_at_school", "willie_at_scotland", "willie_at_parade", "willie_at_camp"
		}
	};
	long numLevs[3] = {0, 3, 5};
	long splitCat[3] = {0, 1, 1};
	long nMaxLevs=5;

	cn=(char**)malloc(nCols*sizeof(char*));
	ln=(char***)malloc(nCols*sizeof(char**));
	for (i=0; i<nCols; i++) {
		cn[i] = colNames[i];
		ln[i]=(char**)malloc(nMaxLevs*sizeof(char*));
		for (j=0; j<nMaxLevs; j++) {
			if (j<numLevs[i]) ln[i][j] = levNames[i][j];
			else ln[i][j] = emptyName;
		}
	}

	return IMinerMetaData_create(md, nCols, cn, numLevs, splitCat, nMaxLevs, ln);
}

long create_dummy_dataset(IMinerMetaData *md, IMinerDataSet *input, long numRows) {
	long numColumns = 3;
	long modes[] = {IMINER_MODE_DOUBLE, IMINER_MODE_STRING, IMINER_MODE_STRING};
	long numLevels1 = IMINER_MD_COLUMN_LEVEL_COUNT(md, 1);
	char **row1 = (char**)malloc(numRows*sizeof(char*));
	long numLevels2 = IMINER_MD_COLUMN_LEVEL_COUNT(md, 2);
	char **row2 = (char**)malloc(numRows*sizeof(char*));
	double *row0 = (double*)malloc(numRows*sizeof(double));
	for (int i=0; i<numRows; i++) {
		long rd1 = (long)((double)rand()/(double)RAND_MAX * numLevels1);
		row1[i] = IMINER_STRING_VALUE(IMINER_MD_COLUMN_LEVEL_NAMES(md, 1), rd1);
		long rd2 = (long)((double)rand()/(double)RAND_MAX * numLevels2);
		row2[i] = IMINER_STRING_VALUE(IMINER_MD_COLUMN_LEVEL_NAMES(md, 2), rd2);
		row0[i] = rand();
	}

	IMinerDataSet_create(input, numRows, numColumns, modes);

	IMinerVector vector;
	long nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_DOUBLE, (const void*)row0);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, 0, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_STRING, (const void*)row1);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, 1, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	nStatus = IMinerVector_create(&vector, numRows, IMINER_MODE_STRING, (const void*)row2);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	nStatus = IMinerDataSet_setColumnAt(input, 2, &vector);
	if(nStatus != IMINER_SUCCESS) return nStatus;
	IMinerVector_destroy(&vector);

	free(row0); free(row1); free(row2);
	return 1;
}

long testInputConvert() {
	IMinerMetaData inputMD;
	create_dummy_metadata(&inputMD);
	IMinerMetaData_print(&inputMD);
	IMinerDataSet data;
	create_dummy_dataset(&inputMD, &data, 20);

	IMinerDataSet modelMD;
	IMinerList_clone(&modelMD, &inputMD);
	char *tmp;

	for (int i=1; i<3; i++) {
		int lev = IMINER_MD_COLUMN_LEVEL_COUNT(&modelMD, i);
		tmp = IMINER_STRING_VALUE(IMINER_MD_COLUMN_LEVEL_NAMES(&modelMD, i), lev-1);
		for (int j=lev-1; j>=0; j--) {
			if (j==0) IMINER_STRING_VALUE(IMINER_MD_COLUMN_LEVEL_NAMES(&modelMD, i), j) = tmp;
			else IMINER_STRING_VALUE(IMINER_MD_COLUMN_LEVEL_NAMES(&modelMD, i), j) = IMINER_STRING_VALUE(IMINER_MD_COLUMN_LEVEL_NAMES(&modelMD, i), j-1);
		}
	}
	IMinerObject *tmp2;
	char *tmp3;
	tmp2 = IMINER_MD_PTR(&modelMD, 2);
	tmp3 = IMINER_STRING_VALUE(IMINER_LIST_NAMES_PTR(&modelMD), 2);
	IMINER_MD_PTR(&modelMD, 2) = IMINER_MD_PTR(&modelMD, 1);
	IMINER_STRING_VALUE(IMINER_LIST_NAMES_PTR(&modelMD), 2) = IMINER_STRING_VALUE(IMINER_LIST_NAMES_PTR(&modelMD), 1);
	IMINER_MD_PTR(&modelMD, 1) = IMINER_MD_PTR(&modelMD, 0);
	IMINER_STRING_VALUE(IMINER_LIST_NAMES_PTR(&modelMD), 1) = IMINER_STRING_VALUE(IMINER_LIST_NAMES_PTR(&modelMD), 0);
	IMINER_MD_PTR(&modelMD, 0) = tmp2;
	IMINER_STRING_VALUE(IMINER_LIST_NAMES_PTR(&modelMD), 0) = tmp3;
	IMinerMetaData_print(&modelMD);

	IMinerDataSet convertedInput;
	IMinerMetaData_InputConvert(&convertedInput, &modelMD, &data, &inputMD);
	IMinerMetaData_print(&inputMD);
	IMinerDataSet_print(&data);
	IMinerMetaData_print(&modelMD);
	IMinerDataSet_print(&convertedInput);



	return 1;
}

long generateMetaData(void)
{
	IMinerObject md;
	create_dummy_metadata(&md);
	IMinerMetaData_print(&md);
	return 1L;
}

