<?xml version='1.0' encoding='UTF-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- XSL style sheet for NeuralNetwork element -->

	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>

	<xsl:template match="IMML">
		<html>
			<title>
				<xsl:value-of select="DisplayOptions/@title"/>
			</title>
			<style type="text/css">
				<xsl:value-of select="CSSText/text()"/>
			</style>
			<body>
				<div><h1 class="title">
					<xsl:value-of select="DisplayOptions/@title"/>
				</h1></div>
				<xsl:apply-templates select="NeuralNetwork"/>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="NeuralNetwork">
  		<xsl:choose>
			<xsl:when test="@modelType='classification'">
				<h3 class="subtitle">
					<xsl:text>Dependent variable: </xsl:text>
					<xsl:value-of select="@targetVariableName"/>
				</h3>
			</xsl:when>
			<xsl:otherwise>
				<div><h2 class="subtitle">Regression Neural Network</h2></div>
				<h3 class="subtitle">
				<xsl:text>Dependent variable: </xsl:text>
				<xsl:value-of select="@targetVariableName"/>
				</h3>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="DevMatrix"/>

		<xsl:apply-templates select="NeuralInputs"/>
		<xsl:apply-templates select="NeuralOutputs"/>
		<div><h3><xsl:text>Bias node = 0</xsl:text></h3></div>
		<xsl:apply-templates select="NeuralLayer"/>
	</xsl:template>

	<xsl:template match="NeuralNetwork[@modelType='classification']/DevMatrix">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<br></br>
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<h3 class="tableHead">Analysis of Deviance</h3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
				        		<th class="blueBG">Source</th>
        						<th class="blueBG">Deviance</th>

				     			<xsl:apply-templates select="DevCell"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<p>
			<h4 class="subtitle">
				<xsl:text>Accuracy: </xsl:text>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@accuracy" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</h4>
		</p>
	</xsl:template>

	<xsl:template match="NeuralNetwork[@modelType='regression']/DevMatrix">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<br></br>
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<h3 class="tableHead">Analysis of Variance</h3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<th class="blueBG">Source</th>
								<th class="blueBG">Sum of Squares</th>
								<xsl:apply-templates select="DevCell"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<p>
			<h4 class="subtitle">
				<xsl:text>Accuracy: </xsl:text>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@accuracy" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</h4>
		</p>
  	</xsl:template>

	<xsl:template match="DevCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left"> <xsl:value-of select="@source"/></th>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@dev" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>

	<xsl:template match="NeuralInputs">
		<br></br>
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<h3 class="tableHead">Neural Inputs</h3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<th class="blueBG"><xsl:text> Id </xsl:text></th>
								<th class="blueBG"><xsl:text> Variable </xsl:text></th>

								<xsl:for-each select="NeuralInput">
									<xsl:element name="tr">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
												<xsl:otherwise>greyBG</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<th style="text-align:left">
											<xsl:value-of select="@id"/>
										</th>
										<xsl:variable name="var" select="NormContinuous/@field"/>
										<xsl:choose>
											<xsl:when test="NormContinuous">
												<td style="text-align:left">
												<xsl:value-of select="$var"/>
												</td>
										</xsl:when>
										<xsl:otherwise>
											<td style="text-align:left">
												<xsl:value-of select="NormDiscrete/@field"/>
												<xsl:text>(</xsl:text>
												<xsl:value-of select="NormDiscrete/@value"/>
												<xsl:text>)</xsl:text>
											</td>
										</xsl:otherwise>
										</xsl:choose>
									</xsl:element>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</xsl:template>

	<xsl:template match="NeuralOutputs">
		<br></br>
		<div>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<h3 class="tableHead">Neural Outputs</h3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<th class="blueBG"><xsl:text> Id </xsl:text></th>
								<th class="blueBG"><xsl:text> Variable </xsl:text></th>

								<xsl:for-each select="NeuralOutput">
									<xsl:element name="tr">
										<xsl:attribute name="class">
											<xsl:choose>
												<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
												<xsl:otherwise>greyBG</xsl:otherwise>
											</xsl:choose>
										</xsl:attribute>

										<th style="text-align:left"><xsl:value-of select="@id"/></th>

										<xsl:variable name="var" select="NormContinuous/@field"/>
										<xsl:choose>
											<xsl:when test="NormContinuous">
												<td style="text-align:left"><xsl:value-of select="$var"/></td>
										</xsl:when>
										<xsl:otherwise>
											<td style="text-align:left">
												<xsl:value-of select="NormDiscrete/@field"/>
												<xsl:text>(</xsl:text>
												<xsl:value-of select="NormDiscrete/@value"/>
												<xsl:text>)</xsl:text>
											</td>
										</xsl:otherwise>
										</xsl:choose>
									</xsl:element>
								</xsl:for-each>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</xsl:template>


	<!-- This table shows the NOT-LAST neuron hidden layer(s) -->
	<xsl:template match="NeuralLayer[not(position()=last())]">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td class="tableBG" >
					<table cellspacing="1" cellpadding="5" border="0" class="content" width="100%">
						<tr><th class="blueBG" width="100%">Hidden Layer #<xsl:value-of select="position()"/></th></tr>
					</table>
					<table cellspacing="1" cellpadding="5" border="0" class="content" width="100%">
						<tr>
						  	<th rowspan="2" class="blueBG">Hidden Layer:<BR />Neuron ID</th>
						  	<th rowspan="2" class="blueBG">Bias</th>
						  	<th colspan="2" class="blueBG">Neuron connection weights</th>
						</tr>
						<tr>
						  	<th class="blueBG">From</th>
						  	<th class="blueBG">Weight</th>
						</tr>

						<xsl:for-each select="Neuron">
							<xsl:element name="tr">
								<xsl:attribute name="class">
									<xsl:choose>
										<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
										<xsl:otherwise>greyBG</xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<td><xsl:value-of select="@id"/></td>
								<td>
									<xsl:call-template name="roundNumber">
											<xsl:with-param name="string" select="Con[@from='0']/@weight" />
											<xsl:with-param name="decimalPattern" select="$decimalPattern" />
											<xsl:with-param name="scientificPattern" select="$scientificPattern" />
									</xsl:call-template>
								</td>
								<td>
									<xsl:for-each select="Con[@from!='0']">
										<xsl:value-of select="@from" />
										<BR />
									</xsl:for-each>
								</td>
								<td>
									<xsl:for-each select="Con[@from!='0']">
										<xsl:call-template name="roundNumber">
												<xsl:with-param name="string" select="@weight" />
												<xsl:with-param name="decimalPattern" select="$decimalPattern" />
												<xsl:with-param name="scientificPattern" select="$scientificPattern" />
										</xsl:call-template>
								  		<BR />
									</xsl:for-each>
								</td>
						  	</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>
	  <BR />
	</xsl:template>

	<!-- This table shows the LAST neuron hidden layer(s) -->
	<xsl:template match="NeuralLayer[last()]">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td class="tableBG" >
					<table cellspacing="1" cellpadding="5" border="0" class="content" width="100%">
						<tr><th class="blueBG" width="100%">Output Layer</th></tr>
					</table>
					<table cellspacing="1" cellpadding="5" border="0" class="content" width="100%">
						<tr>
					  		<th rowspan="2" class="blueBG">Output Layer:<BR />Neuron ID</th>
					  		<th rowspan="2" class="blueBG">Bias</th>
					  		<th colspan="2" class="blueBG">Neuron connection weights</th>
						</tr>
						<tr>
					  		<th class="blueBG">From</th>
					  		<th class="blueBG">Weight</th>
						</tr>

						<xsl:for-each select="Neuron">
							<xsl:element name="tr">
								<xsl:attribute name="class">
									<xsl:choose>
										<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
										<xsl:otherwise>greyBG</xsl:otherwise>
									</xsl:choose>
								</xsl:attribute>

								<td><xsl:value-of select="@id"/></td>
								<td>
									<xsl:call-template name="roundNumber">
											<xsl:with-param name="string" select="Con[@from='0']/@weight" />
											<xsl:with-param name="decimalPattern" select="$decimalPattern" />
											<xsl:with-param name="scientificPattern" select="$scientificPattern" />
									</xsl:call-template>
								</td>
								<td>
									<xsl:for-each select="Con[@from!='0']">
										<xsl:value-of select="@from" />
										<BR />
									</xsl:for-each>
								</td>
								<td>
									<xsl:for-each select="Con[@from!='0']">
										<xsl:call-template name="roundNumber">
												<xsl:with-param name="string" select="@weight" />
												<xsl:with-param name="decimalPattern" select="$decimalPattern" />
												<xsl:with-param name="scientificPattern" select="$scientificPattern" />
										</xsl:call-template>
								  		<BR />
									</xsl:for-each>
								</td>
						  	</xsl:element>
						</xsl:for-each>
					</table>
				</td>
			</tr>
		</table>
	  	<BR />
	</xsl:template>


	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
				<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:when test="$string = 0">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($string, $scientificPattern)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
