<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- XSL style sheet for ColumnStats element -->
	<xsl:template match="IMML">
		<xsl:choose>
			<xsl:when test="DisplayOptions[@title] = 0">
				<DIV><H1 class="subtitle">
					Column Information: <xsl:value-of select="DisplayOptions/@title"/>
				</H1></DIV>
				<xsl:apply-templates select="XTMetaData"/>
			</xsl:when>
			<xsl:otherwise>
				<HTML>
					<TITLE>
						<xsl:value-of select="DisplayOptions/@title"/>
					</TITLE>
					<style type="text/css">
						<xsl:value-of select="CSSText/text()"/>
					</style>
					<BODY>
						<DIV><H1 class="title">
							Column Information: <xsl:value-of select="DisplayOptions/@title"/>
						</H1></DIV>
						<xsl:apply-templates select="XTMetaData"/>
					</BODY>
				</HTML>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="XTMetaData">
		<xsl:apply-templates select="ColumnStats"/>
	</xsl:template>

	<xsl:template match="ColumnStats">
		<xsl:choose>
			<xsl:when test="TableStats/@rowCount = 0">
				<DIV>
					<B> Number of Rows: </B> 0
				</DIV>
				<DIV>
					<B> Number of Columns: </B> 0
				</DIV>
			</xsl:when>
			<xsl:when test="count(UnivariateStats) = 0">
				<DIV>
					<B> Number of Rows: </B> 0
				</DIV>
				<DIV>
					<B> Number of Columns: </B> 0
				</DIV>
			</xsl:when>
			<xsl:otherwise>
				<DIV>
					<B> Number of Rows: </B>
					<xsl:value-of select="TableStats/@rowCount"/>
				</DIV>
				<DIV>
					<B> Number of Columns: </B>
					<xsl:value-of select="count(UnivariateStats)"/>
				</DIV>
				<P> </P>
				<xsl:if test="TableStats/@rowCount != 0">
					<xsl:if test="count(../ColumnDefinitions/ColumnInfo[@type = 'continuous']) != 0">
						<H3 class="subtitle"><B>Continuous Columns</B></H3>
						<DIV>
							<table cellSpacing="0" cellPadding="3" border="0">
								<tbody>
									<tr>
										<td class="tableBG">
											<table class="content" cellSpacing="1" cellPadding="5" border="0">
												<TR class="blueBG" align="right">
													<TD></TD>
													<TD><B>Mean</B></TD>
													<TD><B>Min</B></TD>
													<TD><B>Max</B></TD>
													<TD><B>StdDev</B></TD>
													<TD><B>Missing</B></TD>
												</TR>
												<xsl:for-each select="../ColumnDefinitions/ColumnInfo">
													<xsl:variable name="name" select="@name"/>
													<xsl:if test="@type = 'continuous'">
														<xsl:element name="tr">
															<xsl:attribute name="class">
																<xsl:choose>
																	<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
																	<xsl:otherwise>greyBG</xsl:otherwise>
																</xsl:choose>
															</xsl:attribute>

															<TD align="left"><B><xsl:value-of select="$name"/></B></TD>
															<xsl:apply-templates select="../../ColumnStats/UnivariateStats[@field = $name]/NumericInfo"/>
														</xsl:element>
													</xsl:if>
												</xsl:for-each>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
						</DIV>
					</xsl:if>

					<xsl:if test="count(../ColumnDefinitions/ColumnInfo[@type = 'categorical']) != 0">
						<DIV>
							<H3 class="subtitle"><B>Categorical Columns</B></H3>
							<xsl:apply-templates select="UnivariateStats"/>
						</DIV>
					</xsl:if>

					<xsl:if test="count(../ColumnDefinitions/ColumnInfo[@type = 'string']) != 0">
						<P> </P>
						<H3 class="subtitle"><B>String Columns</B></H3>
						<DIV>
							<table cellSpacing="0" cellPadding="3" border="0">
								<tbody>
									<tr>
										<td class="tableBG">
											<table class="content" cellSpacing="1" cellPadding="5" border="0">
												<TR class="blueBG" align="right">
													<TD></TD>
													<TD><B>Width</B></TD>
												</TR>
												<xsl:for-each select="../ColumnDefinitions/ColumnInfo">
													<xsl:variable name="name" select="@name"/>
													<xsl:if test="@type = 'string'">
														<xsl:element name="tr">
															<xsl:attribute name="class">
																<xsl:choose>
																	<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
																	<xsl:otherwise>greyBG</xsl:otherwise>
																</xsl:choose>
															</xsl:attribute>

															<TD align="left"><B><xsl:value-of select="@name"/></B></TD>
															<TD align="right"><xsl:value-of select="@width"/></TD>
														</xsl:element>
													</xsl:if>
												</xsl:for-each>
											</table>
										</td>
									</tr>
								</tbody>
							</table>
						</DIV>
					</xsl:if>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="UnivariateStats">
		<xsl:for-each select=".">
			<xsl:variable name="field" select="@field"/>
			<xsl:variable name="missingFreq" select="Counts/@missingFreq"/>
			<xsl:choose>
				<xsl:when test="count(Counts[Category])!=0">
					<xsl:apply-templates select="Counts[Category]"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:if test="../../ColumnDefinitions/ColumnInfo[@name = $field]/@type = 'categorical'">
						<xsl:if test="$missingFreq > 0">
							<p> </p>
							<DIV>
								<table cellSpacing="0" cellPadding="3" border="0">
									<tbody>
										<tr>
											<td class="tableBG">
												<H3 class="tableHead"><xsl:value-of select="$field" /></H3>
												<table class="content" cellSpacing="1" cellPadding="5" border="0">
													<TR class="blueBG">
														<TH align="left">Level Name</TH>
														<TH align="right">Counts</TH>
													</TR>

													<xsl:if test="$missingFreq != 0">
														<xsl:element name="tr">
															<xsl:attribute name="class">
																<xsl:choose>
																	<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
																	<xsl:otherwise>greyBG</xsl:otherwise>
																</xsl:choose>
															</xsl:attribute>

															<TD align="left"> Missing </TD>
															<TD align="right"> <xsl:value-of select="$missingFreq "/> </TD>
														</xsl:element>
													</xsl:if>
												</table>
											</td>
										</tr>
									</tbody>
								</table>
							</DIV>
						</xsl:if>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="Counts[Category]">
		<p> </p>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead"><xsl:value-of select="../@field" /></H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TR class="blueBG">
									<TH align="left">Level Name</TH>
									<TH align="right">Counts</TH>
								</TR>
								<xsl:apply-templates select="Category"/>
								<xsl:if test="position()=last()">
									<xsl:if test="@missingFreq != 0">
										<TR class="blueBG">
											<TD align="left"> Missing </TD>
											<TD align="right"> <xsl:value-of select="@missingFreq "/> </TD>
										</TR>
									</xsl:if>
								</xsl:if>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>
	</xsl:template>

	<xsl:template match="Category">
		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<TD align="left"> <xsl:value-of select="@value"/> </TD>
			<TD align="right"> <xsl:value-of select="@freq"/> </TD>
		</xsl:element>
	</xsl:template>

	<xsl:template match="NumericInfo">
		<xsl:variable name="decimalPattern" select="../../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../../DisplayOptions/@scientificPattern"/>
		<xsl:variable name="decimalZero" select="format-number(0, $decimalPattern)"/>
		<xsl:variable name="mean" select="format-number(@mean, $decimalPattern)"/>
		<xsl:variable name="minimum" select="format-number(@minimum, $decimalPattern)"/>
		<xsl:variable name="maximum" select="format-number(@maximum, $decimalPattern)"/>
		<xsl:variable name="standardDeviation" select="format-number(@standardDeviation, $decimalPattern)"/>

		<TD align="right">
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@mean" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</TD>
		<TD align="right">
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@minimum" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</TD>
		<TD align="right">
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@maximum" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</TD>
		<TD align="right">
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@standardDeviation" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</TD>
		<TD align="right"> <xsl:value-of select="../Counts/@missingFreq"/> </TD>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
				<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:when test="$string = 0">
					<xsl:value-of select="format-number($string, $decimalPattern)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="format-number($string, $scientificPattern)"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
