/* @(#) Copyright (c) 2002, 2006 Insightful, Inc.  All rights reserved. */

/* QueryTester.java */
/* Program for testing EJB connection to S-PLUS */

import com.insightful.splus.*;
import com.insightful.controls.*;
import ejbsplus.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import javax.naming.*;
import java.util.Properties;
import javax.swing.border.EmptyBorder;


public class QueryTester extends JFrame {

    String ejbHost = null;
    QueryTesterProxy proxy = null;
    SplusEngine engine = null;
    JFrame m_helpFrame = null;
    JTextArea m_splusInput = new JTextArea();
    JTextArea m_splusOutput = new JTextArea();
    String m_helpText = "Type an S-PLUS expression in the \"S-PLUS input\" field,"
			+ " and click the \"send to S-PLUS\" button to evaluate"
			+ " the expression, showing the output in"
			+ " the \"S-PLUS output\" window.\n\n";

    public QueryTester(String host) {

	super("Query Tester Example");

	ejbHost = host;

	try {		// create a callback handler
	    proxy = new QueryTesterProxy(this);
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}

	JScrollPane scrollIn =  new JScrollPane(m_splusInput, 
				    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				    JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	JScrollPane scrollOut = new JScrollPane(m_splusOutput,
				    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				    JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

	scrollIn.setBorder(BorderFactory.createTitledBorder("S-PLUS input"));
	scrollOut.setBorder(BorderFactory.createTitledBorder("S-PLUS output"));

	JPanel main = new JPanel();
	main.setLayout(new BoxLayout(main, BoxLayout.Y_AXIS));
	main.add(scrollIn);
	main.add(Box.createVerticalStrut(5));
	main.add(scrollOut);

	JPanel buttons = new JPanel(new FlowLayout());
	buttons.add(newButton("send to S-PLUS",
			  	new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		m_splusOutput.setText("sending command to splus...");

		// Evaluate Splus command in a different thread from the
		// current thread (the UI event thread that handles button
		// pushes).  This matters if interactive graphics are tried.

		Thread th = new Thread() {
		    public void run() {
			doSplusExpression();
		    }
		};
		th.start();
	    }
	}));
	buttons.add(newButton("clear input",
			  new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		m_splusInput.setText("");
	    }
	}));
	buttons.add(newButton("help",
			  new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		if (m_helpFrame!=null) {
		    m_helpFrame.dispose();
		    m_helpFrame = null;
		}

		m_helpFrame = new JFrame("Help");
		m_helpFrame.getContentPane().setLayout(new BorderLayout());
		JTextArea txt = new JTextArea(m_helpText);
		txt.setLineWrap(true);
		txt.setWrapStyleWord(true);
		JScrollPane scroll =
			new JScrollPane(txt,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		m_helpFrame.getContentPane().add(scroll, BorderLayout.CENTER);
		m_helpFrame.setSize(300, 200);
		m_helpFrame.setVisible(true);
		scroll.getViewport().setViewPosition(new Point(0,0));
	    }
	}));
	buttons.add(newButton("quit",
			  new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		System.exit(0);
	    }
	}));

	Container contentPane = getContentPane();
	contentPane.setLayout(new BorderLayout(5, 5));
	contentPane.add(main, BorderLayout.CENTER);
	contentPane.add(buttons, BorderLayout.SOUTH);
	setSize(600, 400);
	show();
    }

    public JButton newButton(String title, ActionListener action) {

	JButton b = new JButton(title);
	b.addActionListener(action);
	return(b);
    }

    public void doSplusExpression() {

	String str = "";
	String cmd = str + m_splusInput.getText();

	try {
	    SplusDataResult result = getSession().eval(cmd, proxy);
	    if (result != null) {
		if (result.hasOutput()) str += result.getOutput()+"\n\n";
		if (result.hasError()) str += result.getError();
	    }
	} catch (Exception ex) {
	    ex.printStackTrace();
	}
	if (str.length()<1)  str += "no output";
	m_splusOutput.setText(str);
    }

    public SplusEngine getSession() {

    	if (engine == null) {
	    try {
		Properties p = new Properties();
		p.setProperty(Context.PROVIDER_URL, ejbHost);
		p.setProperty(Context.INITIAL_CONTEXT_FACTORY, 
				"org.jnp.interfaces.NamingContextFactory");
		p.setProperty(Context.URL_PKG_PREFIXES, "org.jboss.naming");

		Context myContext = new InitialContext(p);

		SplusEngineHome eHome = (SplusEngineHome)
					myContext.lookup("SplusEngine");
		engine = eHome.create();
	    } catch (Exception ex) {
		ex.printStackTrace();
	    }
	}
	return engine;
    }

    public String[] getLoginData() {

	final String [] vals = {"","",""};

	final JDialog login = new JDialog();
	login.setTitle("Login");
	login.setModal(true);

	JPanel centerPanel = new JPanel();
	centerPanel.setLayout(new GridLayout(3,2,10,10));
	centerPanel.setBorder(new EmptyBorder(10,10,10,10));

	centerPanel.add(new JLabel("S-PLUS Host:"));
	final JTextField host = new JTextField();
	centerPanel.add(host);

	centerPanel.add(new JLabel("User Name:"));
	final JTextField user = new JTextField();
	centerPanel.add(user);

	centerPanel.add(new JLabel("Password:"));
	final JPasswordField pw = new JPasswordField();
	centerPanel.add(pw);

	final JButton okButton = new JButton("Login");
	final JButton cancelButton = new JButton("Cancel");
	JPanel buttonPanel = new JPanel();

	ActionListener buttonListener = new ActionListener(){
	    public void actionPerformed(ActionEvent ae) {   
		JButton buttonPressed = (JButton) ae.getSource();

		if (buttonPressed == okButton) {

		    vals[0] = host.getText();
		    vals[1] = user.getText();

		    char [] word = pw.getPassword();
		    if (word != null && word.length > 0)
			vals[2] = new String(word);

		    for (int i = 1; i<word.length; i++)
			word[i] = 0;	// overwrite password char []

		    if (	vals[0] == null || vals[0].length() == 0 ||
				vals[1] == null || vals[1].length() == 0 ||
				vals[2] == null || vals[2].length() == 0) {
			JOptionPane.showMessageDialog(login, 
						"All entries are required.",
						"Required Field Error",
						JOptionPane.WARNING_MESSAGE);
			return;
		    }
		    login.dispose();
		}
		else if (buttonPressed == cancelButton) {
		    login.dispose();
		}
            }
	};

	okButton.addActionListener(buttonListener);
	buttonPanel.add(okButton);

	cancelButton.addActionListener(buttonListener);
	buttonPanel.add(cancelButton);

	login.getContentPane().add(centerPanel, BorderLayout.CENTER);
        login.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
	login.pack();

	Dimension dialogDim = login.getSize();
	Dimension screenDim = login.getToolkit().getScreenSize();
	login.setLocation((screenDim.width-dialogDim.width)/2,   
                           (screenDim.height-dialogDim.height)/2);
	login.setResizable(false);
	login.show();

	while (login.isShowing()) {
	    try { Thread.currentThread().sleep(200); } catch (Exception ex){}
	}
	return vals;
    }

    static String usage = 
		"Usage: $JAVA_HOME/bin/java QueryTester hostname:port\n\n" +
		"where:\n" +
		"  hostname = the host running the EJB container (jboss)\n" +
		"  port = RMI port that the EJB container is running on\n\n" +
		"example:  /usr/bin/java QueryTester apple:1099";

    public static void main(String [] args){
	if (args.length < 1) {
		System.out.println("Argument is required:\n\n");
		System.out.println(usage);
		System.exit(0);
	}
	new QueryTester(args[0]);
    }
}
