#!/bin/sh

# Copyright (c) 2002, 2006 Insightful, Inc.  All rights reserved.

#
#  Run script for sample S-PLUS EJB client. 
#

if [ -z "$JAVA_HOME" ]
then
	echo "The JAVA_HOME environmental variable must be set"
	exit 1
fi

if [ -z "$JBOSS_HOME" ]
then
	echo "The JBOSS_HOME environmental variable must be set"
	exit 1
fi

if [ "x$SHOME" = "x" ]
then
	echo "The SHOME environmental variable must be set"
	exit 1
fi

CLASSPATH=.:QueryTester.jar:"$SHOME"/java/Splus.jar:"$SHOME"/java/jre/lib/ext/Splus.jar:"$JBOSS_HOME"/client/jboss-client.jar:"$JBOSS_HOME"/lib/ext/jnp-client.jar:../SplusEngine.jar
export CLASSPATH

EJBHOST=$1
if [ "x$EJBHOST" = "x" ]
then
	echo "Please specify an EJB host parameter.  For example:"
	echo "   > ./client.sh \"apple:1099\""
	exit 1
fi

echo "Running QueryTester.java"
"$JAVA_HOME"/bin/java QueryTester $EJBHOST
