
import com.insightful.splus.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;

public class ImageCalculatorExample extends JFrame {
    Image m_image = null;
    int m_imageWidth = 0;
    int m_imageHeight = 0;
    public static int[] m_red = new int[0];
    public static int[] m_green = new int[0];
    public static int[] m_blue = new int[0];

    String m_helpText =
	"Type an S-PLUS expression in the \"S-PLUS input\" field, and click the \"send to S-PLUS\" button to evaluate the expression, showing the output in the \"S-PLUS output\" window.\n\nAny java.graph output will be displayed in the upper-right window.\n\nThe \"load image\" button loads an image file (gif or jpeg) into the upper-left window.  If an image is loaded, before an S-PLUS expression is evaluated the variables \"red\", \"green\", and \"blue\" are set to matrices containing the RGB values in the image.";
    JFrame m_helpFrame = null;

    JComponent m_imagePane = new JComponent() {
	public void paintComponent(Graphics g) {
	    if (m_image==null) {
		g.setColor(Color.black);
		g.drawString("no image", 30, 30);
	    } else {
		g.drawImage(m_image, 0, 0, getWidth(), getHeight(), null);
	    }
	}
    };
    JComponent m_splusGraph = SplusUserApp.getGraph();
    JTextArea m_splusInput = new JTextArea();
    JTextArea m_splusOutput = new JTextArea();
    String m_currentDirectory = null;

public ImageCalculatorExample() {
    super("Image Calculator Example");

    JScrollPane scrollInput = 
	new JScrollPane(m_splusInput,
			JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
			JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    JScrollPane scrollOutput = 
	new JScrollPane(m_splusOutput,
			JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
			JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);

    m_imagePane.setBorder(BorderFactory.createTitledBorder("image"));
    m_splusGraph.setBorder(BorderFactory.createTitledBorder("S-PLUS graph"));
    scrollInput.setBorder(BorderFactory.createTitledBorder("S-PLUS input"));
    scrollOutput.setBorder(BorderFactory.createTitledBorder("S-PLUS output"));

    JPanel main = new JPanel();
    main.setLayout(new BoxLayout(main, BoxLayout.Y_AXIS));

    JPanel grid = new JPanel(new GridLayout(0, 2, 5, 5));
    grid.add(m_imagePane);
    grid.add(m_splusGraph);

    main.add(grid);
    main.add(Box.createVerticalStrut(5));
    main.add(scrollInput);
    main.add(Box.createVerticalStrut(5));
    main.add(scrollOutput);

    JPanel buttons = new JPanel(new FlowLayout());
    buttons.add(newButton("load image",
			  new ActionListener() {
	public void actionPerformed(ActionEvent e) {
	    loadImage();
	}
    }));
    buttons.add(newButton("send to S-PLUS",
			  new ActionListener() {
	public void actionPerformed(ActionEvent e) {
	    m_splusOutput.setText("sending command to splus...");

	    // Evaluate Splus command in a different thread from the
	    // current thread (the UI event thread that handles button
	    // pushes).  This is necessary if the command executes
	    // identify() or locator(), which need to execute display
	    // update events to update the display and handle mouse
	    // clicks.  If this was not done in a separate thread,
	    // identify() would hang, waiting for mouse events that
	    // should be generated by the UI event thread.

	    Thread th = new Thread() {
		public void run() {
		    doSplusExpression();
		}
	    };
	    th.start();
	}
    }));
    buttons.add(newButton("clear input",
			  new ActionListener() {
	public void actionPerformed(ActionEvent e) {
	    m_splusInput.setText("");
	}
    }));
    buttons.add(newButton("help",
			  new ActionListener() {
	public void actionPerformed(ActionEvent e) {
	    if (m_helpFrame!=null) {
		m_helpFrame.dispose();
		m_helpFrame = null;
	    }

	    m_helpFrame = new JFrame("Help");
	    m_helpFrame.getContentPane().setLayout(new BorderLayout());
	    JTextArea txt = new JTextArea(m_helpText);
	    txt.setLineWrap(true);
	    txt.setWrapStyleWord(true);
	    JScrollPane scroll =
		new JScrollPane(txt,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
	    m_helpFrame.getContentPane().add(scroll, BorderLayout.CENTER);
	    m_helpFrame.setSize(300, 200);
	    m_helpFrame.setVisible(true);
	    scroll.getViewport().setViewPosition(new Point(0,0));
	}
    }));
    buttons.add(newButton("quit",
			  new ActionListener() {
	public void actionPerformed(ActionEvent e) {
	    System.exit(0);
	}
    }));

    Container contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout(5, 5));
    contentPane.add(main, BorderLayout.CENTER);
    contentPane.add(buttons, BorderLayout.SOUTH);
    setSize(600, 400);
    show();
}

public JButton newButton(String title, ActionListener action) {
    JButton b = new JButton(title);
    b.addActionListener(action);
    return(b);
}

public void loadImage() {
    JFileChooser chooser = new JFileChooser();
    chooser.setCurrentDirectory((m_currentDirectory==null)? null :
				new File(m_currentDirectory));
    int returnVal = chooser.showOpenDialog(this);
    if (returnVal!=JFileChooser.APPROVE_OPTION)
	return;
    m_currentDirectory = chooser.getCurrentDirectory().getPath();
    String filename = chooser.getSelectedFile().getPath();
    m_image = Toolkit.getDefaultToolkit().createImage(filename);
    try {
	MediaTracker tracker = new MediaTracker(this);
	tracker.addImage(m_image, 0);
	tracker.waitForAll(2000);
	m_imageWidth = m_image.getWidth(this);
	m_imageHeight = m_image.getHeight(this);
    } catch (Exception ex) {
    }
    m_imagePane.repaint();	    
}

public void doSplusExpression() {
    // grab image pixels, store in global vars
    String varCmd = "";
    if (m_image!=null) {
	int len = m_imageWidth*m_imageHeight;
	int pixels[] = new int[len];
	PixelGrabber grabber =
	    new PixelGrabber(m_image,
			     0, 0, m_imageWidth, m_imageHeight, pixels,
			     0, m_imageWidth);
	try {
	    boolean grabval = grabber.grabPixels();
	} catch (Exception e) {}
	m_red = new int[len];
	m_green = new int[len];
	m_blue = new int[len];
	for (int i=0; i<len; i++) {
	    m_red[i] = (pixels[i]&0x00FF0000) >> 16;
	    m_green[i] = (pixels[i]&0x0000FF00) >> 8;
	    m_blue[i] = (pixels[i]&0x000000FF);
	}
	varCmd =
	    getImageMatrixCommand("red")+";"+
	    getImageMatrixCommand("green")+";"+
	    getImageMatrixCommand("blue")+";";
    }

    String cmd = varCmd+m_splusInput.getText();

    SplusDataResult result =
	SplusUserApp.eval(cmd, true, false,
			  true, false, false);
    String str = "";
    if (result.hasOutput()) str += result.getOutput()+"\n\n";
    if (result.hasError()) str += result.getError();
    if (str.length()<1) {
	str += "no output";
    }
    m_splusOutput.setText(str);
}

public String getImageMatrixCommand(String colorName) {
    String varName = colorName;
    String fieldName = "m_"+colorName;
    return(varName+" <- " +
	   "matrix(data=.JavaField(" +
	   "\"ImageCalculatorExample\"" +
	   ", \""+fieldName+"\"" +
	   ", \"[I\", client = T), nrow=" +
	   m_imageHeight+", ncol="+m_imageWidth+", byrow=T)");
}


public static void main(String [] args){
    new ImageCalculatorExample();
}


}

