/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001

  splang.h: interface for the CSPlanguage class wrapping S-PLUS object of class "language" 
*/

#if !defined(__SCONNECT_SPLANG_H_INCLUDED__)
#define __SCONNECT_SPLANG_H_INCLUDED__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "spobject.h"
class CSPnamed;
class SCONNECT_LIB_EXTERN CSPlanguage : public CSPobject  
{
//////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////
protected:
	//Default constructor
	CSPlanguage();
	virtual ~CSPlanguage();

//////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////
public:
  //Return TRUE if the object is a valid numeric class
	virtual BOOL IsValid(void) const;

//////////////////////////////////////////////////////
// Operations
//////////////////////////////////////////////////////
public:
	//Evaluate body of the "language"  
	virtual CSPobject Eval(void) const =0;          //Must overide
	virtual CSPobject Eval(long lFrame) const;      //Eval in lFrame 
	virtual CSPobject EvalInLocalFrame(void) const; //Eval in a new temporary eval frame

	//Same as above but add or replace objects with names into the evaluation frame first.
	virtual CSPobject Eval(const CSPnamed& sArgs) const;              //Eval in current eval frame
	virtual CSPobject Eval(const CSPnamed& sArgs, long lFrame) const; //Eval in current eval frame
	virtual CSPobject EvalInLocalFrame(const CSPnamed& sArgs) const;  //Eval in a new temporary eval frame

	//Deparse the object and return text.
	CSPobject Deparse(BOOL bValidate=TRUE);
};

#endif // !defined(__SCONNECT_SPLANG_H_INCLUDED__)

