/*
	Connect/C++ : Copyright (c) 2001, 2006 Insightful Corp.
	All rights reserved.
	Version 6.0: 2001
*/

#ifdef WIN32

#include "windows.h"
#include "oleauto.h"

#include "spolecli.h"

int CSPoleclient::GetVariantType( void )
{
	return VT_DISPATCH;
}

BOOL CSPoleclient::GetAsVariant(void *pvVariant, BOOL bMissingsAsErrors, BOOL bValidate)
{
	BOOL bSuccess = FALSE;
#ifndef WIN32
	return bSuccess;
#endif // !WIN32

	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
	if( !pvVariant )
		return bSuccess;

	LPVARIANT lpReturnVariant = (LPVARIANT)pvVariant;
	memset( lpReturnVariant, 0, sizeof(VARIANT) );

	lpReturnVariant->vt = GetVariantType();

	s_object *psTmp = (GetPtr()->value.tree[0]);
	if ( psTmp )
	{
		long lValue = INTEGER_POINTER(psTmp)[0];
		lpReturnVariant->pdispVal = (LPDISPATCH)lValue;
	}

	if ( lpReturnVariant->pdispVal != NULL )
		(lpReturnVariant->pdispVal)->AddRef();

	bSuccess = TRUE;

	return bSuccess;
}

BOOL CSPoleclient::SetAsVariant(void *pvVariant, BOOL bValidate)
{
	BOOL bSuccess = FALSE;
#ifndef WIN32
	return bSuccess;
#endif // !WIN32
	if(bValidate && !IsValid())
		SCONNECT_ThrowException(SCONNECT_INVALID_SOBJECT);
	if( !pvVariant )
		return bSuccess;

	LPVARIANT lpReturnVariant = (LPVARIANT)pvVariant;
	if ( lpReturnVariant->vt != VT_DISPATCH )
		return bSuccess;

	Init( lpReturnVariant->pdispVal );
	bSuccess = TRUE;

	return bSuccess;
}

#endif // WIN32
