"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RLineToHVLine = void 0;
const operator_1 = require("../../../interp/operator");
const draw_call_1 = require("../draw-call");
const general_1 = require("./general");
class RLineToHVLine extends general_1.DrawCallOptimizationPass {
    *doFlush(st) {
        yield st;
    }
    tryUpdateState(st, dc) {
        if (dc.operator !== operator_1.CharStringOperator.RLineTo)
            return null;
        const lastIsY = (st.operator === operator_1.CharStringOperator.VLineTo) === st.args.length % 2 > 0;
        const [dx, dy] = dc.args;
        const canMerge = (lastIsY && (0, general_1.argIsZero)(dy)) || (!lastIsY && (0, general_1.argIsZero)(dx));
        const limits = this.ctx.getLimits();
        if (canMerge) {
            const merged = new draw_call_1.CffDrawCall(st.ivd, [...st.args, lastIsY ? dx : dy], st.operator);
            if (merged.stackRidge < limits.maxStack && merged.stackRise < limits.maxStack) {
                return merged;
            }
            else {
                return null;
            }
        }
        else {
            return null;
        }
    }
    tryInitState(dc) {
        if (dc.operator !== operator_1.CharStringOperator.RLineTo)
            return null;
        const [dx, dy] = dc.args;
        if ((0, general_1.argIsZero)(dx)) {
            return new draw_call_1.CffDrawCall(dc.ivd, [dy], operator_1.CharStringOperator.VLineTo);
        }
        else if ((0, general_1.argIsZero)(dy)) {
            return new draw_call_1.CffDrawCall(dc.ivd, [dx], operator_1.CharStringOperator.HLineTo);
        }
        else {
            return null;
        }
    }
}
exports.RLineToHVLine = RLineToHVLine;
//# sourceMappingURL=hv-lineto.js.map