"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeatureParams = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_layout_1 = require("@ot-builder/ot-layout");
const prelude_1 = require("@ot-builder/prelude");
const primitive_1 = require("@ot-builder/primitive");
exports.FeatureParams = {
    read(view, tag) {
        for (const handler of FeatureParamHandlers) {
            const result = handler.tryRead(tag, view);
            if (result)
                return result;
        }
        return undefined;
    },
    writeOpt(fp, tag) {
        if (!fp)
            return null;
        const tagDrivenTypeID = ot_layout_1.GsubGpos.FeatureParams.tagToTypeIDMap[tag];
        if (!tagDrivenTypeID)
            return null;
        const fpTag = fp.cast(tagDrivenTypeID);
        if (!fpTag)
            return null;
        for (const handler of FeatureParamHandlers) {
            const result = handler.tryWrite(fp);
            if (result)
                return result;
        }
        return null;
    }
};
function CreateHandler(tid, io) {
    return {
        tryRead(tag, view) {
            if (ot_layout_1.GsubGpos.FeatureParams.tagToTypeIDMap[tag] === tid) {
                return prelude_1.Sigma.DependentPair.create(tid, view.next(io));
            }
            else {
                return undefined;
            }
        },
        tryWrite(fpRaw) {
            const fp = fpRaw.cast(tid);
            if (fp)
                return bin_util_1.Frag.from(io, fp);
            else
                return undefined;
        }
    };
}
const FeatureParamStylisticSet = CreateHandler(ot_layout_1.GsubGpos.FeatureParams.TID_StylisticSet, {
    read(view) {
        const version = view.uint16();
        errors_1.Assert.VersionSupported("FeatureParams::StylisticSet", version, 0);
        const uiNameID = view.uint16();
        return { uiNameID };
    },
    write(frag, fp) {
        frag.uint16(0);
        frag.uint16(fp.uiNameID);
    }
});
const FeatureParamCharacterVariant = CreateHandler(ot_layout_1.GsubGpos.FeatureParams.TID_CharacterVariant, {
    read(view) {
        const format = view.uint16();
        errors_1.Assert.FormatSupported("FeatureParam::CharacterVariant", format, 0);
        const featUiLabelNameId = view.uint16();
        const featUiTooltipTextNameId = view.uint16();
        const sampleTextNameId = view.uint16();
        const numNamedParameters = view.uint16();
        const firstParamUiLabelNameId = view.uint16();
        const charCount = view.uint16();
        const chars = view.array(charCount, primitive_1.UInt24);
        return {
            featUiLabelNameId,
            featUiTooltipTextNameId,
            sampleTextNameId,
            numNamedParameters,
            firstParamUiLabelNameId,
            characters: chars
        };
    },
    write(frag, fp) {
        frag.uint16(0)
            .uint16(fp.featUiLabelNameId)
            .uint16(fp.featUiTooltipTextNameId)
            .uint16(fp.sampleTextNameId)
            .uint16(fp.numNamedParameters)
            .uint16(fp.firstParamUiLabelNameId)
            .uint16(fp.characters.length)
            .array(primitive_1.UInt24, fp.characters);
    }
});
const FeatureParamHandlers = [FeatureParamStylisticSet, FeatureParamCharacterVariant];
//# sourceMappingURL=feature-param.js.map