/*
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Copyright © 2025 Keith Packard
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* This file is auto-generated from mk-jis-charsets.py */
/* clang-format off */

#ifndef _JIS_CHARSETS_H_
#define _JIS_CHARSETS_H_

struct jis_charmap {
    uint8_t  first;
    uint8_t  last;
    uint16_t offset;
};

#define __euc_jp_invalid_jis 0xffff
#define __euc_jp_invalid_unicode 0xffff
#define __euc_jp_split_codes 0x4000

/* unicode tables */
#ifdef define_unicode

#define __euc_jp_unicode_first_row 0x00
#define __euc_jp_unicode_last_row 0x9f

#ifndef split_unicode
#define split_unicode_offset 0
#endif

static const uint16_t __euc_jp_unicode_codes[] = {
    /* 0x00: 0xa1 - 0xff */
            0x22c2, 0xa1f1, 0xa1f2, 0x22f0, 0x005c, 0x22c3, 0xa1f8, 0xa1af, 0x22ed, 0x22ec, 0xffff, 0xa2cc, 0xffff, 0x22ee, 0x22b4,
    0xa1eb, 0xa1de, 0xffff, 0xffff, 0xa1ad, 0xffff, 0xa2f9, 0xffff, 0x22b1, 0xffff, 0x22eb, 0xffff, 0xffff, 0xffff, 0xffff, 0x22c4,
    0x2aa2, 0x2aa1, 0x2aa4, 0x2aaa, 0x2aa3, 0x2aa9, 0x29a1, 0x2aae, 0x2ab2, 0x2ab1, 0x2ab4, 0x2ab3, 0x2ac0, 0x2abf, 0x2ac2, 0x2ac1,
    0xffff, 0x2ad0, 0x2ad2, 0x2ad1, 0x2ad4, 0x2ad8, 0x2ad3, 0xa1df, 0x29ac, 0x2ae3, 0x2ae2, 0x2ae5, 0x2ae4, 0x2af2, 0x29b0, 0x29ce,
    0x2ba2, 0x2ba1, 0x2ba4, 0x2baa, 0x2ba3, 0x2ba9, 0x29c1, 0x2bae, 0x2bb2, 0x2bb1, 0x2bb4, 0x2bb3, 0x2bc0, 0x2bbf, 0x2bc2, 0x2bc1,
    0x29c3, 0x2bd0, 0x2bd2, 0x2bd1, 0x2bd4, 0x2bd8, 0x2bd3, 0xa1e0, 0x29cc, 0x2be3, 0x2be2, 0x2be5, 0x2be4, 0x2bf2, 0x29d0, 0x2bf3,

    /* 0x01: 0x00 - 0xf5 */
    0x2aa7, 0x2ba7, 0x2aa5, 0x2ba5, 0x2aa8, 0x2ba8, 0x2aab, 0x2bab, 0x2aac, 0x2bac, 0x2aaf, 0x2baf, 0x2aad, 0x2bad, 0x2ab0, 0x2bb0,
    0x29a2, 0x29c2, 0x2ab7, 0x2bb7, 0xffff, 0xffff, 0x2ab6, 0x2bb6, 0x2ab8, 0x2bb8, 0x2ab5, 0x2bb5, 0x2aba, 0x2bba, 0x2abb, 0x2bbb,
    0x2abd, 0x2bbd, 0x2abc, 0xffff, 0x2abe, 0x2bbe, 0x29a4, 0x29c4, 0x2ac7, 0x2bc7, 0x2ac5, 0x2bc5, 0xffff, 0xffff, 0x2ac6, 0x2bc6,
    0x2ac4, 0x29c5, 0x29a6, 0x29c6, 0x2ac8, 0x2bc8, 0x2ac9, 0x2bc9, 0x29c7, 0x2aca, 0x2bca, 0x2acc, 0x2bcc, 0x2acb, 0x2bcb, 0x29a9,
    0x29c9, 0x29a8, 0x29c8, 0x2acd, 0x2bcd, 0x2acf, 0x2bcf, 0x2ace, 0x2bce, 0x29ca, 0x29ab, 0x29cb, 0x2ad7, 0x2bd7, 0xffff, 0xffff,
    0x2ad6, 0x2bd6, 0x29ad, 0x29cd, 0x2ad9, 0x2bd9, 0x2adb, 0x2bdb, 0x2ada, 0x2bda, 0x2adc, 0x2bdc, 0x2add, 0x2bdd, 0x2adf, 0x2bdf,
    0x2ade, 0x2bde, 0x2ae1, 0x2be1, 0x2ae0, 0x2be0, 0x29af, 0x29cf, 0x2aec, 0x2bec, 0x2ae9, 0x2be9, 0x2ae6, 0x2be6, 0x2aeb, 0x2beb,
    0x2ae8, 0x2be8, 0x2aea, 0x2bea, 0x2af1, 0x2bf1, 0x2af4, 0x2bf4, 0x2af3, 0x2af5, 0x2bf5, 0x2af7, 0x2bf7, 0x2af6, 0x2bf6, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2aa6, 0x2ba6, 0x2ac3,
    0x2bc3, 0x2ad5, 0x2bd5, 0x2ae7, 0x2be7, 0x2af0, 0x2bf0, 0x2aed, 0x2bed, 0x2aef, 0x2bef, 0x2aee, 0x2bee, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2bb9,

    /* 0x02: 0xc7 - 0xdd */
                                                            0x22b0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x22af, 0x22b2, 0x22b6, 0x22b5, 0xffff, 0x22b3,

    /* 0x03: 0x84 - 0xce */
                                    0x22b8, 0x22b9, 0x26e1, 0xffff, 0x26e2, 0x26e3, 0x26e4, 0xffff, 0x26e7, 0xffff, 0x26e9, 0x26ec,
    0x26f6, 0xa6a1, 0xa6a2, 0xa6a3, 0xa6a4, 0xa6a5, 0xa6a6, 0xa6a7, 0xa6a8, 0xa6a9, 0xa6aa, 0xa6ab, 0xa6ac, 0xa6ad, 0xa6ae, 0xa6af,
    0xa6b0, 0xa6b1, 0xffff, 0xa6b2, 0xa6b3, 0xa6b4, 0xa6b5, 0xa6b6, 0xa6b7, 0xa6b8, 0x26e5, 0x26ea, 0x26f1, 0x26f2, 0x26f3, 0x26f4,
    0x26fb, 0xa6c1, 0xa6c2, 0xa6c3, 0xa6c4, 0xa6c5, 0xa6c6, 0xa6c7, 0xa6c8, 0xa6c9, 0xa6ca, 0xa6cb, 0xa6cc, 0xa6cd, 0xa6ce, 0xa6cf,
    0xa6d0, 0xa6d1, 0x26f8, 0xa6d2, 0xa6d3, 0xa6d4, 0xa6d5, 0xa6d6, 0xa6d7, 0xa6d8, 0x26f5, 0x26fa, 0x26f7, 0x26f9, 0x26fc,

    /* 0x04: 0x01 - 0x5f */
            0xa7a7, 0x27c2, 0x27c3, 0x27c4, 0x27c5, 0x27c6, 0x27c7, 0x27c8, 0x27c9, 0x27ca, 0x27cb, 0x27cc, 0xffff, 0x27cd, 0x27ce,
    0xa7a1, 0xa7a2, 0xa7a3, 0xa7a4, 0xa7a5, 0xa7a6, 0xa7a8, 0xa7a9, 0xa7aa, 0xa7ab, 0xa7ac, 0xa7ad, 0xa7ae, 0xa7af, 0xa7b0, 0xa7b1,
    0xa7b2, 0xa7b3, 0xa7b4, 0xa7b5, 0xa7b6, 0xa7b7, 0xa7b8, 0xa7b9, 0xa7ba, 0xa7bb, 0xa7bc, 0xa7bd, 0xa7be, 0xa7bf, 0xa7c0, 0xa7c1,
    0xa7d1, 0xa7d2, 0xa7d3, 0xa7d4, 0xa7d5, 0xa7d6, 0xa7d8, 0xa7d9, 0xa7da, 0xa7db, 0xa7dc, 0xa7dd, 0xa7de, 0xa7df, 0xa7e0, 0xa7e1,
    0xa7e2, 0xa7e3, 0xa7e4, 0xa7e5, 0xa7e6, 0xa7e7, 0xa7e8, 0xa7e9, 0xa7ea, 0xa7eb, 0xa7ec, 0xa7ed, 0xa7ee, 0xa7ef, 0xa7f0, 0xa7f1,
    0xffff, 0xa7d7, 0x27f2, 0x27f3, 0x27f4, 0x27f5, 0x27f6, 0x27f7, 0x27f8, 0x27f9, 0x27fa, 0x27fb, 0x27fc, 0xffff, 0x27fd, 0x27fe,

    /* 0x20: 0x10 - 0x3e */
    0xa1be, 0xffff, 0xffff, 0xffff, 0xffff, 0xa1bd, 0xa1c2, 0xffff, 0xa1c6, 0xa1c7, 0xffff, 0xffff, 0xa1c8, 0xa1c9, 0xffff, 0xffff,
    0xa2f7, 0xa2f8, 0xffff, 0xffff, 0xffff, 0xa1c5, 0xa1c4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xa2f3, 0xffff, 0xa1ec, 0xa1ed, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2a8, 0xffff, 0xffff, 0x007e,

    /* 0x21: 0x03 - 0xd4 */
                            0xa1ee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x22f1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x22ef, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2f2, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xa2ab, 0xa2ac, 0xa2aa, 0xa2ad, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xa2cd, 0xffff, 0xa2ce,

    /* 0x22: 0x00 - 0xa5 */
    0xa2cf, 0xffff, 0xa2df, 0xa2d0, 0xffff, 0xffff, 0xffff, 0xa2e0, 0xa2ba, 0xffff, 0xffff, 0xa2bb, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xa1dd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2e5, 0xffff, 0xffff, 0xa2e7, 0xa1e7, 0xffff,
    0xa2dc, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2ca, 0xa2cb, 0xa2c1, 0xa2c0, 0xa2e9, 0xa2ea, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xa1e8, 0xa2e8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2e6, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xa2e2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xa1e2, 0xa2e1, 0xffff, 0xffff, 0xffff, 0xffff, 0xa1e5, 0xa1e6, 0xffff, 0xffff, 0xa2e3, 0xa2e4, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xa2be, 0xa2bf, 0xffff, 0xffff, 0xa2bc, 0xa2bd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2dd,

    /* 0x23: 0x12 - 0x12 */
                    0xa2de,

    /* 0x25: 0x00 - 0xef */
    0xa8a1, 0xa8ac, 0xa8a2, 0xa8ad, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa8a3, 0xffff, 0xffff, 0xa8ae,
    0xa8a4, 0xffff, 0xffff, 0xa8af, 0xa8a6, 0xffff, 0xffff, 0xa8b1, 0xa8a5, 0xffff, 0xffff, 0xa8b0, 0xa8a7, 0xa8bc, 0xffff, 0xffff,
    0xa8b7, 0xffff, 0xffff, 0xa8b2, 0xa8a9, 0xa8be, 0xffff, 0xffff, 0xa8b9, 0xffff, 0xffff, 0xa8b4, 0xa8a8, 0xffff, 0xffff, 0xa8b8,
    0xa8bd, 0xffff, 0xffff, 0xa8b3, 0xa8aa, 0xffff, 0xffff, 0xa8ba, 0xa8bf, 0xffff, 0xffff, 0xa8b5, 0xa8ab, 0xffff, 0xffff, 0xa8bb,
    0xffff, 0xffff, 0xa8c0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa8b6, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xa2a3, 0xa2a2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xa2a5, 0xa2a4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2a7, 0xa2a6, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2a1, 0xa1fe, 0xffff, 0xffff, 0xffff, 0xa1fb, 0xffff, 0xffff, 0xa1fd, 0xa1fc,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2fe,

    /* 0x26: 0x05 - 0x6f */
                                            0xa1fa, 0xa1f9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xa1ea, 0xffff, 0xa1e9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa2f6, 0xffff, 0xffff, 0xa2f5, 0xffff, 0xa2f4,

    /* 0x30: 0x00 - 0xfe */
    0xa1a1, 0xa1a2, 0xa1a3, 0xa1b7, 0xffff, 0xa1b9, 0xa1ba, 0xa1bb, 0xa1d2, 0xa1d3, 0xa1d4, 0xa1d5, 0xa1d6, 0xa1d7, 0xa1d8, 0xa1d9,
    0xa1da, 0xa1db, 0xa2a9, 0xa2ae, 0xa1cc, 0xa1cd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa1c1, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xa4a1, 0xa4a2, 0xa4a3, 0xa4a4, 0xa4a5, 0xa4a6, 0xa4a7, 0xa4a8, 0xa4a9, 0xa4aa, 0xa4ab, 0xa4ac, 0xa4ad, 0xa4ae, 0xa4af,
    0xa4b0, 0xa4b1, 0xa4b2, 0xa4b3, 0xa4b4, 0xa4b5, 0xa4b6, 0xa4b7, 0xa4b8, 0xa4b9, 0xa4ba, 0xa4bb, 0xa4bc, 0xa4bd, 0xa4be, 0xa4bf,
    0xa4c0, 0xa4c1, 0xa4c2, 0xa4c3, 0xa4c4, 0xa4c5, 0xa4c6, 0xa4c7, 0xa4c8, 0xa4c9, 0xa4ca, 0xa4cb, 0xa4cc, 0xa4cd, 0xa4ce, 0xa4cf,
    0xa4d0, 0xa4d1, 0xa4d2, 0xa4d3, 0xa4d4, 0xa4d5, 0xa4d6, 0xa4d7, 0xa4d8, 0xa4d9, 0xa4da, 0xa4db, 0xa4dc, 0xa4dd, 0xa4de, 0xa4df,
    0xa4e0, 0xa4e1, 0xa4e2, 0xa4e3, 0xa4e4, 0xa4e5, 0xa4e6, 0xa4e7, 0xa4e8, 0xa4e9, 0xa4ea, 0xa4eb, 0xa4ec, 0xa4ed, 0xa4ee, 0xa4ef,
    0xa4f0, 0xa4f1, 0xa4f2, 0xa4f3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xa1ab, 0xa1ac, 0xa1b5, 0xa1b6, 0xffff,
    0xffff, 0xa5a1, 0xa5a2, 0xa5a3, 0xa5a4, 0xa5a5, 0xa5a6, 0xa5a7, 0xa5a8, 0xa5a9, 0xa5aa, 0xa5ab, 0xa5ac, 0xa5ad, 0xa5ae, 0xa5af,
    0xa5b0, 0xa5b1, 0xa5b2, 0xa5b3, 0xa5b4, 0xa5b5, 0xa5b6, 0xa5b7, 0xa5b8, 0xa5b9, 0xa5ba, 0xa5bb, 0xa5bc, 0xa5bd, 0xa5be, 0xa5bf,
    0xa5c0, 0xa5c1, 0xa5c2, 0xa5c3, 0xa5c4, 0xa5c5, 0xa5c6, 0xa5c7, 0xa5c8, 0xa5c9, 0xa5ca, 0xa5cb, 0xa5cc, 0xa5cd, 0xa5ce, 0xa5cf,
    0xa5d0, 0xa5d1, 0xa5d2, 0xa5d3, 0xa5d4, 0xa5d5, 0xa5d6, 0xa5d7, 0xa5d8, 0xa5d9, 0xa5da, 0xa5db, 0xa5dc, 0xa5dd, 0xa5de, 0xa5df,
    0xa5e0, 0xa5e1, 0xa5e2, 0xa5e3, 0xa5e4, 0xa5e5, 0xa5e6, 0xa5e7, 0xa5e8, 0xa5e9, 0xa5ea, 0xa5eb, 0xa5ec, 0xa5ed, 0xa5ee, 0xa5ef,
    0xa5f0, 0xa5f1, 0xa5f2, 0xa5f3, 0xa5f4, 0xa5f5, 0xa5f6, 0xffff, 0xffff, 0xffff, 0xffff, 0xa1a6, 0xa1bc, 0xa1b3, 0xa1b4,

    /* 0x4e: 0x00 - 0xff */
    0xb0ec, 0xc3fa, 0x30a1, 0xbcb7, 0x30a2, 0x30a3, 0xffff, 0xcbfc, 0xbee6, 0xbbb0, 0xbee5, 0xb2bc, 0x30a4, 0xc9d4, 0xcdbf, 0xffff,
    0xd0a2, 0xb1af, 0x30a5, 0xffff, 0xb3ee, 0xd0a3, 0xc0a4, 0xd2c2, 0xb5d6, 0xcaba, 0xffff, 0xffff, 0xffff, 0xffff, 0xbee7, 0x30a6,
    0xffff, 0xcebe, 0xffff, 0x30a7, 0x30a8, 0xffff, 0xcac2, 0xffff, 0x30a9, 0xffff, 0xd0a4, 0x30aa, 0xffff, 0xc3e6, 0x30ab, 0x30ac,
    0x30ad, 0xd0a5, 0xb6fa, 0xffff, 0xffff, 0x30ae, 0xd0a6, 0xffff, 0xb4dd, 0xc3b0, 0xffff, 0xbce7, 0xd0a7, 0xffff, 0xffff, 0xd0a8,
    0x30af, 0x30b0, 0xd0a9, 0xc7b5, 0x30b1, 0xb5d7, 0xffff, 0x30b2, 0xffff, 0xffff, 0xffff, 0xc7b7, 0xffff, 0xc6e3, 0xb8c3, 0xcbb3,
    0xffff, 0x30b3, 0xffff, 0xffff, 0xffff, 0xe9c9, 0xd0aa, 0xbee8, 0xd0ab, 0xb2b5, 0x30b4, 0xffff, 0x30b5, 0xb6e5, 0xb8f0, 0xcce9,
    0xffff, 0xffff, 0xd6a6, 0x30b6, 0xffff, 0xffff, 0xffff, 0xffff, 0x30b7, 0x30b8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xcdf0, 0xffff, 0xc6fd, 0x30b9, 0x30ba, 0xffff, 0xffff, 0xffff, 0x30bb, 0xffff, 0xffff, 0xffff, 0xffff, 0xb4a5, 0x30bc,
    0xb5b5, 0xffff, 0xd0ac, 0xffff, 0xffff, 0xd0ad, 0xcebb, 0xffff, 0xcdbd, 0xc1e8, 0xd0af, 0xbbf6, 0xc6f3, 0x30bd, 0xd0b2, 0xffff,
    0xffff, 0xb1be, 0xb8df, 0xffff, 0xb8de, 0xb0e6, 0x30be, 0x30bf, 0xcfcb, 0xcfca, 0xffff, 0xbab3, 0xb0a1, 0x30c0, 0xd0b3, 0xd0b4,
    0xd0b5, 0xcbb4, 0xd0b6, 0xffff, 0xb8f2, 0xb0e7, 0xcbf2, 0xffff, 0xb5fc, 0xffff, 0xffff, 0xb5fd, 0xb5fe, 0xc4e2, 0xcebc, 0x30c1,
    0xd0b7, 0xffff, 0xffff, 0xd0b8, 0xffff, 0xffff, 0xd0b9, 0xffff, 0xffff, 0x30c2, 0xbfcd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xbdba, 0xbfce, 0xd0be, 0x30c3, 0xd0bc, 0xffff, 0xd0bd, 0xb5d8, 0xffff, 0xffff, 0xbaa3, 0xb2f0, 0xffff, 0xd0bb, 0xd0ba, 0xcaa9,
    0x30c4, 0xffff, 0xffff, 0xffff, 0xbbc6, 0xbbc5, 0xc2be, 0xd0bf, 0xc9d5, 0xc0e7, 0x30c5, 0x30c6, 0xffff, 0xa1b8, 0xd0c0, 0xd0c2,
    0x30c7, 0x30c8, 0x30c9, 0xc2e5, 0xcee1, 0xb0ca, 0xffff, 0xffff, 0x30ca, 0xffff, 0xffff, 0xffff, 0xffff, 0xd0c1, 0xb2be, 0x30cb,
    0xb6c4, 0x30cc, 0xc3e7, 0x30cd, 0xffff, 0x30ce, 0xb7ef, 0xd0c3, 0xffff, 0xffff, 0xffff, 0xc7a4, 0xffff, 0x30cf, 0x30d0, 0x30d1,

    /* 0x4f: 0x00 - 0xff */
    0x30d2, 0xb4eb, 0x30d3, 0x30d4, 0xffff, 0xffff, 0xffff, 0xffff, 0x30d5, 0xd0c4, 0xb0cb, 0x30d6, 0x30d7, 0xb8e0, 0xb4ec, 0xc9fa,
    0xc8b2, 0xb5d9, 0x30d8, 0xffff, 0xffff, 0x30d9, 0x30da, 0x30db, 0xffff, 0x30dc, 0xb2f1, 0xffff, 0xd0e7, 0xc5c1, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x30dd, 0xc7ec,
    0xd0c6, 0x30de, 0xffff, 0x30e0, 0xc8bc, 0x30e1, 0xcee2, 0x30e2, 0xbfad, 0x30e3, 0xbbc7, 0x30e4, 0xbbf7, 0xb2c0, 0x30e5, 0xffff,
    0x30e6, 0xffff, 0x30e7, 0xc4d1, 0xffff, 0xffff, 0xc3a2, 0xd0ca, 0x30e8, 0x30e9, 0xffff, 0x30ea, 0x30eb, 0xb0cc, 0xc4e3, 0xbdbb,
    0xbab4, 0xcda4, 0x30ec, 0xc2ce, 0x30ed, 0xb2bf, 0x30ee, 0xd0c9, 0x30ef, 0xcdbe, 0xd0c5, 0xd0c7, 0xbaee, 0xd0c8, 0xd5a4, 0x30f0,
    0x30df, 0xffff, 0xffff, 0x30f1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd0d0, 0x30f2, 0xffff, 0x30f3, 0xffff, 0x30f4, 0xd0d3,
    0xd0d1, 0x30f5, 0xffff, 0xb2c2, 0xffff, 0xcabb, 0xd0cb, 0x30f6, 0x30f7, 0x30f8, 0x30f9, 0xd0cf, 0xb8f3, 0x30fa, 0x30fb, 0xbbc8,
    0xffff, 0x30fc, 0x30fd, 0xb4a6, 0x30fe, 0x31a1, 0xd0d4, 0xffff, 0xd0cc, 0x31a2, 0x31a3, 0xcee3, 0x31a4, 0xbbf8, 0x31a5, 0xd0cd,
    0x31a6, 0xd0d2, 0x31a7, 0x31a8, 0x31a9, 0xffff, 0xd0d5, 0x31aa, 0xd0ce, 0x31ab, 0x31ac, 0xb6a1, 0xffff, 0xb0cd, 0x31ad, 0x31ae,
    0xb6a2, 0xb2c1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5a5, 0xffff, 0xcbf9, 0xc9ee, 0xb8f4,
    0xffff, 0xffff, 0x31af, 0xffff, 0xffff, 0xbfaf, 0xceb7, 0x31b0, 0xffff, 0x31b1, 0xffff, 0x31b2, 0x31b3, 0x31b4, 0x31b5, 0xcad8,
    0x31b6, 0x31b7, 0xb7b8, 0xc2a5, 0xb2e4, 0x31b8, 0x31b9, 0xffff, 0x31ba, 0x31bb, 0xbdd3, 0x31bc, 0x31bd, 0x31be, 0xd0d9, 0x31bf,
    0xd0de, 0xd0dc, 0x31c0, 0xffff, 0xd0d7, 0xffff, 0xffff, 0xc2af, 0xd0da, 0xffff, 0xd0dd, 0xd0db, 0x31c1, 0xcadd, 0xffff, 0xd0d8,
    0x31c2, 0xbfae, 0x31c3, 0xcbf3, 0xd0df, 0xd0e0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbda4, 0xd0ed,
    0x31c4, 0xffff, 0x31c5, 0xc7d0, 0xffff, 0xc9b6, 0xd0e8, 0xffff, 0xcaf0, 0xffff, 0xb2b6, 0xffff, 0x31c6, 0x31c7, 0xd0ec, 0x31c8,

    /* 0x50: 0x00 - 0xfe */
    0x31c9, 0x31ca, 0xffff, 0xffff, 0x31cb, 0xd0e6, 0xd0ef, 0x31cc, 0xffff, 0xc1d2, 0x31cd, 0xb8c4, 0x31ce, 0xc7dc, 0x31cf, 0xe0c7,
    0x31d0, 0xd0ee, 0xc5dd, 0x31d1, 0xd0e3, 0xffff, 0xb8f6, 0x31d2, 0x31d3, 0xb8f5, 0xd0e1, 0x31d4, 0x31d5, 0x31d6, 0x31d7, 0xbcda,
    0xffff, 0xd0e9, 0x31d8, 0xcaef, 0xc3cd, 0xd0e5, 0xb7f1, 0x31d9, 0xd0e2, 0xd0ea, 0xd0e4, 0xced1, 0xd0eb, 0xcfc1, 0x31da, 0xffff,
    0x31db, 0xffff, 0x31dc, 0x31dd, 0xffff, 0x31de, 0xb6e6, 0xffff, 0xffff, 0xb7f0, 0xffff, 0x31f6, 0xffff, 0xffff, 0xffff, 0xffff,
    0x31df, 0x31e0, 0x31e1, 0xd0f0, 0xffff, 0x31e2, 0x31e3, 0xd0f1, 0xd0f5, 0xb0ce, 0x31e4, 0xffff, 0x31e5, 0xffff, 0x31e6, 0xcad0,
    0xd0f4, 0x31e7, 0x31e8, 0x31e9, 0xffff, 0xd0f3, 0xd0f7, 0x31ea, 0xffff, 0x31eb, 0xd0f6, 0xffff, 0xc4e4, 0xffff, 0xffff, 0x31ec,
    0x31ed, 0xffff, 0x31ee, 0x31ef, 0xffff, 0xb7f2, 0x31f0, 0x31f1, 0xffff, 0xffff, 0x31f2, 0xffff, 0xd0f8, 0x31f3, 0xffff, 0xffff,
    0x31f4, 0x31f5, 0xbcc5, 0xffff, 0xc2a6, 0xc4e5, 0xb6f6, 0xffff, 0xd0f9, 0xffff, 0xffff, 0xffff, 0xffff, 0xb5b6, 0xffff, 0xffff,
    0xd0fa, 0x31f7, 0xffff, 0x31f8, 0x31f9, 0xd0fc, 0x31fa, 0xffff, 0xffff, 0xffff, 0x31fb, 0xffff, 0xffff, 0xcbb5, 0x31fc, 0x31fd,
    0x31fe, 0xb7e6, 0x32a1, 0x32a2, 0x32a3, 0xffff, 0x32a4, 0xffff, 0xbbb1, 0xc8f7, 0xd0fb, 0x32a5, 0x32a6, 0xffff, 0x32a7, 0x32a8,
    0x32a9, 0x32aa, 0x32ab, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x32ac, 0xffff, 0xbac5, 0xcdc3, 0xffff, 0x32ad,
    0x32ae, 0xffff, 0xd0fe, 0xd1a3, 0xd0fd, 0xbac4, 0xffff, 0xbdfd, 0xffff, 0x32af, 0x32b0, 0xffff, 0xffff, 0x32b1, 0xb7b9, 0xffff,
    0x32b2, 0xffff, 0xd1a4, 0x32b3, 0x32b4, 0xb6cf, 0xffff, 0x32b5, 0xffff, 0xd1a1, 0xd1a2, 0xffff, 0x32b6, 0xc6af, 0x32b7, 0xc1fc,
    0x32b8, 0xb6a3, 0xffff, 0x32b9, 0x32ba, 0xcbcd, 0xd1a5, 0xffff, 0x32bb, 0xffff, 0xcebd, 0xffff, 0x32bc, 0x32bd, 0xd1a6, 0x32be,
    0xffff, 0xffff, 0x32bf, 0xd1a9, 0x32c0, 0xd1a7, 0x32c1, 0xc1ce, 0x32c2, 0x32c3, 0xffff, 0xffff, 0xffff, 0xd1a8, 0xd1aa, 0x32c4,
    0xffff, 0x32c5, 0x32d1, 0xffff, 0xffff, 0xd1ac, 0x32c6, 0xffff, 0xffff, 0xd1ab, 0x32c7, 0xcac8, 0xffff, 0xffff, 0x32c8,

    /* 0x51: 0x00 - 0xfe */
    0xb5b7, 0xd1ae, 0xd1af, 0x32c9, 0xb2af, 0xffff, 0x32ca, 0x32cb, 0x32cc, 0xd1ad, 0xffff, 0x32cd, 0x32ce, 0x32cf, 0x32d0, 0xffff,
    0x32d2, 0xffff, 0xbcf4, 0xffff, 0xd1b2, 0xd1b1, 0xd1b0, 0x32d3, 0xd0d6, 0x32d4, 0xd1b3, 0x32d5, 0x32d6, 0x32d7, 0x32d8, 0xbdfe,
    0xffff, 0xd1b4, 0xffff, 0x32d9, 0xffff, 0xffff, 0xffff, 0x32da, 0x32db, 0xffff, 0xcda5, 0xffff, 0x32dc, 0x32dd, 0xffff, 0x32de,
    0xffff, 0x32df, 0xccd9, 0x32e0, 0x32e1, 0x32e2, 0xffff, 0xd1b6, 0x32e3, 0x32e4, 0xd1b5, 0xd1b8, 0xd1b7, 0xffff, 0xffff, 0xd1b9,
    0xd1ba, 0xb0f4, 0x32e5, 0xb8b5, 0xb7bb, 0xbdbc, 0xc3fb, 0xb6a4, 0xc0e8, 0xb8f7, 0x32e6, 0xb9ee, 0xd1bc, 0xccc8, 0xc5c6, 0x32e7,
    0xbbf9, 0xffff, 0xd1bb, 0x32e8, 0xd1bd, 0x32e9, 0xffff, 0x32ea, 0x32eb, 0xffff, 0xc5de, 0xffff, 0xb3f5, 0xffff, 0xffff, 0x32ec,
    0xffff, 0xffff, 0xd1be, 0xffff, 0x32ed, 0xc6fe, 0x32ee, 0xffff, 0xc1b4, 0xd1c0, 0xd1c1, 0xc8ac, 0xb8f8, 0xcfbb, 0xd1c2, 0xffff,
    0xffff, 0xb6a6, 0xffff, 0xffff, 0xffff, 0xcabc, 0xc2b6, 0xb6f1, 0xc5b5, 0xffff, 0xffff, 0xffff, 0xb7f3, 0xffff, 0x32ef, 0xffff,
    0xd1c3, 0xffff, 0xd1c4, 0x32f0, 0x32f1, 0xc6e2, 0xb1df, 0xffff, 0xffff, 0xd1c7, 0xbafd, 0x32f2, 0xd1c6, 0xbac6, 0x32f3, 0xd1c8,
    0xe6ee, 0xd1c9, 0xcbc1, 0xd1ca, 0xffff, 0xd1cb, 0xd1cc, 0xbee9, 0x32f4, 0xbccc, 0xffff, 0xffff, 0xffff, 0x32f5, 0xffff, 0xffff,
    0xb4a7, 0x32f6, 0xd1cf, 0x32f7, 0xd1cd, 0xccbd, 0xd1ce, 0xffff, 0xc9da, 0xd1d0, 0xd1d1, 0xd1d2, 0xc5df, 0x32f8, 0xffff, 0xffff,
    0xd1d6, 0xd1d4, 0xd1d5, 0xd1d3, 0xbae3, 0xd1d7, 0xccea, 0xcee4, 0x32f9, 0xffff, 0x32fa, 0xffff, 0x32fb, 0xd1d8, 0x32fc, 0x32fd,
    0xffff, 0xffff, 0x32fe, 0xffff, 0xc0a8, 0xd1d9, 0xbdda, 0xffff, 0x33a1, 0xd1da, 0xffff, 0xc3fc, 0xcebf, 0xc5e0, 0xffff, 0x33a2,
    0xffff, 0x33a3, 0x33a4, 0x33a5, 0xffff, 0x33a6, 0xd2c5, 0xffff, 0x33a7, 0xffff, 0xffff, 0xd1db, 0xf4a5, 0xb6c5, 0x33a8, 0xffff,
    0xd1dc, 0xcbde, 0x33a9, 0xffff, 0xffff, 0x33aa, 0xbde8, 0xc2fc, 0xffff, 0xd1de, 0xc6e4, 0xffff, 0xffff, 0xd1df, 0x33ab, 0xffff,
    0xd1e0, 0xb3ae, 0x33ac, 0x33ad, 0x33ae, 0xd1e1, 0xb6a7, 0x33af, 0xc6cc, 0xb1fa, 0xbdd0, 0xffff, 0xffff, 0xc8a1, 0xd1e2,

    /* 0x52: 0x00 - 0xff */
    0xc5e1, 0x33b0, 0x33b1, 0xbfcf, 0xd1e3, 0x33b2, 0xcaac, 0xc0da, 0xb4a2, 0xffff, 0xb4a9, 0xd1e4, 0xffff, 0xffff, 0xd1e6, 0xffff,
    0xffff, 0xb7ba, 0x33b3, 0x33b4, 0xd1e5, 0x33b5, 0x33b6, 0xcef3, 0x33b7, 0xffff, 0xffff, 0xffff, 0xffff, 0xbde9, 0xffff, 0xffff,
    0xffff, 0xffff, 0x33b8, 0xffff, 0xc8bd, 0xcacc, 0xffff, 0xd1e7, 0x33b9, 0xcdf8, 0xd1e8, 0xffff, 0xffff, 0xffff, 0xd1e9, 0xffff,
    0xc5fe, 0x33ba, 0x33bb, 0xd1ea, 0xffff, 0x33bc, 0xc0a9, 0xbafe, 0xb7f4, 0xd1eb, 0xbbc9, 0xb9ef, 0x33bd, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xc4e6, 0xd1ed, 0x33be, 0xffff, 0xc2a7, 0xffff, 0x33bf, 0xbaef, 0xd1ee, 0xd1ef, 0xc1b0, 0xffff, 0xd1ec,
    0xffff, 0xffff, 0xffff, 0xffff, 0xd1f1, 0x33c0, 0xcbb6, 0x33c1, 0x33c2, 0xffff, 0x33c3, 0xb9e4, 0x33c4, 0xffff, 0xd1f0, 0x33c5,
    0x33c6, 0x33c7, 0xffff, 0xb7f5, 0xbade, 0xc7ed, 0x33c8, 0xffff, 0xffff, 0xd1f4, 0xd1f2, 0xffff, 0xffff, 0xffff, 0x33c9, 0xc9fb,
    0xbeea, 0xd1fb, 0xb3e4, 0xd1f5, 0xd1f3, 0xc1cf, 0xffff, 0x33ca, 0x33cb, 0x33cc, 0xffff, 0xffff, 0xffff, 0xd1f7, 0xffff, 0xd1f6,
    0x33cd, 0xffff, 0x33ce, 0xb3c4, 0xffff, 0x33cf, 0xffff, 0xb7e0, 0xd1fc, 0xcead, 0x33d0, 0xffff, 0x33d1, 0xd1f8, 0xffff, 0xffff,
    0xffff, 0xd1fd, 0xd1fa, 0x33d2, 0xd1f9, 0x33d3, 0x33d4, 0x33d5, 0x33d6, 0xffff, 0x33d7, 0xcecf, 0x33d8, 0xffff, 0xffff, 0xb8f9,
    0xb2c3, 0xffff, 0xffff, 0xcef4, 0x33d9, 0x33da, 0x33db, 0x33dc, 0xffff, 0xbdf5, 0xc5d8, 0xb9e5, 0xd2a2, 0xd2a3, 0xffff, 0x33dd,
    0x33de, 0xcee5, 0xffff, 0xffff, 0xcfab, 0xd2a5, 0x33df, 0x33e0, 0x33e1, 0xb8fa, 0x33e2, 0x33e3, 0xd2a4, 0x33e4, 0xb3af, 0xffff,
    0x33e5, 0xd2a6, 0xffff, 0xcbd6, 0x33e6, 0xc4bc, 0x33e7, 0xcda6, 0x33e8, 0xcad9, 0xffff, 0xffff, 0x33e9, 0xd2a7, 0xffff, 0x33ea,
    0xffff, 0x33eb, 0xf0d5, 0xffff, 0x33ec, 0xc6b0, 0x33ed, 0xd2a8, 0xb4aa, 0xccb3, 0xffff, 0x33ee, 0x33ef, 0xbea1, 0xd2a9, 0xcae7,
    0xd2ad, 0x33f0, 0xc0aa, 0xd2aa, 0xb6d0, 0x33f1, 0xd2ab, 0xb4ab, 0x33f2, 0x33f3, 0x33f4, 0xffff, 0x33f5, 0xffff, 0xffff, 0xffff,
    0x33f6, 0x33f7, 0xb7ae, 0xd2ae, 0x33f8, 0xd2af, 0x33f9, 0x33fa, 0xd2b0, 0xd2b1, 0xbcdb, 0xffff, 0xffff, 0xffff, 0xb8fb, 0xccde,

    /* 0x53: 0x00 - 0xfa */
    0x33fb, 0xcce8, 0xc6f7, 0x33fc, 0xffff, 0xcaf1, 0xd2b2, 0xffff, 0xd2b3, 0xffff, 0x33fd, 0x33fe, 0x34a1, 0xd2b5, 0xffff, 0xd2b7,
    0xd2b6, 0x34a2, 0xffff, 0x34a3, 0xffff, 0xd2b8, 0xb2bd, 0xcbcc, 0x34a4, 0xbafc, 0xd2b9, 0x34a5, 0x34a6, 0xc1d9, 0x34a7, 0x34a8,
    0xbea2, 0xb6a9, 0xffff, 0xd2ba, 0xffff, 0x34a9, 0xffff, 0x34aa, 0x34ab, 0x34ac, 0xc8db, 0x34ad, 0x34ae, 0x34af, 0xffff, 0xd2bb,
    0x34b0, 0xd2bc, 0x34b1, 0xd2bd, 0xffff, 0x34b2, 0xffff, 0xffff, 0xd2be, 0xc9a4, 0xb6e8, 0xb0e5, 0x34b3, 0x34b4, 0x34b5, 0xc6bf,
    0xd2bf, 0xbdbd, 0x34b6, 0xc0e9, 0xffff, 0xd2c1, 0xd2c0, 0xbea3, 0xb8e1, 0xd2c3, 0xc8be, 0x34b8, 0x34b7, 0xd2c4, 0xffff, 0xffff,
    0xffff, 0xc8dc, 0xc2b4, 0xc2ee, 0xb6a8, 0xffff, 0xffff, 0xc6ee, 0xc3b1, 0x34b9, 0xc7ee, 0x34ba, 0xcbce, 0xffff, 0xd2c6, 0xffff,
    0xc0ea, 0x34bb, 0xffff, 0x34bc, 0xffff, 0x34bd, 0xb7b5, 0xffff, 0xffff, 0xd2c7, 0xffff, 0xffff, 0x34be, 0x34bf, 0xd2c8, 0xb1ac,
    0xb0f5, 0xb4ed, 0x34c0, 0xc2a8, 0xb5d1, 0xcdf1, 0xffff, 0xd2cb, 0xb2b7, 0x34c1, 0xffff, 0xd2ca, 0xffff, 0xffff, 0x34c2, 0xb6aa,
    0xffff, 0xffff, 0xd2cc, 0x34c3, 0xccf1, 0xffff, 0xffff, 0x34c4, 0x34c5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x34c6, 0xffff,
    0xffff, 0xffff, 0xffff, 0x34c7, 0x34c8, 0xffff, 0xd2cd, 0xffff, 0xced2, 0x34c9, 0xb8fc, 0xffff, 0xffff, 0x34ca, 0xffff, 0xb8b6,
    0xd2ce, 0x34cb, 0xffff, 0xffff, 0x34cc, 0xd2d0, 0xd2cf, 0xffff, 0xbfdf, 0xb1b9, 0x34cd, 0x34ce, 0xffff, 0xb1de, 0xd2d1, 0x34cf,
    0xd2d2, 0xffff, 0x34d0, 0xb8b7, 0x34d1, 0x34d2, 0xd2d3, 0x34d3, 0x34d4, 0xffff, 0x34d5, 0xb5ee, 0xffff, 0x34d6, 0xffff, 0xffff,
    0x34d7, 0xffff, 0xbbb2, 0xd2d4, 0xffff, 0x34d8, 0xffff, 0xffff, 0xcbf4, 0xbab5, 0xb5da, 0xcda7, 0xc1d0, 0xc8bf, 0xbcfd, 0x34d9,
    0xffff, 0xffff, 0x34da, 0x34db, 0xbdc7, 0x34dc, 0xbce8, 0xbcf5, 0xffff, 0xbdf6, 0x34dd, 0xc8c0, 0xffff, 0x34de, 0x34df, 0xd2d7,
    0x34e0, 0xb1c3, 0xc1d1, 0xb8fd, 0xb8c5, 0xb6e7, 0x34e1, 0x34e2, 0xd2db, 0xc3a1, 0xc2fe, 0xb6ab, 0xbea4, 0xd2dc, 0xd2da, 0xb2c4,
    0xc2e6, 0xbcb8, 0xbbcb, 0xb1a6, 0xffff, 0x34e3, 0xb3f0, 0xb9e6, 0xbbca, 0xffff, 0xd2dd,

    /* 0x54: 0x01 - 0xff */
            0xd2de, 0x34e4, 0xb5c9, 0xb3c6, 0xffff, 0xffff, 0xffff, 0xb9e7, 0xb5c8, 0xc4df, 0xb1a5, 0xc6b1, 0xccbe, 0xb9a1, 0xcdf9,
    0xc5c7, 0xb8fe, 0xffff, 0x34e5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x34e6, 0xb7af, 0xffff, 0xd2e7, 0xffff, 0xb6e3,
    0xcbca, 0x34e7, 0xffff, 0xffff, 0xffff, 0xffff, 0xc8dd, 0x34e8, 0x34e9, 0xd2e6, 0x34ea, 0xb4de, 0xd2e1, 0xd2e2, 0xd2e4, 0x34eb,
    0xffff, 0x34ec, 0xffff, 0xffff, 0x34ed, 0x34ee, 0xd2e5, 0xffff, 0xb5db, 0xbfe1, 0xffff, 0xcaad, 0xd2e3, 0xd2df, 0xb8e3, 0xffff,
    0xd2e0, 0xffff, 0xcfa4, 0x34ef, 0x34f0, 0xffff, 0xcaf2, 0x34f1, 0xc4e8, 0xb8e2, 0xb9f0, 0xffff, 0xffff, 0x34f2, 0xd2e8, 0x34f3,
    0xffff, 0xc6dd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x34f4, 0xd2ec,
    0xffff, 0xffff, 0x34f5, 0xffff, 0x34f6, 0xffff, 0x34f7, 0x34f8, 0xbcfe, 0x34f9, 0xbcf6, 0x34fa, 0xffff, 0x34fb, 0x34fc, 0xffff,
    0xd2ef, 0xd2ed, 0xffff, 0xcca3, 0x34fd, 0xd2ea, 0xd2f3, 0xd2ee, 0xffff, 0xffff, 0xffff, 0xd2f1, 0xb8c6, 0xccbf, 0xffff, 0x34fe,
    0xd2f2, 0x35a1, 0xffff, 0x35a2, 0xd2f4, 0x35a3, 0xd2f6, 0xffff, 0x35a4, 0x35a5, 0xffff, 0xbaf0, 0xcfc2, 0x35a6, 0xd2eb, 0xd2e9,
    0xd2f5, 0x35a7, 0xd2f0, 0xffff, 0xffff, 0x35a8, 0x35a9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x35aa, 0xffff, 0xffff, 0x35ab,
    0xffff, 0x35ac, 0xd2f8, 0xffff, 0xd3a3, 0xd2fa, 0x35ad, 0x35ae, 0xd2fe, 0x35af, 0x35b0, 0xd3a1, 0xd2fb, 0x35b1, 0x35b2, 0xd3be,
    0xffff, 0x35b3, 0xbae9, 0xb3b1, 0xffff, 0xffff, 0xffff, 0x35b4, 0xd2f9, 0x35b5, 0x35b6, 0x35b7, 0xd3a5, 0xb0f6, 0xd3a4, 0x35b8,
    0xb0a5, 0xc9ca, 0xd3a2, 0xffff, 0xd2fc, 0xffff, 0x35b9, 0xd2f7, 0xd2fd, 0xbac8, 0x35ba, 0xffff, 0xffff, 0x35bb, 0x35bc, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd3a6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x35bd, 0xb0f7, 0xd3af, 0xffff, 0xffff, 0xd3a7, 0xd3a8, 0xffff, 0xbea5, 0xcbe9, 0x35be, 0xffff, 0x35bf, 0xd3ad, 0xd3ac, 0x35c0,
    0xffff, 0xffff, 0xc5af, 0xffff, 0xffff, 0xffff, 0x35c1, 0xffff, 0xffff, 0xffff, 0xd3ae, 0xffff, 0x35c2, 0xd3ab, 0x35c3, 0x35c4,

    /* 0x55: 0x00 - 0xff */
    0x35c5, 0x35c6, 0xffff, 0xffff, 0xb1b4, 0x35c7, 0xbab6, 0xbfb0, 0x35c8, 0x35c9, 0xffff, 0xffff, 0x35ca, 0x35cb, 0x35cc, 0xd3a9,
    0xc5e2, 0xffff, 0xffff, 0xffff, 0xd3aa, 0x35cd, 0xb0a2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x35ce, 0x35cf, 0xffff, 0xffff, 0xd3b4, 0xcda3,
    0xffff, 0xbea7, 0x35d0, 0xd3ba, 0xffff, 0x35d1, 0x35d2, 0xffff, 0xd3b9, 0xd3b0, 0xffff, 0x35d3, 0x35d4, 0x35d5, 0xc2c3, 0xffff,
    0xd3b1, 0x35d6, 0xffff, 0xffff, 0xc2ef, 0xd3b6, 0xbea6, 0x35d7, 0xffff, 0x35d8, 0x35d9, 0xffff, 0xd3b3, 0x35da, 0xffff, 0xcce4,
    0x35db, 0x35dc, 0xffff, 0xb7bc, 0xffff, 0xffff, 0xd3b7, 0xd3b8, 0x35dd, 0xffff, 0x35de, 0x35df, 0xd3b5, 0xd3bb, 0x35e0, 0xffff,
    0x35e1, 0x35e2, 0xffff, 0xd3b2, 0x35e3, 0xffff, 0x35e4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd3c1, 0xd3c6, 0xffff, 0xd3c2, 0x35e5,
    0xd3bd, 0x35e6, 0x35e7, 0xd3c7, 0xc1b1, 0xffff, 0x35e8, 0xd3c9, 0x35e9, 0xb9a2, 0xd3bf, 0xc3fd, 0xffff, 0xffff, 0x35ea, 0x35eb,
    0xffff, 0x35ec, 0x35ed, 0x35ee, 0x35ef, 0xffff, 0xffff, 0x35f0, 0xd3c3, 0xd3bc, 0xb4ad, 0xffff, 0xb4ee, 0xb3e5, 0xd3c4, 0xd3c0,
    0xffff, 0xffff, 0xffff, 0x35f1, 0x35f2, 0xffff, 0xffff, 0xb7f6, 0xd3ca, 0xd3c8, 0xc1d3, 0xb5ca, 0xb6ac, 0x35f3, 0xd3c5, 0xffff,
    0xb6f4, 0xffff, 0x35f4, 0xffff, 0xffff, 0xffff, 0xb1c4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x35f5,
    0xffff, 0x35f6, 0xffff, 0x35f7, 0xd3ce, 0xd3cc, 0x35f8, 0xd4a7, 0xffff, 0x35f9, 0xffff, 0x35fa, 0x35fb, 0xffff, 0x35fc, 0xffff,
    0xffff, 0x35fd, 0x35fe, 0x36a1, 0xd3d1, 0xffff, 0xffff, 0x36a2, 0x36a3, 0xffff, 0xd3cb, 0x36a4, 0xd3cf, 0xffff, 0x36a5, 0xd3cd,
    0xffff, 0xffff, 0x36a6, 0xbbcc, 0xd3d0, 0xffff, 0xffff, 0xffff, 0xffff, 0x36a7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x36a8, 0xd3d3, 0xffff, 0xd3d8, 0xffff, 0xffff, 0xffff, 0xd3d6, 0xd3d5, 0x36a9,

    /* 0x56: 0x05 - 0xff */
                                            0x36aa, 0xc3b2, 0xffff, 0x36ab, 0xb2c5, 0x36ac, 0xffff, 0xffff, 0x36ad, 0x36ae, 0x36af,
    0x36b0, 0x36b1, 0x36b2, 0xffff, 0xd3d2, 0xffff, 0xd3d4, 0xbea8, 0xb1b3, 0x36b3, 0xffff, 0xd3d7, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb2de, 0xffff, 0xffff, 0x36b4, 0xffff, 0xffff, 0xd3e2,
    0x36b5, 0xbefc, 0xd3de, 0x36b6, 0xd3dc, 0x36b7, 0xd3dd, 0x36b8, 0xd3df, 0x36b9, 0xffff, 0x36ba, 0x36bb, 0x36bc, 0xffff, 0x36bd,
    0x36be, 0x36bf, 0xb1bd, 0x36c0, 0x36c1, 0xffff, 0x36c2, 0xffff, 0xffff, 0x36c3, 0xffff, 0x36c4, 0xc1b9, 0x36c5, 0xd3d9, 0x36c6,
    0xd3da, 0xffff, 0xffff, 0xffff, 0x36c7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb3fa, 0xffff, 0xffff, 0x36c8, 0xffff,
    0x36c9, 0x36ca, 0x36cb, 0x36cc, 0xd3e1, 0xffff, 0x36cd, 0xffff, 0xb4ef, 0x36ce, 0xd3e4, 0xd3e0, 0xd3e3, 0x36cf, 0xffff, 0x36d0,
    0xffff, 0x36d1, 0x36d2, 0xffff, 0xcaae, 0x36d3, 0xffff, 0xffff, 0xc6d5, 0xffff, 0xc8b8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xd3e6, 0xffff, 0xffff, 0xffff, 0x36d4, 0x36d5, 0xd3e5, 0xb3c5, 0x36d6, 0xffff, 0xd3e7, 0x36d7, 0x36d8, 0xffff, 0xffff, 0xd3ea,
    0xffff, 0xffff, 0xffff, 0xffff, 0xd3e9, 0x36d9, 0xffff, 0xffff, 0xffff, 0x36da, 0x36db, 0xffff, 0xffff, 0x36dc, 0x36dd, 0x36de,
    0xd3e8, 0xffff, 0xc7b9, 0xffff, 0xffff, 0xd3eb, 0x36df, 0x36e0, 0x36e1, 0x36e2, 0xffff, 0x36e3, 0x36e4, 0x36e5, 0xd3ec, 0xffff,
    0xffff, 0x36e6, 0xffff, 0x36e7, 0xd3ee, 0xffff, 0xd3ed, 0x36e8, 0xffff, 0xffff, 0xffff, 0xffff, 0xd3f0, 0xffff, 0x36e9, 0xffff,
    0xd3f3, 0xd3f1, 0xd3ef, 0xd3f2, 0xffff, 0x36ea, 0xffff, 0xffff, 0xd3f4, 0x36eb, 0x36ec, 0x36ed, 0x36f0, 0x36f1, 0xd3f5, 0x36ee,
    0x36ef, 0xd3f6, 0xffff, 0xd3f7, 0xffff, 0xffff, 0xffff, 0xd3f8, 0xd1c5, 0x36f2, 0xbcfc, 0xbbcd, 0x36f3, 0x36f4, 0xb2f3, 0x36f5,
    0xb0f8, 0x36f6, 0xffff, 0xc3c4, 0x36f7, 0x36f8, 0x36f9, 0x36fa, 0x36fb, 0xffff, 0xffff, 0x36fd, 0xffff, 0x36fe, 0xd3f9, 0xffff,
    0xbaa4, 0x36fc, 0xb0cf, 0xbfde, 0xffff, 0xffff, 0x37a1, 0x37a2, 0xffff, 0xd3fa, 0xb8c7, 0xffff, 0xffff, 0xb9f1, 0xffff, 0xd3fc,

    /* 0x57: 0x00 - 0xff */
    0xd3fb, 0x37a3, 0x37a4, 0xcae0, 0xd3fd, 0xffff, 0xffff, 0x37a5, 0xd4a1, 0xd3fe, 0x37a6, 0xd4a2, 0x37a7, 0xd4a3, 0xffff, 0xb7f7,
    0xffff, 0x37a8, 0xb1e0, 0xd4a4, 0xffff, 0x37a9, 0xd4a6, 0xffff, 0xd4a5, 0xffff, 0x37aa, 0x37ab, 0xd4a8, 0x37ac, 0xffff, 0xc5da,
    0x37ad, 0xffff, 0x37ae, 0x37af, 0x37b0, 0x37b1, 0xd4a9, 0xb0b5, 0xbadf, 0x37b2, 0x37b3, 0xffff, 0x37b4, 0xb7bd, 0x37b5, 0x37b6,
    0xc3cf, 0xffff, 0xffff, 0x37b7, 0x37b8, 0xffff, 0xffff, 0xd4aa, 0xd4ab, 0xffff, 0xffff, 0xd4ad, 0xffff, 0x37b9, 0x37ba, 0x37bb,
    0xd4ae, 0xffff, 0xbae4, 0xffff, 0xffff, 0x37bc, 0x37bd, 0xb6d1, 0xffff, 0xffff, 0xcbb7, 0xffff, 0x37be, 0x37bf, 0xd4ac, 0xd4af,
    0xbac1, 0xb9a3, 0x37c0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xd4b3, 0x37c1, 0xffff, 0xbaa5, 0x37c2, 0xc3b3, 0x37c3, 0x37c4, 0xd4b0, 0xc4da, 0x37c5, 0xffff, 0x37c6, 0x37c7, 0x37c8,
    0x37c9, 0x37ca, 0xffff, 0x37cb, 0x37cc, 0x37cd, 0xffff, 0x37ce, 0xffff, 0x37cf, 0x37d0, 0x37d1, 0x37d2, 0xffff, 0x37d3, 0xd4b4,
    0xffff, 0x37d4, 0xbfe2, 0x37d5, 0xffff, 0xffff, 0xffff, 0xffff, 0xd4b2, 0xd4b5, 0xffff, 0xb7bf, 0x37d6, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xd4b6, 0x37d7, 0x37e0, 0xffff, 0x37d8, 0xffff, 0x37d9, 0x37da, 0xffff, 0x37db, 0x37dc, 0x37dd, 0x37de,
    0xd4b7, 0x37df, 0xb9a4, 0xb3c0, 0xd4b9, 0xffff, 0xffff, 0x37e1, 0x37e2, 0x37e3, 0xd4ba, 0xffff, 0x37e4, 0xffff, 0xffff, 0xffff,
    0xd4bb, 0xffff, 0xffff, 0xd4b8, 0xffff, 0xffff, 0xffff, 0xffff, 0x37e5, 0xffff, 0xffff, 0xffff, 0xffff, 0x37e6, 0xffff, 0xffff,
    0xd4b1, 0xffff, 0xffff, 0xd4bc, 0xffff, 0xffff, 0xd4bd, 0x37e7, 0x37e8, 0xffff, 0xffff, 0xcbe4, 0x37e9, 0xffff, 0xbeeb, 0x37ea,
    0xffff, 0xffff, 0xd4bf, 0xd4c0, 0xd4be, 0x37eb, 0xd4c2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc7b8, 0x37ec, 0x37ed, 0xb0e8,
    0xc9d6, 0x37fe, 0xffff, 0xd4c3, 0x37ee, 0xffff, 0x37ef, 0x37f0, 0xffff, 0x37f1, 0xffff, 0xffff, 0xffff, 0x37f2, 0xffff, 0xffff,
    0x37f3, 0xffff, 0xffff, 0xffff, 0xbefd, 0x37f4, 0x37f5, 0xbcb9, 0x37f6, 0xc7dd, 0xb4f0, 0xffff, 0xbaeb, 0x37f7, 0x37f8, 0x37f9,

    /* 0x58: 0x00 - 0xfd */
    0xcbd9, 0xffff, 0xc6b2, 0x37fa, 0x37fb, 0xb7f8, 0xc2cf, 0xffff, 0x37fc, 0x37fd, 0xd4c1, 0xd4c4, 0x38a1, 0x38a2, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc2c4, 0xffff, 0xffff, 0xffff, 0xd4c5, 0xffff, 0x38a3, 0xffff, 0xd4c6, 0x38a4, 0x38a5,
    0x38a6, 0xd4c8, 0xffff, 0xffff, 0xc4e9, 0xffff, 0x38a7, 0x38a8, 0xffff, 0xffff, 0xb4ae, 0xffff, 0xffff, 0x38a9, 0xffff, 0xf4a1,
    0xb1e1, 0xcaf3, 0x38aa, 0xffff, 0xbeec, 0xc5c8, 0xffff, 0xffff, 0xffff, 0x38ab, 0xbae6, 0xffff, 0xffff, 0xd4ce, 0xffff, 0x38ac,
    0xcabd, 0xcedd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x38ad, 0xb2f4, 0xd4ca, 0x38ae, 0x38af, 0xffff, 0x38b0,
    0x38b1, 0xc1ba, 0xd4cd, 0xffff, 0xc5e3, 0x38b2, 0xffff, 0xc5c9, 0xc5e4, 0xc8b9, 0xc4cd, 0xffff, 0xffff, 0xffff, 0xbac9, 0x38b3,
    0xffff, 0x38b4, 0xd4c9, 0xffff, 0x38b5, 0xffff, 0xffff, 0x38b6, 0x38b7, 0xb1f6, 0xffff, 0xc5b6, 0xffff, 0xffff, 0xffff, 0xffff,
    0xd4cb, 0xffff, 0xd4c7, 0xffff, 0xffff, 0xbfd0, 0xffff, 0xffff, 0x38b8, 0xd4cf, 0xffff, 0xffff, 0x38b9, 0xffff, 0xbdce, 0x38ba,
    0x38bb, 0x38bc, 0xffff, 0xb6ad, 0xffff, 0xd4d0, 0xffff, 0x38bd, 0x38be, 0x38bf, 0x38c0, 0xffff, 0x38c1, 0x38c2, 0xffff, 0x38c3,
    0x38c4, 0xffff, 0xffff, 0xcae8, 0x38c5, 0xffff, 0x38c6, 0xc1fd, 0xffff, 0xffff, 0xffff, 0xffff, 0xc4c6, 0x38c7, 0xffff, 0xd4d2,
    0x38c8, 0x38c9, 0x38ca, 0xffff, 0xffff, 0xffff, 0x38cb, 0xffff, 0xcbcf, 0x38cc, 0xffff, 0xd4d3, 0xffff, 0xffff, 0xd4d8, 0xffff,
    0xffff, 0x38cd, 0x38ce, 0xcaaf, 0xffff, 0xffff, 0xffff, 0xffff, 0xd4d7, 0xd4d1, 0xd4d4, 0xd4d6, 0x38d0, 0xffff, 0xbaa6, 0xffff,
    0xffff, 0xcac9, 0x38d1, 0xffff, 0x38cf, 0xd4d9, 0xffff, 0xc3c5, 0x38d2, 0xffff, 0xb2f5, 0xffff, 0xbeed, 0x38d3, 0x38d4, 0xffff,
    0x38d5, 0xd4db, 0x38d6, 0xd4da, 0x38d7, 0xb9e8, 0x38d8, 0xd4dc, 0xd4de, 0xd4dd, 0x38d9, 0xffff, 0xd4e0, 0x38da, 0xd4d5, 0xd4e2,
    0xffff, 0x38db, 0x38dc, 0xffff, 0xd4e1, 0xd4df, 0xffff, 0xffff, 0xffff, 0x38dd, 0xffff, 0xbbce, 0xbfd1, 0xffff, 0xc1d4, 0xd4e3,
    0xc0bc, 0xb0ed, 0xc7e4, 0x38de, 0xffff, 0xffff, 0xffff, 0xc4db, 0xffff, 0xd4e5, 0xd4e4, 0xd4e6, 0xd4e7, 0xd4e8,

    /* 0x59: 0x02 - 0xff */
                    0xd4e9, 0xffff, 0xffff, 0x38df, 0x38e0, 0xffff, 0xffff, 0xcad1, 0xd4ea, 0x38e1, 0x38e2, 0xffff, 0xffff, 0xb2c6,
    0xd4eb, 0xffff, 0x38e3, 0x38e4, 0x38e5, 0xcdbc, 0xb3b0, 0xffff, 0xd2c9, 0xbdc8, 0xc2bf, 0xd4ec, 0xcceb, 0x38e7, 0xffff, 0xffff,
    0xffff, 0x38e8, 0xccb4, 0x38e9, 0x38ea, 0xd4ee, 0xffff, 0xc2e7, 0x38eb, 0xc5b7, 0xc2c0, 0xc9d7, 0xd4ef, 0xd4f0, 0xb1fb, 0x38ec,
    0x38ed, 0xbcba, 0xd4f1, 0x38ee, 0xffff, 0x38ef, 0x38f0, 0xb0d0, 0xd4f2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd4f3, 0x38f1,
    0xffff, 0xffff, 0xffff, 0x38f2, 0xb1e2, 0xffff, 0x38f3, 0xb4f1, 0xc6e0, 0xcaf4, 0xffff, 0xffff, 0xffff, 0xffff, 0xd4f7, 0xc1d5,
    0xd4f6, 0xb7c0, 0x38f4, 0x38f5, 0xcbdb, 0xd4f5, 0xffff, 0xc5e5, 0xd4f9, 0x38f6, 0xd4f8, 0x38f7, 0xffff, 0x38f8, 0x38f9, 0x38fa,
    0xd4fb, 0x38fb, 0xd4fa, 0x38fc, 0xffff, 0xb1fc, 0xffff, 0xd4fc, 0xbea9, 0xd4fe, 0xc3a5, 0x38fd, 0xd4fd, 0x38fe, 0xcab3, 0x39a1,
    0xffff, 0xffff, 0x39a2, 0xbdf7, 0xc5db, 0x39a3, 0x39a4, 0xffff, 0xd5a1, 0x39a5, 0xffff, 0x39a6, 0x39a7, 0xb9a5, 0xffff, 0xffff,
    0xffff, 0xd5a2, 0xc7a1, 0xc8de, 0xccd1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc7a5, 0x39a8, 0x39a9, 0xd5ab, 0x39aa, 0xffff,
    0xffff, 0xffff, 0x39ab, 0xb5b8, 0xffff, 0x39ac, 0xcdc5, 0x39ad, 0xffff, 0xccaf, 0xffff, 0xd6ac, 0xffff, 0xd5a3, 0xffff, 0x39ae,
    0xffff, 0xffff, 0xffff, 0xd5a6, 0x39af, 0xc2c5, 0xffff, 0x39b0, 0xcbb8, 0xffff, 0xffff, 0xffff, 0xc5ca, 0x39b1, 0x39b2, 0x39b3,
    0x39b4, 0xffff, 0xd5a7, 0x39b5, 0xffff, 0xffff, 0xffff, 0x39b6, 0xffff, 0xcbe5, 0x39b7, 0xbaca, 0x39b8, 0xffff, 0xbeaa, 0xffff,
    0xffff, 0x39b9, 0xffff, 0x39ba, 0x39bb, 0xffff, 0xd5a8, 0xffff, 0x39bc, 0xbbd0, 0x39bd, 0xbbcf, 0xffff, 0x39be, 0xffff, 0xffff,
    0xb0b9, 0xb8c8, 0x39bf, 0xc0ab, 0xb0d1, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5ac, 0xd5ad, 0xffff, 0xd5aa, 0x39c0, 0x39c1, 0x39c2,
    0xffff, 0xffff, 0xffff, 0x39c3, 0x39c4, 0xb1b8, 0xb4af, 0x39c5, 0xd5a9, 0xffff, 0xccc5, 0xc9b1, 0xffff, 0xffff, 0x39c6, 0x39c7,
    0xffff, 0x39c8, 0x39c9, 0xffff, 0x39ca, 0xffff, 0xb0a8, 0x39cb, 0xffff, 0xffff, 0xffff, 0xb0f9, 0xffff, 0xffff, 0xffff, 0xbbd1,

    /* 0x5a: 0x00 - 0xfd */
    0x39cc, 0xb0d2, 0xffff, 0xb0a3, 0x39cd, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5b2, 0xffff, 0xffff, 0x39ce, 0x39cf, 0x39d0, 0xffff,
    0xffff, 0xd5b0, 0x39d1, 0x39d2, 0xffff, 0xffff, 0xffff, 0xffff, 0xccbc, 0xffff, 0xd5b3, 0xffff, 0xd5b1, 0xffff, 0x39d3, 0xd5af,
    0xbfb1, 0xffff, 0xffff, 0x39d4, 0x39d5, 0xd5ae, 0xffff, 0x39d6, 0x39d7, 0xcada, 0x39d8, 0xffff, 0xffff, 0x39d9, 0xffff, 0xb8e4,
    0x39da, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5b7, 0xd5b8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbeab, 0xffff, 0xffff, 0xffff,
    0xd5b4, 0xcfac, 0xffff, 0xffff, 0x39db, 0x39dc, 0xc7cc, 0x39dd, 0x39de, 0xd5b6, 0xffff, 0xffff, 0x39df, 0xffff, 0xffff, 0xffff,
    0x39e0, 0xffff, 0xffff, 0xffff, 0xffff, 0x39e1, 0xffff, 0xffff, 0xffff, 0xffff, 0xbaa7, 0xffff, 0xffff, 0xffff, 0x39e2, 0xffff,
    0xffff, 0xffff, 0xd5b9, 0x39e3, 0xffff, 0x39e4, 0xc9d8, 0x39e5, 0xffff, 0xffff, 0xd5ba, 0xffff, 0xd5b5, 0x39e6, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x39e7, 0xffff, 0xffff, 0x39e8, 0x39e9, 0xffff, 0xffff, 0x39ea, 0xccbb,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x39eb, 0xffff, 0xffff, 0xffff, 0xffff,
    0x39ec, 0xffff, 0xc7de, 0x39ed, 0xffff, 0xffff, 0x39ee, 0xffff, 0xffff, 0x39ef, 0xd5bb, 0xc9b2, 0x39f0, 0xffff, 0x39f1, 0x39f2,
    0x39f3, 0xffff, 0x39f4, 0xffff, 0xffff, 0xffff, 0xffff, 0x39f5, 0xffff, 0xffff, 0xffff, 0xffff, 0x39f6, 0xffff, 0xffff, 0xffff,
    0xffff, 0x39f7, 0x39f8, 0x39f9, 0xffff, 0x39fa, 0xffff, 0xffff, 0x39fb, 0xffff, 0x39fc, 0x39fd, 0xd5bc, 0xd5c0, 0xd5bd, 0x39fe,
    0xffff, 0xb2c7, 0xd5bf, 0xffff, 0x3aa1, 0xffff, 0x3aa2, 0xffff, 0x3aa3, 0xbcbb, 0xffff, 0xd5be, 0xb7f9, 0xffff, 0xffff, 0x3aa4,
    0xd5cc, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5c5, 0xd5c2, 0xffff, 0xffff, 0x3aa5, 0xffff, 0x3aa6, 0xffff, 0xffff, 0xffff,
    0x3aa7, 0xc3e4, 0xffff, 0xd5c1, 0xffff, 0x3aa8, 0xd5c3, 0xffff, 0xffff, 0xd5c4, 0x3aa9, 0xffff, 0xffff, 0xffff, 0x3aaa, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3aab, 0x3aac, 0xffff, 0xffff, 0xffff, 0xd5c6, 0xd5c7, 0xffff, 0x3aad,

    /* 0x5b: 0x00 - 0xff */
    0x3aae, 0x3aaf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3ab0, 0xb4f2, 0xffff, 0xd5c9, 0xd5c8, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5ca, 0x3ab1, 0xffff, 0x3ab3, 0xffff, 0x3ab4, 0xffff, 0x3ab5, 0xffff, 0xffff,
    0xffff, 0x3ab6, 0xbeee, 0xffff, 0xffff, 0x3ab7, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5cd, 0xffff, 0xc4dc, 0x3ab8, 0xffff, 0xffff,
    0xb1c5, 0xffff, 0xd5cb, 0xffff, 0x3ab2, 0xffff, 0xd5ce, 0xffff, 0x3ab9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd5cf, 0xffff,
    0xd5d2, 0x3aba, 0xffff, 0xd5d0, 0xffff, 0xd5d1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3abb, 0x3abc, 0xffff, 0xffff, 0xffff,
    0xbbd2, 0xd5d3, 0x3abd, 0xffff, 0xb9a6, 0xd5d4, 0x3abe, 0xbbfa, 0xc2b8, 0xffff, 0xd5d5, 0xd5d6, 0xbbda, 0xb9a7, 0x3abf, 0xccd2,
    0xffff, 0xffff, 0xffff, 0xb5a8, 0xb8c9, 0xd5d7, 0xb3d8, 0xffff, 0x3ac0, 0xd5d8, 0xffff, 0xc2b9, 0xffff, 0xffff, 0x3ac1, 0x3ac2,
    0xd5d9, 0xd6a3, 0xffff, 0xd5da, 0xffff, 0xd5db, 0xffff, 0xffff, 0xd5dc, 0xffff, 0xd5de, 0xffff, 0x3ac3, 0x3ac4, 0x3ac5, 0x3ac6,
    0xd5df, 0x3ac7, 0xffff, 0xd5e0, 0x3ac8, 0xc2f0, 0x3ac9, 0xb1a7, 0xbce9, 0xb0c2, 0x3aca, 0xc1d7, 0xb4b0, 0xbcb5, 0x3acb, 0xb9a8,
    0x3acc, 0x3acd, 0xffff, 0x3ace, 0x3acf, 0xc5e6, 0x3ad0, 0xbda1, 0xb4b1, 0xc3e8, 0xc4ea, 0xb0b8, 0xb5b9, 0xcaf5, 0xffff, 0xbcc2,
    0xffff, 0xffff, 0xb5d2, 0xc0eb, 0xbcbc, 0xcda8, 0xd5e1, 0xffff, 0x3ad1, 0x3ad2, 0xffff, 0xffff, 0x3ad3, 0x3ad4, 0xb5dc, 0x3ad5,
    0xbacb, 0x3ad6, 0x3ad7, 0xb3b2, 0xb1e3, 0xbeac, 0xb2c8, 0x3ad8, 0xd5e2, 0xcdc6, 0x3ad9, 0xffff, 0x3ada, 0xffff, 0xffff, 0xbdc9,
    0x3adb, 0x3adc, 0xbce4, 0xd5e3, 0xb4f3, 0xc6d2, 0xcca9, 0xd5e4, 0xffff, 0xd5e5, 0xffff, 0xffff, 0xc9d9, 0x3add, 0xffff, 0x3ade,
    0xd5e7, 0xffff, 0xb4a8, 0xb6f7, 0xd5e6, 0xffff, 0x3adf, 0x3ae0, 0x3ae1, 0x3ae2, 0x3ae3, 0xb4b2, 0xffff, 0xbfb2, 0xd5eb, 0xbba1,
    0x3ae4, 0xb2c9, 0xd5ea, 0xffff, 0xd5e8, 0xd5ec, 0xd5e9, 0xc7ab, 0xdccd, 0xbfb3, 0xffff, 0xd5ed, 0xffff, 0xffff, 0xcec0, 0x3ae5,
    0xd5ee, 0x3ae6, 0xffff, 0xd5f0, 0x3ae7, 0xc3fe, 0xd5ef, 0xffff, 0xc0a3, 0xffff, 0xbbfb, 0xffff, 0xffff, 0x3ae8, 0xc2d0, 0xbcf7,

    /* 0x5c: 0x01 - 0xfd */
            0xc9f5, 0xc0ec, 0xffff, 0xbccd, 0xd5f1, 0xbead, 0xd5f2, 0xd5f3, 0xb0d3, 0xc2ba, 0xbfd2, 0x3ae9, 0xd5f4, 0xc6b3, 0xbeae,
    0xffff, 0xbeaf, 0xffff, 0xd5f5, 0xffff, 0xffff, 0xc0ed, 0x3aea, 0xffff, 0xffff, 0xbeb0, 0xffff, 0xffff, 0xffff, 0x3aeb, 0x3aec,
    0xd5f6, 0xffff, 0xd5f7, 0x3aed, 0xcce0, 0xffff, 0x3aee, 0xffff, 0xd5f8, 0x3aef, 0xffff, 0x3af0, 0x3af1, 0xb6c6, 0x3af2, 0xffff,
    0x3af3, 0xbda2, 0x3af4, 0xffff, 0xffff, 0x3af5, 0x3af6, 0xffff, 0xd5f9, 0xd5fa, 0xbcdc, 0xbfac, 0xc6f4, 0xbfd4, 0xc8f8, 0xc7a2,
    0xb6c9, 0xd5fb, 0xffff, 0xffff, 0xffff, 0xb5ef, 0xd5fc, 0xffff, 0xb6fe, 0xffff, 0xc6cf, 0xb2b0, 0xffff, 0xbbd3, 0xd5fd, 0xd6a2,
    0xd6a1, 0xb6fd, 0xffff, 0xd5fe, 0xffff, 0xc5b8, 0xffff, 0xffff, 0xffff, 0x3af7, 0x3af8, 0xffff, 0x3af9, 0xffff, 0xc2b0, 0xffff,
    0xc5cb, 0xbcc8, 0x3afa, 0x3afb, 0xc1d8, 0xcdfa, 0xffff, 0x3afc, 0x3afd, 0x3afe, 0xffff, 0xffff, 0xd6a4, 0x3ba1, 0xd6a5, 0xc6d6,
    0x3ba2, 0xbbb3, 0xffff, 0xffff, 0x3ba3, 0x3ba4, 0xd6a7, 0xffff, 0xffff, 0xd6a8, 0x3ba5, 0x3ba6, 0x3ba7, 0x3ba8, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3ba9, 0x3baa, 0xffff, 0x3bab, 0xffff, 0xd6a9, 0xffff, 0xffff, 0x3bac,
    0xb4f4, 0xd6aa, 0x3bad, 0xffff, 0xd6ab, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3bae, 0xffff, 0x3baf,
    0x3bb0, 0xb2ac, 0x3bb1, 0x3bb2, 0xffff, 0xffff, 0x3bb3, 0xffff, 0xc1bb, 0xb4e4, 0x3bb4, 0xd6ad, 0xcca8, 0xffff, 0xffff, 0xffff,
    0xffff, 0xc2d2, 0x3bb5, 0xb3d9, 0x3bb6, 0x3bb7, 0xd6af, 0xd6b1, 0xb4df, 0xffff, 0x3bb8, 0xd6ae, 0xd6b0, 0xffff, 0xd6b3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd6b2, 0xffff, 0xd6b4, 0xffff, 0x3bb9, 0xffff, 0x3bba, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x3bbb, 0xffff, 0xffff, 0xffff, 0xffff, 0x3bbd, 0xffff, 0xd6b5, 0xffff, 0xffff, 0xffff, 0x3bbc, 0xffff, 0xffff,
    0xc6bd, 0xb6ae, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb2e5, 0xd6b6, 0xd6bb, 0xffff, 0xffff, 0xd6b9, 0x3bbe, 0xcaf7,
    0xcaf6, 0x3bbf, 0x3bc0, 0xffff, 0x3bc1, 0xffff, 0xc5e7, 0xffff, 0xffff, 0xffff, 0xd6b8, 0xbdd4, 0xffff, 0xd6b7,

    /* 0x5d: 0x01 - 0xfe */
            0x3bc2, 0xffff, 0xffff, 0xffff, 0xffff, 0x3bc3, 0xbff2, 0xffff, 0xffff, 0xffff, 0xd6bc, 0xffff, 0x3bc4, 0xbaea, 0xffff,
    0xffff, 0xd6c2, 0x3bc5, 0xffff, 0xd6c3, 0xd6bd, 0xb3b3, 0xd6be, 0xd6c7, 0xd6c6, 0xd6c5, 0xd6c1, 0xffff, 0xffff, 0xffff, 0xd6c0,
    0xffff, 0xffff, 0xd6c4, 0x3bc7, 0x3bc8, 0xffff, 0x3bc9, 0x3bca, 0xffff, 0xcaf8, 0xffff, 0x3bc6, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x3bcb, 0xffff, 0xffff, 0x3bcc, 0xffff, 0xffff, 0xffff, 0xffff, 0x3bcd, 0xffff, 0xffff, 0xffff, 0x3bce, 0xffff, 0x3bcf,
    0xffff, 0xffff, 0x3bd0, 0x3bd1, 0xffff, 0xffff, 0x3bd2, 0xffff, 0x3bd3, 0xffff, 0x3bd7, 0xd6cb, 0xd6c8, 0xffff, 0xd6ca, 0xffff,
    0xcdf2, 0x3bd5, 0xd6c9, 0xffff, 0xffff, 0x3bd4, 0xffff, 0xffff, 0xffff, 0x3bd6, 0xffff, 0xffff, 0xd6bf, 0xffff, 0xffff, 0x3bd8,
    0x3bd9, 0x3bda, 0x3bdb, 0xffff, 0x3bdc, 0xffff, 0xffff, 0xffff, 0xffff, 0xbff3, 0x3bdd, 0xffff, 0xd6cc, 0x3bde, 0xffff, 0xbab7,
    0x3bdf, 0xffff, 0xffff, 0xd6cd, 0xffff, 0xffff, 0xd6ce, 0xffff, 0xffff, 0x3be0, 0x3be1, 0xffff, 0xffff, 0xffff, 0x3be2, 0x3be3,
    0xffff, 0x3be4, 0xd6d1, 0x3be5, 0xd6d0, 0xffff, 0xffff, 0xd6cf, 0x3be6, 0xffff, 0x3be7, 0xc5e8, 0xd6ba, 0xffff, 0xffff, 0xffff,
    0xd6d7, 0xffff, 0x3be8, 0x3be9, 0x3bea, 0x3beb, 0xffff, 0xffff, 0xffff, 0x3bec, 0xffff, 0x3bed, 0xffff, 0xd6d3, 0xffff, 0x3bee,
    0x3bef, 0xffff, 0xd6d2, 0xffff, 0xffff, 0xffff, 0xffff, 0x3bf0, 0xffff, 0xffff, 0xffff, 0x3bf1, 0xd6d4, 0xffff, 0xd6d5, 0xffff,
    0x3bf2, 0xffff, 0x66f4, 0xffff, 0x3bf3, 0xffff, 0xffff, 0xd6d8, 0x3bf4, 0x3bf5, 0xcee6, 0xffff, 0xd6d9, 0xd6d6, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x3bf6, 0xffff, 0xffff, 0xffff, 0x3bf7, 0xffff, 0xd6da, 0xffff, 0x3bf8, 0xb4e0, 0xd6db, 0x3bfa, 0xffff,
    0x3bf9, 0xffff, 0xd6dd, 0xd6dc, 0xffff, 0xffff, 0xd6de, 0xffff, 0x3bfb, 0x3bfc, 0xffff, 0xd6df, 0xffff, 0xc0ee, 0xbda3, 0xffff,
    0x3bfd, 0xbde4, 0xffff, 0xc1e3, 0x3bfe, 0xb9a9, 0xbab8, 0xb9aa, 0xb5f0, 0x3ca1, 0xffff, 0xd6e0, 0xffff, 0xffff, 0xbab9, 0xffff,
    0xffff, 0xb8ca, 0xd6e1, 0xcca6, 0xc7c3, 0xd6e2, 0xffff, 0xb9ab, 0x3ca2, 0x3ca3, 0xffff, 0xb4ac, 0xffff, 0xc3a7, 0xb6d2,

    /* 0x5e: 0x00 - 0xff */
    0x3ca4, 0xffff, 0xbbd4, 0xc9db, 0xffff, 0xffff, 0xc8c1, 0x3ca5, 0xffff, 0xffff, 0xffff, 0xd6e3, 0xb4f5, 0x3ca6, 0xffff, 0xffff,
    0xffff, 0xd6e6, 0x3ca7, 0xffff, 0x3ca8, 0x3ca9, 0xc4a1, 0xffff, 0x3caa, 0xd6e5, 0xd6e4, 0xd6e7, 0xffff, 0xc4eb, 0xffff, 0x3cab,
    0x3cac, 0xffff, 0xffff, 0xffff, 0xffff, 0xbfe3, 0xffff, 0xffff, 0x3cae, 0xffff, 0xffff, 0xbbd5, 0xffff, 0xc0ca, 0x3cad, 0xc2d3,
    0xb5a2, 0xffff, 0x3caf, 0xc4a2, 0xffff, 0x3cb0, 0xd6e8, 0xd6e9, 0xbeef, 0xffff, 0xffff, 0xffff, 0xffff, 0xcbb9, 0x3cb1, 0xffff,
    0xd6ec, 0xffff, 0xffff, 0xd6eb, 0xd6ea, 0xc9fd, 0xffff, 0xd6f3, 0xffff, 0x3cb4, 0xffff, 0x3cb2, 0xcbda, 0xffff, 0xd6ed, 0xffff,
    0x3cb3, 0x3cb5, 0xffff, 0xffff, 0xd6ef, 0xcbeb, 0x3cb6, 0xd6ee, 0x3cb7, 0xffff, 0xffff, 0x3cb8, 0x3cb9, 0xffff, 0x3cba, 0xd6f0,
    0xffff, 0xc8a8, 0xd6f1, 0xcabe, 0xd6f2, 0xffff, 0xffff, 0xffff, 0x3cbb, 0xffff, 0x3cbc, 0x3cbd, 0x3cbe, 0x3cbf, 0x3cc0, 0xffff,
    0x3cc1, 0xffff, 0xb4b3, 0xcabf, 0xc7af, 0xd6f4, 0xd6f5, 0xffff, 0xb9ac, 0xb4b4, 0xd6f6, 0xb8b8, 0xcdc4, 0xcda9, 0xb4f6, 0xd6f8,
    0x3cc2, 0xc4a3, 0xffff, 0xb9ad, 0xbeb1, 0xffff, 0xffff, 0xc8df, 0xffff, 0xffff, 0xbeb2, 0x3cc3, 0xffff, 0xffff, 0x3cc4, 0xbdf8,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc4ec, 0xcaf9, 0xc5b9, 0xffff, 0xffff, 0xb9ae, 0xffff, 0xc9dc, 0xffff, 0xffff, 0xffff,
    0xd6f9, 0xffff, 0x3cc5, 0xffff, 0x3cc6, 0x3cc7, 0xc5d9, 0xbac2, 0x3cc8, 0xffff, 0x3cc9, 0xb8cb, 0x3cca, 0xc4ed, 0xffff, 0xffff,
    0xffff, 0x3ccb, 0xffff, 0x3ccc, 0xffff, 0xb0c3, 0xbdee, 0xb9af, 0xcdc7, 0xffff, 0xffff, 0xffff, 0xffff, 0x3ccd, 0x3cce, 0x3ccf,
    0xffff, 0xd6fa, 0xd6fb, 0xc7d1, 0xffff, 0xffff, 0x3cd0, 0xffff, 0xd6fc, 0xcef7, 0xcfad, 0x3cd2, 0x3cd1, 0xffff, 0x3cd3, 0xd6fe,
    0xd6fd, 0x3cd4, 0x3cd5, 0xb3c7, 0x3cd6, 0x3cd7, 0xd7a1, 0xffff, 0xffff, 0xffff, 0xd7a4, 0xd7a5, 0x3cd8, 0xd7a3, 0x3cd9, 0xc9c0,
    0xbeb3, 0xd7a7, 0xd7a6, 0xd7a2, 0xffff, 0x3cda, 0xffff, 0xffff, 0xd7a8, 0xd7a9, 0xffff, 0x3cdb, 0xd7aa, 0xffff, 0xffff, 0xffff,
    0xd7ad, 0xd7ab, 0xffff, 0xd7ac, 0xd7ae, 0xffff, 0xb1e4, 0xc4ee, 0xd7af, 0xffff, 0xb7fa, 0xb2f6, 0xc7b6, 0xffff, 0xd7b0, 0xc6fb,

    /* 0x5f: 0x01 - 0xff */
            0xcadb, 0x3cdc, 0xd7b1, 0xcfae, 0xffff, 0x3cdd, 0x3cde, 0x3cdf, 0xd7b2, 0xcac0, 0xd7b5, 0xd0a1, 0xd0b1, 0x3ce0, 0xbcb0,
    0xc6f5, 0xd7b6, 0xffff, 0xb5dd, 0xc4a4, 0xb0fa, 0xd7b7, 0xcaa6, 0xb9b0, 0x3ce1, 0xffff, 0xc3d0, 0x3ce2, 0x3ce3, 0xffff, 0xc4ef,
    0xffff, 0x3ce4, 0x3ce5, 0x3ce6, 0x3ce7, 0xccef, 0xb8b9, 0xb8cc, 0x3ce8, 0xd7b8, 0xffff, 0x3ce9, 0x3cea, 0xd7b9, 0x3ceb, 0xd7bf,
    0x3cec, 0xbce5, 0xffff, 0xffff, 0x3ced, 0xc4a5, 0x3cee, 0xb6af, 0xd7ba, 0xffff, 0xffff, 0x3cef, 0xc9ab, 0x3cf0, 0xc3c6, 0x3cf1,
    0x3cf2, 0xd7bb, 0xffff, 0xffff, 0x3cf3, 0x3cf4, 0xffff, 0x3cf5, 0xd7bc, 0xffff, 0xb6b0, 0xffff, 0xd7bd, 0x3cf6, 0xd7be, 0xffff,
    0x3cf7, 0xd7c0, 0xffff, 0xc5f6, 0x3cf8, 0xffff, 0xd7c1, 0xd7c2, 0x3cf9, 0xd7c3, 0xffff, 0x3cfa, 0xd7b4, 0xd7b3, 0xffff, 0xffff,
    0x3cfb, 0xd7c4, 0xb7c1, 0x3cfc, 0x3cfd, 0xffff, 0xc9a7, 0x3cfe, 0xffff, 0xbacc, 0xc9b7, 0xc4a6, 0xc9cb, 0xd7c5, 0xffff, 0x3da1,
    0xbeb4, 0xb1c6, 0x3da2, 0xd7c6, 0x3da3, 0x3da4, 0xffff, 0xd7c7, 0x3da5, 0xccf2, 0x3da6, 0xffff, 0xc8e0, 0x3da7, 0x3da8, 0xd7ca,
    0xb1fd, 0xc0ac, 0xd7c9, 0xd7c8, 0xb7c2, 0xc2d4, 0xffff, 0xd7ce, 0xd7cc, 0x3da9, 0xd7cb, 0xcea7, 0xb8e5, 0x3daa, 0xffff, 0x3dab,
    0xbdf9, 0xd7cd, 0xc5cc, 0xbdbe, 0xffff, 0xffff, 0x3dac, 0xc6c0, 0xd7d1, 0xd7d0, 0xffff, 0xffff, 0x3dad, 0x3dae, 0xd7cf, 0xffff,
    0xd7d2, 0xb8e6, 0x3daf, 0xffff, 0x3db2, 0xffff, 0xffff, 0x3db0, 0xd7d3, 0xc9fc, 0xbddb, 0x3db1, 0x3db3, 0xd7d4, 0xc8f9, 0x3db4,
    0x3db5, 0x3db6, 0xffff, 0xc6c1, 0xc4a7, 0xffff, 0xffff, 0xffff, 0x3db7, 0xc5b0, 0xffff, 0xffff, 0xd7d5, 0xb5ab, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xbfb4, 0x3db8, 0xc9ac, 0xffff, 0x3db9, 0x3dba, 0x3dbb, 0xffff, 0x3dbc, 0xb4f7, 0xc7a6, 0xffff, 0xffff,
    0x3dbd, 0x3dbe, 0x3dbf, 0x3dc0, 0x3dc1, 0xffff, 0xd7d6, 0xbbd6, 0xcbba, 0xcbbb, 0xffff, 0xffff, 0xb1fe, 0xd7db, 0x3dc2, 0xffff,
    0xc3e9, 0x3dc3, 0x3dc4, 0xffff, 0xd7d8, 0xffff, 0xffff, 0xffff, 0x3dc5, 0x3dc6, 0x3dc7, 0xb2f7, 0x3dc8, 0x3dc9, 0x3dca, 0x3dcb,
    0xd8ad, 0xd7da, 0x3dcc, 0x3dcd, 0xffff, 0xc7b0, 0x3dce, 0xffff, 0xd7d9, 0xffff, 0x3dcf, 0xd7d7, 0x3dd0, 0xb9fa, 0xffff, 0xd7dd,

    /* 0x60: 0x07 - 0xfd */
                                                            0x3dd1, 0xffff, 0xffff, 0x3dd2, 0xffff, 0xffff, 0x3dd3, 0xd7e3, 0xd7e9,
    0xd7e1, 0xffff, 0xc5dc, 0x3dd4, 0x3dd5, 0xd7e6, 0xc9dd, 0x3dd6, 0x3dd7, 0xd7e0, 0x3dd8, 0xd7e5, 0xcee7, 0xbbd7, 0xffff, 0x3dd9,
    0xc2d5, 0xd7de, 0xffff, 0xffff, 0x3dda, 0xb5de, 0xd7e8, 0xc0ad, 0xb1e5, 0xd7e2, 0xb2f8, 0xd7e7, 0xffff, 0x3ddb, 0xffff, 0xb6b1,
    0xffff, 0xd7e4, 0xffff, 0x3ddc, 0xffff, 0x3ddd, 0xffff, 0xffff, 0xffff, 0xffff, 0xd7ea, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3dde, 0xd7ec, 0xd7f6, 0xd7f4, 0xffff, 0xffff, 0xd7f1, 0x3ddf, 0x3de0, 0x3de1, 0xd7f0, 0xcef8, 0x3de2, 0xd7f2, 0xffff, 0xffff,
    0xb6b2, 0x3de3, 0xb9b1, 0xffff, 0x3de4, 0xbdfa, 0x3de5, 0x3de6, 0xffff, 0xd7f9, 0xd7eb, 0xffff, 0xffff, 0x3de7, 0xffff, 0xd7ef,
    0xd7df, 0x3de8, 0xb2fa, 0xd7f3, 0xd7f5, 0xc3d1, 0xffff, 0x3de9, 0xbaa8, 0xb2b8, 0xd7ed, 0xd7f8, 0xd7f7, 0xb6b3, 0xffff, 0xc2a9,
    0xb3e6, 0x3dea, 0xffff, 0xffff, 0xffff, 0xb7c3, 0xffff, 0xd7ee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3deb, 0x3dec,
    0xffff, 0xd7fa, 0x3ded, 0xd7fd, 0xd8a1, 0xffff, 0x3dee, 0xffff, 0x3def, 0xbcbd, 0x3df0, 0xd8a7, 0xc4f0, 0xd7fb, 0x3df1, 0xffff,
    0xffff, 0x3df2, 0xd8a5, 0x3df3, 0xb2f9, 0x3df4, 0xd8a3, 0xd8a4, 0x3df5, 0xffff, 0xd7fe, 0xd8a2, 0xffff, 0x3df6, 0x3df7, 0xb8e7,
    0xcdaa, 0xffff, 0x3df8, 0xb4b5, 0x3df9, 0x3dfa, 0xb1d9, 0xd8a6, 0x3dfb, 0xc7ba, 0xb0ad, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x3dfc, 0x3dfd, 0xc8e1, 0xd7dc, 0xd8ac, 0xd8b0, 0xcce5, 0x3dfe, 0xd8a9, 0xffff, 0xffff, 0x3ea1, 0xc5e9, 0xd8ae, 0x3ea2, 0xffff,
    0xffff, 0xffff, 0x3ea3, 0xffff, 0x3ea4, 0xbef0, 0xd8af, 0xc6d7, 0x3ea5, 0x3ea6, 0x3ea7, 0x3ea8, 0xffff, 0xffff, 0x3ea9, 0x3eaa,
    0xffff, 0xcfc7, 0xffff, 0xd8ab, 0x3eab, 0x3eac, 0xffff, 0xffff, 0xd8b1, 0x3ead, 0xb9fb, 0x3eae, 0xc0cb, 0x3eaf, 0x3eb0, 0xb0d4,
    0xd8aa, 0xd8a8, 0x3eb1, 0xc1da, 0xffff, 0x3eb2, 0xffff, 0xd7fc, 0xbbb4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xc2c6, 0xd8bd, 0x3eb3, 0xc1db, 0xd8b8, 0x3eb4, 0xd8b5, 0xd8b6, 0x3eb5, 0xbce6, 0xd8b9, 0xd8bc, 0x3eb6, 0x3eb7,

    /* 0x61: 0x00 - 0xff */
    0xd8b7, 0xbda5, 0x3eb8, 0xd8ba, 0xffff, 0xffff, 0xd8b4, 0x3eb9, 0xccfc, 0xccfb, 0x3eba, 0xffff, 0x3ebb, 0xd8be, 0xd8bf, 0xb0d5,
    0x3ebc, 0x3ebd, 0x3ebe, 0x3ebf, 0x3ec0, 0xd8b3, 0x3ec1, 0x3ec2, 0xffff, 0x3ec3, 0xb6f2, 0xb0a6, 0x3ec4, 0xffff, 0x3ec5, 0xb4b6,
    0xffff, 0xd8bb, 0x3ec6, 0xffff, 0xffff, 0xffff, 0xffff, 0xd8c3, 0xd8c2, 0xffff, 0x3ec7, 0x3ec8, 0xd8c7, 0xffff, 0xffff, 0xffff,
    0x3ec9, 0x3eca, 0xffff, 0xffff, 0xd8c8, 0x3ecb, 0x3ecc, 0x3ecd, 0xffff, 0x3ece, 0xffff, 0xffff, 0xd8c6, 0xd8c9, 0xd8c1, 0xd8c5,
    0xffff, 0x3ecf, 0xd8ca, 0xffff, 0xd8cb, 0x3ed0, 0x3ed1, 0xd8c0, 0xbbfc, 0x3ed2, 0xd8c4, 0xc2d6, 0xb9b2, 0xd8b2, 0xbfb5, 0xffff,
    0xffff, 0xffff, 0xffff, 0xd8d8, 0xffff, 0xcae9, 0xffff, 0xffff, 0xd8ce, 0xd8cf, 0xd8d0, 0xffff, 0xffff, 0xd8d7, 0x3ed3, 0xd8d6,
    0x3ed4, 0xffff, 0xcbfd, 0xb4b7, 0xffff, 0xd8d4, 0xffff, 0xb7c5, 0xb3b4, 0xffff, 0xffff, 0xd8d1, 0x3ed5, 0xffff, 0xceb8, 0xd8d3,
    0xb0d6, 0xd8d5, 0x3ed6, 0xd8cc, 0xd8d2, 0xd8d9, 0xb7c4, 0xd8cd, 0x3ed7, 0xffff, 0xffff, 0x3ed8, 0x3ed9, 0xffff, 0xcddd, 0x3eda,
    0x3edb, 0x3edc, 0xcdab, 0x3edd, 0x3ede, 0xffff, 0xffff, 0xd8dc, 0xffff, 0xffff, 0xd8e0, 0x3edf, 0xffff, 0x3ee0, 0xc1fe, 0xffff,
    0xcef9, 0xd8e1, 0x3ee1, 0x3ee2, 0xd8de, 0xffff, 0xd8db, 0x3ee3, 0x3ee4, 0xd8da, 0xd8df, 0xffff, 0x3ee5, 0x3ee6, 0xffff, 0x3ee7,
    0x3ee8, 0xffff, 0xffff, 0xffff, 0xcab0, 0x3ee9, 0xffff, 0xc6b4, 0x3eea, 0xb7c6, 0x3eeb, 0xd8e2, 0xd8dd, 0x3eec, 0xd8e3, 0xffff,
    0xffff, 0xffff, 0xb7fb, 0xffff, 0xffff, 0xffff, 0xb2b1, 0xffff, 0x3eed, 0x3eee, 0xd8eb, 0xffff, 0x3eef, 0xffff, 0xb4b8, 0xffff,
    0x3ef0, 0x3ef1, 0x3ef2, 0xd8e9, 0xffff, 0xffff, 0xd8ea, 0xbaa9, 0xd8e8, 0xd8e6, 0xd8e5, 0xd8ec, 0xd8e4, 0xd8ee, 0x3ef3, 0x3ef4,
    0xb2fb, 0xffff, 0xffff, 0xffff, 0xffff, 0x3ef5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3ef6, 0x3ef7, 0x3ef8, 0x3ef9,
    0xffff, 0x3efa, 0x3efb, 0xd8f0, 0xffff, 0x3efe, 0xd8ef, 0x3efc, 0xffff, 0x3efd, 0xffff, 0xffff, 0x3fa1, 0x3fa2, 0xffff, 0x3fa3,
    0xffff, 0xffff, 0xc4a8, 0xffff, 0xd8f3, 0xffff, 0xd8f1, 0xd8e7, 0xb7fc, 0xffff, 0xd8f2, 0xffff, 0xd8f6, 0xd8f5, 0xd8f7, 0xd8f4,

    /* 0x62: 0x00 - 0xff */
    0xd8f8, 0x3fa4, 0xffff, 0x3fa5, 0x3fa6, 0xffff, 0xffff, 0x3fa7, 0xd8f9, 0xd8fa, 0xcaea, 0xffff, 0xd8fc, 0xd8fb, 0xbdbf, 0xffff,
    0xc0ae, 0xb2e6, 0xb2fc, 0x3fa8, 0xd8fd, 0x3fa9, 0xb0bf, 0xffff, 0xffff, 0xffff, 0xc0cc, 0xd8fe, 0x3faa, 0xecc3, 0xd9a1, 0xb7e1,
    0x3fab, 0xd9a2, 0x3fac, 0x3fad, 0xffff, 0xffff, 0xc0ef, 0x3fae, 0xffff, 0x3faf, 0xd9a3, 0x3fb0, 0xffff, 0xffff, 0xd9a4, 0xb5ba,
    0xd9a5, 0xffff, 0xd9a6, 0xd9a7, 0xc2d7, 0xffff, 0xffff, 0xffff, 0xb8cd, 0x3fb1, 0xffff, 0xcce1, 0xffff, 0x3fb2, 0xffff, 0xcbbc,
    0xbdea, 0xd9a8, 0x3fb3, 0x3fb4, 0x3fb5, 0xffff, 0x3fb6, 0xc0f0, 0xeebd, 0xc8e2, 0xffff, 0xbcea, 0x3fb7, 0xbacd, 0xd9a9, 0xffff,
    0x3fb8, 0x3fb9, 0x3fba, 0xc2c7, 0x3fbb, 0xcaa7, 0x3fbc, 0xffff, 0xc2f1, 0xffff, 0x3fbd, 0xd9ac, 0x3fbe, 0xffff, 0xd9aa, 0xffff,
    0xd9ad, 0xffff, 0xffff, 0xd9ab, 0x3fbf, 0xffff, 0xffff, 0xffff, 0xd9ae, 0xffff, 0xffff, 0xffff, 0xffff, 0x3fc0, 0xcab1, 0x3fc1,
    0xffff, 0xb0b7, 0xffff, 0x3fc2, 0xffff, 0xffff, 0xc9de, 0xffff, 0xffff, 0xc8e3, 0x3fc3, 0xffff, 0xd9af, 0x3fc4, 0xd9b2, 0xbeb5,
    0xb5bb, 0xffff, 0xd9b0, 0xd9b7, 0xbeb6, 0xffff, 0xffff, 0xffff, 0xffff, 0xd9b1, 0xc7c4, 0xffff, 0xffff, 0x3fc5, 0x3fc6, 0x3fc7,
    0x3fc8, 0xcdde, 0xd9b3, 0xd9b4, 0xd9b8, 0xc5ea, 0xd9b5, 0xb9b3, 0xc0de, 0xffff, 0xffff, 0xd9c6, 0xc8b4, 0xffff, 0xc2f2, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3fc9, 0xffff, 0x3fca, 0xffff, 0xffff, 0xc8e4, 0xdaad, 0xffff, 0xffff, 0xffff,
    0xffff, 0xcafa, 0xffff, 0x3fcb, 0xffff, 0xc4f1, 0x3fcc, 0x3fcd, 0xffff, 0xcbf5, 0x3fce, 0xd9bb, 0xb2a1, 0xc3ea, 0x3fcf, 0x3fd0,
    0xffff, 0xffff, 0xd9c4, 0xffff, 0x3fd1, 0xc3b4, 0xd9be, 0xd9c5, 0xd9c0, 0xd9c7, 0xd9c3, 0xffff, 0xd9c2, 0xc7ef, 0x3fd2, 0xd9bc,
    0xb2fd, 0xd9ba, 0xb5f1, 0xc2f3, 0xd9b6, 0x3fd3, 0x3fd4, 0xd9b9, 0xb9b4, 0xc0db, 0x3fd5, 0xbeb7, 0xd9c1, 0xc7d2, 0xffff, 0xffff,
    0xb5f2, 0xb3c8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3fd6, 0xffff, 0xb3e7, 0xbfa1, 0xd9c9, 0xd9ce,
    0xffff, 0xd9ca, 0x3fd7, 0xb7fd, 0x3fd8, 0xd9cf, 0xbba2, 0xb9e9, 0xffff, 0xffff, 0xffff, 0xffff, 0x3fd9, 0x3fda, 0xbda6, 0xd9bd,

    /* 0x63: 0x01 - 0xfa */
            0xbbfd, 0xd9cc, 0x3fdb, 0x3fdc, 0xffff, 0xffff, 0xbbd8, 0xd9cd, 0xb0c4, 0x3fdd, 0x3fde, 0xd9c8, 0x3fdf, 0xffff, 0xffff,
    0x3fe0, 0xc4a9, 0xffff, 0x3fe1, 0xffff, 0xffff, 0x3fe2, 0xffff, 0x3fe3, 0xb5f3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb6b4,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xd9cb, 0xb0a7, 0x3fe4, 0x3fe5, 0xbac3, 0xffff, 0x3fe6, 0xffff, 0xbfb6,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3fe7, 0x3fe8, 0xffff, 0xffff, 0x3fe9, 0xc4f2, 0xffff, 0x3fea, 0xc8d4, 0xd9d1, 0xc1de,
    0xffff, 0x3feb, 0x3fec, 0x3fed, 0x3fee, 0xffff, 0x3fef, 0xffff, 0xffff, 0xc2aa, 0x3ff0, 0x3ff1, 0xbbab, 0xd9d2, 0x3ff2, 0xd9d4,
    0xd9d0, 0xffff, 0x3ff3, 0x3ff4, 0x3ff5, 0xcae1, 0xffff, 0xc4bd, 0x3ff6, 0xffff, 0xffff, 0x3ff7, 0xc1dc, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x3ff8, 0x3ff9, 0xcafb, 0xbcce, 0xd9e0, 0xffff, 0xd9df, 0x3ffa, 0x3ffb, 0xbff8, 0xffff,
    0xffff, 0x3ffc, 0xb7fe, 0xffff, 0x3ffd, 0x3ffe, 0xd9d9, 0xbeb9, 0x40a1, 0xffff, 0xc6e8, 0xc7b1, 0x40a2, 0x40a3, 0xffff, 0x40a4,
    0xd9d7, 0xffff, 0x40a5, 0xc1dd, 0x40a6, 0xffff, 0xffff, 0x40a7, 0xbcf8, 0xd9dc, 0x40a8, 0xffff, 0xbeb8, 0xffff, 0xd9d6, 0xd9db,
    0x40a9, 0xffff, 0xc7d3, 0xffff, 0x40aa, 0x40ab, 0xd9d5, 0xffff, 0xb7a1, 0x40ac, 0x40ad, 0xb3dd, 0xffff, 0xffff, 0x40ae, 0xd9dd,
    0xceab, 0xbace, 0xc3b5, 0xd9da, 0x40af, 0xc0dc, 0x40b0, 0xb9b5, 0xbfe4, 0xb1e6, 0xc1bc, 0xd9d8, 0xb5c5, 0x40b1, 0x40b2, 0x40b3,
    0xffff, 0xffff, 0xb7c7, 0xffff, 0xc4cf, 0xd9de, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc1df, 0xffff, 0x40b4, 0xd9e1, 0xffff,
    0xd9e3, 0x40b5, 0xffff, 0xc2b7, 0xd9e9, 0x40b6, 0xd9e4, 0xffff, 0x40b7, 0xd9e6, 0xffff, 0xffff, 0xffff, 0xffff, 0x40b8, 0xc9c1,
    0xc4f3, 0x40b9, 0xd9e7, 0x40ba, 0x40bb, 0x40bc, 0xcdac, 0xffff, 0xffff, 0xffff, 0xcdc8, 0xb4b9, 0x40bd, 0xffff, 0xffff, 0xffff,
    0x40be, 0xb0ae, 0xffff, 0xd9e5, 0xffff, 0x40bf, 0xffff, 0xffff, 0xffff, 0xd9e2, 0x40c0, 0xffff, 0x40c1, 0xffff, 0xb4f8, 0xffff,
    0xffff, 0xffff, 0x40c2, 0x40c3, 0xb1e7, 0x40c4, 0xd9e8, 0xffff, 0x40c5, 0x40c6, 0xcdc9,

    /* 0x64: 0x06 - 0xff */
                                                    0xd9ec, 0xffff, 0xffff, 0x40c7, 0x40c8, 0xffff, 0xffff, 0xc2bb, 0xffff, 0xd9f3,
    0x40c9, 0xffff, 0x40ca, 0xd9ed, 0x40cb, 0xffff, 0xd9ea, 0xd9f1, 0x40cc, 0xffff, 0xffff, 0xffff, 0xd9d3, 0xffff, 0x40cd, 0xffff,
    0x40ce, 0xffff, 0x40cf, 0xffff, 0x40d0, 0x40d1, 0xd9ee, 0xffff, 0xd9f2, 0x40d2, 0x40d3, 0xffff, 0xc8c2, 0xc5eb, 0xffff, 0x40d4,
    0x40d5, 0xffff, 0xffff, 0xffff, 0xd9eb, 0x40d6, 0xd9ef, 0xffff, 0xffff, 0xffff, 0xb7c8, 0xffff, 0xffff, 0x40d7, 0xbaf1, 0x40d8,
    0xffff, 0xffff, 0xc0dd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x40d9, 0xffff, 0xffff, 0xd9f7, 0x40da,
    0xffff, 0x40db, 0x40dc, 0x40dd, 0x40de, 0xffff, 0xffff, 0xffff, 0xc5a6, 0xffff, 0x40df, 0x40e0, 0x40e1, 0x40e2, 0xffff, 0x40e3,
    0x40e4, 0x40e5, 0xffff, 0x40e6, 0xffff, 0xffff, 0xffff, 0xd9f4, 0xffff, 0xcbe0, 0xffff, 0xffff, 0xffff, 0x40e7, 0xffff, 0xd9f5,
    0xffff, 0xffff, 0xffff, 0x40e8, 0x40e9, 0xffff, 0xd9f6, 0xffff, 0xccce, 0xffff, 0xc0a2, 0x40ea, 0xffff, 0x40eb, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xb7e2, 0xffff, 0x40ec, 0xffff, 0x40ed, 0xd9fd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x40ee,
    0x40ef, 0x40f0, 0xbbb5, 0xd9fa, 0xffff, 0xd9f9, 0xffff, 0xffff, 0x40f1, 0x40f2, 0xc7b2, 0x40f3, 0xffff, 0x40f4, 0xc6b5, 0x40f5,
    0xffff, 0x40f6, 0xffff, 0x40f7, 0xc5b1, 0xd9fb, 0x40f8, 0xffff, 0x40f9, 0xd9fc, 0xffff, 0xc9ef, 0x40fa, 0xc7c5, 0xbba3, 0xffff,
    0xc0f1, 0xffff, 0xcbd0, 0x40fb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb3c9, 0xffff, 0xdaa5, 0xd9fe, 0x40fc, 0x40fd, 0x40fe,
    0xffff, 0xcdca, 0xdaa7, 0xffff, 0x41a1, 0xdaa3, 0xffff, 0xdaa4, 0xffff, 0x41a2, 0x41a3, 0x41a4, 0x41a5, 0xc1e0, 0x41a6, 0xffff,
    0x41a7, 0x41a8, 0xdaa2, 0xffff, 0xd9bf, 0x41a9, 0xffff, 0x41aa, 0xdaa6, 0xffff, 0xdaa1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xdaab, 0xdaac, 0xc5a7, 0xdaae, 0x41ab, 0x41ac, 0xbba4, 0xdaa9, 0xffff, 0x41ad, 0x41ae, 0xffff, 0xb5bc, 0x41af, 0xffff, 0xdaaf,
    0x41b0, 0xdaa8, 0xdab3, 0xffff, 0xdab2, 0x41b1, 0xdab1, 0x41b2, 0xffff, 0xffff, 0xdab4, 0x41b3, 0xffff, 0xdab6, 0xbef1, 0x41b4,

    /* 0x65: 0x00 - 0xff */
    0xdab5, 0x41b5, 0xffff, 0xffff, 0x41b6, 0xdab9, 0xffff, 0xffff, 0x41b7, 0x41b8, 0x41b9, 0xffff, 0xffff, 0xffff, 0xffff, 0x41ba,
    0xffff, 0xffff, 0xffff, 0x41bb, 0x41bc, 0xffff, 0x41bd, 0xffff, 0xdab7, 0x41be, 0xffff, 0x41bf, 0xdab8, 0xd9f0, 0x41c0, 0x41c1,
    0xffff, 0xffff, 0x41c2, 0xdabb, 0xdaba, 0xffff, 0x41c3, 0xffff, 0xffff, 0x41c4, 0xd9f8, 0xdabc, 0xdab0, 0xffff, 0x41c5, 0xbbd9,
    0xffff, 0x41c6, 0xffff, 0xffff, 0xdabd, 0xdabe, 0xdac0, 0xdabf, 0xdac1, 0xb2fe, 0x41c7, 0xb9b6, 0x41c8, 0x41c9, 0xcafc, 0xc0af,
    0xffff, 0xffff, 0xffff, 0x41ca, 0xffff, 0xb8ce, 0xffff, 0x41cb, 0xdac3, 0x41cc, 0xffff, 0xffff, 0xffff, 0xdac6, 0xffff, 0xc9d2,
    0x41cd, 0xb5df, 0x41ce, 0xffff, 0x41cf, 0xdac5, 0xdac4, 0xc7d4, 0xdac7, 0xb6b5, 0xffff, 0xffff, 0xffff, 0xdac9, 0xdac8, 0x41d0,
    0x41d1, 0xffff, 0xb4ba, 0xbbb6, 0xffff, 0xffff, 0xc6d8, 0x41d2, 0xffff, 0xffff, 0xffff, 0x41d3, 0xb7c9, 0xffff, 0xffff, 0xffff,
    0xbff4, 0xffff, 0xdaca, 0xffff, 0xc0b0, 0xc5a8, 0xffff, 0xc9df, 0xdacb, 0xffff, 0x41d4, 0xffff, 0xffff, 0x41d5, 0xffff, 0xffff,
    0xffff, 0x41d6, 0xdacc, 0xdacd, 0xffff, 0x41d7, 0xffff, 0xcab8, 0xd5dd, 0xc0c6, 0x41d8, 0xffff, 0xc9cc, 0xffff, 0xbad8, 0xffff,
    0xc8e5, 0xc8c3, 0x41d9, 0xffff, 0xffff, 0x41da, 0xffff, 0xc5cd, 0x41db, 0xcec1, 0xffff, 0xdacf, 0xbcd0, 0x41dc, 0xffff, 0xdad0,
    0x41dd, 0xb0b6, 0xffff, 0x41de, 0xb6d4, 0xc0cd, 0x41df, 0xc9e0, 0xffff, 0xffff, 0xffff, 0xdad1, 0xbbc2, 0xc3c7, 0x41e0, 0xbbdb,
    0xbfb7, 0xffff, 0x41e1, 0x41e2, 0x41e3, 0xffff, 0xffff, 0xdad2, 0xffff, 0xcafd, 0xffff, 0xffff, 0xb1f7, 0xbbdc, 0xffff, 0x41e4,
    0xffff, 0xdad5, 0x41e5, 0xdad3, 0xdad6, 0xceb9, 0xdad4, 0xffff, 0x41e6, 0x41e7, 0xffff, 0xc0fb, 0xdad7, 0xffff, 0x41e8, 0xc2b2,
    0x41e9, 0xffff, 0xdad8, 0xffff, 0x41ea, 0xffff, 0x41eb, 0xb4fa, 0x41ec, 0xdada, 0xffff, 0xdad9, 0xffff, 0xffff, 0xffff, 0x41ed,
    0xdadb, 0xdadc, 0xb4fb, 0xffff, 0xffff, 0xc6fc, 0xc3b6, 0xb5ec, 0xbbdd, 0xc1e1, 0xffff, 0xffff, 0xbddc, 0xb0b0, 0xffff, 0xffff,
    0x41ee, 0xdadd, 0x41ef, 0xffff, 0x41f0, 0x41f1, 0xffff, 0xffff, 0xffff, 0x41f2, 0xb2a2, 0xdae1, 0xffff, 0xffff, 0x41f3, 0x41f4,

    /* 0x66: 0x00 - 0xff */
    0x41f5, 0xffff, 0xb9b7, 0xdae0, 0x41f6, 0xffff, 0xbaab, 0xbeba, 0x41f7, 0x41f8, 0xdadf, 0xffff, 0xbebb, 0x41f9, 0xccc0, 0xbaaa,
    0xffff, 0x41fa, 0x41fb, 0xb0d7, 0xc0ce, 0x41fc, 0x41fd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdae6, 0x41fe, 0x42a1, 0xc0b1,
    0xb1c7, 0x42a2, 0x42a3, 0x42a4, 0x42a5, 0xbdd5, 0x42a6, 0xcbe6, 0xbaf2, 0x42a7, 0x42a8, 0x42a9, 0x42aa, 0xbebc, 0x42ab, 0xc0a7,
    0x42ac, 0x42ad, 0xffff, 0x42ae, 0xdae5, 0xdae3, 0xdae4, 0x42b0, 0xffff, 0x42af, 0xffff, 0xffff, 0xc3eb, 0xffff, 0xffff, 0xdba6,
    0x42b1, 0xdaea, 0xbbfe, 0xb9b8, 0xdae8, 0x42b2, 0x42b3, 0xffff, 0xffff, 0xdae9, 0x42b4, 0xbfb8, 0x42b5, 0xffff, 0x42b7, 0xdae7,
    0xffff, 0x42b6, 0xbbaf, 0xffff, 0xffff, 0xffff, 0xffff, 0x42b8, 0x42b9, 0x42ba, 0xffff, 0x42bb, 0x42bc, 0xdaec, 0xdaeb, 0xdaf0,
    0x42bd, 0x42be, 0xdaf1, 0xffff, 0xdaed, 0xffff, 0xb3a2, 0xdaee, 0xdaef, 0xc8d5, 0x42c0, 0x42c1, 0x42c2, 0xffff, 0xc9e1, 0xb7ca,
    0xdaf2, 0xffff, 0xffff, 0x42c4, 0xc0b2, 0x42c5, 0xbebd, 0x42c7, 0x42c8, 0x42c9, 0xc3d2, 0x42ca, 0x42cc, 0xffff, 0x42c3, 0x42c6,
    0x42cb, 0xb6c7, 0xffff, 0xdaf3, 0xdaf7, 0xffff, 0xffff, 0xb2cb, 0xdaf4, 0xdaf6, 0xffff, 0x42cd, 0x42ce, 0x42cf, 0xdaf5, 0xffff,
    0x42d0, 0xbdeb, 0x42d1, 0xffff, 0xffff, 0xffff, 0xc3c8, 0xb0c5, 0xdaf8, 0x42d2, 0x42d3, 0x42d4, 0x42d5, 0xdaf9, 0xffff, 0x42d6,
    0x42d7, 0xffff, 0xc4aa, 0xffff, 0x42d8, 0xffff, 0xcef1, 0xffff, 0xffff, 0xffff, 0xffff, 0xbbc3, 0xffff, 0x42d9, 0xcaeb, 0xffff,
    0xffff, 0x42da, 0x42db, 0xffff, 0xcbbd, 0x42dc, 0xffff, 0xffff, 0xdba2, 0xdafb, 0xffff, 0x42dd, 0xdafe, 0xffff, 0xdafd, 0x42de,
    0x42df, 0xdafa, 0x42e0, 0x42e1, 0xdba1, 0xffff, 0xffff, 0xc6de, 0x42e2, 0xdafc, 0xffff, 0xffff, 0x42e3, 0xffff, 0x42e4, 0x42e5,
    0xffff, 0xffff, 0xffff, 0xffff, 0x42e6, 0xffff, 0xdba3, 0xffff, 0xffff, 0xbdec, 0xdba4, 0x42e7, 0xcdcb, 0xc7f8, 0xffff, 0x42e8,
    0xdba5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdba7, 0xffff, 0x42e9, 0xdba8, 0xffff, 0x42ea, 0x42eb, 0xffff, 0x42ec, 0xffff,
    0xdba9, 0xffff, 0xb6ca, 0xb1c8, 0xb9b9, 0xdbaa, 0xffff, 0xdbab, 0xbdf1, 0xc1e2, 0x42ed, 0x42bf, 0xd2d8, 0xc1be, 0xc1bd, 0xc2d8,

    /* 0x67: 0x00 - 0xff */
    0xbac7, 0xffff, 0xffff, 0xd0f2, 0xffff, 0x42ee, 0xffff, 0x42ef, 0xb7ee, 0xcdad, 0xffff, 0xcafe, 0xffff, 0xc9fe, 0x42f0, 0xdbac,
    0xffff, 0xffff, 0xffff, 0x42f1, 0xbaf3, 0xc4bf, 0xdbad, 0xcfaf, 0xffff, 0x42f2, 0xffff, 0xcbbe, 0x42f3, 0xc4ab, 0xdbae, 0xb4fc,
    0x42f4, 0xffff, 0x42f5, 0xffff, 0xffff, 0xffff, 0xdbaf, 0xdbb0, 0xccda, 0xffff, 0xcca4, 0xcbf6, 0xcbdc, 0xbba5, 0xdbb2, 0xffff,
    0xffff, 0xbceb, 0xffff, 0x42f6, 0xcbd1, 0xffff, 0xdbb4, 0xdbb7, 0xdbb6, 0xffff, 0xb4f9, 0xffff, 0xffff, 0xb5e0, 0x42f7, 0xdbb3,
    0xffff, 0xdbb5, 0xffff, 0xffff, 0xffff, 0x42f8, 0xdbb8, 0x42f9, 0x42fa, 0xbff9, 0xffff, 0xffff, 0x42fb, 0xffff, 0xcdfb, 0xb0c9,
    0xbae0, 0xc2bc, 0xffff, 0xbcdd, 0x42fc, 0x42fd, 0xbef3, 0xffff, 0xffff, 0xdbbb, 0xffff, 0xffff, 0xc5ce, 0x42fe, 0xdbb9, 0xc2ab,
    0xdbba, 0xbef2, 0xccdd, 0xdbbc, 0xdbbd, 0xcde8, 0x43a1, 0xffff, 0xffff, 0xffff, 0xdbc2, 0xffff, 0x43a2, 0xb9ba, 0x43a3, 0xc7d5,
    0xdbbf, 0xc5ec, 0xdade, 0xdae2, 0x43a4, 0xb5cf, 0x43a5, 0xc7c7, 0xffff, 0xffff, 0xffff, 0x43a6, 0xdbc1, 0xffff, 0xbebe, 0xc8c4,
    0xffff, 0x43a7, 0xffff, 0xffff, 0x43a8, 0xdbc7, 0xffff, 0xc8fa, 0xffff, 0xdbbe, 0xffff, 0xdbc4, 0xdbc3, 0xffff, 0x43a9, 0x43aa,
    0xc0cf, 0x43ab, 0xffff, 0x43ac, 0xffff, 0xcbed, 0x43ad, 0xced3, 0x43ae, 0x43af, 0xcbe7, 0x43b0, 0xb2cc, 0xbbde, 0xffff, 0xffff,
    0xcfc8, 0xdbc6, 0xbff5, 0xffff, 0xffff, 0xffff, 0xdbc5, 0xffff, 0xffff, 0xdbc0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb8cf,
    0x43b1, 0x43b2, 0x43b3, 0xdbcc, 0xdbca, 0x43b4, 0xb2cd, 0xdbc8, 0xdbce, 0xdbd4, 0xffff, 0x43b5, 0x43b6, 0x43b7, 0xffff, 0xffff,
    0x43b9, 0xc2c8, 0x43ba, 0x43bb, 0xcac1, 0x43bc, 0xdbd6, 0xffff, 0x43bd, 0x43be, 0xc9a2, 0xffff, 0xffff, 0xffff, 0xdbd5, 0xc7f0,
    0xcbbf, 0xb4bb, 0x43bf, 0xc0f7, 0xbdc0, 0xffff, 0xffff, 0x43c0, 0xc4d3, 0x43c1, 0xcdae, 0xffff, 0x43c2, 0xdbd1, 0xdbd0, 0xffff,
    0xffff, 0x43c3, 0xdbd2, 0xffff, 0xdbcf, 0xffff, 0x43c4, 0xdbd7, 0xffff, 0xdbcd, 0xffff, 0xffff, 0xdbcb, 0xffff, 0xdbd3, 0xdbc9,
    0x43c5, 0xc3ec, 0x43c6, 0xccf8, 0xbcc6, 0xbaf4, 0x43c7, 0x43c8, 0xffff, 0x43b8, 0xffff, 0xbaba, 0xffff, 0xffff, 0xcbef, 0xb3c1,

    /* 0x68: 0x02 - 0xfd */
                    0xc4ce, 0xc6ca, 0xb1c9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xc0f2, 0x43ca, 0xffff, 0xc0b4, 0xb7aa, 0xffff, 0x43cb, 0xffff, 0xffff, 0xffff, 0x43cc, 0xdbd9, 0x43cd,
    0xffff, 0xb9bb, 0xb3fc, 0xffff, 0xffff, 0xffff, 0xffff, 0x43cf, 0x43ce, 0xdbdb, 0xb3f4, 0xdbe1, 0x43d0, 0x43d1, 0xffff, 0x43d2,
    0x43d3, 0x43d4, 0xdbde, 0x43d5, 0xc0f3, 0xffff, 0xffff, 0xffff, 0xb3cb, 0xbaac, 0xffff, 0x43d6, 0xb3ca, 0xbacf, 0xffff, 0x43d7,
    0xdbdc, 0xb7e5, 0xb7cb, 0xc5ed, 0x43d8, 0x43d9, 0xdbda, 0xffff, 0xb0c6, 0xffff, 0x43da, 0xffff, 0x43db, 0xdbdd, 0xdbdf, 0xffff,
    0xb6cd, 0xb7ac, 0x43c9, 0xb4bc, 0xb5cb, 0x43dc, 0xffff, 0x43dd, 0x43de, 0xdbe2, 0xffff, 0x43df, 0xbaf9, 0xcbf1, 0xffff, 0xbbb7,
    0xffff, 0xffff, 0xffff, 0xdbe3, 0xffff, 0xffff, 0xffff, 0xc9b0, 0xffff, 0xffff, 0xffff, 0x43e0, 0xffff, 0xffff, 0x43e1, 0x43e2,
    0x43e3, 0x43e4, 0x43e5, 0xffff, 0xdbef, 0x43e6, 0xb2b3, 0xdbe4, 0xffff, 0x43e7, 0x43e8, 0x43e9, 0x43ea, 0xffff, 0xdbf5, 0xdbe5,
    0xffff, 0xcec2, 0x43eb, 0xdbec, 0x43ec, 0xc7df, 0x43ed, 0xffff, 0x43ee, 0xffff, 0xffff, 0xffff, 0xffff, 0xdbf4, 0xffff, 0xdbe7,
    0xffff, 0xffff, 0xffff, 0xb0b4, 0xdbe9, 0xffff, 0x43ef, 0xb9bc, 0x43f0, 0xffff, 0x43f1, 0xdbeb, 0x43f2, 0xdbea, 0xffff, 0xdbe6,
    0xdbf1, 0x43f3, 0xbebf, 0x43f4, 0xffff, 0x43f5, 0xd4ed, 0xb8e8, 0xcdfc, 0x43f6, 0x43f7, 0xffff, 0xffff, 0xdbe8, 0x43f8, 0xc4f4,
    0xb3a3, 0xbaad, 0x43f9, 0xdbe0, 0xffff, 0xdbf0, 0xb3e1, 0xffff, 0xffff, 0xdbee, 0xdbf2, 0x43fa, 0xc5ee, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xb4fe, 0x43fb, 0xdcb2, 0xffff, 0x43fc, 0xccc9, 0xdbf7, 0xb4fd, 0x43fd, 0xdbfe, 0xffff, 0x43fe,
    0x44a1, 0x44a2, 0xcbc0, 0x44a3, 0xdca1, 0xdca3, 0x44a4, 0xdca7, 0xdbf9, 0x44a5, 0xc3aa, 0xffff, 0x44a6, 0x44a7, 0xffff, 0xc5ef,
    0xdcab, 0xdbfc, 0xffff, 0xdca8, 0xffff, 0x44a8, 0xffff, 0xdca2, 0x44a9, 0xffff, 0x44aa, 0x44ab, 0x44ac, 0x44ad, 0xbfb9, 0xdcac,
    0x44ae, 0x44af, 0xc0b3, 0xffff, 0xffff, 0x44b0, 0x44b1, 0xffff, 0xffff, 0xdcaa, 0xb4bd, 0x44b2, 0x44b3, 0x44b4,

    /* 0x69: 0x00 - 0xff */
    0xcfd0, 0xdbf6, 0xffff, 0xffff, 0xdca6, 0xb0d8, 0x44b5, 0xffff, 0xdbf8, 0x44b6, 0x44b7, 0xccba, 0xdbfd, 0xbfa2, 0xc4c7, 0xdbf3,
    0x44b8, 0x44b9, 0xdca5, 0x44ba, 0xffff, 0xffff, 0x44bb, 0x44bc, 0xffff, 0xbffa, 0xdcaf, 0xb3f1, 0xb8a1, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdcb1, 0xdbfa, 0xdcb0, 0xffff, 0xdca9, 0xdbfb, 0xffff, 0xdcad, 0xffff, 0xdcae, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xdcbf, 0x44bd, 0xffff, 0x44be, 0xc6ce, 0x44bf, 0xdca4, 0xffff, 0x44c0, 0xdcbb, 0xffff, 0x44c1, 0xffff, 0xdcbd, 0xffff, 0xc4d8,
    0xffff, 0xffff, 0x44c2, 0xffff, 0xffff, 0x44c3, 0xffff, 0xffff, 0xffff, 0x44c4, 0xcdcc, 0xffff, 0xffff, 0xffff, 0x44c5, 0xffff,
    0xffff, 0xffff, 0xffff, 0xc9f6, 0xdcb8, 0xc2ca, 0xffff, 0x44c6, 0xffff, 0xdcbe, 0xc1bf, 0x44c7, 0xdcb5, 0xdcc2, 0xdcc1, 0xffff,
    0xc6ef, 0xdcc0, 0xc6ea, 0x44c8, 0x44c9, 0x44ca, 0x44cb, 0xffff, 0x44cc, 0x44cd, 0xdcc4, 0xdcb7, 0x44ce, 0xb6c8, 0xdcba, 0xbddd,
    0x44cf, 0x44d0, 0x44d1, 0xc7e0, 0xdcbc, 0xb6cb, 0xffff, 0xdcb4, 0xdcb6, 0xdcb3, 0x44d2, 0x44d3, 0xcfb0, 0xb3da, 0xdcb9, 0x44d4,
    0x44d5, 0xdcc3, 0xb3b5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbae7, 0xffff, 0xffff, 0x44d6, 0xb1dd, 0xffff,
    0xffff, 0xdcd4, 0x44d7, 0xffff, 0xcfb1, 0xdcd7, 0x44d8, 0xffff, 0x44d9, 0xffff, 0xffff, 0xbfba, 0xdcd6, 0xffff, 0xffff, 0xffff,
    0xdcd5, 0x44da, 0xffff, 0xffff, 0xffff, 0x44db, 0x44dc, 0xdcd2, 0x44dd, 0xffff, 0xffff, 0x44de, 0xffff, 0x44df, 0xdcc6, 0x44e0,
    0xffff, 0xdce3, 0xdcc5, 0xffff, 0xdcd8, 0xffff, 0xffff, 0x44e1, 0x44e2, 0xffff, 0x44e3, 0xdcd0, 0x44e4, 0xffff, 0xdccb, 0xdcc8,
    0xffff, 0xdcc9, 0xffff, 0xdcd1, 0xffff, 0x44e5, 0xffff, 0xf4a2, 0x44e6, 0xffff, 0xdcce, 0xb9bd, 0xc4c8, 0xc1e4, 0xdccc, 0xffff,
    0xdcc7, 0x44e7, 0xffff, 0xdcca, 0xffff, 0xffff, 0x44e8, 0x44e9, 0xcdcd, 0xcbea, 0xffff, 0xffff, 0xffff, 0xdccf, 0xdcd9, 0xffff,
    0xffff, 0xffff, 0x44ea, 0xffff, 0xffff, 0x44eb, 0xffff, 0xdce1, 0xdcda, 0xffff, 0xffff, 0xdce7, 0xffff, 0xdce5, 0x44ec, 0x44ed,
    0xffff, 0x44ee, 0xdce0, 0x44ef, 0xffff, 0x44f0, 0xffff, 0xffff, 0xffff, 0xdcdf, 0xffff, 0xc4d0, 0xffff, 0xc1e5, 0x44f1, 0xdcdd,

    /* 0x6a: 0x00 - 0xfd */
    0x44f2, 0x44f3, 0xdcdb, 0x44f4, 0xffff, 0xdce2, 0xffff, 0xffff, 0xffff, 0xffff, 0xdce8, 0xc8f5, 0xdcee, 0xffff, 0xffff, 0x44f5,
    0xffff, 0x44f6, 0xdce9, 0xdcec, 0xdce6, 0x44f7, 0xffff, 0xc3f4, 0xffff, 0xc9b8, 0x44f8, 0xdcdc, 0xffff, 0x44f9, 0xdce4, 0xbec0,
    0x44fa, 0xcccf, 0xdcf8, 0xdceb, 0x44fb, 0xffff, 0xffff, 0xffff, 0x44fc, 0xb8a2, 0xb2a3, 0xb3df, 0xffff, 0xffff, 0xdcd3, 0xffff,
    0x44fd, 0xffff, 0x44fe, 0xffff, 0x45a1, 0xbec1, 0xdcf0, 0x45a2, 0xdcf7, 0xbcf9, 0xb3f2, 0x45a3, 0xffff, 0xc3ae, 0x45a4, 0x45a5,
    0xffff, 0xffff, 0xffff, 0xffff, 0xdced, 0x45a6, 0x45a7, 0xdcf2, 0xdcf6, 0x45a8, 0x45a9, 0xb6b6, 0xffff, 0xffff, 0x45aa, 0xffff,
    0x45ab, 0x45ac, 0x45ad, 0xffff, 0xffff, 0x45ae, 0x45af, 0xffff, 0xb5cc, 0xdcf4, 0xffff, 0x45b0, 0xffff, 0xffff, 0xffff, 0xb5a1,
    0xffff, 0xc6cb, 0xdcf3, 0xffff, 0x45b1, 0xffff, 0xdcf5, 0x45b2, 0xffff, 0xffff, 0x45b3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x45b4, 0xdcef, 0x45b5, 0xffff, 0xffff, 0xffff, 0xffff, 0xdcf1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x45b6, 0xb3e0,
    0xc3c9, 0x45b7, 0xffff, 0x45b8, 0xdcfc, 0xffff, 0x45b9, 0x45ba, 0xffff, 0x45bb, 0xffff, 0x45bc, 0xffff, 0xdcfa, 0xb8e9, 0xffff,
    0xdcf9, 0x45bd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdda1, 0xffff, 0xffff, 0xffff, 0x45be, 0xdbd8, 0x45bf, 0x45c0, 0x45c1,
    0xdcfb, 0xffff, 0xdcfd, 0xdcfe, 0xffff, 0x45c2, 0xffff, 0xffff, 0xffff, 0xffff, 0xddac, 0x45c3, 0xdda8, 0xffff, 0xdbed, 0x45c4,
    0x45c5, 0x45c6, 0xffff, 0xdda7, 0x45c7, 0xffff, 0xffff, 0xffff, 0xdda6, 0xffff, 0xffff, 0xdda3, 0xffff, 0x45c8, 0x45c9, 0x45ca,
    0xffff, 0xdcea, 0xdda5, 0xdda4, 0xffff, 0xffff, 0x45cb, 0xffff, 0x45cd, 0x45cc, 0xffff, 0xffff, 0x45ce, 0xffff, 0xffff, 0xffff,
    0x45cf, 0xddaa, 0xffff, 0xcfa6, 0x45d0, 0x45d1, 0x45d2, 0xffff, 0xffff, 0xffff, 0xddad, 0xb6fb, 0x45d3, 0x45d4, 0xdda9, 0xddab,
    0xffff, 0xffff, 0xffff, 0xffff, 0x45d5, 0xffff, 0xffff, 0x45d6, 0xc8a7, 0xffff, 0xddae, 0xffff, 0x45d7, 0xffff, 0xffff, 0xffff,
    0x45d8, 0x45d9, 0x45da, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xddb2, 0xddaf, 0x45db, 0x45dc,

    /* 0x6b: 0x02 - 0xff */
                    0x45dd, 0x45de, 0xcdf3, 0xddb0, 0x45df, 0x45e0, 0xffff, 0x45e1, 0xdcde, 0xffff, 0xffff, 0xffff, 0xffff, 0x45e2,
    0x45e3, 0x45e4, 0xddb3, 0xffff, 0xffff, 0xffff, 0xddb4, 0x45e5, 0xffff, 0xffff, 0xffff, 0x45e6, 0xffff, 0xb1b5, 0x45e7, 0xddb6,
    0xb7e7, 0xbca1, 0xffff, 0xb6d5, 0x45e8, 0xffff, 0xffff, 0xb2a4, 0x45e9, 0xffff, 0xffff, 0x45ea, 0x45eb, 0xffff, 0xffff, 0x45ec,
    0xffff, 0xffff, 0xcddf, 0xffff, 0xffff, 0x45ed, 0x45ee, 0xddb8, 0xddb7, 0xddba, 0xb5bd, 0x45ef, 0xffff, 0xb6d6, 0xb4be, 0x45f0,
    0xffff, 0xffff, 0xffff, 0xddbd, 0xffff, 0xffff, 0x45f1, 0xddbc, 0xffff, 0xddbe, 0x45f2, 0xffff, 0xb2ce, 0x45f3, 0xc3b7, 0xffff,
    0xddbf, 0xffff, 0x45f4, 0xb4bf, 0xddc1, 0xffff, 0x45f5, 0xffff, 0x45f6, 0xddc0, 0xffff, 0xddc2, 0xffff, 0x45f7, 0xffff, 0xddc3,
    0x45f8, 0xddc4, 0xbbdf, 0xc0b5, 0xbaa1, 0xffff, 0xc9f0, 0x45f9, 0xffff, 0xcae2, 0xcfc4, 0x45fa, 0xffff, 0xffff, 0x45fb, 0xbbf5,
    0x45fc, 0xffff, 0xffff, 0xbad0, 0xcef2, 0x45fd, 0xffff, 0xffff, 0xddc5, 0xddc6, 0xffff, 0xbbe0, 0xffff, 0x45fe, 0x46a1, 0xddc7,
    0xddc8, 0xffff, 0x46a2, 0xddca, 0xddc9, 0x46a3, 0xcbd8, 0xffff, 0xffff, 0xbdde, 0xbcec, 0xbbc4, 0xffff, 0xddcb, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xddcd, 0xbfa3, 0x46a4, 0xddcc, 0xffff, 0xffff, 0x46a5, 0xffff, 0xffff, 0xddce, 0x46a6,
    0x46a7, 0xffff, 0x46a8, 0x46a9, 0xddcf, 0xffff, 0xffff, 0xffff, 0x46aa, 0x46ab, 0xddd0, 0xddd1, 0x46ac, 0x46ad, 0x46ae, 0xddd2,
    0x46af, 0xddd4, 0xddd3, 0xddd5, 0xb2a5, 0xc3ca, 0xffff, 0xddd6, 0x46b0, 0x46b1, 0xbba6, 0xb3cc, 0xddd7, 0x46b2, 0x46b3, 0xc5c2,
    0xd4cc, 0xffff, 0xffff, 0x46b4, 0x46b5, 0xb5a3, 0xddd8, 0xffff, 0xffff, 0x46b6, 0xffff, 0xddd9, 0x46b7, 0xcaec, 0xcbe8, 0xffff,
    0xffff, 0xffff, 0xc6c7, 0xddda, 0xc8e6, 0xffff, 0x46b8, 0xffff, 0xc8fb, 0xffff, 0x46b9, 0xccd3, 0xffff, 0xffff, 0xffff, 0xdddb,
    0xffff, 0x46ba, 0xffff, 0x46bb, 0xffff, 0xffff, 0x46bc, 0x46bd, 0xffff, 0xffff, 0xffff, 0xdddd, 0xdddc, 0xffff, 0x46be, 0xdddf,
    0xffff, 0x46bf, 0xffff, 0xddde, 0xffff, 0xffff, 0xffff, 0x46c0, 0xffff, 0x46c1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x46c2,

    /* 0x6c: 0x02 - 0xf4 */
                    0x46c3, 0xffff, 0x46c4, 0x46c5, 0xffff, 0xffff, 0xdde1, 0x46c6, 0xffff, 0xffff, 0xffff, 0x46c7, 0x46c8, 0xbbe1,
    0x46c9, 0xccb1, 0x46ca, 0xdde2, 0xdde3, 0xffff, 0xffff, 0xb5a4, 0xffff, 0x46cb, 0xffff, 0xdde4, 0xffff, 0xffff, 0xffff, 0x46cc,
    0xffff, 0xffff, 0xffff, 0xdde6, 0xdde5, 0xffff, 0x46cd, 0x46ce, 0x46cf, 0xffff, 0xffff, 0xffff, 0x46d0, 0xffff, 0x46d1, 0xffff,
    0xffff, 0xffff, 0xffff, 0x46d2, 0xbfe5, 0x46d3, 0x46d4, 0xc9b9, 0xb1ca, 0xffff, 0x46d5, 0x46d6, 0xffff, 0xffff, 0xc8c5, 0x46d7,
    0xc4f5, 0xbdc1, 0xb5e1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x46d8, 0x46d9, 0xffff, 0x46da, 0xc8c6, 0x46db,
    0xbcae, 0xffff, 0x46dc, 0xffff, 0x46dd, 0xdde8, 0xffff, 0xb4c0, 0xffff, 0x46de, 0xb1f8, 0x46df, 0x46e0, 0xc6f2, 0xdde7, 0xb9be,
    0xc3d3, 0xffff, 0xdde9, 0xffff, 0xffff, 0xffff, 0xffff, 0x47b6, 0xddf1, 0xffff, 0xddea, 0x46e1, 0xffff, 0x46e2, 0xffff, 0x46e3,
    0xc2c1, 0xffff, 0xb5e2, 0xddf2, 0x46e4, 0xffff, 0x46e5, 0xffff, 0x46e6, 0x46e7, 0xb7e8, 0x46e8, 0xffff, 0xb5a5, 0xddf0, 0xffff,
    0xffff, 0xddee, 0xddeb, 0xcde0, 0xffff, 0x46e9, 0x46ea, 0x46eb, 0xc4c0, 0x46ec, 0xffff, 0xffff, 0xc6d9, 0xddec, 0xffff, 0xffff,
    0xddf4, 0xffff, 0xddf3, 0xb7a3, 0x46ed, 0x46ee, 0xb2ad, 0x46ef, 0x46f0, 0xbabb, 0xdded, 0xddef, 0x46f1, 0xffff, 0xffff, 0x46f2,
    0xffff, 0xcbd7, 0xc2f4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xcbf7, 0xffff, 0xffff, 0xddfc, 0xffff,
    0x46f3, 0xddfd, 0x46f4, 0xb2cf, 0x46f5, 0xffff, 0xffff, 0xffff, 0xcaa8, 0xccfd, 0xdea1, 0xbca3, 0xbec2, 0xddf8, 0xddfe, 0xb1e8,
    0xffff, 0xb6b7, 0x46f6, 0xffff, 0xddf5, 0xddfa, 0x46f7, 0xffff, 0xffff, 0xc0f4, 0xc7f1, 0xffff, 0xc8e7, 0x46f8, 0xffff, 0x46f9,
    0x46fa, 0x46fb, 0x46fc, 0xddf7, 0x46fd, 0xcba1, 0x46fe, 0xddf9, 0xffff, 0xdea4, 0x47a1, 0xdea2, 0x47a2, 0xddfb, 0xffff, 0xffff,
    0x47a3, 0xcba2, 0xc7c8, 0xb5e3, 0xffff, 0xc5a5, 0xffff, 0x47a4, 0xc3ed, 0x47a5, 0xdea5, 0x47a6, 0x47a7, 0xffff, 0x47a8, 0xdea3,
    0xc2d9, 0xddf6, 0x47a9, 0xb1cb, 0x47aa,

    /* 0x6d: 0x04 - 0xfc */
                                    0x47ab, 0xffff, 0xffff, 0x47ac, 0xffff, 0xffff, 0x47ad, 0xcdce, 0xdeb0, 0xffff, 0x47ae, 0x47af,
    0xffff, 0x47b0, 0xdeaf, 0x47b1, 0xffff, 0xffff, 0xffff, 0xc0f6, 0xffff, 0xdeac, 0x47b2, 0xcdec, 0xffff, 0xffff, 0xc6b6, 0xdea6,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc4c5, 0x47b3, 0x47b4, 0x47b5, 0xb1cc, 0xb9bf, 0xdea9, 0xffff, 0xffff, 0x47b7, 0x47b8,
    0xffff, 0x47b9, 0xbda7, 0xdeae, 0xffff, 0xdead, 0xdea8, 0xffff, 0xdeab, 0x47ba, 0xffff, 0xb3e8, 0x47bb, 0xdeaa, 0xc7c9, 0x47bc,
    0xffff, 0xceae, 0xffff, 0xffff, 0xbef4, 0xc0f5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x47bd, 0xffff, 0xdeb6, 0xdeb4, 0xffff, 0xc9cd, 0xffff, 0x47be, 0x47bf,
    0xffff, 0x47c0, 0xffff, 0xdeb1, 0xdeb3, 0x47c1, 0xb1ba, 0x47c2, 0xffff, 0xb9c0, 0xcfb2, 0xffff, 0xb3bd, 0xffff, 0xc9e2, 0x47c3,
    0x47c4, 0xffff, 0xffff, 0xffff, 0xcde1, 0xffff, 0xffff, 0xb3a4, 0xbfbb, 0xdeb5, 0xffff, 0xffff, 0x47c5, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x47c6, 0xffff, 0xffff, 0xdeba, 0xffff, 0x47c7, 0xbec3, 0xffff, 0xffff, 0xffff, 0xcdb0, 0xffff, 0xdeb7, 0xffff,
    0xffff, 0x47c8, 0x47c9, 0xdeb2, 0x47ca, 0xdeb8, 0x47cb, 0x47cc, 0x47cd, 0xcede, 0xffff, 0xc5f3, 0xc6c2, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x47ce, 0xffff, 0x47cf, 0xffff, 0xffff, 0xb3b6,
    0xffff, 0xffff, 0xb1d5, 0xffff, 0x47d0, 0xdebe, 0xffff, 0x47d1, 0xdec1, 0x47d2, 0xffff, 0xffff, 0xcec3, 0x47d3, 0xffff, 0x47d4,
    0xcde4, 0xffff, 0xffff, 0xffff, 0x47d5, 0xdec8, 0xdec2, 0xdebf, 0x47d6, 0xffff, 0x47d7, 0xced4, 0xdec5, 0xffff, 0x47d8, 0x47d9,
    0xffff, 0xbdca, 0xdec7, 0xffff, 0xffff, 0xdecc, 0x47da, 0xffff, 0xc5f1, 0xdeca, 0xffff, 0x47db, 0xffff, 0x47dc, 0xdec4, 0x47dd,
    0x47de, 0xc3b8, 0x47df, 0xffff, 0xdecb, 0x47e0, 0xdec0, 0xffff, 0xdec6, 0x47e1, 0xdecd, 0xb0fc, 0xdec3, 0xffff, 0xdece, 0x47e2,
    0x47e3, 0xbfbc, 0xffff, 0xbddf, 0x47e4, 0xcaa5, 0x47e5, 0xbaae, 0xffff, 0xdebb, 0xdec9, 0xc5ba, 0x47e6,

    /* 0x6e: 0x00 - 0xff */
    0x47e7, 0xffff, 0xffff, 0xffff, 0x47e8, 0xc0b6, 0xffff, 0xb3e9, 0xbad1, 0xbec4, 0xdebd, 0xbdc2, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xb7cc, 0xffff, 0xdebc, 0xffff, 0xffff, 0xffff, 0xded2, 0xbded, 0xb8ba, 0xffff, 0xdee1, 0x47e9, 0xdedb,
    0xb5f4, 0xc5cf, 0x47ea, 0xded6, 0xdedf, 0xb0af, 0xb1b2, 0x47eb, 0xffff, 0xb2b9, 0xffff, 0xded8, 0xc2ac, 0xdecf, 0xded1, 0xb9c1,
    0xffff, 0xffff, 0x47ec, 0xffff, 0xffff, 0xffff, 0x47ed, 0xffff, 0xdee2, 0x47ee, 0xdedd, 0x47ef, 0x47f0, 0xffff, 0xded5, 0xffff,
    0xffff, 0xffff, 0xffff, 0xdedc, 0x47f1, 0x47f2, 0xffff, 0xffff, 0x47f3, 0x47f4, 0xccab, 0x47f5, 0xffff, 0xdeda, 0xdede, 0x47f6,
    0xffff, 0x47f7, 0x47f8, 0x47f9, 0x47fa, 0xffff, 0xb8d0, 0x47fb, 0xbec5, 0xffff, 0xffff, 0xc3b9, 0x47fc, 0x47fd, 0x47fe, 0xded4,
    0xffff, 0xffff, 0x48a1, 0x48a2, 0xffff, 0xffff, 0xffff, 0xcdaf, 0x48a3, 0xffff, 0xffff, 0xded7, 0xffff, 0xffff, 0xded0, 0xc5f2,
    0xffff, 0xffff, 0xded3, 0x48a4, 0xffff, 0xffff, 0xded9, 0xffff, 0xffff, 0xffff, 0xffff, 0x48a5, 0xffff, 0x48a6, 0xcfd1, 0xbcbe,
    0xcbfe, 0xffff, 0xdee3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc8ae, 0x48a7, 0xffff, 0xdeef,
    0xb8bb, 0xffff, 0xffff, 0x48a8, 0xffff, 0xffff, 0xbde0, 0xffff, 0xdee5, 0x48a9, 0xffff, 0xffff, 0xceaf, 0xb9c2, 0xffff, 0xdef2,
    0x48aa, 0xffff, 0xb0ee, 0xffff, 0xffff, 0xdef0, 0xffff, 0x48ab, 0xffff, 0xffff, 0xdee4, 0xffff, 0xffff, 0x48ac, 0x48ad, 0xdeea,
    0xffff, 0x48ae, 0xdeec, 0x48af, 0xffff, 0xffff, 0xcdcf, 0xdee7, 0xffff, 0xffff, 0xc5ae, 0x48b0, 0xffff, 0xdee9, 0xffff, 0x48b1,
    0x48b2, 0x48b3, 0xdef1, 0x48b4, 0xdeeb, 0xccc7, 0xffff, 0x48b5, 0x48b6, 0xdee6, 0x48b7, 0xbca2, 0xdefe, 0x48b8, 0x48b9, 0x48ba,
    0xffff, 0xb3ea, 0xffff, 0xdee8, 0xdeed, 0xdeee, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc2ec, 0xc2da, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x48bb, 0xdef6, 0x48bc, 0x48bd, 0xdefc,
    0xffff, 0xffff, 0xdefa, 0xffff, 0xc5a9, 0xffff, 0xffff, 0xdfa3, 0xdef7, 0x48be, 0xffff, 0x48bf, 0xffff, 0x48c0, 0xdef8, 0xdee0,

    /* 0x6f: 0x01 - 0xfe */
            0xb5f9, 0xc9ba, 0xffff, 0x48c1, 0xffff, 0xbcbf, 0xffff, 0x48c2, 0xb9f7, 0x48c3, 0xffff, 0x48c4, 0x48c5, 0xffff, 0xcfb3,
    0xffff, 0xdef4, 0xffff, 0xdfa2, 0xb1e9, 0xc1e6, 0x48c6, 0xffff, 0x48c7, 0xffff, 0x48c8, 0x48c9, 0xffff, 0xffff, 0xffff, 0xffff,
    0xc7f9, 0xffff, 0xb4c1, 0xcefa, 0xffff, 0xffff, 0x48ca, 0xffff, 0xffff, 0x48cb, 0x48cc, 0xcca1, 0xc4d2, 0x48d3, 0xffff, 0x48cd,
    0x48ce, 0xdefb, 0xdefd, 0x48cf, 0xffff, 0xffff, 0x48d0, 0xffff, 0xc1b2, 0xffff, 0xffff, 0x48d1, 0x48d2, 0xffff, 0xdfa1, 0xdef9,
    0xffff, 0xdef3, 0xffff, 0xffff, 0xffff, 0xb4c3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x48d4,
    0xffff, 0x48d5, 0x48d6, 0x48d7, 0xb7e9, 0xffff, 0xffff, 0x48d8, 0xdfaf, 0x48d9, 0x48da, 0xdfaa, 0xc0f8, 0x48db, 0x48dc, 0xb3e3,
    0xffff, 0x48dd, 0x48de, 0xffff, 0xbde1, 0xffff, 0xdfb3, 0xffff, 0x48df, 0xffff, 0xffff, 0xffff, 0x48e0, 0xdfac, 0xc4ac, 0xdfa9,
    0xc4d9, 0xffff, 0xffff, 0xffff, 0xdfcc, 0xffff, 0xffff, 0xffff, 0xdfa6, 0xffff, 0xdfa5, 0xffff, 0xdfae, 0x48e1, 0x48e2, 0xffff,
    0xdfa8, 0xdfa7, 0xdfad, 0x48e3, 0xc0a1, 0xffff, 0xdfa4, 0x48e4, 0x48e5, 0xffff, 0xffff, 0x48e6, 0x48e7, 0x48e8, 0xdfb0, 0xffff,
    0x48e9, 0xdfb1, 0x48ea, 0x48eb, 0x48ec, 0xffff, 0x48ed, 0xb4c2, 0xffff, 0xffff, 0x48ee, 0xffff, 0xffff, 0xffff, 0xffff, 0x48ef,
    0x48f0, 0xdfb6, 0xffff, 0xdfb5, 0xdfb7, 0x48f1, 0x48f2, 0x48f3, 0x48f4, 0xffff, 0xdfba, 0xffff, 0xffff, 0xffff, 0x48f5, 0x48f6,
    0x48f7, 0xc5c3, 0xffff, 0xdfb4, 0xffff, 0x48f8, 0x48f9, 0xffff, 0xffff, 0xdfb8, 0xffff, 0xffff, 0x48fa, 0xffff, 0xffff, 0xffff,
    0xb7e3, 0xc2f9, 0xdfb2, 0xc7bb, 0xffff, 0x48fb, 0xdfb9, 0x48fc, 0x48fd, 0xffff, 0x48fe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xdfbe, 0xdfbc, 0xffff, 0xffff, 0xdfbf, 0xffff, 0x49a1, 0xdfc2, 0xffff, 0xffff, 0x49a2, 0xdfbb,
    0xb9ea, 0xc7a8, 0xffff, 0xffff, 0xdeb9, 0xffff, 0xffff, 0xffff, 0x49a3, 0x49a4, 0xffff, 0xcdf4, 0xdfbd, 0xffff, 0xdfc1, 0xc2f5,
    0x49a5, 0xdfc0, 0xffff, 0xdfab, 0xffff, 0x49a6, 0xefe9, 0xffff, 0xffff, 0x49a7, 0xdfc5, 0xffff, 0x49a8, 0x49a9, 0xdfc9,

    /* 0x70: 0x00 - 0xfd */
    0x49aa, 0xdfc7, 0xffff, 0xffff, 0xffff, 0x49ab, 0x49ac, 0x49ad, 0xffff, 0xdfc3, 0xffff, 0xdfc4, 0xffff, 0x49ae, 0xffff, 0xdfc8,
    0xffff, 0xdfc6, 0xffff, 0xffff, 0xffff, 0xc9ce, 0xffff, 0x49af, 0xdfce, 0xffff, 0xdfcb, 0xdfca, 0xffff, 0xdfcd, 0xc6d4, 0xdfcf,
    0x49b0, 0xffff, 0xffff, 0x49b1, 0xffff, 0xffff, 0xc3f5, 0xc2ed, 0xffff, 0xffff, 0xffff, 0xffff, 0xc0a5, 0xffff, 0xffff, 0x49b2,
    0xdfd0, 0xffff, 0xdfd2, 0xffff, 0x49b3, 0xffff, 0xffff, 0x49b4, 0xffff, 0x49b5, 0xffff, 0xffff, 0x49b6, 0xffff, 0xdfd1, 0xffff,
    0xffff, 0xffff, 0xffff, 0x49b7, 0x49b8, 0xffff, 0xffff, 0xffff, 0x49b9, 0x49ba, 0x49bb, 0x49bc, 0xdef5, 0xffff, 0x49c1, 0xffff,
    0xffff, 0xdfd3, 0xffff, 0xffff, 0x49bd, 0x49be, 0xffff, 0xffff, 0xc6e7, 0xffff, 0xffff, 0xffff, 0xffff, 0x49bf, 0x49c0, 0xffff,
    0xffff, 0xffff, 0xffff, 0xdfd4, 0x49c2, 0x49c3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb2d0, 0x49c4, 0xffff, 0x49c5, 0xc5f4,
    0xb3a5, 0xffff, 0xffff, 0xffff, 0xffff, 0x49c6, 0x49c7, 0xffff, 0xb5e4, 0xffff, 0xffff, 0xffff, 0xbcde, 0xbad2, 0x49c8, 0xffff,
    0xffff, 0x49c9, 0xffff, 0xffff, 0xffff, 0x49ca, 0x49cb, 0xffff, 0xffff, 0xcfa7, 0xbfe6, 0xffff, 0xffff, 0xffff, 0xb1ea, 0xffff,
    0xffff, 0xffff, 0xdfd6, 0xffff, 0x49cc, 0x49cd, 0x49ce, 0x49cf, 0x49d0, 0xdfd5, 0xffff, 0x49d1, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x49d2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x49d3, 0xdfd9, 0xc3ba, 0xdfdc, 0xdfd7,
    0x49d4, 0x49d5, 0xffff, 0xdfdb, 0x49d6, 0xffff, 0xffff, 0x49d7, 0xdfda, 0xc5c0, 0xb0d9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xcef5, 0xffff, 0x49d8, 0xdfde, 0xffff, 0xffff, 0xffff, 0xb1a8,
    0xffff, 0x49d9, 0xffff, 0x49da, 0x49db, 0x49dc, 0x49dd, 0xffff, 0x49de, 0xdfe0, 0xffff, 0xffff, 0x49df, 0xdfdf, 0xffff, 0xdfdd,
    0xffff, 0xffff, 0xffff, 0xffff, 0x49e0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xdfd8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xcba3, 0x49e1, 0xffff, 0xffff, 0xdfe2,

    /* 0x71: 0x03 - 0xff */
                            0x49e2, 0x49e3, 0x49e4, 0x49e5, 0x49e6, 0xffff, 0xdfe1, 0xffff, 0x49e7, 0x49e8, 0xffff, 0xffff, 0x49e9,
    0xffff, 0xffff, 0xffff, 0xffff, 0xb1eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xdfe4, 0xcab2, 0xffff, 0xdfe3, 0xffff, 0x49ea, 0xffff,
    0x49eb, 0xccb5, 0xffff, 0xffff, 0xffff, 0xffff, 0xbec7, 0xffff, 0xffff, 0xffff, 0xffff, 0x49ec, 0xffff, 0x49ed, 0xffff, 0x49ee,
    0x49ef, 0x49f0, 0xffff, 0xffff, 0xffff, 0xffff, 0xc1b3, 0xffff, 0x49f1, 0xffff, 0xffff, 0xffff, 0xbec6, 0xffff, 0xffff, 0xffff,
    0xffff, 0x49f2, 0xffff, 0xffff, 0xffff, 0x49f3, 0x49f4, 0x49f5, 0xffff, 0xcefb, 0x49f6, 0x49f7, 0xdfea, 0xffff, 0xc0f9, 0xffff,
    0x49f8, 0xffff, 0x49f9, 0xffff, 0xffff, 0xdfe6, 0xdfeb, 0x49fa, 0xffff, 0xb1ec, 0x49fb, 0xffff, 0x49fc, 0xffff, 0x49fd, 0xffff,
    0x49fe, 0xffff, 0xdfe9, 0xffff, 0xc7e1, 0xdfe5, 0xdfe8, 0xbec8, 0x4aa1, 0xc8d1, 0xffff, 0xffff, 0xdfec, 0xffff, 0xbcd1, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4aa2, 0xffff, 0xffff, 0xffff, 0xc0fa, 0xffff, 0xffff,
    0x4aa3, 0xffff, 0xffff, 0xffff, 0xdfef, 0x4aa4, 0xffff, 0x4aa5, 0xdfe7, 0xffff, 0xb7a7, 0xffff, 0x4aa6, 0xffff, 0xffff, 0xdfed,
    0xffff, 0xffff, 0x4aa7, 0xffff, 0xcdd0, 0xdff0, 0xffff, 0xffff, 0xffff, 0xf4a6, 0x4aa8, 0x4aa9, 0xffff, 0xffff, 0xffff, 0xbdcf,
    0x4aaa, 0xffff, 0x4aab, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdff1, 0xffff, 0xffff, 0xffff, 0xdff2, 0xffff, 0xffff, 0x4aac,
    0x4aad, 0xc7ae, 0x4aae, 0x4aaf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdff4, 0x4ab0, 0xffff, 0xffff, 0xffff, 0xdff5, 0x4ab1,
    0x4ab2, 0x4ab3, 0xffff, 0xc7b3, 0x4ab4, 0xffff, 0xffff, 0xffff, 0xc5f5, 0xdff7, 0xffff, 0x4ab5, 0x4ab6, 0xffff, 0xdff9, 0xffff,
    0xced5, 0xffff, 0xdff6, 0x4ab7, 0xdff8, 0xb1ed, 0x4ab8, 0xdff3, 0xffff, 0x4ab9, 0x4aba, 0xffff, 0x4abb, 0xffff, 0xffff, 0xd3db,
    0xdffa, 0xffff, 0xffff, 0xffff, 0xffff, 0xc1e7, 0xbbb8, 0xdffc, 0xffff, 0xffff, 0xffff, 0xffff, 0xdffb, 0xbfa4, 0xd2d9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xdffd, 0xffff, 0xffff, 0x4abc, 0xe0a1, 0xffff, 0xdfee, 0xdffe, 0xffff, 0x4abd, 0xe0a2,

    /* 0x72: 0x00 - 0xfe */
    0x4abe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc7fa, 0x4abf, 0x4ac0, 0x4ac1, 0xffff, 0xffff, 0xffff, 0xe0a3, 0xffff, 0xffff,
    0xe0a4, 0xffff, 0xffff, 0x4ac2, 0xffff, 0xffff, 0xffff, 0x4ac3, 0xffff, 0xffff, 0x4ac4, 0xe0a5, 0xffff, 0x4ac5, 0xffff, 0x4ac6,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4ac7, 0xffff, 0xffff, 0xffff, 0xe0a6, 0xffff, 0xc4de, 0x4ac8, 0xe0a8, 0xe0a7, 0xffff, 0x4ac9,
    0xe0a9, 0xffff, 0xe0aa, 0xffff, 0x4aca, 0xbcdf, 0xc9e3, 0xffff, 0x4acb, 0x4acc, 0xccec, 0xe0ab, 0xe0ac, 0xc1d6, 0xbca4, 0xe0ad,
    0xe0ae, 0x4acd, 0x4ace, 0x4acf, 0xffff, 0x4ad0, 0xe0af, 0xcad2, 0xc8c7, 0xffff, 0xffff, 0xe0b0, 0xc7d7, 0xffff, 0x4ad1, 0x4ad2,
    0x4ad3, 0xffff, 0xc4ad, 0x4ad4, 0xffff, 0x4ad5, 0x4ad6, 0xffff, 0xe0b1, 0xb2e7, 0x4ad7, 0xb5ed, 0x4ad8, 0xccc6, 0x4ad9, 0xccb6,
    0x4ada, 0xb2b4, 0xcfb4, 0x4adb, 0xffff, 0xffff, 0xffff, 0xcbd2, 0x4adc, 0xcaaa, 0xffff, 0x4add, 0xffff, 0xffff, 0x4ade, 0x4adf,
    0xffff, 0x4ae0, 0xc0b7, 0xffff, 0xe0b2, 0xffff, 0xffff, 0x4ae1, 0x4ae2, 0xc6c3, 0xffff, 0x4ae3, 0x4ae4, 0xb8a3, 0xe0b3, 0x4ae5,
    0xbad4, 0xe0b5, 0xe0b4, 0xffff, 0x4ae6, 0xffff, 0xffff, 0xe0b6, 0xffff, 0x4ae7, 0xffff, 0xffff, 0xffff, 0x4ae8, 0x4ae9, 0xffff,
    0xffff, 0xffff, 0xe0b7, 0x4aea, 0xffff, 0xffff, 0xe0b8, 0xffff, 0xffff, 0xffff, 0xffff, 0x4aeb, 0xffff, 0xffff, 0xffff, 0xffff,
    0xb5be, 0xffff, 0xe0b9, 0xffff, 0xffff, 0xffff, 0xffff, 0xe0ba, 0x4aec, 0xffff, 0xffff, 0xffff, 0xb8a4, 0x4aed, 0x4aee, 0xc8c8,
    0xffff, 0x4aef, 0xe0bc, 0xffff, 0x4af0, 0xffff, 0xbef5, 0xffff, 0xffff, 0xe0bb, 0xffff, 0xffff, 0xffff, 0xffff, 0x4af1, 0xffff,
    0xffff, 0x4af2, 0xb6b8, 0xe0bd, 0xe0bf, 0xffff, 0xe0be, 0x4af3, 0xffff, 0x4af4, 0xffff, 0xffff, 0x4af5, 0xffff, 0xe0c0, 0xffff,
    0xb8d1, 0xffff, 0xe0c1, 0xffff, 0xffff, 0x4af6, 0x4af7, 0xb6e9, 0x4af8, 0xc1c0, 0xffff, 0xb9fd, 0xffff, 0xffff, 0xffff, 0x4af9,
    0xe0c3, 0xe0c4, 0xe0c2, 0xffff, 0xffff, 0x4afa, 0xffff, 0xffff, 0xffff, 0xbced, 0xffff, 0xffff, 0xc6c8, 0xb6b9, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x4afb, 0x4afc, 0xffff, 0xffff, 0xe0c6, 0xc3ac, 0xe0c5, 0x4afd, 0x4afe, 0xcfb5, 0xc7e2, 0x4ba1,

    /* 0x73: 0x02 - 0xff */
                    0x4ba2, 0xffff, 0x4ba3, 0x4ba4, 0xffff, 0x4ba5, 0xffff, 0xffff, 0xe0c9, 0x4ba6, 0xffff, 0x4ba7, 0xffff, 0xffff,
    0xffff, 0xffff, 0x4ba8, 0x4ba9, 0xffff, 0xffff, 0xe0cb, 0xe0c8, 0x4baa, 0x4bab, 0xffff, 0xccd4, 0xe0ca, 0xe0cc, 0x4bac, 0xcec4,
    0xffff, 0xffff, 0x4bad, 0xffff, 0x4bae, 0xe0d0, 0xffff, 0x4baf, 0x4bb0, 0xe0cf, 0xc3f6, 0xc7ad, 0x4bb1, 0xffff, 0xb8a5, 0xe0ce,
    0xffff, 0x4bb2, 0x4bb3, 0xffff, 0xe0cd, 0x4bb4, 0xcdb1, 0xcdb2, 0xffff, 0xffff, 0x4bb5, 0x4bb6, 0xffff, 0x4bb7, 0xe0d1, 0xb1ee,
    0xffff, 0xffff, 0xffff, 0x4bb8, 0xb9f6, 0xbbe2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4bb9, 0xe0d2, 0xe0d3,
    0x4bba, 0xffff, 0x4bbb, 0xffff, 0xffff, 0xffff, 0x4bbc, 0xe0d5, 0x4bbd, 0xffff, 0xffff, 0xffff, 0xffff, 0x4bbe, 0x4bbf, 0x4bc0,
    0x4bc1, 0xffff, 0xffff, 0xbdc3, 0xffff, 0xffff, 0x4bc2, 0x4bc3, 0xe0d7, 0x4bc4, 0xe0d6, 0x4bc5, 0x4bc6, 0xffff, 0x4bc7, 0x4bc8,
    0xe0d8, 0x4bc9, 0xb3cd, 0xffff, 0xffff, 0xe0da, 0xffff, 0x4bca, 0xe0d9, 0x4bcb, 0xe0dc, 0xe0db, 0x4bcc, 0xffff, 0xffff, 0xffff,
    0x4bcd, 0x4bce, 0xffff, 0x4bcf, 0xb8bc, 0x4bd0, 0x4bd1, 0xcea8, 0xffff, 0xb6cc, 0xffff, 0xb2a6, 0xffff, 0xffff, 0x4bd2, 0xffff,
    0x4bd3, 0xffff, 0xffff, 0x4bd4, 0xffff, 0x4bd5, 0xb6ea, 0x4bd6, 0x4bd7, 0xffff, 0xffff, 0xffff, 0x4bd8, 0xffff, 0x4bd9, 0x4bda,
    0x4bdb, 0xffff, 0x4bdc, 0xffff, 0xffff, 0x4bdd, 0x4bde, 0xffff, 0xffff, 0xb4e1, 0x4bdf, 0x4be0, 0xffff, 0x4be1, 0xffff, 0xffff,
    0xffff, 0xffff, 0xcee8, 0xe0de, 0xffff, 0x4be2, 0xffff, 0x4be3, 0xffff, 0x4be4, 0xffff, 0xe0e0, 0x4be5, 0x4be6, 0xffff, 0x4be7,
    0xe0e1, 0xffff, 0xb2d1, 0xffff, 0xffff, 0x4be8, 0x4be9, 0xffff, 0xe0dd, 0x4bea, 0xbbb9, 0x4beb, 0x4bec, 0xc4c1, 0xe0df, 0x4bed,
    0xffff, 0xffff, 0x4bee, 0x4bef, 0xffff, 0xffff, 0x4bf0, 0xffff, 0xffff, 0x4bf1, 0xffff, 0xffff, 0xffff, 0x4bf2, 0xe0e4, 0xffff,
    0xbcee, 0x4bf3, 0xffff, 0x4bf4, 0xffff, 0xe0e2, 0x4bf5, 0x4bf6, 0xffff, 0x4bf7, 0xb7be, 0xffff, 0xffff, 0xc8c9, 0xe0e3, 0xffff,
    0xffff, 0xe0fe, 0xffff, 0xffff, 0x4bf8, 0x4bf9, 0xffff, 0x4bfa, 0xe0e9, 0x4bfb, 0x4bfc, 0x4bfd, 0xffff, 0x4bfe, 0xb8bd, 0x4ca1,

    /* 0x74: 0x00 - 0xff */
    0x4ca2, 0x4ca3, 0xffff, 0xb5e5, 0x4ca4, 0xe0e6, 0xcdfd, 0x4ca5, 0xffff, 0xceb0, 0x4ca6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x4ca7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4ca8, 0x4ca9, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xc2f6, 0xffff, 0x4caa, 0xe0e8, 0x4cab, 0xffff, 0x4cac, 0x4cad, 0x4cae, 0x4caf, 0x4cb0, 0x4cb1, 0x4cb2, 0x4cb3,
    0x4cb4, 0x4cb5, 0xe0ea, 0xced6, 0xb6d7, 0xc8fc, 0xc7ca, 0xffff, 0xffff, 0x4cb6, 0xe0eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xe0ed,
    0x4cb7, 0xe0f0, 0xffff, 0x4cb8, 0x4cb9, 0xffff, 0x4cba, 0x4cbb, 0xffff, 0xffff, 0xffff, 0x4cbc, 0xffff, 0x4cbd, 0xffff, 0xffff,
    0xffff, 0x4cbe, 0x4cbf, 0xffff, 0xffff, 0xe0ec, 0xffff, 0x4cc0, 0xffff, 0xe0ef, 0xb8ea, 0xb1cd, 0xe0f1, 0x4cc1, 0xbff0, 0xe0ee,
    0xcedc, 0xffff, 0x4cc2, 0xe0f4, 0xf4a4, 0xffff, 0x4cc3, 0x4cc4, 0x4cc5, 0xe0f2, 0xe0f5, 0x4cc6, 0xffff, 0x4cc7, 0x4cc8, 0xe0e7,
    0xe0f3, 0x4cc9, 0x4cca, 0xbabc, 0xffff, 0xffff, 0xe0f6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe0f7, 0xffff,
    0x4ccb, 0x4ccc, 0xffff, 0xcdfe, 0xffff, 0x4ccd, 0x4cce, 0x4ccf, 0xffff, 0x4cd0, 0xffff, 0xe0f8, 0xffff, 0xffff, 0xffff, 0x4cd1,
    0x4cd2, 0x4cd3, 0x4cd4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4cd5, 0x4cd6, 0x4cd7, 0xffff, 0x4cd8, 0xffff, 0xe0f9, 0x4cd9,
    0x4cda, 0x4cdb, 0xe0e5, 0x4cdc, 0xffff, 0xffff, 0x4cdd, 0xe0fa, 0x4cde, 0x4cdf, 0x4ce0, 0x4ce1, 0xffff, 0xffff, 0x4ce2, 0x4ce3,
    0xb4c4, 0x4ce4, 0x4ce5, 0xffff, 0xffff, 0x4ce6, 0xffff, 0xffff, 0xffff, 0x4ce7, 0xffff, 0x4ce8, 0xffff, 0xbca5, 0xffff, 0x4ce9,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4cea, 0x4ceb, 0xe0fb, 0xffff, 0x4cec, 0xffff, 0xffff, 0xe0fc,
    0x4ced, 0xffff, 0xffff, 0x4cee, 0xe0fd, 0xffff, 0xffff, 0xffff, 0x4cef, 0xffff, 0x4cf0, 0x4cf1, 0xb1bb, 0xffff, 0x4cf2, 0x4cf3,
    0xe1a1, 0xffff, 0xc9bb, 0xe1a2, 0x4cf4, 0xffff, 0xb4a4, 0xe1a3, 0x4cf5, 0xe1a4, 0x4cf6, 0x4cf7, 0xffff, 0xffff, 0xe1a5, 0x4cf8,
    0xe1a7, 0xe1a8, 0xe1a6, 0xffff, 0x4cf9, 0xffff, 0xc9d3, 0xe1aa, 0xe1a9, 0xffff, 0x4cfa, 0x4cfb, 0x4cfc, 0xffff, 0xffff, 0x4cfd,

    /* 0x75: 0x03 - 0xff */
                            0xe1ac, 0xe1ab, 0xe1ad, 0x4cfe, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe1ae, 0xe1b0, 0xe1af, 0xffff,
    0xffff, 0xb9f9, 0x4da1, 0xe1b2, 0xffff, 0xe1b1, 0x4da2, 0x4da3, 0xb4c5, 0xffff, 0xbfd3, 0xffff, 0xc5bc, 0xffff, 0xe1b3, 0xc0b8,
    0x4da4, 0x4da5, 0xffff, 0xbbba, 0x4da6, 0xb1f9, 0xe1b4, 0x4da7, 0xcdd1, 0x4da8, 0x4da9, 0xcae3, 0xe1b5, 0xffff, 0xffff, 0x4daa,
    0xc5c4, 0xcdb3, 0xb9c3, 0xbfbd, 0xffff, 0xffff, 0x4dab, 0xc3cb, 0xd2b4, 0x4dac, 0xc4ae, 0xb2e8, 0xe1b6, 0x4dad, 0x4dae, 0x4daf,
    0x4db0, 0xffff, 0xffff, 0x4db1, 0xe1b7, 0xffff, 0xe1bc, 0x4db2, 0x4db3, 0xe1ba, 0xe1b9, 0xdac2, 0xb3a6, 0xe1b8, 0x4db4, 0xb0da,
    0x4db5, 0xc8aa, 0x4db6, 0xffff, 0xc8ca, 0xffff, 0xffff, 0x4db7, 0xffff, 0xceb1, 0xe1bd, 0xe1bb, 0xc3dc, 0xc0a6, 0x4db8, 0x4db9,
    0xc8ab, 0x4dba, 0xc9ad, 0xffff, 0xe1bf, 0xceac, 0xb7cd, 0xe1c0, 0xffff, 0xe1be, 0xc8d6, 0xe1c1, 0xffff, 0xe1c2, 0xffff, 0x4dbb,
    0xb0db, 0x4dbc, 0xffff, 0xbef6, 0xe1c7, 0xffff, 0xe1c4, 0xc6ed, 0xe1c3, 0x4dbd, 0x4dbe, 0x4dbf, 0x4dc0, 0x4dc1, 0x4dc2, 0xb5a6,
    0xffff, 0x4dc3, 0xe1ca, 0xffff, 0xffff, 0x4dc4, 0xe1c5, 0xe1c6, 0xffff, 0xe1c9, 0xe1c8, 0xc9a5, 0xffff, 0xffff, 0xc1c2, 0xc1c1,
    0x4dc5, 0xb5bf, 0x4dc6, 0x4dc7, 0xe1cb, 0x4dc8, 0xffff, 0xffff, 0xffff, 0x4dc9, 0xe1cc, 0xffff, 0x4dca, 0xe1cd, 0xffff, 0xffff,
    0xffff, 0xffff, 0x4dcb, 0xe1cf, 0x4dcc, 0xe1ce, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb1d6, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xe1d7, 0xc8e8, 0xe1d1, 0x4dcd, 0xe1d3, 0xffff, 0xffff, 0xe1d5, 0xbfbe, 0x4dce, 0xffff, 0xe1d6, 0xe1d4, 0xbcc0, 0x4dcf,
    0x4dd0, 0x4dd1, 0xe1d0, 0xe1d2, 0x4dd2, 0xc9c2, 0x4dd3, 0xbec9, 0xffff, 0xffff, 0xe1d9, 0xffff, 0x4dd4, 0xe1d8, 0x4dd5, 0x4dd6,
    0xffff, 0xffff, 0xe1da, 0xffff, 0xbca6, 0xbaaf, 0xffff, 0x4dd7, 0xc5f7, 0xe1db, 0xffff, 0xc4cb, 0x4dd8, 0xffff, 0xe1dd, 0x4dd9,
    0x4dda, 0x4ddb, 0xcea1, 0xe1dc, 0x4ddc, 0xffff, 0xffff, 0x4ddd, 0xffff, 0xc1e9, 0xffff, 0xffff, 0x4dde, 0xffff, 0x4ddf, 0x4de0,
    0xe1e2, 0x4de1, 0xe1e4, 0xe1e5, 0xc3d4, 0xffff, 0xffff, 0xffff, 0xffff, 0x4de2, 0xe1e3, 0xffff, 0xe1e0, 0xffff, 0xe1de, 0xe1df,

    /* 0x76: 0x00 - 0xfe */
    0x4de3, 0xe1e1, 0x4de4, 0x4de5, 0x4de6, 0xffff, 0xffff, 0x4de7, 0x4de8, 0xe1e8, 0x4de9, 0xe1e6, 0x4dea, 0xe1e7, 0xffff, 0x4deb,
    0xffff, 0xffff, 0x4dec, 0x4ded, 0xffff, 0x4dee, 0x4def, 0xffff, 0xffff, 0x4df0, 0xffff, 0x4df1, 0x4df2, 0x4df3, 0x4df4, 0xe1e9,
    0xe1eb, 0xe1ec, 0xe1ed, 0x4df5, 0xe1ee, 0x4df6, 0x4df7, 0xe1ea, 0xffff, 0x4df8, 0xffff, 0xffff, 0xffff, 0x4df9, 0xffff, 0xffff,
    0xe1f0, 0xffff, 0x4dfa, 0x4dfb, 0xe1ef, 0x4dfc, 0xffff, 0xffff, 0x4dfd, 0x4dfe, 0x4ea1, 0xe1f1, 0x4ea2, 0xffff, 0xffff, 0xffff,
    0x4ea4, 0x4ea5, 0xcec5, 0x4ea6, 0x4ea7, 0x4ea8, 0xe1f4, 0xe1f2, 0xe1f3, 0x4ea9, 0x4ea3, 0x4eaa, 0xb4e2, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xccfe, 0xffff, 0xffff, 0x4eab, 0xcaca, 0xffff, 0xe1f6, 0x4eac, 0xffff, 0xffff, 0xe1f5, 0xffff, 0xffff, 0x4ead,
    0xffff, 0xe1f7, 0xe1f8, 0xffff, 0x4eae, 0x4eaf, 0xffff, 0xe1fc, 0xe1f9, 0xe1fa, 0xe1fb, 0xffff, 0xe1fd, 0x4eb0, 0x4eb1, 0x4eb2,
    0xe1fe, 0x4eb3, 0xe2a1, 0xffff, 0x4eb4, 0xffff, 0xe2a2, 0xffff, 0xe2a3, 0xffff, 0xc8af, 0xc5d0, 0xe2a4, 0xc7f2, 0xc9b4, 0xffff,
    0xe2a5, 0x4eb5, 0xffff, 0xe2a6, 0xc5aa, 0x4eb6, 0xb3a7, 0xb9c4, 0xe2a7, 0xffff, 0xffff, 0xe2a8, 0x4eb7, 0x4eb8, 0xe2a9, 0xffff,
    0xbba9, 0xffff, 0xffff, 0xe2ab, 0xffff, 0x4eb9, 0xe2aa, 0xffff, 0xffff, 0xe2ac, 0xe2ad, 0x4eba, 0x4ebb, 0x4ebc, 0xffff, 0x4ebd,
    0x4ebe, 0xffff, 0x4ebf, 0x4ec0, 0x4ec1, 0x4ec2, 0x4ec3, 0x4ec4, 0x4ec5, 0xffff, 0x4ec6, 0xffff, 0xffff, 0x4ec7, 0xc8e9, 0xffff,
    0xe2ae, 0xffff, 0xffff, 0xffff, 0xe2af, 0xffff, 0xffff, 0xf3e9, 0xe2b0, 0xe2b1, 0xe2b2, 0xffff, 0xffff, 0x4ec8, 0xffff, 0xbbae,
    0xffff, 0x4ec9, 0xe2b3, 0xc7d6, 0xffff, 0x4eca, 0xcbdf, 0xffff, 0xb1ce, 0x4ecb, 0xb1d7, 0x4ecc, 0x4ecd, 0xe2b4, 0x4ece, 0xffff,
    0xffff, 0xffff, 0xe2b6, 0xffff, 0x4ecf, 0xffff, 0xe2b5, 0xc5f0, 0xffff, 0x4ed0, 0xffff, 0xc0b9, 0xddb9, 0xffff, 0xe2b7, 0xccc1,
    0x4ed1, 0xe2b8, 0xffff, 0xb4c6, 0xc8d7, 0xe2b9, 0x4ed2, 0xe2ba, 0x4ed3, 0xffff, 0xe2bb, 0xffff, 0x4ed4, 0xffff, 0xccdc, 0xffff,
    0x4ed5, 0x4ed6, 0xccd5, 0xffff, 0xc4be, 0xffff, 0x4ed7, 0xffff, 0xc1ea, 0x4ed8, 0xffff, 0xe2bd, 0x4ed9, 0xffff, 0xbde2,

    /* 0x77: 0x00 - 0xfc */
    0x4eda, 0xbeca, 0xffff, 0xffff, 0xe2c0, 0xffff, 0x4edb, 0xe2bf, 0xe2be, 0xc8fd, 0x4edc, 0xb4c7, 0xb8a9, 0xffff, 0x4edd, 0xffff,
    0xffff, 0xffff, 0x4ede, 0xffff, 0x4edf, 0x4ee0, 0xffff, 0x4ee1, 0xffff, 0x4ee2, 0x4ee3, 0xe2c6, 0x4ee4, 0xffff, 0xe2c3, 0xbfbf,
    0xccb2, 0xffff, 0x4ee5, 0xffff, 0xe2c2, 0xe2c4, 0xe2c5, 0xffff, 0x4ee6, 0xe2c1, 0xffff, 0xffff, 0xffff, 0x4ee7, 0x4ee8, 0x4ee9,
    0xffff, 0xffff, 0xffff, 0xffff, 0x4eea, 0x4eeb, 0x4eec, 0xe2c7, 0xe2c8, 0x4eed, 0xc4af, 0xffff, 0xb4e3, 0x4eee, 0x4eef, 0xffff,
    0xc3e5, 0xffff, 0x4ef0, 0xffff, 0xffff, 0x4ef1, 0x4ef2, 0xe2c9, 0xffff, 0xffff, 0x4ef3, 0xffff, 0xffff, 0x4ef4, 0x4ef5, 0x4ef6,
    0xffff, 0xffff, 0x4ef7, 0xffff, 0xffff, 0xffff, 0x4ef8, 0x4ef9, 0xffff, 0xffff, 0xe2ca, 0xe2cd, 0x4efa, 0xffff, 0x4efb, 0x4efc,
    0x4efd, 0xbfe7, 0x4efe, 0xc6c4, 0x4fa1, 0xe2ce, 0xcbd3, 0x4fa2, 0xe2cb, 0xffff, 0x4fa3, 0xe2cc, 0x4fa4, 0xffff, 0xffff, 0xffff,
    0x4fa5, 0xffff, 0x4fa6, 0x4fa7, 0x4fa8, 0xffff, 0xffff, 0xffff, 0xffff, 0xe2d1, 0x4fa9, 0xffff, 0xffff, 0x4faa, 0xe2d0, 0xe2cf,
    0x4fab, 0xffff, 0xffff, 0xffff, 0x4fac, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe2d3, 0x4fad, 0x4fae, 0xe2d2, 0xffff,
    0xffff, 0xe2d4, 0xffff, 0xffff, 0x4faf, 0x4fb0, 0x4fb1, 0xffff, 0xffff, 0xffff, 0x4fb2, 0xffff, 0xffff, 0xffff, 0xe2d6, 0x4fb3,
    0xe2d5, 0xffff, 0x4fb4, 0xffff, 0xffff, 0xcacd, 0xffff, 0x4fb5, 0xffff, 0xffff, 0x4fb6, 0xffff, 0xbdd6, 0xcec6, 0x4fb7, 0x4fb8,
    0xe2d7, 0x4fb9, 0xffff, 0xc6b7, 0xffff, 0x4fba, 0xe2d8, 0xffff, 0xffff, 0xe2d9, 0xffff, 0xe2dd, 0xe2db, 0xe2dc, 0x4fbb, 0xe2da,
    0xffff, 0xffff, 0xffff, 0x4fbc, 0xffff, 0xffff, 0xffff, 0xe2de, 0xffff, 0x4fbd, 0xffff, 0xffff, 0xffff, 0xe2df, 0xffff, 0xffff,
    0xffff, 0x4fbe, 0x4fbf, 0xffff, 0xffff, 0x4fc0, 0xffff, 0xe2e0, 0xffff, 0x4fc1, 0xe2e1, 0xccb7, 0xe2e2, 0xffff, 0x4fc2, 0x4fc3,
    0x4fc4, 0xffff, 0xccf0, 0xe2e3, 0x4fc5, 0xc3ce, 0x4fc6, 0xc7ea, 0xffff, 0xb6eb, 0x4fc7, 0xffff, 0x4fc8, 0xc3bb, 0xe2e4, 0xb6ba,
    0x4fc9, 0x4fca, 0xffff, 0xc0d0, 0x4fcb, 0xffff, 0xffff, 0xffff, 0x4fcc, 0xffff, 0xffff, 0x4fcd, 0xe2e5,

    /* 0x78: 0x02 - 0xff */
                    0xbabd, 0xffff, 0xffff, 0x4fce, 0x4fcf, 0xffff, 0xffff, 0x4fd0, 0xffff, 0xffff, 0xe2e6, 0x4fd1, 0x4fd2, 0xffff,
    0xffff, 0x4fd3, 0xe2e7, 0xffff, 0xb8a6, 0xbad5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4fd4, 0xffff, 0xffff,
    0xe2e9, 0x4fd5, 0x4fd6, 0x4fd7, 0xffff, 0xc5d6, 0xbad6, 0xb5ce, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4fd8, 0x4fd9, 0xffff,
    0x4fda, 0xffff, 0xcba4, 0xffff, 0xc7cb, 0x4fdb, 0xffff, 0x4fdc, 0xffff, 0xffff, 0xc5d7, 0xffff, 0xffff, 0xffff, 0xffff, 0xb9dc,
    0xffff, 0xffff, 0xffff, 0x4fdd, 0x4fde, 0xe2eb, 0xffff, 0x4fdf, 0x4fe0, 0xffff, 0xffff, 0xffff, 0x4fe1, 0xffff, 0x4fe2, 0xffff,
    0xffff, 0xffff, 0x4fe3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4fe4, 0xbecb, 0x4fe5, 0xffff,
    0x4fe6, 0x4fe7, 0xffff, 0x4fe8, 0x4fe9, 0xffff, 0xffff, 0xffff, 0x4fea, 0xffff, 0x4feb, 0xceb2, 0xb9c5, 0xffff, 0x4fec, 0xb8a7,
    0xffff, 0xffff, 0xc8a3, 0xffff, 0xe2ed, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x4fed, 0xffff, 0xe2ef, 0xffff, 0x4fee, 0xffff,
    0xffff, 0xb8eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xe2ee, 0xc4f6, 0xffff, 0xffff, 0x4fef, 0xffff, 0xe2f1, 0xb3b7, 0xe2ec, 0x4ff0,
    0xffff, 0xc8ea, 0xffff, 0xb1b0, 0x4ff1, 0xbaec, 0xffff, 0xcfd2, 0x4ff2, 0xffff, 0xe2f0, 0xffff, 0xffff, 0x4ff4, 0x4ff5, 0x4ff6,
    0xffff, 0x4ff3, 0xffff, 0xe2f2, 0x4ff7, 0xffff, 0xffff, 0xcacb, 0x4ff8, 0xc0d9, 0xe2f4, 0xffff, 0x4ff9, 0x4ffa, 0xffff, 0xe2f5,
    0x4ffb, 0x4ffc, 0x4ffd, 0x4ffe, 0xffff, 0xe2f3, 0xffff, 0xffff, 0xffff, 0xffff, 0xb3ce, 0x50a1, 0xe2fb, 0x50a2, 0xe2fa, 0x50a3,
    0xffff, 0xbca7, 0xffff, 0xffff, 0xffff, 0xe2fc, 0xe2f7, 0x50a4, 0x50a5, 0x50a6, 0xe2fd, 0xe2f8, 0x50a7, 0xffff, 0x50a8, 0xffff,
    0xc8d8, 0xe2f6, 0x50a9, 0x50aa, 0xe2f9, 0x50ab, 0x50ac, 0xffff, 0xffff, 0xffff, 0xe3a2, 0x50ae, 0xffff, 0xffff, 0xffff, 0x50af,
    0x50b0, 0x50b1, 0xffff, 0xffff, 0x50ad, 0xffff, 0x50b2, 0xe3a1, 0xcbe1, 0xffff, 0x50b3, 0xffff, 0xe2fe, 0xffff, 0xffff, 0xb0eb,
    0xffff, 0xffff, 0x50b4, 0x50b5, 0xe3a4, 0xffff, 0x50b7, 0x50b8, 0xffff, 0xffff, 0x50b9, 0x50ba, 0xffff, 0xe3a3, 0xffff, 0x50bb,

    /* 0x79: 0x00 - 0xfc */
    0x50b6, 0xbecc, 0xffff, 0xffff, 0xffff, 0xffff, 0x50bc, 0xe3a5, 0xffff, 0xffff, 0xffff, 0xffff, 0x50bd, 0xffff, 0xc1c3, 0xffff,
    0x50be, 0xe3a7, 0xe3a6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe3a8, 0x50bf, 0xffff, 0x50c0, 0xffff, 0x50c1, 0x50c2,
    0x50c3, 0xffff, 0xffff, 0xffff, 0xffff, 0x50c4, 0xe2e8, 0x50c5, 0xffff, 0x50c6, 0xe2ea, 0xe3aa, 0xe3a9, 0x50c7, 0xffff, 0xffff,
    0xffff, 0x50c8, 0xffff, 0xffff, 0x50c9, 0x50ca, 0xffff, 0xffff, 0xffff, 0xffff, 0xbca8, 0x50cb, 0xcee9, 0x50cc, 0xbcd2, 0x50cd,
    0xe3ab, 0xb7b7, 0xffff, 0xffff, 0x50ce, 0x50cf, 0x50d0, 0xb5c0, 0xb5a7, 0xbbe3, 0x50d1, 0x50d2, 0xffff, 0xffff, 0xffff, 0x50d3,
    0xcdb4, 0x50d4, 0xffff, 0xe3b1, 0x50d5, 0xe3b0, 0xc1c4, 0xe3ad, 0x50d6, 0xffff, 0xe3af, 0x50d7, 0x50d8, 0xbdcb, 0xbfc0, 0xe3ae,
    0xe3ac, 0xffff, 0xc7aa, 0xffff, 0xffff, 0xbecd, 0xffff, 0x50d9, 0xc9bc, 0x50da, 0xffff, 0x50db, 0xffff, 0xbad7, 0xffff, 0xffff,
    0xffff, 0xffff, 0x50dc, 0xffff, 0xffff, 0xffff, 0xffff, 0xc5f8, 0xffff, 0x50dd, 0xe3b2, 0x50de, 0x50df, 0xffff, 0x50e0, 0xe3b3,
    0xe3c9, 0xb6d8, 0xffff, 0xffff, 0xcfbd, 0xc1b5, 0xffff, 0xffff, 0xffff, 0xffff, 0xe3b4, 0x50e1, 0x50e2, 0xb2d2, 0xc4f7, 0xcaa1,
    0xffff, 0x50e3, 0xffff, 0x50e4, 0x50e5, 0x50e6, 0x50e7, 0xffff, 0x50e8, 0xffff, 0xffff, 0x50e9, 0x50ea, 0xe3b5, 0xffff, 0xffff,
    0xffff, 0x50eb, 0xffff, 0xffff, 0xffff, 0xffff, 0xb5fa, 0xe3b6, 0x50ec, 0x50ed, 0xe3b8, 0x50ee, 0xffff, 0xffff, 0xe3b9, 0x50ef,
    0xc7a9, 0x50f0, 0xffff, 0xe3ba, 0x50f1, 0xffff, 0xffff, 0xffff, 0x50f2, 0xe3bb, 0xe3bc, 0x50f3, 0xffff, 0xb6d9, 0xb2d3, 0xc6c5,
    0xbda8, 0xbbe4, 0x50f4, 0xffff, 0x50f5, 0xffff, 0xffff, 0x50f6, 0x50f7, 0xe3bd, 0x50f8, 0xbda9, 0xffff, 0xffff, 0xffff, 0x50f9,
    0xffff, 0xb2ca, 0xc9c3, 0xffff, 0x50fa, 0xe3be, 0x50fb, 0xffff, 0xc8eb, 0xffff, 0x50fc, 0xffff, 0xffff, 0x50fd, 0x50fe, 0xc1c5,
    0x51a1, 0xe3c1, 0x51a2, 0xe3c2, 0xc7e9, 0x51a3, 0xbfc1, 0xe3bf, 0xffff, 0xc3e1, 0x51a4, 0x51a5, 0xe3c0, 0x51a6, 0xffff, 0xffff,
    0xbece, 0x51a7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x51a8, 0xffff, 0xffff, 0xb0dc, 0x51a9,

    /* 0x7a: 0x00 - 0xff */
    0xb5a9, 0xffff, 0x51aa, 0x51ab, 0xffff, 0xffff, 0xffff, 0x51ac, 0xe3c3, 0x51ad, 0x51ae, 0xc4f8, 0x51af, 0xe3c4, 0xc0c7, 0xffff,
    0xffff, 0x51b0, 0xffff, 0xffff, 0xccad, 0x51b1, 0xffff, 0xc9a3, 0xe3c5, 0xe3c6, 0xc3d5, 0x51b2, 0xcec7, 0xffff, 0x51b3, 0xe3c8,
    0xe3c7, 0x51b4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x51b5, 0xffff, 0xffff, 0xffff, 0x51b6, 0xffff, 0x51b7, 0xbcef, 0x51b8,
    0x51b9, 0xe3ca, 0xb0f0, 0xffff, 0x51ba, 0x51bb, 0xffff, 0xe3cd, 0x51bc, 0x51bd, 0x51be, 0xe3cb, 0xb2d4, 0xb7ce, 0xe3cc, 0xb9c6,
    0xb9f2, 0xffff, 0xcae6, 0xe3ce, 0x51bf, 0x51c0, 0xcbd4, 0x51c1, 0x51c2, 0xe3d0, 0xffff, 0xffff, 0x51c3, 0xc0d1, 0xb1cf, 0xb2ba,
    0xb0ac, 0xffff, 0xffff, 0xffff, 0xffff, 0x51c4, 0x51c5, 0xe3cf, 0xffff, 0x51c6, 0xffff, 0xffff, 0x51c7, 0x51c8, 0xffff, 0x51c9,
    0x51ca, 0xe3d1, 0xe3d2, 0xbef7, 0xffff, 0x51cb, 0xffff, 0x51cc, 0xffff, 0xe3d3, 0x51cd, 0xb3cf, 0xffff, 0x51ce, 0xffff, 0xffff,
    0xe3d5, 0xffff, 0xffff, 0xffff, 0xb7ea, 0x51cf, 0xb5e6, 0xffff, 0x51d0, 0xe3d6, 0xb6f5, 0xffff, 0xffff, 0xe3d7, 0x51d1, 0xc0fc,
    0x51d2, 0xc6cd, 0x51d3, 0xc0e0, 0xbaf5, 0x51d4, 0x51d5, 0xffff, 0xe3d8, 0xffff, 0x51d6, 0x51d7, 0xffff, 0xffff, 0xffff, 0xffff,
    0x51d8, 0x51d9, 0xc3e2, 0xc1eb, 0x51da, 0xe3da, 0xe3dc, 0xe3d9, 0xe3db, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x51db, 0xb7a2,
    0x51dc, 0xffff, 0xffff, 0x51dd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe3dd, 0xb7a6, 0xffff, 0x51de, 0xffff, 0xb5e7, 0xcdd2,
    0xe3df, 0xffff, 0xffff, 0x51df, 0xffff, 0x51e0, 0xe3e0, 0xffff, 0xffff, 0x51e1, 0xb1ae, 0x51e2, 0x51e3, 0xffff, 0xffff, 0xe3e3,
    0xffff, 0xffff, 0xffff, 0xb3f6, 0xe3e2, 0xe3e1, 0x51e4, 0xe3e5, 0xe3de, 0x51e5, 0xe3e6, 0xcea9, 0x51e6, 0xe3e7, 0x51e7, 0xe3e8,
    0xffff, 0x51e8, 0xd4f4, 0xe3ea, 0xffff, 0xe3e9, 0xffff, 0xffff, 0xffff, 0xe3eb, 0xe3ec, 0x51e9, 0xceb5, 0xe3ed, 0xffff, 0xf0ef,
    0xbecf, 0xe3ee, 0xe3ef, 0xbdd7, 0xffff, 0xc6b8, 0xe3f0, 0xffff, 0x51ea, 0x51eb, 0xc3a8, 0x51ec, 0x51ed, 0xe3f1, 0xffff, 0xc3bc,
    0xe3f2, 0x51ee, 0xffff, 0xffff, 0x51ef, 0xffff, 0xb6a5, 0xffff, 0xd1bf, 0xc3dd, 0xbcb3, 0x51f0, 0xffff, 0x51f1, 0x51f2, 0xb4c8,

    /* 0x7b: 0x02 - 0xfe */
                    0xe3f3, 0xffff, 0xe4a2, 0xffff, 0xe3f6, 0x51f3, 0xb5e8, 0xffff, 0xe3f5, 0xe4a4, 0xffff, 0xffff, 0xffff, 0xe3f4,
    0xffff, 0xbed0, 0xffff, 0xffff, 0x51f4, 0xffff, 0xffff, 0xffff, 0xe3f8, 0xe3f9, 0xffff, 0xc5ab, 0xffff, 0xffff, 0xe3fa, 0x51f5,
    0xb3de, 0xffff, 0xffff, 0x51f6, 0xffff, 0xbfda, 0xc9e4, 0x51f7, 0xe3fc, 0x51f8, 0x51f9, 0x51fa, 0xc2e8, 0x51fb, 0x51fc, 0x51fd,
    0x51fe, 0x52a1, 0xffff, 0xe3f7, 0x52a2, 0xe3fb, 0xe3fd, 0xffff, 0xffff, 0xbafb, 0xffff, 0xffff, 0xffff, 0x52a3, 0xffff, 0x52a4,
    0x52a5, 0x52a6, 0xffff, 0xffff, 0xffff, 0xe4a6, 0xc9ae, 0x52a7, 0xc8a6, 0xc5f9, 0xffff, 0xb6da, 0xe4a5, 0xe4a3, 0x52a8, 0xc8b5,
    0xe3fe, 0xc3de, 0xc5fb, 0xffff, 0xc5fa, 0x52a9, 0xbaf6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe4b8, 0xffff, 0xffff,
    0x52aa, 0xffff, 0xffff, 0xffff, 0x52ab, 0xe4a8, 0x52ac, 0xe4aa, 0xffff, 0x52ad, 0x52ae, 0xffff, 0xe4ad, 0x52af, 0xe4ae, 0x52b0,
    0xe4ab, 0xe4ac, 0x52b1, 0x52b2, 0xe4a9, 0xe4a7, 0xffff, 0x52b3, 0xffff, 0xffff, 0xe4a1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x52b4, 0xffff, 0xcacf, 0xb2d5, 0xffff, 0x52b5, 0xffff, 0xe4b5, 0xffff, 0xe4b2, 0x52b6, 0xe4b7,
    0x52b7, 0x52b8, 0xe4b6, 0xffff, 0xc7f3, 0xcca7, 0x52b9, 0xbbbb, 0xe4b0, 0xe4b9, 0xe4b4, 0x52ba, 0xe4b3, 0xe4af, 0x52bb, 0xe4b1,
    0x52bc, 0xb4c9, 0xffff, 0xffff, 0xffff, 0x52bd, 0xffff, 0xffff, 0xffff, 0xffff, 0xc3bd, 0xffff, 0x52be, 0xc0fd, 0xffff, 0x52bf,
    0x52c0, 0xc8a2, 0x52c1, 0xffff, 0xe4be, 0x52c2, 0x52c3, 0xffff, 0xc8a4, 0xffff, 0x52c4, 0x52c5, 0x52c6, 0x52c7, 0xffff, 0xffff,
    0xc0e1, 0xe4bb, 0x52c8, 0xffff, 0xc8cf, 0x52c9, 0xe4bf, 0xcad3, 0x52ca, 0xc3db, 0x52cb, 0xe4ba, 0xe4bc, 0xffff, 0xffff, 0xe4bd,
    0xffff, 0xffff, 0xffff, 0xffff, 0x52cc, 0xffff, 0x52cd, 0x52ce, 0xffff, 0x52cf, 0x52d0, 0x52d1, 0xffff, 0xe4c0, 0xffff, 0xffff,
    0xbcc4, 0xffff, 0xffff, 0xffff, 0xc6c6, 0xe4c5, 0xe4c4, 0xffff, 0x52d2, 0xe4c1, 0x52d3, 0xffff, 0xffff, 0xcfb6, 0xffff, 0xffff,
    0xffff, 0xffff, 0x52d4, 0xe4ca, 0x52d5, 0x52d6, 0xe4ce, 0xe4cb, 0x52d7, 0x52d8, 0x52d9, 0xffff, 0x52da, 0xffff, 0x52db,

    /* 0x7c: 0x00 - 0xfe */
    0xe4c7, 0x52dc, 0x52dd, 0x52de, 0x52df, 0xffff, 0x52e0, 0xe4c8, 0xffff, 0x52e1, 0xffff, 0x52e2, 0x52e3, 0xe4cd, 0x52e4, 0x52e5,
    0xffff, 0xe4c2, 0xd2d5, 0xe4c9, 0xe4c3, 0xffff, 0xffff, 0xe4cc, 0xffff, 0x52e6, 0xffff, 0x52e7, 0xffff, 0xffff, 0xffff, 0xe4d2,
    0x52e8, 0xb4ca, 0xffff, 0xe4cf, 0xffff, 0x52e9, 0x52ea, 0xe4d0, 0x52eb, 0xffff, 0xe4d1, 0xe4d4, 0x52ec, 0xffff, 0xffff, 0xffff,
    0xffff, 0x52ed, 0xffff, 0x52ee, 0x52ef, 0xffff, 0x52f0, 0xe4d3, 0xc8f6, 0x52f1, 0x52f2, 0xffff, 0xffff, 0xe4d5, 0xcefc, 0xcaed,
    0xe4da, 0xffff, 0xffff, 0xe4d7, 0xffff, 0xffff, 0x52f3, 0xffff, 0xffff, 0xffff, 0x52f4, 0xffff, 0xe4d6, 0xc0d2, 0xffff, 0xe4d9,
    0xe4db, 0x52f6, 0x52f7, 0x52f8, 0xe4d8, 0x52f5, 0xe4df, 0xffff, 0xe4dc, 0x52f9, 0x52fa, 0x52fb, 0x52fc, 0x52fd, 0x52fe, 0xe4dd,
    0xe4c6, 0x53a1, 0xffff, 0x53a2, 0xe4de, 0xe4e0, 0xffff, 0x53a3, 0xffff, 0x53a4, 0xffff, 0xffff, 0xe4e1, 0x53a5, 0x53a6, 0xffff,
    0x53a7, 0xffff, 0x53a8, 0xcac6, 0xffff, 0xe4e2, 0xffff, 0xffff, 0xffff, 0x53a9, 0xffff, 0xffff, 0x53aa, 0x53ab, 0xcce2, 0xffff,
    0xffff, 0xb6ce, 0xb7a9, 0xe4e3, 0xffff, 0xffff, 0x53ac, 0x53ad, 0xffff, 0xcab4, 0xffff, 0xbfe8, 0xffff, 0xccb0, 0xffff, 0x53ae,
    0xe4e4, 0xffff, 0xceb3, 0xffff, 0x53af, 0xc7f4, 0xffff, 0xc1c6, 0xc7b4, 0xffff, 0xffff, 0xbdcd, 0xffff, 0xffff, 0x53b0, 0xb0c0,
    0x53b1, 0xe4e9, 0xe4e7, 0xffff, 0xe4e5, 0xb4a1, 0x53b2, 0xbed1, 0xe4ea, 0xffff, 0xffff, 0xe4e8, 0xffff, 0xe4e6, 0xe4ee, 0xffff,
    0x53b3, 0xe4ed, 0xe4ec, 0xe4eb, 0xffff, 0xffff, 0x53b4, 0x53b5, 0xffff, 0xe4ef, 0x53b6, 0x53b7, 0x53b8, 0xe4f0, 0xc0ba, 0x53b9,
    0xe4f1, 0xffff, 0xe4f3, 0xffff, 0x53ba, 0xe4f2, 0xffff, 0x53bb, 0x53bc, 0x53bd, 0xb8d2, 0xffff, 0xffff, 0x53be, 0xc1b8, 0x53bf,
    0xffff, 0xffff, 0xe4f5, 0x53c0, 0x53c1, 0x53c2, 0xc5fc, 0x53c3, 0xe4f4, 0x53c4, 0x53c5, 0xffff, 0xe4f6, 0x53c6, 0xcab5, 0xc1ec,
    0xb9c7, 0xffff, 0xe4f7, 0xffff, 0xffff, 0xffff, 0x53c7, 0xcec8, 0xffff, 0x53c8, 0xffff, 0x53c9, 0xffff, 0xffff, 0xffff, 0xe4f9,
    0xffff, 0xffff, 0xe4fa, 0xffff, 0xe4fb, 0x53ca, 0xe4fc, 0xffff, 0xbbe5, 0xffff, 0xe4fd, 0xb7cf, 0xffff, 0xffff, 0xb5ea,

    /* 0x7d: 0x00 - 0xfb */
    0xb5aa, 0xffff, 0xe5a1, 0x53cb, 0xccf3, 0xb9c8, 0xe4fe, 0x53cc, 0x53cd, 0x53ce, 0xe5a4, 0xcce6, 0xffff, 0xc7bc, 0xffff, 0x53cf,
    0xc9b3, 0x53d0, 0x53d1, 0x53d2, 0xbde3, 0xe5a3, 0x53d3, 0xbcd3, 0xb9c9, 0xbbe6, 0xb5e9, 0xcab6, 0xe5a2, 0x53d4, 0x53d5, 0xffff,
    0xc1c7, 0xcbc2, 0xbaf7, 0x53d6, 0xffff, 0xffff, 0x53d7, 0xffff, 0xffff, 0xffff, 0x53d8, 0xbbe7, 0xc4dd, 0x53d9, 0xe5a7, 0xcedf,
    0xbad9, 0x53da, 0xe5a8, 0xbfc2, 0xffff, 0xe5aa, 0xffff, 0xffff, 0xffff, 0xbed2, 0xbab0, 0xffff, 0x53db, 0x53dc, 0x53dd, 0xe5a9,
    0x53de, 0x53df, 0xbdaa, 0xb8be, 0xc1c8, 0xe5a5, 0xe5ab, 0x53e0, 0x53e1, 0xffff, 0xffff, 0xe5a6, 0xb7d0, 0x53e2, 0xe5ae, 0xe5b2,
    0xb7eb, 0x53e3, 0xffff, 0x53e4, 0xffff, 0xffff, 0xe5ad, 0x53e5, 0xffff, 0x53e6, 0x53e7, 0xe5b6, 0x53e8, 0x53e9, 0xb9ca, 0xffff,
    0xffff, 0xcded, 0xb0bc, 0xe5b3, 0xffff, 0x53ea, 0xb5eb, 0x53eb, 0xe5b0, 0xffff, 0x53ec, 0xffff, 0xffff, 0xffff, 0xe5b1, 0xffff,
    0x53ed, 0xc5fd, 0xe5af, 0xe5ac, 0xffff, 0xb3a8, 0xc0e4, 0xffff, 0x53ee, 0xb8a8, 0x53ef, 0x53f0, 0xffff, 0xe5b8, 0xffff, 0x53f1,
    0xffff, 0x53f2, 0x53f3, 0x53f4, 0xffff, 0x53f5, 0x53f6, 0xffff, 0x53f7, 0xe5b5, 0xffff, 0x53f8, 0x53f9, 0x53fa, 0xffff, 0xe5b7,
    0xffff, 0x53fb, 0xffff, 0xe5b4, 0xffff, 0xffff, 0x53fc, 0x53fd, 0xffff, 0xb7d1, 0xc2b3, 0xe5b9, 0xc1ee, 0x53fe, 0x54a1, 0xe5c6,
    0xffff, 0xffff, 0xe5c2, 0xe5bc, 0xffff, 0xffff, 0x54a2, 0x54a3, 0xffff, 0xffff, 0x54a4, 0xe5c0, 0xbcfa, 0xb0dd, 0xe5bb, 0xe5c3,
    0xe5c7, 0xb9cb, 0xccd6, 0x54a5, 0xc4d6, 0xe5bd, 0x54a6, 0x54a7, 0xe5c5, 0x54a8, 0xe5ba, 0xc3be, 0xffff, 0xe5bf, 0xb0bd, 0xccca,
    0xffff, 0xffff, 0x54a9, 0x54aa, 0x54ab, 0x54ac, 0x54ad, 0xe5be, 0xffff, 0xffff, 0xb6db, 0xc8ec, 0x54ae, 0x54af, 0x54b0, 0xc1ed,
    0xffff, 0xced0, 0xbdef, 0xffff, 0xffff, 0xe5ee, 0xffff, 0x54b1, 0xe5c8, 0x54b2, 0xc0fe, 0xffff, 0xe5c4, 0xe5c9, 0xe5cb, 0xffff,
    0xc4f9, 0xe5ce, 0x54b4, 0xffff, 0xe5ca, 0x54b5, 0x54b6, 0xffff, 0xcad4, 0xb4cb, 0x54b7, 0x54b8, 0xcccb, 0x54b9, 0xffff, 0xb0de,
    0xffff, 0x54ba, 0xe5cd, 0xffff, 0xcefd, 0x54bb, 0x54bc, 0xffff, 0xffff, 0x54bd, 0x54be, 0xe5cc,

    /* 0x7e: 0x00 - 0x9e */
    0x54b3, 0xb1ef, 0xffff, 0xffff, 0xc6ec, 0xe5cf, 0xffff, 0xffff, 0x54bf, 0xe5d6, 0xe5d0, 0xe5d7, 0xffff, 0xffff, 0xffff, 0xffff,
    0x54c0, 0x54c1, 0xe5d3, 0xffff, 0xffff, 0x54c2, 0xffff, 0x54c3, 0xffff, 0xffff, 0xffff, 0xc7fb, 0x54c4, 0x54c5, 0xbcca, 0xe5d5,
    0x54c6, 0xe5d2, 0xe5d8, 0xe5d1, 0xffff, 0xffff, 0xbdc4, 0x54c7, 0x54c8, 0xffff, 0xffff, 0xcba5, 0x54c9, 0x54ca, 0xbdcc, 0x54cb,
    0xffff, 0xe5d4, 0xe5e0, 0x54cc, 0xffff, 0xe5dc, 0x54cd, 0xe5df, 0xffff, 0xe5dd, 0xe5e1, 0xe5db, 0xffff, 0xe5c1, 0xc0d3, 0x54ce,
    0xffff, 0xc8cb, 0xffff, 0xe5de, 0x54cf, 0x54d0, 0xe5d9, 0x54d1, 0xffff, 0xffff, 0xc1a1, 0xb7d2, 0xffff, 0xbdab, 0x54d2, 0xffff,
    0x54d3, 0xffff, 0x54d4, 0xffff, 0xbfa5, 0xc1b6, 0xe5e4, 0xffff, 0x54d5, 0xe5e6, 0xe5e7, 0xffff, 0xffff, 0xe5e3, 0xe5e5, 0x54d6,
    0xffff, 0x54d7, 0x54d8, 0xffff, 0xffff, 0x54d9, 0xe5da, 0xe5e2, 0xffff, 0xe5ea, 0xe5e9, 0x54da, 0xffff, 0xcbfa, 0x54db, 0x54dc,
    0xb7ab, 0xffff, 0xffff, 0x54dd, 0xffff, 0xffff, 0xffff, 0xffff, 0x54de, 0xe5e8, 0xffff, 0xe5ec, 0xe5eb, 0xe5ef, 0x54df, 0xe5f1,
    0xffff, 0x54e0, 0xbbbc, 0xe5ed, 0xffff, 0xffff, 0x54e1, 0x54e2, 0xe5f2, 0xe5f3, 0x54e3, 0xffff, 0xe5f4, 0x54e4, 0xe5fa, 0xc5bb,
    0xe5f6, 0x54e5, 0xe5f5, 0xe5f7, 0xe5f8, 0x54e6, 0xe5f9, 0xffff, 0x54e7, 0xffff, 0x54e8, 0xe5fb, 0xe5fc, 0x54e9, 0x54ea,

    /* 0x7f: 0x36 - 0xff */
                                                    0xb4cc, 0xffff, 0xe5fd, 0xffff, 0xe5fe, 0x54ec, 0x54eb, 0x54ed, 0x54ee, 0x54ef,
    0xffff, 0xffff, 0xffff, 0x54f0, 0x54f1, 0xe6a1, 0xffff, 0x54f2, 0xffff, 0xffff, 0xffff, 0xffff, 0xe6a2, 0xe6a3, 0xe6a4, 0x54f3,
    0xe6a5, 0xe6a6, 0x54f4, 0x54f5, 0xe6a8, 0xe6a7, 0xffff, 0xffff, 0xe6a9, 0xffff, 0xffff, 0x54f6, 0x54f7, 0x54f8, 0xffff, 0xe6aa,
    0xe6ab, 0x54f9, 0xffff, 0x54fa, 0x54fb, 0x54fc, 0x54fd, 0xe6ae, 0xe6ac, 0xe6ad, 0xbae1, 0xb7d3, 0xffff, 0x54fe, 0xc3d6, 0xffff,
    0xc8b3, 0x55a1, 0xbdf0, 0xffff, 0xffff, 0xc7cd, 0xffff, 0xc8ed, 0xe6af, 0xd8ed, 0xffff, 0xffff, 0xffff, 0x55a2, 0x55a3, 0x55a4,
    0x55a5, 0xffff, 0xe6b0, 0xe6b2, 0xffff, 0xcde5, 0xe6b1, 0xe6b4, 0xe6b3, 0xffff, 0xcdd3, 0x55a6, 0xe6b5, 0x55a7, 0xc8fe, 0x55a8,
    0x55a9, 0x55aa, 0xffff, 0xffff, 0xe6b6, 0xffff, 0x55ab, 0x55ac, 0xffff, 0xffff, 0xe6b9, 0xffff, 0x55ad, 0xe6b8, 0xe6b7, 0xffff,
    0xffff, 0x55ae, 0x55af, 0xe6ba, 0xb7b2, 0xffff, 0x55b0, 0xffff, 0xc1a2, 0xb5c1, 0x55b1, 0xffff, 0xffff, 0x55b2, 0xe6be, 0xe6bb,
    0xffff, 0xffff, 0xe6bc, 0xffff, 0x55b3, 0xffff, 0xe6bf, 0xffff, 0xe6c0, 0xe6bd, 0xffff, 0xffff, 0x55b4, 0xb1a9, 0xffff, 0x55b5,
    0x55b6, 0xb2a7, 0xffff, 0x55b7, 0xffff, 0xe6c2, 0xe6c3, 0xffff, 0x55b8, 0xffff, 0xe6c4, 0xffff, 0xcde2, 0xffff, 0x55b9, 0x55ba,
    0xffff, 0xffff, 0xbdac, 0xffff, 0xe6c6, 0xe6c5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x55bb, 0xffff, 0xffff, 0xffff, 0x55bc,
    0xbfe9, 0xe6c7, 0xffff, 0x55bd, 0xffff, 0x55be, 0xe6c8, 0xffff, 0x55bf, 0xe6c9, 0xffff, 0xb4e5, 0x55c0, 0xffff, 0x55c1, 0x55c2,
    0xb4cd, 0xffff, 0x55c3, 0xe6ca, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe6cb, 0x55c4, 0xcbdd, 0xcde3, 0x55c5, 0x55c6, 0x55c7,

    /* 0x80: 0x00 - 0xfe */
    0xcdd4, 0xcfb7, 0xffff, 0xb9cd, 0xe6ce, 0xbcd4, 0xe6cd, 0x55c8, 0x55c9, 0xffff, 0x55ca, 0xe6cf, 0xbca9, 0x55cb, 0x55cc, 0x55cd,
    0xc2d1, 0x55ce, 0xe6d0, 0x55cf, 0x55d0, 0xb9cc, 0x55d1, 0xccd7, 0xe6d1, 0xe6d2, 0xffff, 0xffff, 0xe6d3, 0x55d2, 0x55d3, 0x55d4,
    0x55d5, 0xe6d4, 0xffff, 0xffff, 0x55d6, 0xffff, 0x55d7, 0xffff, 0xe6d5, 0xffff, 0xffff, 0xffff, 0x55d8, 0xffff, 0x55d9, 0xffff,
    0x55da, 0xffff, 0xffff, 0xbcaa, 0x55db, 0x55dc, 0xcced, 0x55dd, 0xffff, 0x55de, 0x55df, 0xe6d7, 0x55e0, 0xc3bf, 0x55e1, 0xe6d6,
    0x55e2, 0xffff, 0xffff, 0xffff, 0x55e3, 0xffff, 0xe6d9, 0xffff, 0xffff, 0xffff, 0xe6d8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xe6da, 0xffff, 0xffff, 0xffff, 0xc0bb, 0xffff, 0xe6db, 0xffff, 0xe6dc, 0xffff, 0xffff, 0xffff, 0xcab9, 0xe6dd,
    0x55e4, 0xc1ef, 0xe6de, 0xffff, 0x55e5, 0xffff, 0x55e6, 0xffff, 0xe6df, 0xffff, 0xffff, 0xffff, 0xffff, 0x55e7, 0xffff, 0xcefe,
    0xe6e2, 0x55e8, 0xe6e1, 0xe6e0, 0xc4b0, 0x55e9, 0xe6e3, 0xbfa6, 0xffff, 0xe6e4, 0xffff, 0xffff, 0xffff, 0xe6e5, 0xcfb8, 0xe6e6,
    0xffff, 0x55ea, 0xffff, 0xffff, 0xe6e7, 0xe6e9, 0xe6e8, 0xc8a5, 0x55eb, 0xc6f9, 0xffff, 0xcfbe, 0xc8a9, 0xffff, 0x55ec, 0xffff,
    0xffff, 0xffff, 0xffff, 0xe6eb, 0xffff, 0xffff, 0xbed3, 0xffff, 0xc9aa, 0xffff, 0xe6ec, 0xe6ea, 0x55ed, 0xb4ce, 0x55ee, 0xffff,
    0xffff, 0xb8d4, 0xbbe8, 0xffff, 0xffff, 0xc8ee, 0x55ef, 0x55f0, 0xffff, 0xb8aa, 0xcbc3, 0x55f1, 0xe6ef, 0xe6ed, 0xffff, 0xb9ce,
    0xffff, 0xb9cf, 0xb0e9, 0xffff, 0xbae8, 0xffff, 0xffff, 0xffff, 0x55f2, 0x55f3, 0xc7d9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xb0df, 0xe6f4, 0xffff, 0xc3c0, 0xffff, 0x55f4, 0xffff, 0xffff, 0xffff, 0xc7d8, 0x55f5, 0xc2db, 0x55f6,
    0xffff, 0xffff, 0x55f7, 0xffff, 0x55f8, 0x55f9, 0xe6f6, 0x55fa, 0x55fb, 0xe6f2, 0xe6f5, 0xe6f0, 0xffff, 0xe6f3, 0xcba6, 0xffff,
    0x55fc, 0xb8d5, 0xffff, 0xffff, 0xb0fd, 0xe6f1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x55fd, 0x55fe, 0xe6f8,
    0x56a1, 0xe6f9, 0x56a2, 0x56a3, 0xc6b9, 0xffff, 0x56a4, 0xffff, 0xb6bb, 0x56a5, 0x56a6, 0xffff, 0xe7a6, 0xc7bd, 0x56a7,

    /* 0x81: 0x02 - 0xff */
                    0xbbe9, 0x56a8, 0xffff, 0xb6bc, 0xc0c8, 0xcfc6, 0xccae, 0xe6f7, 0xc0d4, 0x56a9, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x56aa, 0x56ab, 0x56ac, 0xffff, 0xb5d3, 0xe6fa, 0x56ad, 0xffff, 0x56ae, 0xffff,
    0x56af, 0xffff, 0xffff, 0xe6fc, 0x56b0, 0xffff, 0xffff, 0x56b1, 0xffff, 0xe6fb, 0xffff, 0xffff, 0x56b2, 0xffff, 0xffff, 0xe6fd,
    0x56b3, 0xc3a6, 0xffff, 0xc7be, 0xffff, 0x56b4, 0xffff, 0xffff, 0xffff, 0xc4b1, 0x56b5, 0xffff, 0x56b6, 0xffff, 0xe7a3, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x56b7, 0xe7a2, 0x56b8, 0xffff, 0xffff, 0x56b9, 0xe6fe, 0x56ba, 0xffff, 0xbfd5, 0xffff,
    0xc9e5, 0xe7a5, 0x56bb, 0xe7a4, 0xb9d0, 0xcfd3, 0xffff, 0x56bc, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe7b5,
    0x56bd, 0x56be, 0xffff, 0xffff, 0xffff, 0xe7a9, 0xe7aa, 0x56bf, 0x56c0, 0x56c1, 0xffff, 0xbcf0, 0xffff, 0x56c2, 0xe7a8, 0x56c3,
    0xb9f8, 0xe7a7, 0xffff, 0xffff, 0xe7ab, 0xffff, 0xffff, 0x56c4, 0xc4b2, 0xcaa2, 0xc1a3, 0xffff, 0xffff, 0xffff, 0xffff, 0xc2dc,
    0xe7af, 0x56c5, 0xe7b0, 0xe7ac, 0x56c7, 0x56c8, 0x56c9, 0xffff, 0xe7ad, 0xffff, 0xe7ae, 0x56ca, 0xffff, 0xffff, 0x56cb, 0xb9d1,
    0x56c6, 0xffff, 0xffff, 0xe7b6, 0xffff, 0xe7b2, 0x56cc, 0xffff, 0x56cd, 0xffff, 0xc9e6, 0x56ce, 0xcbec, 0xc9a8, 0x56cf, 0xffff,
    0xe7b1, 0xffff, 0x56d0, 0xe7b4, 0xe7b3, 0xffff, 0xffff, 0xffff, 0xcbc4, 0xe7b7, 0xffff, 0xffff, 0xffff, 0xffff, 0x56d1, 0xffff,
    0xe7b8, 0xffff, 0x56d2, 0xc1b7, 0x56d3, 0xe7b9, 0xffff, 0xffff, 0xe7bb, 0xffff, 0xe7bf, 0x56d4, 0xffff, 0xe7bc, 0xe7ba, 0xc7bf,
    0xe7bd, 0xffff, 0xe7be, 0x56d6, 0xffff, 0x56d7, 0xb2b2, 0xffff, 0xe7c5, 0xe7c0, 0x56d8, 0x56d5, 0xffff, 0xe7c1, 0x56d9, 0x56da,
    0xffff, 0xe7c2, 0xffff, 0xc2a1, 0xffff, 0x56db, 0xffff, 0x56dc, 0xe7c4, 0xe7c3, 0xe7c6, 0x56dd, 0xffff, 0x56de, 0x56df, 0xe7c7,
    0xe7c8, 0x56e0, 0xffff, 0xbfc3, 0x56e1, 0xb2e9, 0xffff, 0xe7c9, 0xced7, 0xffff, 0xbcab, 0x56e2, 0x56e3, 0xbdad, 0xffff, 0xffff,
    0x56e4, 0x56e5, 0x56e6, 0xbbea, 0xc3d7, 0x56e7, 0x56e8, 0xffff, 0x56e9, 0x56ea, 0xe7ca, 0xe7cb, 0xb1b1, 0x56eb, 0xe7cc, 0x56ec,

    /* 0x82: 0x00 - 0xfe */
    0x56ed, 0xe7cd, 0xe7ce, 0x56ee, 0xffff, 0xe7cf, 0xffff, 0xe7d0, 0xb6bd, 0xdaaa, 0xe7d1, 0xffff, 0xc0e5, 0xe7d2, 0xbccb, 0x56ef,
    0xe7d3, 0xffff, 0xd0b0, 0x56f0, 0x56f1, 0xffff, 0xe7d4, 0xcade, 0xb4dc, 0x56f2, 0x56f3, 0xc1a4, 0xbdd8, 0x56f4, 0xc9f1, 0xbdae,
    0xffff, 0x56f5, 0x56f6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x56f7, 0xe7d5, 0xb9d2, 0xe7d6, 0xc8cc, 0xffff, 0xe7e4, 0xffff,
    0xffff, 0xffff, 0x56f8, 0xe7d8, 0x56f9, 0xc2c9, 0xc7f5, 0xb8bf, 0xe7d7, 0xc1a5, 0x56fa, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xe7d9, 0xffff, 0xffff, 0x56fb, 0x56fc, 0x56fd, 0x56fe, 0xc4fa, 0xffff, 0xffff, 0xffff, 0x57a1, 0xffff, 0xffff, 0x57a2, 0x57a3,
    0xffff, 0x57a4, 0xffff, 0xffff, 0xffff, 0xffff, 0x57a5, 0xffff, 0xe7db, 0xe7da, 0xe7dd, 0xffff, 0x57a6, 0xe7dc, 0xffff, 0xe7de,
    0x57a7, 0xffff, 0xe7e0, 0x57a8, 0xe7df, 0xffff, 0xb4cf, 0x57a9, 0xe7e1, 0xffff, 0xe7e2, 0xe7e3, 0xffff, 0x57aa, 0xbab1, 0xcec9,
    0xffff, 0xe7e5, 0xbfa7, 0xffff, 0x57ab, 0xffff, 0xb1f0, 0xe7e6, 0xe7e7, 0xffff, 0xffff, 0x57ac, 0xffff, 0x57ad, 0xe7e8, 0x57ae,
    0x57af, 0x57b0, 0xffff, 0x57b1, 0x57b2, 0xffff, 0xffff, 0x57b3, 0xffff, 0x57b4, 0x57b5, 0xb0f2, 0xffff, 0xe7e9, 0x57b6, 0xffff,
    0xffff, 0x57b7, 0xe7ea, 0xffff, 0x57b8, 0xffff, 0x57b9, 0xffff, 0x57ba, 0xc9e7, 0x57bb, 0x57bc, 0xffff, 0xbcc7, 0xffff, 0xe7ec,
    0x57bd, 0x57be, 0xffff, 0x57bf, 0x57c0, 0xb3a9, 0xb0b2, 0x57c1, 0x57c2, 0x57c3, 0x57c4, 0xe7eb, 0xe7ee, 0xc7ce, 0x57c5, 0xbfc4,
    0x57c6, 0xb2d6, 0x57c7, 0xcba7, 0x57c8, 0xffff, 0xffff, 0x57c9, 0xb7dd, 0xb6dc, 0x57ca, 0xe7ed, 0x57cb, 0xb2ea, 0x57cc, 0x57cd,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb4a3, 0x57ce, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x57cf, 0xb1f1, 0xe7f2, 0xceea, 0xc2dd, 0x57d0, 0xffff, 0xc9c4, 0xffff, 0xe7fe, 0x57d1, 0xb2d7, 0xe7fc, 0xffff, 0xe7fa, 0xe7f1,
    0x57d2, 0xe7ef, 0x57d3, 0xe7f0, 0x57d4, 0xbce3, 0xb6ec, 0xc3f7, 0x57d5, 0xffff, 0x57d6, 0xc6d1, 0xffff, 0x57d7, 0xffff, 0x57d8,
    0xffff, 0xb1d1, 0xffff, 0xe7f4, 0xe7f3, 0xffff, 0x57d9, 0x57da, 0xffff, 0xe7f9, 0xe7f5, 0xe7f8, 0xffff, 0x57db, 0x57dc,

    /* 0x83: 0x00 - 0xfd */
    0x57dd, 0x57de, 0xccd0, 0xe7f7, 0xb2d8, 0xb3fd, 0xe7fb, 0x57df, 0x57e0, 0xe7fd, 0x57e1, 0x57e2, 0xffff, 0xffff, 0xb7d4, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe8a3, 0xe8ac, 0xe8ad, 0xffff, 0xffff, 0x57e4, 0xb0ab, 0x57e5, 0x57e6, 0x57e7,
    0xffff, 0x57e8, 0x57e9, 0xe8b4, 0xffff, 0xffff, 0xffff, 0xffff, 0xb0f1, 0xffff, 0xffff, 0xe8ab, 0x57ea, 0x57eb, 0x57ec, 0xe8aa,
    0x57ed, 0xe8a5, 0xe8a4, 0x57ee, 0xe8a2, 0xe8a1, 0xc3e3, 0x57ef, 0xc2fb, 0xe8a7, 0x57f0, 0xffff, 0x57f1, 0x57f2, 0xffff, 0xffff,
    0xe8a6, 0xffff, 0x57f3, 0x57f4, 0x57f5, 0xe8a9, 0xffff, 0x57f6, 0xffff, 0xc1f0, 0xb7d5, 0xffff, 0xffff, 0x57f7, 0x57f8, 0xb1c1,
    0xe8a8, 0x57f9, 0xb9d3, 0x58be, 0x57e3, 0x57fa, 0x57fb, 0x57fc, 0xc1f1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x57fd, 0xffff, 0xffff, 0xe8ba, 0xffff, 0xe8bb, 0xffff, 0xb2d9, 0x57fe, 0xffff, 0xffff, 0xb2ae, 0xe8b8, 0x58a1, 0xffff, 0x58a2,
    0x58a3, 0xffff, 0x58a4, 0xffff, 0x58a5, 0xe8ae, 0x58a6, 0xe8b6, 0xffff, 0xe8bd, 0xe8b7, 0xffff, 0xffff, 0x58a7, 0xe8b5, 0xffff,
    0xffff, 0xffff, 0x58a8, 0xe7f6, 0x58a9, 0x58aa, 0xe8b3, 0xffff, 0x58ab, 0x58ac, 0xe8af, 0x58ad, 0x58ae, 0x58af, 0xb4d0, 0xe8b1,
    0xe8bc, 0xffff, 0xe8b2, 0xffff, 0xffff, 0xffff, 0x58b0, 0x58b1, 0xe8be, 0x58b2, 0xe8b0, 0xc7fc, 0x58b3, 0x58cc, 0xffff, 0xffff,
    0xffff, 0xcde9, 0xffff, 0xffff, 0xffff, 0xe8b9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe8cf, 0x58b4, 0x58b5,
    0x58b6, 0xe8c7, 0xffff, 0xffff, 0xffff, 0xbffb, 0xffff, 0x58b7, 0xffff, 0x58b8, 0xb5c6, 0xffff, 0xb6dd, 0xffff, 0xe8c2, 0x58b9,
    0x58ba, 0x58bb, 0xffff, 0xb2db, 0x58bc, 0xffff, 0xbed4, 0xffff, 0xe8c5, 0xffff, 0xffff, 0xffff, 0xbada, 0x58bd, 0xffff, 0xc5d1,
    0xe8ca, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x58bf, 0xcaee, 0x58c0, 0xe8c1, 0xffff, 0xffff, 0xffff, 0xb2da,
    0xb8d6, 0xc9a9, 0xe8cb, 0xffff, 0xe8bf, 0xffff, 0x58c1, 0xe8c8, 0x58c2, 0x58c3, 0xffff, 0xe8d2, 0x58c4, 0xe8c3,

    /* 0x84: 0x01 - 0xff */
            0x58c5, 0xffff, 0xe8c4, 0xc6ba, 0xffff, 0x58c6, 0xe8c9, 0xffff, 0xffff, 0x58c7, 0xe8c6, 0xcba8, 0xe8cc, 0xb0e0, 0x58c8,
    0xffff, 0x58c9, 0xffff, 0xe8c0, 0xffff, 0x58ca, 0xffff, 0xffff, 0xffff, 0x58cb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xe8ce, 0xffff, 0xe8cd, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc7eb, 0xe8d4, 0xffff, 0xe8df, 0xffff, 0xffff, 0x58cd,
    0xffff, 0xb3fe, 0xffff, 0xffff, 0xffff, 0xe8e2, 0xffff, 0xffff, 0xe8d0, 0x58ce, 0xffff, 0xffff, 0xe8d5, 0xcdee, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x58cf, 0xe8de, 0x58d0, 0x58d1, 0xcdd5, 0x58d2, 0xffff, 0xffff, 0x58d3, 0xceaa, 0x58d4,
    0xffff, 0x58d5, 0x58d6, 0xffff, 0xffff, 0xffff, 0x58d7, 0xc3f8, 0x58d8, 0x58d9, 0x58da, 0xb3eb, 0x58db, 0xffff, 0xffff, 0xffff,
    0x58dc, 0xc9f2, 0xe8e4, 0xc6a1, 0x58dd, 0x58de, 0xb0b1, 0x58df, 0xffff, 0xe8dd, 0x58e0, 0xe8d9, 0xc1f2, 0xe8d3, 0xe8db, 0xe8e0,
    0x58e1, 0xc7ac, 0xffff, 0x58e2, 0x58e3, 0xb0aa, 0x58e4, 0xe8d8, 0x58e5, 0xe8e1, 0xc9f8, 0xffff, 0x58e6, 0x58e7, 0xffff, 0xffff,
    0xffff, 0x58e8, 0xe8dc, 0xffff, 0xe8d7, 0x58e9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbed5, 0xffff, 0xffff, 0xffff, 0xffff,
    0xbdaf, 0xffff, 0x58ea, 0x58eb, 0xbcac, 0x58ec, 0xffff, 0xffff, 0xffff, 0xccd8, 0xffff, 0xffff, 0xc9c7, 0xffff, 0x58ed, 0xe8e7,
    0xffff, 0xe8f0, 0xffff, 0xffff, 0xffff, 0xffff, 0x58ee, 0xffff, 0x58ef, 0x58f0, 0x58f1, 0xffff, 0xffff, 0xe8da, 0xffff, 0x58f2,
    0xffff, 0x58f3, 0xb3f7, 0xffff, 0x58f4, 0xffff, 0xffff, 0xffff, 0xbef8, 0xe8e5, 0x58f5, 0xe8ea, 0xc1f3, 0x58f6, 0x58f7, 0xe8e6,
    0x58f8, 0xe8ed, 0x58f9, 0xffff, 0xc3df, 0xffff, 0xe8ee, 0x58fa, 0x58fb, 0xcdd6, 0xe8e3, 0xb3b8, 0x58fc, 0xe8e9, 0xffff, 0x58fd,
    0xe8ec, 0xccac, 0xffff, 0x58fe, 0xffff, 0xffff, 0xe8ef, 0xffff, 0xffff, 0xe8e8, 0xe8eb, 0xffff, 0x59a1, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x59a2, 0xffff, 0xffff, 0x59a3, 0xffff, 0xcba9, 0xffff, 0xcfa1, 0x59a4,
    0x59a5, 0x59a6, 0x59a7, 0xffff, 0xe8f3, 0xffff, 0xffff, 0x59a8, 0xffff, 0xffff, 0x59aa, 0x59ab, 0xe8fa, 0x59ac, 0xffff, 0xe8f2,

    /* 0x85: 0x00 - 0xff */
    0xbcc3, 0xffff, 0x59ad, 0x59ae, 0xffff, 0xffff, 0xe8d1, 0x59af, 0xffff, 0xffff, 0xffff, 0xffff, 0x59b0, 0xffff, 0x59b1, 0xffff,
    0x59b2, 0xcace, 0xffff, 0xcca2, 0xe8f9, 0xe8f8, 0xffff, 0xe8f4, 0xe8f5, 0xffff, 0xb1b6, 0xffff, 0x59b3, 0xffff, 0x59b4, 0xe8f7,
    0xffff, 0xe8f1, 0x59b5, 0x59b6, 0x59b7, 0x59b8, 0xc4d5, 0x59b9, 0xffff, 0xffff, 0x59ba, 0x59bb, 0xe8f6, 0xb0fe, 0xffff, 0x59bc,
    0xffff, 0xffff, 0x59a9, 0x59bd, 0x59be, 0xc2a2, 0x59bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xcac3, 0xffff, 0x59c0,
    0xe8fb, 0xe9a1, 0xffff, 0xc8d9, 0xffff, 0xffff, 0x59c1, 0xffff, 0xe8fe, 0xbed6, 0xbcc9, 0xe9a3, 0xffff, 0xffff, 0xb6be, 0x59c2,
    0x59c3, 0x59c4, 0x59c5, 0x59c6, 0xffff, 0xe9a4, 0x59c7, 0xc9f9, 0xe8fd, 0x59c8, 0xe8d6, 0xffff, 0x59c9, 0x59ca, 0x59cb, 0x59cc,
    0x59cd, 0x59ce, 0x59cf, 0xe8fc, 0x59d0, 0xffff, 0xffff, 0xffff, 0xcfcf, 0xc6a2, 0xc9f3, 0x59d1, 0xffff, 0xe9ab, 0xffff, 0x59d2,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe9b1, 0xffff, 0x59d3, 0x59d4, 0x59d5, 0xffff, 0x59d6, 0xe9b2, 0x59d7,
    0xe9a5, 0x59d8, 0xffff, 0xffff, 0xc7f6, 0x59d9, 0x59da, 0xe9af, 0xe9a7, 0x59db, 0xe9a9, 0x59dc, 0x59dd, 0xffff, 0xffff, 0x59de,
    0xe9b3, 0xe9a8, 0xffff, 0x59df, 0xe9ac, 0xffff, 0xffff, 0xb1f2, 0x59e0, 0xc6e5, 0xffff, 0xe9ad, 0xe9b0, 0x59e1, 0xffff, 0x59e2,
    0x59e3, 0xffff, 0x59e4, 0xffff, 0xe9a6, 0x59e5, 0xc1a6, 0x59e6, 0xe9aa, 0xbba7, 0xbfc5, 0xb7b0, 0xccf4, 0x59f4, 0xccf9, 0xbdf2,
    0xffff, 0xffff, 0xffff, 0xffff, 0x59e7, 0xffff, 0x59e8, 0x59e9, 0x59ea, 0xe9b7, 0xe9b5, 0xffff, 0x59eb, 0x59ec, 0x59ed, 0x59ee,
    0xffff, 0xcfce, 0x59ef, 0xffff, 0xffff, 0xffff, 0xffff, 0x59f0, 0xffff, 0xe9b4, 0x59f1, 0x59f2, 0xffff, 0xcdf5, 0x59f3, 0xe9b6,
    0xe9b8, 0xffff, 0xffff, 0xffff, 0xffff, 0xe9b9, 0xffff, 0xffff, 0x59f5, 0xffff, 0x59f6, 0xffff, 0xe9bc, 0xe9ba, 0xffff, 0x59f7,
    0x59f8, 0xffff, 0xffff, 0xffff, 0xc6a3, 0xe9bb, 0x59f9, 0xffff, 0x59fa, 0xc8cd, 0xe9ae, 0xffff, 0xffff, 0x59fb, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x59fc, 0xffff, 0xffff, 0x59fd, 0xbdf3, 0xffff, 0xe9bd, 0xe9c2, 0xc1f4, 0x59fe, 0xffff, 0xe9c1, 0x5aa1,

    /* 0x86: 0x00 - 0xfe */
    0x5aa2, 0xffff, 0xe9a2, 0xffff, 0x5aa3, 0x5aa4, 0xe9c3, 0xc1c9, 0xffff, 0xffff, 0xe9be, 0xe9c0, 0xffff, 0x5aa5, 0x5aa6, 0xffff,
    0x5aa7, 0x5aa8, 0x5aa9, 0xe9bf, 0xffff, 0xffff, 0xddb1, 0xdda2, 0x5aaa, 0x5aab, 0xe9c5, 0x5aac, 0xffff, 0xffff, 0x5aad, 0xffff,
    0xffff, 0x5aae, 0xe9c4, 0xffff, 0xffff, 0xffff, 0xffff, 0x5aaf, 0xffff, 0x5ab0, 0xffff, 0xffff, 0xffff, 0xcdf6, 0xffff, 0xe2bc,
    0xe9c6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5ab1, 0xffff, 0x5ab2, 0xffff, 0x5ab3, 0xffff, 0x5ab4, 0x5ab5, 0xffff, 0xe9c7,
    0x5ab6, 0x38e6, 0x5ab7, 0xffff, 0xffff, 0xffff, 0x5ab8, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xe9c8, 0xb8d7, 0xffff,
    0xb5d4, 0xffff, 0x5ab9, 0x5aba, 0xe9ca, 0xd1dd, 0x5abb, 0x5abc, 0x5abd, 0x5abe, 0xb5f5, 0xffff, 0xceba, 0x5abf, 0xb6f3, 0xe9cb,
    0x5ac0, 0x5ac1, 0x5ac2, 0x5ac3, 0x5ac4, 0xffff, 0xffff, 0xe9cc, 0xffff, 0x5ac5, 0xffff, 0xc3ee, 0x5ac6, 0xffff, 0xffff, 0x5ac7,
    0xffff, 0xe9cd, 0xffff, 0xffff, 0xffff, 0x5ac8, 0x5ac9, 0x5aca, 0xffff, 0xc6fa, 0x5acb, 0xb0ba, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5aed, 0xffff, 0xb2e3, 0xe9d2, 0xe9d3, 0x5acc, 0xffff, 0xffff,
    0xffff, 0x5acd, 0xffff, 0xe9ce, 0xffff, 0xbbbd, 0x5ace, 0xffff, 0x5acf, 0xffff, 0x5ad0, 0xffff, 0x5ad1, 0xffff, 0xffff, 0xffff,
    0xffff, 0x5ad2, 0xffff, 0xe9cf, 0xc7c2, 0xffff, 0x5ad3, 0x5ad4, 0x5ad5, 0xe9d0, 0xe9d1, 0xe9db, 0xffff, 0x5ad6, 0xffff, 0xe9d5,
    0xe9d8, 0x5ad7, 0xffff, 0x5ad8, 0x5ad9, 0x5ada, 0xe9d4, 0x5adb, 0x5adc, 0x5add, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5ade,
    0x5adf, 0x5ae0, 0xffff, 0x5ae1, 0xe9d6, 0x5ae2, 0xe9d7, 0xbcd8, 0xffff, 0xe9d9, 0xffff, 0xc3c1, 0xffff, 0xb7d6, 0xb3c2, 0xffff,
    0xffff, 0x5ae3, 0x5ae4, 0xffff, 0xe9dc, 0x5ae5, 0xffff, 0x5ae6, 0xffff, 0xb3bf, 0x5ae7, 0xe9e1, 0x5ae8, 0xffff, 0xe9dd, 0xe9e0,
    0x5ae9, 0xffff, 0xffff, 0x5aea, 0xc8ba, 0x5aeb, 0xffff, 0x5aec, 0xffff, 0xe9de, 0xffff, 0xffff, 0xe9df, 0xc9c8, 0xc8da, 0xe9e2,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc2fd, 0xe9ec, 0x5aee, 0xe9e8, 0x5aef, 0x5af0, 0xb2eb,

    /* 0x87: 0x00 - 0xff */
    0xe9e6, 0xffff, 0xcbaa, 0xe9e7, 0x5af1, 0x5af2, 0xe9e4, 0x5af3, 0xe9e5, 0xe9ea, 0xe9ed, 0x5af4, 0xffff, 0xe9eb, 0x5af5, 0x5af6,
    0x5af7, 0xe9e9, 0xe9e3, 0x5af8, 0x5af9, 0xffff, 0xffff, 0xffff, 0xc3d8, 0x5afa, 0xe9f4, 0xffff, 0xccaa, 0xffff, 0x5afb, 0x5afc,
    0xffff, 0x5afd, 0xffff, 0x5afe, 0xffff, 0xe9f2, 0xffff, 0xffff, 0x5ba1, 0xe9f3, 0xffff, 0xffff, 0xffff, 0xffff, 0x5ba2, 0x5ba3,
    0xffff, 0x5ba4, 0x5ba5, 0xffff, 0xe9ee, 0xffff, 0xffff, 0xe9f0, 0xffff, 0x5ba6, 0x5ba7, 0xe9f1, 0x5ba8, 0x5ba9, 0x5baa, 0xe9ef,
    0x5bab, 0xffff, 0xffff, 0x5bac, 0xffff, 0x5bad, 0xffff, 0xffff, 0xffff, 0xc0e6, 0xffff, 0xcfb9, 0xe9f8, 0x5bae, 0xe9f9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xeaa1, 0xffff, 0xbfaa, 0xffff, 0xe9fb, 0x5baf, 0xe9fe, 0xffff, 0xffff, 0xffff, 0x5bb0, 0xffff, 0xe9f6,
    0xe9f5, 0x5bb1, 0xffff, 0xeaa2, 0x5bb2, 0x5bb3, 0xb2dc, 0xffff, 0xe9fc, 0xffff, 0xeaa3, 0xffff, 0xffff, 0xffff, 0xe9fd, 0x5bb4,
    0xffff, 0x5bb5, 0x5bb6, 0xffff, 0xe9fa, 0xffff, 0xc4b3, 0xffff, 0xe9f7, 0xffff, 0xffff, 0x5bb7, 0xffff, 0xffff, 0xffff, 0xc7e8,
    0xffff, 0xffff, 0xeaa7, 0x5bb8, 0x5bb9, 0x5bba, 0x5bbb, 0x5bbc, 0x5bbd, 0x5bbe, 0xffff, 0x5bbf, 0x5bc0, 0xcdbb, 0xffff, 0xffff,
    0x5bc1, 0xffff, 0xffff, 0x5bc2, 0xffff, 0x5bc3, 0xffff, 0x5bc4, 0x5bc5, 0x5bc6, 0xffff, 0xffff, 0xffff, 0xffff, 0x5bc7, 0xeaa6,
    0x5bc8, 0xffff, 0xeaa5, 0x5bc9, 0xffff, 0xffff, 0xffff, 0x5bca, 0xffff, 0xffff, 0xffff, 0xeaae, 0x5bcb, 0x5bcc, 0x5bcd, 0xeaa8,
    0xffff, 0x5bce, 0xffff, 0xeab0, 0xffff, 0x5bcf, 0xffff, 0xffff, 0xffff, 0xffff, 0xcde6, 0xeab3, 0xffff, 0xeaaa, 0x5bd0, 0x5bd1,
    0xeaab, 0x5bd2, 0xffff, 0xffff, 0xeaaf, 0xffff, 0xeab2, 0xeab1, 0x5bd3, 0x5bd4, 0x5bd5, 0xeaa9, 0xffff, 0xffff, 0x5bd6, 0xffff,
    0xeaac, 0xffff, 0xeabd, 0xffff, 0xffff, 0x5bd7, 0x5bd8, 0xffff, 0xffff, 0x5bd9, 0x5bda, 0xffff, 0x5bdb, 0xffff, 0xffff, 0x5bdc,
    0xeab6, 0xffff, 0x5bdd, 0x5bde, 0x5bdf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5be0, 0x5be1, 0xffff, 0x5be2, 0xffff, 0xeab4,
    0xffff, 0x5be3, 0xeab5, 0x5be4, 0xffff, 0xffff, 0xeaba, 0xeabb, 0x5be5, 0xb3aa, 0x5be6, 0xb5c2, 0xffff, 0xffff, 0xeab9, 0x5be7,

#ifdef split_unicode
};

#define split_unicode_offset 239 /* 0x4000 - 16145 */

static const uint16_t __euc_jp_unicode_codes_second[] = {
#endif

    /* 0x88: 0x01 - 0xfe */
            0x5be8, 0xffff, 0x5be9, 0xffff, 0xeaa4, 0x5bea, 0xffff, 0xffff, 0x5beb, 0x5bec, 0x5bed, 0xffff, 0xeab8, 0xeabc, 0xeab7,
    0x5bee, 0xeabe, 0x5bf0, 0x5bf1, 0x5bf2, 0xeac0, 0xeabf, 0xffff, 0x5bf3, 0x5bef, 0x5bf4, 0x5bf5, 0x5bf6, 0xffff, 0x5bf7, 0x5bf8,
    0xffff, 0xeac2, 0xeac1, 0xe9da, 0xffff, 0xffff, 0xffff, 0xeac6, 0x5bf9, 0xffff, 0xffff, 0xffff, 0xffff, 0x5bfa, 0x5bfb, 0xffff,
    0x5bfc, 0xeac3, 0x5bfd, 0xffff, 0xffff, 0x5bfe, 0xeac4, 0xffff, 0xffff, 0xeac5, 0x5ca1, 0xeac7, 0x5ca2, 0xffff, 0xffff, 0xffff,
    0xb7ec, 0x5ca3, 0xeac9, 0x5ca4, 0xeac8, 0x5ca5, 0xbdb0, 0xffff, 0x5ca6, 0x5ca7, 0x5ca8, 0x5ca9, 0xb9d4, 0xdea7, 0x5caa, 0xffff,
    0xffff, 0x5cab, 0xeaca, 0xbdd1, 0xffff, 0x5cac, 0x5cad, 0xb3b9, 0x5cae, 0xeacb, 0x5caf, 0xb1d2, 0x5cb0, 0xbed7, 0xeacc, 0x5cb1,
    0x5cb2, 0xb9d5, 0xeacd, 0xb0e1, 0x5cb3, 0xffff, 0xffff, 0xffff, 0xc9bd, 0x5cb4, 0xffff, 0xeace, 0xffff, 0xffff, 0xffff, 0xffff,
    0xbfea, 0x5cb5, 0xead5, 0xffff, 0xffff, 0xead2, 0xffff, 0xc3ef, 0xffff, 0x5cb6, 0xffff, 0x5cb7, 0xffff, 0xead3, 0xead0, 0xb6de,
    0x5cb8, 0xeacf, 0xead6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb7b6, 0xffff, 0xffff, 0xc2de, 0xffff, 0xeadc, 0xffff, 0xffff,
    0xffff, 0xffff, 0xead8, 0xffff, 0xffff, 0xffff, 0xc2b5, 0xead7, 0x5cb9, 0xeada, 0x5cba, 0x5cbb, 0x5cbc, 0xffff, 0xead1, 0x5cbd,
    0x5cbe, 0xffff, 0xeadb, 0xffff, 0xeadd, 0xffff, 0xffff, 0xffff, 0x5cbf, 0xffff, 0x5cc0, 0xc8ef, 0xffff, 0xffff, 0xead9, 0xffff,
    0xeade, 0xeae0, 0xffff, 0xffff, 0xb8d3, 0xead4, 0xffff, 0xb0c1, 0xffff, 0xffff, 0x5cc1, 0xffff, 0xffff, 0x5cc2, 0x5cc3, 0xeadf,
    0x5cc4, 0xbadb, 0xcef6, 0xeae1, 0xeae2, 0xc1f5, 0xffff, 0xffff, 0xffff, 0xffff, 0x5cc5, 0x5cc6, 0x5cc7, 0x5cc8, 0x5cc9, 0xcea2,
    0xffff, 0x5cca, 0x5ccb, 0x5ccc, 0xeae3, 0xcdb5, 0xffff, 0xffff, 0xeae4, 0xeae5, 0xffff, 0x5ccd, 0xcae4, 0xeae6, 0x5cce, 0xbac0,
    0xffff, 0xcea3, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5ccf, 0xeaeb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5cd0,
    0x5cd1, 0x5cd2, 0xeaec, 0xbed8, 0xeaea, 0x5cd3, 0xffff, 0x5cd4, 0xcde7, 0xeae7, 0xffff, 0xffff, 0xeae9, 0xc0bd, 0xbffe,

    /* 0x89: 0x01 - 0xff */
            0x5cd5, 0xeae8, 0xffff, 0xeaed, 0xffff, 0x5cd6, 0xcaa3, 0xffff, 0xffff, 0xeaef, 0xffff, 0xeaee, 0x5cd7, 0x5cd8, 0x5cd9,
    0xb3ec, 0xffff, 0xcbab, 0xeaf0, 0xffff, 0x5cda, 0x5cdb, 0xffff, 0x5cdc, 0x5cdd, 0x5cde, 0xffff, 0x5cdf, 0xeafc, 0xeaf2, 0xffff,
    0x5ce0, 0xffff, 0xffff, 0xffff, 0xffff, 0xeaf3, 0x5ce1, 0x5ce2, 0x5ce3, 0xffff, 0xeaf4, 0xeaf5, 0xffff, 0xffff, 0xffff, 0xffff,
    0x5ce4, 0x5ce5, 0x5ce6, 0xffff, 0xffff, 0x5ce7, 0xeaf9, 0xffff, 0xeafa, 0x5ce8, 0x5ce9, 0xeaf8, 0xffff, 0xffff, 0x5cea, 0xffff,
    0x5ceb, 0xeaf6, 0x5cec, 0xeaf1, 0xeaf7, 0x5ced, 0x5cee, 0xffff, 0xffff, 0x5cef, 0xffff, 0xffff, 0xeafb, 0xf0b7, 0xffff, 0x5cf0,
    0xffff, 0xffff, 0x5cf1, 0xffff, 0xffff, 0xffff, 0xb2a8, 0x5cf2, 0xffff, 0xffff, 0x5cf3, 0x5cf4, 0x5cf5, 0xffff, 0xeafe, 0xb6df,
    0xeafd, 0x5cf6, 0x5cf7, 0x5cf8, 0xeba2, 0xffff, 0xeba1, 0xffff, 0xffff, 0xffff, 0xeba4, 0x5cf9, 0xffff, 0xeba3, 0x5cfa, 0xeba5,
    0x5cfb, 0xffff, 0xbdb1, 0x5cfc, 0xeba6, 0x5cfd, 0xffff, 0xeba7, 0xffff, 0xffff, 0x5cfe, 0x5da1, 0x5da2, 0x5da3, 0xeba8, 0xc0be,
    0xffff, 0xcdd7, 0xffff, 0xeba9, 0xffff, 0xffff, 0xcaa4, 0xc7c6, 0xebaa, 0x5da4, 0xebab, 0xb8ab, 0xffff, 0x5da5, 0xffff, 0xb5ac,
    0x5da6, 0xffff, 0xffff, 0xebac, 0x5da7, 0x5da8, 0xbbeb, 0xc7c1, 0xebad, 0xffff, 0xb3d0, 0x5da9, 0x5daa, 0xffff, 0xffff, 0x5dab,
    0x5dac, 0xebae, 0xffff, 0xffff, 0xffff, 0x5dad, 0xebb0, 0xcdf7, 0xffff, 0xebaf, 0xbfc6, 0xffff, 0xebb1, 0xffff, 0xffff, 0xebb2,
    0x5dae, 0xffff, 0xebb3, 0xb4d1, 0x5daf, 0x5db0, 0x5db1, 0x5db2, 0xffff, 0xffff, 0xebb4, 0xffff, 0x5db3, 0xebb5, 0xffff, 0xebb6,
    0xebb7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xb3d1, 0xffff, 0x5db4, 0x5db5, 0x5db6, 0x5db7, 0x5db8, 0xffff, 0xebb8, 0xffff, 0xebb9, 0xebba, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xb2f2, 0xffff, 0x5db9, 0xbfa8, 0xebbb, 0xffff, 0x5dba, 0xffff, 0x5dbb, 0xffff, 0x5dbc, 0xffff, 0xffff,
    0xffff, 0x5dbd, 0xffff, 0x5dbe, 0xebbc, 0xffff, 0x5dbf, 0xffff, 0xebbd, 0x5dc0, 0xffff, 0xffff, 0xffff, 0x5dc1, 0xffff, 0x5dc2,

    /* 0x8a: 0x00 - 0xff */
    0xb8c0, 0xffff, 0xc4fb, 0xebbe, 0x5dc3, 0x5dc4, 0xffff, 0x5dc5, 0xb7d7, 0xffff, 0xbfd6, 0xffff, 0xebc1, 0xffff, 0xc6a4, 0x5dc6,
    0xebc0, 0x5dc7, 0x5dc8, 0xb7b1, 0x5dc9, 0x5dca, 0xebbf, 0xc2f7, 0xb5ad, 0xffff, 0xffff, 0xebc2, 0xffff, 0xebc3, 0x5dcb, 0xbed9,
    0x5dcc, 0xffff, 0x5dcd, 0xb7ed, 0x5dce, 0xebc4, 0x5dcf, 0xffff, 0xffff, 0xffff, 0xcbac, 0x5dd0, 0x5dd1, 0xc0df, 0xffff, 0x5dd2,
    0xffff, 0xb5f6, 0xffff, 0xccf5, 0xc1ca, 0x5dd3, 0xebc5, 0x5dd4, 0xffff, 0xffff, 0xbfc7, 0xc3f0, 0xbeda, 0x5dd5, 0x5dd6, 0xffff,
    0x5dd7, 0xebc6, 0xffff, 0x5dd8, 0xffff, 0x5dd9, 0xebc9, 0x5dda, 0xebca, 0x5ddb, 0xffff, 0xffff, 0xffff, 0x5ddc, 0x5ddd, 0xffff,
    0xbabe, 0xc2c2, 0xebc8, 0x5dde, 0xbedb, 0xc9be, 0x5ddf, 0x5de0, 0x5de1, 0xffff, 0xffff, 0xebc7, 0x5de2, 0x5de3, 0xbbec, 0xffff,
    0xb1d3, 0x5de4, 0xebce, 0xb7d8, 0xffff, 0x5de5, 0xbbee, 0x5de6, 0xffff, 0xbbed, 0xffff, 0xcfcd, 0xebcd, 0xebcc, 0xc1a7, 0xffff,
    0xb5cd, 0xcfc3, 0xb3ba, 0xbedc, 0xffff, 0x5de7, 0x5de8, 0x5de9, 0xffff, 0x5dea, 0x5deb, 0x5dec, 0xebcb, 0xffff, 0x5ded, 0x5dee,
    0x5def, 0xffff, 0xebd0, 0x5df0, 0xebd1, 0xebcf, 0x5df1, 0xb8d8, 0xffff, 0xcdc0, 0xffff, 0x5df2, 0xbbef, 0xc7a7, 0xffff, 0x5df3,
    0x5df4, 0xebd4, 0x5df5, 0xc0c0, 0xffff, 0xc3c2, 0x5df6, 0x5df7, 0xcdb6, 0x5df8, 0xebd7, 0xffff, 0xffff, 0xffff, 0xb8ec, 0x5df9,
    0xc0bf, 0xebd3, 0xffff, 0xebd8, 0xb8ed, 0xebd5, 0xebd6, 0x5dfa, 0xebd2, 0x5dfb, 0xffff, 0xffff, 0xc0e2, 0xc6c9, 0x5dfc, 0x5dfd,
    0xc3af, 0xffff, 0xb2dd, 0x5dfe, 0xffff, 0xffff, 0x5ea1, 0x5ea2, 0xffff, 0xc8f0, 0xffff, 0x5ea3, 0xb5c3, 0xffff, 0x5ea4, 0xc4b4,
    0xffff, 0xffff, 0xebdb, 0x5ea5, 0xebd9, 0xffff, 0x5ea6, 0xc3cc, 0x5ea7, 0x5ea8, 0x5ea9, 0xc0c1, 0xb4d2, 0xebda, 0xffff, 0xbfdb,
    0xffff, 0x5eaa, 0xceca, 0x5eab, 0x5eac, 0x5ead, 0xcfc0, 0x5eae, 0xffff, 0xffff, 0xebdc, 0xebe7, 0xc4b5, 0x5eaf, 0xebe6, 0x5eb0,
    0xebe3, 0xebeb, 0xebe4, 0xffff, 0xebe0, 0xffff, 0xc4fc, 0xebdf, 0xffff, 0xffff, 0xffff, 0xebdd, 0x5eb1, 0xcda1, 0xbbf0, 0xffff,
    0x5eb2, 0xebe1, 0xffff, 0xebde, 0x5eb3, 0x5eb4, 0x5eb5, 0xebe5, 0xbdf4, 0xffff, 0xb8c1, 0xffff, 0x5eb6, 0xffff, 0xc2fa, 0x5eb7,

    /* 0x8b: 0x00 - 0x9f */
    0xcbc5, 0xb1da, 0xb0e2, 0xffff, 0xc6a5, 0x5eb8, 0x5eb9, 0xebe9, 0xffff, 0xffff, 0x5ebf, 0x5eba, 0xebe8, 0xffff, 0xc6e6, 0xffff,
    0xebed, 0x5ebb, 0xffff, 0xffff, 0xebe2, 0xffff, 0xebec, 0xebee, 0xffff, 0xb8ac, 0xebea, 0xb9d6, 0x5ebc, 0xbcd5, 0x5ebd, 0x5ebe,
    0xebef, 0xcdd8, 0xffff, 0xffff, 0xffff, 0xffff, 0xebf2, 0xffff, 0xebf5, 0xffff, 0xffff, 0xebf3, 0xc9b5, 0x5ec0, 0xffff, 0xffff,
    0x5ec1, 0xffff, 0xffff, 0xebf0, 0xffff, 0xffff, 0xffff, 0x5ec2, 0xffff, 0xb6e0, 0xffff, 0xffff, 0x5ec3, 0xffff, 0xebf4, 0xffff,
    0xffff, 0xebf6, 0x5ec4, 0x5ec5, 0x5ec6, 0x5ec7, 0x5ec8, 0xffff, 0x5ec9, 0xebfa, 0xffff, 0xffff, 0xebf7, 0x5ece, 0xebf9, 0xebf8,
    0xffff, 0xffff, 0x5eca, 0x5ecb, 0x5ecc, 0xffff, 0xebfb, 0xffff, 0xbcb1, 0x5ecd, 0xebfd, 0xebfc, 0xc9e8, 0xffff, 0x5ecf, 0xeca1,
    0xffff, 0xffff, 0xffff, 0x5ed0, 0xffff, 0xffff, 0xb7d9, 0xffff, 0xffff, 0xffff, 0xffff, 0xebfe, 0xeca2, 0x5ed1, 0xffff, 0xeca3,
    0xb5c4, 0xe6c1, 0xbef9, 0xffff, 0xeca4, 0xffff, 0x5ed2, 0xb8ee, 0x5ed3, 0x5ed4, 0xffff, 0xffff, 0x5ed5, 0xeca5, 0x5ed6, 0xffff,
    0xeca6, 0x5ed7, 0xffff, 0xbbbe, 0x5ed8, 0x5ed9, 0xffff, 0xffff, 0xffff, 0xffff, 0xdace, 0x5eda, 0xeca7, 0x5edb, 0xeca8, 0x5edc,
    0xbdb2, 0xffff, 0xeca9, 0xecaa, 0x5edd, 0x5ede, 0xecab, 0xffff, 0xffff, 0xecac, 0xecad, 0xffff, 0x5edf, 0xffff, 0x5ee0, 0x5ee1,

    /* 0x8c: 0x37 - 0xff */
                                                            0xc3ab, 0x5ee2, 0x5ee3, 0xecae, 0xffff, 0xffff, 0x5ee4, 0x5ee5, 0xecb0,
    0xffff, 0xecaf, 0xffff, 0xffff, 0xffff, 0x5ee6, 0xc6a6, 0x5ee7, 0xecb1, 0x5ee8, 0xcbad, 0x5ee9, 0xecb2, 0xffff, 0xecb3, 0x5eea,
    0xecb4, 0x5eeb, 0xffff, 0x5eec, 0x5eed, 0xecb5, 0xffff, 0x5eee, 0x5eef, 0x5ef2, 0xc6da, 0x5ef0, 0xffff, 0x5ef1, 0xffff, 0xffff,
    0xffff, 0xbedd, 0xecb6, 0x5ef3, 0x5ef4, 0xffff, 0x5ef5, 0xffff, 0x5ef6, 0x5ef7, 0xb9eb, 0xd0ae, 0xecb7, 0x5ef8, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x5ef9, 0xffff, 0x5efa, 0x5efb, 0xffff, 0xecb8, 0xc9bf, 0xecb9, 0x5efc, 0xecc1, 0xffff, 0x5efd, 0xffff,
    0xffff, 0xffff, 0xecba, 0xffff, 0xffff, 0xecbc, 0x5efe, 0x5fa1, 0xffff, 0xecbb, 0xecbd, 0x5fa2, 0xcbc6, 0xecbe, 0xecbf, 0xffff,
    0x5fa3, 0xffff, 0x5fa4, 0x5fa5, 0xecc0, 0xffff, 0xffff, 0xffff, 0xecc2, 0x5fa6, 0xffff, 0x5fa7, 0x5fa8, 0xb3ad, 0xc4e7, 0xffff,
    0xc9e9, 0xbae2, 0xb9d7, 0xffff, 0x5fa9, 0xffff, 0xffff, 0xc9cf, 0xb2df, 0xc8ce, 0xecc5, 0xb4d3, 0xc0d5, 0xecc4, 0xecc9, 0xc3f9,
    0xcce3, 0xffff, 0xecc7, 0xecc8, 0xb5ae, 0xffff, 0xecca, 0xc7e3, 0xc2df, 0x5faa, 0x5fab, 0xc8f1, 0xc5bd, 0xecc6, 0xffff, 0xcbc7,
    0xb2ec, 0xeccc, 0xcfa8, 0xc4c2, 0xcfc5, 0x5fac, 0x5fad, 0xbbf1, 0xeccb, 0x5fae, 0xc2b1, 0x5faf, 0xffff, 0xecdc, 0xc1a8, 0x5fb0,
    0xffff, 0xc6f8, 0xffff, 0xc9d0, 0xffff, 0x5fb2, 0x5fb1, 0xffff, 0xffff, 0x5fb3, 0xeccf, 0xbbbf, 0xbbf2, 0x5fb4, 0xbede, 0xffff,
    0xc7e5, 0x5fb5, 0xb8ad, 0xecce, 0xeccd, 0xffff, 0xc9ea, 0xffff, 0x5fb6, 0xffff, 0xbcc1, 0xffff, 0x5fb7, 0xc5d2, 0xffff, 0x5fb8,
    0x5fb9, 0xffff, 0x5fba, 0xffff, 0xffff, 0x5fbb, 0xffff, 0x5fbc, 0x5fbd, 0xffff, 0xecd1, 0xecd2, 0xb9d8, 0xecd0, 0x5fbe, 0x5fbf,

    /* 0x8d: 0x01 - 0xff */
            0x5fc0, 0xffff, 0x5fc1, 0xecd3, 0xecd4, 0xffff, 0xecd6, 0xc2a3, 0x5fc2, 0xecd5, 0xb4e6, 0xffff, 0xecd8, 0xffff, 0xecd7,
    0xecd9, 0xffff, 0x5fc3, 0xecdb, 0xecdd, 0xffff, 0xecde, 0x5fc4, 0xffff, 0xffff, 0xffff, 0x5fc5, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xc0d6, 0x5fc6, 0xbccf, 0xecdf, 0xffff, 0x5fc7, 0xffff, 0xb3d2, 0x5fc8, 0xece0, 0x5fc9, 0xffff,
    0xc1f6, 0xece1, 0xffff, 0xece2, 0xc9eb, 0xffff, 0xffff, 0xb5af, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x5fca,
    0xffff, 0xece3, 0x5fcb, 0xffff, 0x5fcc, 0xc4b6, 0xffff, 0xffff, 0x5fcd, 0xffff, 0xb1db, 0xffff, 0xffff, 0x5fce, 0xffff, 0xffff,
    0x5fcf, 0x5fd0, 0xffff, 0xffff, 0xffff, 0x5fd1, 0xffff, 0xffff, 0xffff, 0xece4, 0xffff, 0xffff, 0xffff, 0xffff, 0x5fd2, 0x5fd3,
    0x5fd4, 0xffff, 0xffff, 0xbcf1, 0xffff, 0xffff, 0x5fd5, 0xffff, 0xbff6, 0xffff, 0xffff, 0x5fd6, 0x5fd7, 0xffff, 0xffff, 0x5fd8,
    0xffff, 0xffff, 0x5fd9, 0xc2ad, 0xffff, 0x5fda, 0xffff, 0x5fdb, 0xffff, 0x5fdc, 0xece7, 0x5fdd, 0x5fef, 0xffff, 0xece6, 0xffff,
    0x5fde, 0xffff, 0xece5, 0xffff, 0xffff, 0x5fdf, 0x5fe0, 0x5fe1, 0x5fe2, 0xffff, 0x5fe3, 0xeced, 0xeceb, 0xffff, 0x5fe4, 0xece8,
    0xffff, 0x5fe5, 0xffff, 0xffff, 0x5fe6, 0x5fe7, 0xecea, 0x5fe8, 0xffff, 0x5fe9, 0xece9, 0xecec, 0xffff, 0xb5f7, 0xffff, 0xecf0,
    0xffff, 0xc0d7, 0xffff, 0xecf1, 0x5fea, 0x5feb, 0xffff, 0x5fec, 0xb8d9, 0xffff, 0xecee, 0xecef, 0x5fed, 0xffff, 0xffff, 0xcfa9,
    0x5fee, 0x5ff0, 0x5ff1, 0xc4b7, 0x5ff2, 0xc1a9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xecf2, 0x5ff3, 0xffff, 0xecf5,

    /* 0x8e: 0x01 - 0xfe */
            0x5ff4, 0xffff, 0xffff, 0x5ff5, 0x5ff6, 0x5ff7, 0xffff, 0xecf3, 0xecf4, 0xcdd9, 0x5ff8, 0xffff, 0xffff, 0xffff, 0xc6a7,
    0xecf8, 0x5ff9, 0xffff, 0xffff, 0x5ffa, 0xffff, 0x5ffb, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xecf6, 0xecf7, 0xecf9,
    0x5ffc, 0x5ffd, 0x5ffe, 0x60a1, 0xffff, 0xffff, 0x60a2, 0x60a3, 0xffff, 0xffff, 0xeda9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xecfc, 0x60a4, 0xffff, 0x60a5, 0xecfd, 0xecfb, 0x60a6, 0x60a7, 0x60a8, 0x60a9, 0xffff, 0xffff, 0xffff, 0x60aa, 0xffff, 0xffff,
    0x60ab, 0x60ac, 0xecfa, 0xffff, 0xc4fd, 0xffff, 0xffff, 0xeda1, 0xeda5, 0xeda2, 0xecfe, 0x60ad, 0xeda3, 0x60ae, 0x60af, 0x60b0,
    0xeda4, 0xffff, 0xffff, 0xffff, 0x60b1, 0xedab, 0xffff, 0xffff, 0xffff, 0xeda6, 0xffff, 0x60b2, 0x60b3, 0x60b4, 0x60b5, 0xc0d8,
    0xeda8, 0x60b6, 0x60b7, 0xedaa, 0xeda7, 0xffff, 0xffff, 0xffff, 0xffff, 0x60b8, 0xffff, 0xffff, 0x60b9, 0x60ba, 0xffff, 0x60bb,
    0x60bc, 0x60bd, 0xedad, 0xffff, 0xbdb3, 0xffff, 0xedac, 0xffff, 0xffff, 0x60be, 0x60bf, 0x60c0, 0xedae, 0xffff, 0xffff, 0xffff,
    0xffff, 0xedaf, 0x60c1, 0x60c2, 0xedb2, 0xedb1, 0xffff, 0xedb0, 0xffff, 0x60c3, 0xedb4, 0xedb3, 0xffff, 0xccf6, 0xffff, 0xffff,
    0x60c4, 0xedb6, 0x60c5, 0xedb5, 0xedb7, 0x60c6, 0xffff, 0xffff, 0xffff, 0xedb8, 0x60c7, 0x60c8, 0xffff, 0x60c9, 0x60ca, 0xffff,
    0xffff, 0xedba, 0x60cb, 0xffff, 0xffff, 0xffff, 0xffff, 0x60cc, 0xffff, 0x60cd, 0xedb9, 0xbfc8, 0xedbb, 0x60ce, 0x60cf, 0xb6ed,
    0xedbc, 0xedbe, 0xffff, 0x60d0, 0xffff, 0x60d1, 0xffff, 0xffff, 0xffff, 0xffff, 0x60d2, 0x60d3, 0xffff, 0xffff, 0xedbf, 0xffff,
    0x60d4, 0x60d5, 0xffff, 0x60d6, 0x60d7, 0xedc0, 0xedbd, 0x60d8, 0xedc1, 0xffff, 0xbcd6, 0xedc2, 0xb5b0, 0xb7b3, 0xffff, 0x60d9,
    0xffff, 0x60da, 0xb8ae, 0xffff, 0x60db, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xedc3, 0x60dc, 0xffff, 0xffff, 0xc6f0,
    0xffff, 0xffff, 0xc5be, 0xedc4, 0xffff, 0xffff, 0xffff, 0xffff, 0x60dd, 0xffff, 0xffff, 0xedc7, 0xffff, 0x60e4, 0x60de, 0xffff,
    0x60df, 0x60e0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x60e1, 0xbcb4, 0x60e2, 0x60e3, 0xedc6, 0xedc5, 0xb7da, 0xedc8,

    /* 0x8f: 0x00 - 0xfe */
    0x60e5, 0xffff, 0x60e6, 0xb3d3, 0xffff, 0xedca, 0xffff, 0x60e7, 0x60e8, 0xbadc, 0xedc9, 0xffff, 0xedd2, 0xffff, 0xffff, 0x60e9,
    0x60ea, 0xffff, 0xedcc, 0xedce, 0xcae5, 0xedcb, 0x60eb, 0x60ec, 0x60ed, 0xedcd, 0xffff, 0xedd1, 0xedcf, 0xb5b1, 0x60ee, 0xedd0,
    0x60ef, 0x60f0, 0xffff, 0x60f1, 0xffff, 0x60f2, 0xedd3, 0x60f3, 0x60f4, 0xc7da, 0xced8, 0xffff, 0x60f5, 0x60f6, 0x60f7, 0xbdb4,
    0xffff, 0xffff, 0xffff, 0xedd4, 0x60f8, 0x60f9, 0x60fa, 0x60fb, 0xcda2, 0xedd6, 0x60fc, 0xedd5, 0xffff, 0xffff, 0xedd9, 0xcdc1,
    0x60fd, 0x60fe, 0xedd8, 0x61a1, 0xb3ed, 0xedd7, 0xeddc, 0x61a2, 0xffff, 0xeddb, 0xffff, 0xffff, 0xedda, 0xc5b2, 0xeddd, 0x61a3,
    0xffff, 0x61a4, 0x61a5, 0x61a6, 0x61a7, 0x61a8, 0xffff, 0xedde, 0x61a9, 0xffff, 0xffff, 0xffff, 0xeddf, 0x61aa, 0x61ab, 0xb9ec,
    0xffff, 0xb7a5, 0xede0, 0xede1, 0xede2, 0x61ac, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbfc9, 0xede3, 0x61ad, 0xbcad, 0xede4,
    0x61ae, 0x61af, 0xffff, 0xede5, 0x61b0, 0x61b1, 0x61b2, 0xd2a1, 0xd1fe, 0xffff, 0xffff, 0xffff, 0xffff, 0xede6, 0xe5f0, 0xede7,
    0xc3a4, 0xbfab, 0xc7c0, 0xffff, 0xffff, 0x61b3, 0x61b4, 0xede8, 0x61b5, 0xffff, 0xcad5, 0xc4d4, 0xb9fe, 0xffff, 0x61b6, 0xc3a9,
    0x61b7, 0x61b8, 0xb1aa, 0xffff, 0xcbf8, 0xbfd7, 0x61b9, 0xffff, 0xffff, 0xffff, 0x61ba, 0x61bb, 0xffff, 0x61bc, 0xb7de, 0xffff,
    0x61bd, 0xb6e1, 0x61be, 0x61bf, 0xcad6, 0x61c0, 0xffff, 0xffff, 0xffff, 0xffff, 0xede9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0x61c1, 0xffff, 0xedeb, 0x61c2, 0x61c3, 0xedea, 0xb2e0, 0xffff, 0x61c4, 0xc6f6, 0xedec, 0xc7f7, 0xffff, 0xc5b3, 0x61c5, 0xeded,
    0xbdd2, 0x61c6, 0xffff, 0xffff, 0xedef, 0x61c7, 0x61c8, 0xccc2, 0xedfe, 0xedf1, 0xedf2, 0x61c9, 0xffff, 0xc4c9, 0x61ca,

    /* 0x90: 0x00 - 0xff */
    0xc2e0, 0xc1f7, 0x61cb, 0xc6a8, 0x61cc, 0xedf0, 0xb5d5, 0xffff, 0x61cd, 0xffff, 0xffff, 0xedf9, 0x61ce, 0xedf6, 0xeea5, 0xc6a9,
    0xc3e0, 0xedf3, 0xffff, 0xc4fe, 0xc5d3, 0xedf4, 0xedf8, 0xbfe0, 0x61cf, 0xc7e7, 0xc4cc, 0x61d0, 0xffff, 0xc0c2, 0xedf7, 0xc2ae,
    0xc2a4, 0xedf5, 0xb0a9, 0xcfa2, 0xffff, 0xffff, 0xffff, 0xedfa, 0x61d1, 0x61d2, 0x61d4, 0xffff, 0x61d5, 0x61d6, 0xc2e1, 0x61d3,
    0xffff, 0xbdb5, 0xbfca, 0x61d7, 0x61d8, 0xedfc, 0xedfb, 0x61d9, 0xb0ef, 0xedfd, 0xffff, 0xffff, 0xc9af, 0xffff, 0xeea7, 0x61da,
    0xffff, 0xc6db, 0xbfeb, 0x61db, 0x61dc, 0xc3d9, 0xffff, 0xb6f8, 0xffff, 0xeea6, 0xcdb7, 0xb1bf, 0x61dd, 0xcad7, 0xb2e1, 0xeea1,
    0xeea2, 0xeea3, 0xeea4, 0xc6bb, 0xc3a3, 0xb0e3, 0xeea8, 0xffff, 0xeea9, 0xf4a3, 0xffff, 0x61de, 0xc2bd, 0x61df, 0xeeaa, 0xffff,
    0xb1f3, 0xc1cc, 0x61e0, 0xb8af, 0xffff, 0xcdda, 0x61e1, 0x61e2, 0xeeab, 0xc5ac, 0xffff, 0xffff, 0x61e3, 0xc1f8, 0xbcd7, 0xeeac,
    0x61e4, 0xffff, 0xeeaf, 0xffff, 0x61e5, 0xbde5, 0xeead, 0xc1ab, 0xc1aa, 0x61e6, 0xb0e4, 0xffff, 0xcecb, 0xeeb1, 0xffff, 0xc8f2,
    0xeeb3, 0xeeb2, 0xeeb0, 0xe3e4, 0xb4d4, 0x61e7, 0xffff, 0xedee, 0x61e8, 0xeeb5, 0xeeb4, 0x61e9, 0x61ea, 0xffff, 0x61eb, 0xeeb6,
    0x61ec, 0xcdb8, 0xffff, 0xffff, 0xffff, 0x61ed, 0xffff, 0x61ee, 0x61ef, 0x61f0, 0xffff, 0x61f1, 0xffff, 0xffff, 0xffff, 0xffff,
    0x61f2, 0x61f3, 0x61f4, 0xc6e1, 0xffff, 0x61f5, 0xcbae, 0xffff, 0xeeb7, 0xffff, 0xbcd9, 0xffff, 0xffff, 0xffff, 0xffff, 0xeeb8,
    0x61f6, 0xeeb9, 0x61f7, 0x61f8, 0x61f9, 0xeeba, 0x61fa, 0xffff, 0xc5a1, 0xffff, 0xffff, 0xffff, 0xffff, 0x61fb, 0x61fd, 0xffff,
    0xffff, 0xb0ea, 0xffff, 0x61fe, 0x62a1, 0x62a2, 0xffff, 0x62a3, 0x62a4, 0xffff, 0xb9d9, 0xffff, 0x61fc, 0xffff, 0xcfba, 0xffff,
    0xffff, 0xffff, 0x62ad, 0xffff, 0xffff, 0x62a5, 0xffff, 0x62a6, 0x62a7, 0x62a8, 0xffff, 0xeebe, 0x62a9, 0x62aa, 0xffff, 0x62ab,
    0xffff, 0xb7b4, 0xeebb, 0xffff, 0xeebc, 0x62ac, 0xffff, 0xffff, 0xc9f4, 0xffff, 0xffff, 0x62af, 0xffff, 0xb3d4, 0xffff, 0x62b0,
    0x62b1, 0xffff, 0xffff, 0xffff, 0x62b2, 0xcdb9, 0x62ae, 0xb6bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc5d4, 0x62b3, 0x62b4,

    /* 0x91: 0x00 - 0xff */
    0x62b5, 0xffff, 0xeebf, 0xffff, 0x62b6, 0x62b7, 0x62b8, 0xffff, 0x62b9, 0xffff, 0xffff, 0xffff, 0xffff, 0x62ba, 0xffff, 0xffff,
    0x62bb, 0xffff, 0xeec0, 0xffff, 0x62bc, 0xffff, 0x62bd, 0x62be, 0x62bf, 0xeec1, 0x62c0, 0xffff, 0x62c1, 0xffff, 0x62c2, 0xffff,
    0x62c3, 0xffff, 0x62c5, 0x62c6, 0xffff, 0x62c4, 0xffff, 0x62c7, 0xffff, 0x62c8, 0xffff, 0xffff, 0xffff, 0xc5a2, 0x62c9, 0x62ca,
    0xeec3, 0x62cb, 0xeec2, 0xffff, 0x62cc, 0xffff, 0x62cd, 0x62ce, 0xffff, 0x62cf, 0x62d0, 0xffff, 0x62d1, 0x62d2, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0x62d3, 0xffff, 0xffff, 0xffff, 0x62d4, 0x62d5, 0xc6d3, 0xeec4, 0xbdb6, 0xbce0, 0xc7db, 0xc3f1, 0x62d6,
    0xffff, 0xffff, 0xbcf2, 0x62d7, 0xbfec, 0xffff, 0xeec5, 0x62d8, 0xeec6, 0x62d9, 0x62da, 0x62db, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x62dc, 0xbfdd, 0xeec7, 0x62dd, 0xeec8, 0xffff, 0x62de, 0xffff, 0xeec9, 0xcdef, 0xffff, 0xbdb7, 0x62df, 0xffff, 0xffff,
    0xffff, 0xffff, 0xeecb, 0xeeca, 0x62e0, 0xb9da, 0xffff, 0xb9f3, 0xbbc0, 0x62e1, 0x62e2, 0x62e3, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x62e4, 0xeece, 0x62e5, 0xffff, 0x62e6, 0x62e7, 0xbde6, 0xffff, 0xeecd, 0x62e8, 0xeecc, 0xffff, 0xc2e9, 0x62e9, 0xffff,
    0xb8ef, 0x62ea, 0xc0c3, 0x62eb, 0x62ec, 0x62ed, 0xffff, 0xc8b0, 0x62ee, 0xffff, 0xffff, 0xffff, 0xbdb9, 0xffff, 0x62ef, 0xffff,
    0xffff, 0x62f0, 0xeecf, 0xffff, 0xbedf, 0xffff, 0x62f1, 0xffff, 0x62f2, 0xffff, 0xeed2, 0xeed0, 0x62f3, 0x62f4, 0x62f5, 0xeed1,
    0x62f6, 0x62f7, 0x62f8, 0x62f9, 0xeed4, 0xeed3, 0x62fa, 0xffff, 0xbefa, 0xffff, 0xeed5, 0x62fb, 0x62fc, 0x62fd, 0xffff, 0x62fe,
    0xeed6, 0xeed7, 0x63a1, 0x63a2, 0xffff, 0x63a3, 0xc8d0, 0xbad3, 0xbce1, 0xeed8, 0xffff, 0xeed9, 0xcea4, 0xbdc5, 0xccee, 0xcecc,
    0xeeda, 0xb6e2, 0xffff, 0x63a4, 0x63a5, 0xffff, 0xeedb, 0x63a6, 0xc5a3, 0x63a7, 0x63a8, 0xeede, 0xb3f8, 0xbfcb, 0x63a9, 0xeedc,
    0xffff, 0xeedd, 0xffff, 0xc4e0, 0x63aa, 0x63ab, 0xcbd5, 0xb6fc, 0xffff, 0x63ac, 0x63ad, 0xffff, 0x63ae, 0x63af, 0x63b0, 0x63b1,
    0x63b2, 0x63b3, 0xffff, 0xffff, 0xffff, 0xeee0, 0xeee1, 0x63b4, 0xffff, 0x63b5, 0xffff, 0x63b6, 0xeedf, 0x63b7, 0xffff, 0xeee3,

    /* 0x92: 0x00 - 0xff */
    0x63b8, 0x63b9, 0xffff, 0xffff, 0x63ba, 0x63bb, 0x63bc, 0x63bd, 0xffff, 0x63be, 0x63bf, 0xffff, 0x63c0, 0xc6df, 0xb3c3, 0xffff,
    0x63c1, 0xeee7, 0x63c2, 0x63c3, 0xeee4, 0xeee6, 0x63c4, 0xffff, 0x63c5, 0xffff, 0xffff, 0xffff, 0x63c6, 0x63c7, 0xeee2, 0xffff,
    0xffff, 0xffff, 0xffff, 0x63c8, 0x63c9, 0x63ca, 0x63cb, 0xffff, 0x63cc, 0xefcf, 0xffff, 0xffff, 0xeee5, 0xffff, 0x63cd, 0x63ce,
    0x63cf, 0xffff, 0xffff, 0x63d0, 0xceeb, 0x63d1, 0x63d2, 0xb8da, 0x63d3, 0x63d4, 0x63d5, 0xffff, 0x63d6, 0xffff, 0x63d7, 0xeeef,
    0x63d8, 0xffff, 0x63d9, 0x63da, 0xc5b4, 0xeeea, 0x63db, 0x63dc, 0xeeed, 0xeeeb, 0x63dd, 0xeef0, 0xffff, 0x63de, 0x63df, 0x63e0,
    0xeef1, 0x63e1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xeee9, 0x63e2, 0x63e3, 0xeef6, 0xb1f4, 0x63e4, 0x63e5, 0xeee8, 0xffff,
    0x63e6, 0x63e7, 0xc8ad, 0xffff, 0xeeec, 0x63e8, 0xbee0, 0x63e9, 0x63ea, 0x63eb, 0xffff, 0xffff, 0xffff, 0xffff, 0x63ec, 0x63ed,
    0x63ee, 0xb9db, 0xffff, 0xffff, 0xffff, 0x63ef, 0x63f0, 0x63f1, 0x63f2, 0x63f3, 0xffff, 0x63f4, 0x63f5, 0x63f6, 0xcbc8, 0x63f7,
    0xb6e4, 0xffff, 0xffff, 0xbdc6, 0xffff, 0xc6bc, 0xffff, 0xffff, 0x63f8, 0x63f9, 0x63fa, 0xffff, 0xffff, 0x63fb, 0x63fc, 0xffff,
    0xffff, 0xc1ad, 0x63fd, 0xeef4, 0xffff, 0xeeee, 0xeef3, 0x63fe, 0xccc3, 0x64a1, 0xc4b8, 0xeef5, 0xeef2, 0xffff, 0xffff, 0x64a2,
    0x64a3, 0xffff, 0xffff, 0xffff, 0x64a4, 0x64a5, 0xffff, 0x64a6, 0x64a7, 0xffff, 0xffff, 0x64a8, 0xffff, 0xc1ac, 0xffff, 0x64a9,
    0xffff, 0xffff, 0x64aa, 0xffff, 0xffff, 0xffff, 0x64ab, 0xeef9, 0x64ac, 0xeef8, 0x64ad, 0x64ae, 0x64af, 0x64b0, 0xffff, 0x64b1,
    0x64b2, 0x64b3, 0x64b4, 0x64b5, 0xffff, 0x64b6, 0x64b7, 0x64b8, 0x64b9, 0xffff, 0xffff, 0x64ba, 0x64bb, 0x64bc, 0x64bd, 0xeef7,
    0x64be, 0xffff, 0xcbaf, 0x64bf, 0xffff, 0x64c0, 0xffff, 0x64c1, 0x64c2, 0x64c3, 0xffff, 0xffff, 0x64c4, 0x64c5, 0xffff, 0x64c6,
    0x64c7, 0x64c8, 0xffff, 0x64c9, 0xbdfb, 0x64ca, 0xffff, 0x64cb, 0x64cc, 0xeefa, 0xcadf, 0xffff, 0x64cd, 0xb1d4, 0x64ce, 0xffff,
    0x64cf, 0xffff, 0xc9c6, 0xc3f2, 0xffff, 0xffff, 0xffff, 0xffff, 0xb5f8, 0x64d0, 0xeefc, 0x64d1, 0xb9dd, 0xffff, 0xffff, 0x64d2,

    /* 0x93: 0x00 - 0xfd */
    0x64d3, 0xffff, 0x64d4, 0xffff, 0xffff, 0xffff, 0xbbac, 0xffff, 0x64d5, 0xffff, 0xffff, 0xffff, 0xffff, 0x64d6, 0xffff, 0xeefb,
    0xbfed, 0x64d7, 0xffff, 0xffff, 0x64d8, 0x64d9, 0xffff, 0xffff, 0xbfee, 0xefa1, 0xefa3, 0xffff, 0x64da, 0x64db, 0x64dc, 0x64dd,
    0xbefb, 0x64de, 0xefa2, 0xefa4, 0x64df, 0x64e0, 0xb6d3, 0x64e1, 0xc9c5, 0x64e2, 0x64e3, 0xbce2, 0xcfa3, 0xffff, 0xeefe, 0xbaf8,
    0xffff, 0xffff, 0xcfbf, 0x64e4, 0x64e5, 0xefa6, 0x64e6, 0x64e7, 0xffff, 0xffff, 0xefa5, 0xefa7, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xeefd, 0xffff, 0xffff, 0x64e8, 0x64e9, 0x64ea, 0xffff, 0xc6e9, 0xffff, 0xc5d5, 0xffff, 0xffff,
    0x64eb, 0x64ec, 0x64ed, 0xffff, 0xc4d7, 0x64ee, 0xefac, 0x64ef, 0x64f0, 0xffff, 0x64f1, 0xc3c3, 0xefa8, 0xffff, 0x64f2, 0xffff,
    0xefa9, 0xffff, 0xffff, 0xffff, 0x64f3, 0x64f4, 0xffff, 0x64f5, 0xffff, 0x64f6, 0x64f7, 0xffff, 0xb7ad, 0x64f8, 0xefab, 0x64f9,
    0x64fa, 0x64fb, 0xffff, 0x64fc, 0x64fd, 0xb8b0, 0x64fe, 0xffff, 0xffff, 0xffff, 0x65a1, 0xffff, 0xefaa, 0x65a2, 0xbee1, 0x65a3,
    0x65a4, 0x65a5, 0x65a6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x65a7, 0xffff, 0x65a8, 0x65a9, 0xb3f9, 0x65aa, 0xffff, 0x65ab,
    0xffff, 0xffff, 0x65ac, 0xffff, 0xefb0, 0x65ad, 0xbabf, 0xc1f9, 0x65ae, 0xffff, 0xc4ca, 0x65af, 0xffff, 0xffff, 0x65b0, 0xffff,
    0xffff, 0x65b1, 0xffff, 0x65b2, 0x65b3, 0xffff, 0x65b4, 0xb3bb, 0x65b5, 0x65bb, 0xffff, 0x65b6, 0xefae, 0xefaf, 0xc4c3, 0xffff,
    0xefad, 0xffff, 0xffff, 0xffff, 0x65b7, 0x65b8, 0x65b9, 0xffff, 0xffff, 0xefb1, 0x65ba, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x65bc, 0xffff, 0xefb7, 0x65bd, 0x65be, 0x65bf, 0x65c0, 0xefba, 0x65c1, 0x65c2, 0x65c3, 0x65c4, 0x65c5, 0xffff, 0xffff,
    0xefb9, 0xc5ad, 0xffff, 0x65c6, 0xffff, 0xffff, 0xefb2, 0xefb3, 0xefb6, 0x65c7, 0xffff, 0xffff, 0x65c8, 0xefb8, 0x65c9, 0x65ca,
    0xffff, 0xb6c0, 0x65cb, 0xffff, 0xefbb, 0xefb5, 0x65cc, 0x65cd, 0xefb4, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x65cf, 0x65d0, 0x65ce, 0x65d1, 0x65d2, 0xffff, 0x65d3,

    /* 0x94: 0x01 - 0x84 */
            0x65d4, 0x65d5, 0xefbf, 0x65d6, 0xffff, 0xffff, 0xefc0, 0x65d7, 0x65d8, 0xffff, 0xffff, 0xffff, 0x65d9, 0x65da, 0x65db,
    0xefc1, 0xffff, 0xffff, 0xefbe, 0xefbd, 0x65dc, 0x65dd, 0x65de, 0xbee2, 0xc6aa, 0xefbc, 0xffff, 0xffff, 0xffff, 0xffff, 0x65df,
    0xffff, 0xefc5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xefc3, 0xffff, 0xffff, 0x65e0, 0x65e1,
    0xffff, 0x65e2, 0x65e3, 0x65e4, 0x65e5, 0xefc4, 0xefc2, 0xffff, 0xc2f8, 0xffff, 0xefc6, 0x65e6, 0xffff, 0x65e8, 0xffff, 0x65e7,
    0xffff, 0xefc7, 0xffff, 0x65e9, 0xefc9, 0x65ea, 0xffff, 0xffff, 0x65eb, 0xffff, 0x65ec, 0xffff, 0x65ed, 0xffff, 0xffff, 0xffff,
    0xffff, 0xb4d5, 0xefc8, 0xccfa, 0xffff, 0x65ee, 0xffff, 0xffff, 0xffff, 0x65ef, 0xefd4, 0xefca, 0x65f0, 0xffff, 0xefcd, 0x65f1,
    0xefcb, 0x65f2, 0xefcc, 0x65f3, 0xffff, 0xffff, 0xffff, 0xffff, 0x65f4, 0xffff, 0xefce, 0x65f5, 0xffff, 0x65f6, 0x65f7, 0x65f8,
    0xefd0, 0x65f9, 0x65fa, 0xffff, 0xffff, 0xefd1, 0xffff, 0xefd2, 0xffff, 0xffff, 0xffff, 0xffff, 0xefd5, 0xefd3, 0xefd6, 0xefd8,
    0xffff, 0xefd7, 0xffff, 0x65fc, 0x65fb,

    /* 0x95: 0x77 - 0xe6 */
                                                            0xc4b9, 0x65fd, 0x65fe, 0xffff, 0xffff, 0xffff, 0xffff, 0x66a1, 0xffff,
    0xcce7, 0xffff, 0xefd9, 0xc1ae, 0x66a2, 0xffff, 0xffff, 0xefda, 0x66a3, 0xcac4, 0xefdb, 0xb3ab, 0x66a4, 0x66a5, 0x66a6, 0xb1bc,
    0xffff, 0xb4d7, 0xffff, 0xb4d6, 0xefdc, 0xffff, 0xefdd, 0xffff, 0xefde, 0xefdf, 0xffff, 0xffff, 0xffff, 0x66a7, 0x66a8, 0x66a9,
    0xefe0, 0x66aa, 0xb4d8, 0xb3d5, 0xb9de, 0xc8b6, 0x66ab, 0xefe2, 0xefe1, 0x66ac, 0xffff, 0x66ad, 0x66ae, 0xefe3, 0xffff, 0xffff,
    0xffff, 0xffff, 0xb1dc, 0xffff, 0x66af, 0xffff, 0x66b0, 0xffff, 0xffff, 0xefe6, 0x66b1, 0xefe5, 0xefe4, 0x66b2, 0xefe7, 0x66b3,
    0xffff, 0xffff, 0xffff, 0xefea, 0xffff, 0xffff, 0x66b4, 0xb0c7, 0x66b5, 0x66b6, 0xefe8, 0x66b7, 0xefec, 0xefeb, 0xffff, 0xffff,
    0x66b8, 0x66b9, 0x66ba, 0x66bb, 0xefee, 0xefed, 0xefef, 0xffff, 0xc6ae, 0x66bc, 0x66bd, 0xffff, 0xeff0, 0x66be, 0x66bf, 0x66c0,
    0x66c1, 0xeff1, 0xeff3, 0xffff, 0x66c2, 0xeff2, 0x66c3,

    /* 0x96: 0x1c - 0xfb */
                                                                                                    0xc9ec, 0x66c4, 0x66c5, 0xffff,
    0xffff, 0xeff4, 0x66c6, 0xffff, 0x66c7, 0x66c8, 0x66c9, 0xffff, 0xeff5, 0xffff, 0xbae5, 0xffff, 0x66ca, 0xffff, 0xeff6, 0xeff7,
    0xffff, 0x66cb, 0xcbc9, 0x66cc, 0xffff, 0xffff, 0xffff, 0x66cd, 0x66ce, 0x66cf, 0x66d0, 0xc1cb, 0x66d1, 0x66d2, 0xffff, 0xb0a4,
    0xc2cb, 0x66d3, 0xeff8, 0xffff, 0xc9ed, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xeffb, 0xeff9, 0xb9df, 0xffff, 0xeffa,
    0xb8c2, 0xffff, 0x66d4, 0xffff, 0x66d5, 0xffff, 0x66d6, 0x66d7, 0x66d8, 0xffff, 0xffff, 0xcac5, 0xeffd, 0xf0a1, 0xeffe, 0xf0a2,
    0xffff, 0x66d9, 0xb1a1, 0xbfd8, 0xbdfc, 0xb4d9, 0xf0a3, 0xffff, 0xffff, 0xffff, 0xc7e6, 0xffff, 0xf0a5, 0xffff, 0x66da, 0xffff,
    0xb1a2, 0xffff, 0xf0a4, 0xc4c4, 0x66db, 0xcecd, 0xc6ab, 0xeffc, 0xcea6, 0xffff, 0xb8b1, 0x66dc, 0x66dd, 0xcddb, 0x66de, 0x66df,
    0xffff, 0x66e0, 0x66e1, 0x66e2, 0x66e3, 0xb6f9, 0xceb4, 0xffff, 0xb7a8, 0x66e4, 0xc2e2, 0xe7a1, 0xffff, 0xf0a6, 0xb3ac, 0xbfef,
    0xffff, 0x66e5, 0xffff, 0xffff, 0xb3d6, 0xf0a8, 0x66e6, 0xf0a9, 0xf0a7, 0xb7e4, 0x66e7, 0xbadd, 0xbee3, 0x66e8, 0xffff, 0x66e9,
    0xb1a3, 0xffff, 0xffff, 0xced9, 0x66ea, 0x66eb, 0x66ec, 0xf0ab, 0xeeae, 0x66ed, 0xf0aa, 0xffff, 0xffff, 0xffff, 0x66ee, 0x66ef,
    0xf0ae, 0xf0ac, 0xf0ad, 0x66f0, 0xf0af, 0xffff, 0xf0b0, 0xceec, 0xf0b1, 0xf0b2, 0x66f1, 0xc0c9, 0xc8bb, 0xffff, 0xffff, 0xffff,
    0xbffd, 0xb4e7, 0xffff, 0xffff, 0xcdba, 0xb2ed, 0xbdb8, 0xb8db, 0xffff, 0xf0b5, 0x66f2, 0xf0b4, 0xbbf3, 0xf0b6, 0xf0b3, 0xffff,
    0xffff, 0xbba8, 0x66f3, 0xffff, 0xffff, 0xf0ba, 0xeaad, 0xffff, 0x66f5, 0xd2d6, 0x66f6, 0xbff7, 0xf0b8, 0x66f7, 0x66f8, 0x66f9,
    0xffff, 0xffff, 0xcea5, 0xc6f1, 0xffff, 0xffff, 0xffff, 0xffff, 0xb1ab, 0x66fa, 0xc0e3, 0xbcb6, 0xffff, 0xffff, 0xffff, 0x66fb,
    0xcab7, 0x66fc, 0xb1c0, 0xffff, 0xffff, 0xffff, 0xceed, 0xcdeb, 0xffff, 0xf0bb, 0x66fd, 0xc5c5,

    /* 0x97: 0x00 - 0xff */
    0xbcfb, 0xffff, 0x66fe, 0x67a1, 0xf0bc, 0x67a2, 0xf0bd, 0xbfcc, 0xf0be, 0x67a3, 0xceee, 0xffff, 0xffff, 0xf0b9, 0xf0c0, 0xf0c2,
    0xffff, 0xf0c1, 0xffff, 0xf0bf, 0xffff, 0xffff, 0xf0c3, 0xffff, 0xffff, 0xf0c4, 0x67a4, 0x67a5, 0xc1fa, 0x67a6, 0xb2e2, 0xffff,
    0xffff, 0x67a7, 0x67a8, 0x67a9, 0xf0c5, 0xffff, 0xffff, 0xccb8, 0x67aa, 0xffff, 0xf0c6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xf0c7, 0x67ab, 0xcfaa, 0x67ac, 0xffff, 0xffff, 0xffff, 0xffff, 0xdbb1, 0xf0c8, 0xffff, 0xffff, 0xffff, 0xf0c9, 0xf0ca, 0xffff,
    0xffff, 0x67ad, 0xf0ce, 0x67ae, 0xf0cb, 0xffff, 0xf0cc, 0xffff, 0xf0cd, 0xf0cf, 0x67af, 0xffff, 0xffff, 0xffff, 0x67b0, 0x67b1,
    0xffff, 0xffff, 0xc0c4, 0xffff, 0xffff, 0x67b2, 0xccf7, 0x67b3, 0x67b4, 0xc0c5, 0x67b5, 0x67b6, 0xf0d0, 0xffff, 0xc8f3, 0xffff,
    0xf0d1, 0xf3d3, 0xcccc, 0x67b7, 0xf0d2, 0xffff, 0xf0d3, 0x67b8, 0xf0d4, 0xb3d7, 0x67b9, 0xf0d6, 0xffff, 0xbfd9, 0x67ba, 0xffff,
    0xffff, 0xf0d7, 0xffff, 0x67bb, 0xb7a4, 0xffff, 0x67bc, 0x67bd, 0x67be, 0xf0d8, 0xf0dc, 0x67bf, 0xf0da, 0x67c0, 0xffff, 0x67c1,
    0x67c2, 0xf0db, 0xffff, 0xffff, 0xb3f3, 0xf0d9, 0xf0dd, 0xffff, 0xffff, 0x67c3, 0xffff, 0xf0de, 0xffff, 0xb0c8, 0xffff, 0xf0df,
    0xf0e0, 0xffff, 0xffff, 0xffff, 0xffff, 0x67c4, 0x67c5, 0x67c6, 0xbee4, 0x67c7, 0x67c8, 0xffff, 0xf0e1, 0xffff, 0x67c9, 0x67ca,
    0xb5c7, 0xffff, 0x67cb, 0xf0e4, 0xffff, 0xffff, 0xf0e3, 0xffff, 0xf0e2, 0xffff, 0xffff, 0xebf1, 0x67cc, 0xcadc, 0x67cd, 0xffff,
    0xffff, 0x67ce, 0x67cf, 0xf0e5, 0xf0e6, 0x67d0, 0x67d1, 0xffff, 0x67d2, 0x67d3, 0x67d4, 0xffff, 0x67d5, 0xffff, 0x67d6, 0x67d7,
    0xffff, 0x67d8, 0xffff, 0xf0e7, 0x67d9, 0x67da, 0xf0e8, 0x67db, 0xf0e9, 0x67dc, 0x67dd, 0xf0ea, 0x67de, 0x67df, 0x67e0, 0xffff,
    0x67e1, 0x67e2, 0xffff, 0xb4da, 0x67e3, 0xffff, 0xffff, 0x67e4, 0x67e5, 0x67e6, 0xffff, 0x67ea, 0xf0eb, 0x67e7, 0x67e8, 0xffff,
    0x67e9, 0x67eb, 0xffff, 0xffff, 0x67ec, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf0ec, 0xc7a3, 0x67ed,
    0xffff, 0x67ee, 0xf0ee, 0xb2bb, 0x67ef, 0xf0f1, 0xf0f0, 0x67f0, 0x67f1, 0xffff, 0x67f2, 0xb1a4, 0xffff, 0xffff, 0xffff, 0xb6c1,

    /* 0x98: 0x01 - 0xfe */
            0xcac7, 0xc4ba, 0xbaa2, 0xffff, 0xb9e0, 0xbde7, 0x67f3, 0xbfdc, 0xffff, 0x67f4, 0xffff, 0xf0f3, 0x67f6, 0x67f7, 0xf0f2,
    0xcdc2, 0xb4e8, 0xc8d2, 0xc6dc, 0x67f8, 0xffff, 0x67f9, 0xbffc, 0xcece, 0x67f5, 0xb7db, 0xffff, 0x67fa, 0xffff, 0x67fb, 0xffff,
    0x67fc, 0xf0f6, 0xffff, 0x67fd, 0xf0f5, 0x68a8, 0x67fe, 0xffff, 0xffff, 0xffff, 0xffff, 0x68a1, 0xcbcb, 0xc6ac, 0x68a2, 0x68a3,
    0x68a4, 0xffff, 0x68a5, 0x68a6, 0xb1d0, 0x68a7, 0xffff, 0xf0f7, 0xf0f4, 0xffff, 0xffff, 0xc9d1, 0xcdea, 0xf0f8, 0x68a9, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0x68aa, 0xffff, 0xf0f9, 0x68ab, 0xffff, 0xffff, 0x68ac, 0xf0fb, 0xc2ea, 0xb3db, 0xb3dc, 0xf0fa,
    0xffff, 0x68ad, 0x68ae, 0x68af, 0xb4e9, 0xb8b2, 0x68b0, 0x68b1, 0xb4ea, 0x68b2, 0x68b3, 0xc5bf, 0xffff, 0xffff, 0xcee0, 0xffff,
    0xffff, 0xffff, 0x68b4, 0x68b5, 0xffff, 0x68b6, 0x68b7, 0xb8dc, 0xffff, 0xffff, 0x68b8, 0xf0fc, 0x68b9, 0xffff, 0xffff, 0xf0fd,
    0xf0fe, 0xf1a1, 0xffff, 0xf1a3, 0xf1a2, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc9f7, 0xffff, 0xf1a4, 0x68ba, 0xffff, 0x68bb, 0x68bc, 0xf1a5,
    0x68bd, 0xf1a6, 0xffff, 0xffff, 0x68be, 0xffff, 0xf1a7, 0x68bf, 0x68c0, 0xffff, 0x68c1, 0x68c2, 0xffff, 0xffff, 0xffff, 0x68c3,
    0xffff, 0xffff, 0x68c4, 0xf1a9, 0xf1a8, 0x68c5, 0xf1aa, 0xffff, 0x68c6, 0xffff, 0xffff, 0xffff, 0x68c7, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc8f4, 0xe6cc, 0xffff, 0xffff, 0xbfa9,
    0xffff, 0x68c8, 0xb5b2, 0x68c9, 0xffff, 0x68ca, 0x68cb, 0x68cc, 0xffff, 0xf1ab, 0x68cd, 0xf1ac, 0xffff, 0xd2ac, 0xddbb, 0xc8d3,
    0xffff, 0xffff, 0xb0fb, 0x68ce, 0xb0bb, 0xffff, 0x68cf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbbf4, 0xcbb0, 0xbefe,

    /* 0x99: 0x02 - 0xff */
                    0x68d0, 0xf1ad, 0xffff, 0xccdf, 0xffff, 0x68d1, 0x68d2, 0xf1ae, 0xcddc, 0xffff, 0xb1c2, 0xffff, 0xffff, 0xffff,
    0xbbc1, 0x68d3, 0xf1af, 0xb2ee, 0xf1b0, 0x68d4, 0x68d5, 0x68d6, 0xf1b1, 0xffff, 0x68d7, 0x68d8, 0x68d9, 0xf1b3, 0xf1b4, 0x68da,
    0xf1b6, 0xf1b2, 0x68db, 0xffff, 0xf1b5, 0xffff, 0x68dc, 0x68dd, 0xb4db, 0xffff, 0xffff, 0x68de, 0xf1b7, 0xffff, 0xf1b8, 0xffff,
    0xffff, 0x68df, 0x68e0, 0x68e1, 0x68e2, 0x68e3, 0xffff, 0xffff, 0xffff, 0x68e4, 0x68e5, 0x68e6, 0x68e7, 0xf1b9, 0xf1ba, 0xffff,
    0x68e8, 0x68e9, 0xf1bb, 0xffff, 0xffff, 0xf1bd, 0x68ea, 0x68eb, 0x68ec, 0xf1bc, 0xffff, 0xf1bf, 0xf1c2, 0x68ed, 0x68ee, 0xffff,
    0xf1be, 0xf1c0, 0xf1c1, 0xffff, 0x68ef, 0xf1c3, 0xffff, 0xb6c2, 0x68f0, 0x68f1, 0xffff, 0x68f2, 0x68f3, 0xffff, 0x68f4, 0x68f5,
    0x68f6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xbcf3, 0xf1c4, 0xf1c5, 0xb9e1, 0xffff, 0x68f7, 0xffff, 0x68f8, 0xffff, 0x68f9,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf1c6, 0x68fa, 0xffff, 0xb3be, 0xffff, 0xffff, 0xffff, 0xc7cf, 0xf1c7, 0xf1c8, 0xffff,
    0x68fb, 0x68fc, 0x68fd, 0xc3da, 0xc6eb, 0x68fe, 0xffff, 0xffff, 0xffff, 0x69a1, 0x69a2, 0xffff, 0xf1c9, 0x69a3, 0xffff, 0x69a4,
    0xffff, 0xc7fd, 0xffff, 0x69a5, 0xc2cc, 0xb1d8, 0xb6ee, 0xffff, 0xb6ef, 0x69a6, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xc3f3, 0xf1ce, 0xb6f0, 0x69a7, 0x69a8, 0xb2ef, 0xffff, 0xffff, 0xf1cd, 0x69a9, 0x69aa, 0xf1cb, 0x69ab, 0xf1cc, 0x69ac, 0xf1ca,
    0xffff, 0xffff, 0xf1d8, 0xffff, 0xffff, 0xffff, 0xffff, 0x69ad, 0xffff, 0xffff, 0x69ae, 0x69af, 0x69b0, 0xf1cf, 0xf1d0, 0xffff,
    0x69b1, 0xf1d1, 0xf1d2, 0xffff, 0x69b2, 0x69b3, 0xffff, 0xffff, 0xf1d4, 0x69b4, 0xffff, 0xf1d3, 0xffff, 0x69b5, 0x69b6, 0xbdd9,

    /* 0x9a: 0x01 - 0xff */
            0xf1d5, 0x69b7, 0x69b8, 0x69b9, 0xf1d7, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x69ba, 0x69bb, 0xffff, 0xb5b3, 0xf1d6,
    0x69bc, 0x69bd, 0xc1fb, 0xb8b3, 0xffff, 0xffff, 0x69be, 0xffff, 0xffff, 0xf1d9, 0xffff, 0xffff, 0xffff, 0xffff, 0x69bf, 0xffff,
    0x69c0, 0xffff, 0x69c1, 0x69c2, 0x69c3, 0xffff, 0xffff, 0x69c4, 0xc2cd, 0xffff, 0xffff, 0xf1da, 0xffff, 0x69c5, 0x69c6, 0xffff,
    0xc6ad, 0xffff, 0xffff, 0x69c7, 0xffff, 0x69c8, 0x69c9, 0xf1db, 0x69ca, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf1e0, 0xffff,
    0xf1de, 0x69cc, 0xf1dd, 0xf1df, 0x69cd, 0xf1dc, 0xffff, 0x69cb, 0xffff, 0xffff, 0x69ce, 0x69cf, 0x69d0, 0xf1e2, 0x69d1, 0xffff,
    0xffff, 0x69d2, 0xffff, 0xffff, 0x69d3, 0xf1e1, 0x69d4, 0xf1e4, 0xffff, 0xffff, 0xb6c3, 0xf1e3, 0xffff, 0x69d5, 0xffff, 0xf1e5,
    0xffff, 0xffff, 0xf1e6, 0xffff, 0xf1e8, 0xf1e7, 0xffff, 0xffff, 0xffff, 0xf1e9, 0xf1eb, 0xf1ea, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xb9fc, 0xffff, 0x69d6, 0xffff, 0x69d7, 0xf1ec, 0x69d8, 0x69d9,
    0xf1ed, 0xffff, 0x69da, 0xffff, 0x69db, 0x69dc, 0x69dd, 0xffff, 0xb3bc, 0x69de, 0xffff, 0x69df, 0xf1ee, 0xffff, 0x69e0, 0x69e1,
    0xf1ef, 0x69e2, 0xffff, 0x69e3, 0xbff1, 0xffff, 0x69e4, 0xffff, 0x69e5, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x69e6, 0xf1f0,
    0x69e7, 0xf1f1, 0x69e8, 0xf1f2, 0xf1f3, 0x69e9, 0x69ea, 0x69eb, 0xb9e2, 0xffff, 0xffff, 0x69ec, 0x69ed, 0xffff, 0xf1f4, 0xf1f5,
    0x69ee, 0xffff, 0xf1f6, 0xf1f7, 0x69ef, 0x69f0, 0xf1f8, 0x69f1, 0xffff, 0x69f2, 0xc8b1, 0xf1fa, 0x69f3, 0xc9a6, 0xf1fb, 0xf1f9,
    0xffff, 0xf1fd, 0x69f4, 0x69f5, 0xf1fc, 0x69f6, 0xffff, 0xf1fe, 0xffff, 0x69f7, 0x69f8, 0xf2a1, 0xffff, 0x69f9, 0xffff, 0x69fa,

    /* 0x9b: 0x00 - 0xff */
    0x69fb, 0x69fc, 0x69fd, 0x69fe, 0x6aa1, 0x6aa2, 0xf2a2, 0xffff, 0x6aa3, 0x6aa4, 0xffff, 0x6aa5, 0x6aa6, 0x6aa7, 0x6aa8, 0xffff,
    0x6aa9, 0xffff, 0x6aaa, 0xffff, 0xffff, 0xffff, 0x6aab, 0xffff, 0xf2a3, 0x6aac, 0xf2a4, 0x6aad, 0x6aae, 0xffff, 0xffff, 0xf2a5,
    0x6aaf, 0xffff, 0xf2a6, 0xf2a7, 0xffff, 0xf2a8, 0x6ab0, 0xf2a9, 0xf2aa, 0xf2ab, 0xf2ac, 0x6ab1, 0xffff, 0x6ab2, 0xf2ad, 0xf2ae,
    0xffff, 0xddb5, 0xf2af, 0x6ab3, 0x6ab4, 0x6ab5, 0xffff, 0x6ab6, 0xffff, 0x6ab7, 0x6ab8, 0xe4f8, 0xb5b4, 0x6ab9, 0xffff, 0xffff,
    0xffff, 0xb3a1, 0xbab2, 0xf2b1, 0xf2b0, 0xcca5, 0xffff, 0xffff, 0x6aba, 0xffff, 0xffff, 0x6abb, 0x6abc, 0xf2b3, 0xf2b4, 0xf2b2,
    0xffff, 0xf2b5, 0xffff, 0xffff, 0xcbe2, 0x6abd, 0x6abe, 0x6abf, 0xf2b6, 0xffff, 0xb5fb, 0x6ac0, 0xffff, 0xffff, 0x6ac1, 0xffff,
    0xffff, 0x6ac2, 0xffff, 0x6ac3, 0xffff, 0x6ac4, 0x6ac5, 0xffff, 0x6ac6, 0xffff, 0x6ac7, 0x6ac8, 0x6ac9, 0x6aca, 0x6acb, 0xcfa5,
    0xffff, 0xffff, 0xffff, 0x6acc, 0xf2b7, 0x6acd, 0xffff, 0x6ace, 0x6acf, 0x6ad0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6ad1,
    0x6ad2, 0xffff, 0xffff, 0xf2b9, 0x6ad3, 0x6ad4, 0x6ad5, 0x6ad6, 0xffff, 0x6ad7, 0x6ad8, 0x6ad9, 0xffff, 0x6ada, 0xb0be, 0x6adb,
    0x6adc, 0xf2ba, 0xcaab, 0xf2b8, 0x6add, 0xffff, 0xf2bb, 0xf2bc, 0xffff, 0xffff, 0x6ade, 0xffff, 0xffff, 0x6adf, 0x6ae0, 0xf2bd,
    0xf2be, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6ae1, 0x6ae2, 0xf2bf, 0x6ae3, 0xcbee, 0xbbad, 0x6ae4, 0xbafa, 0xc1af, 0xffff,
    0x6ae5, 0x6ae6, 0x6ae7, 0xffff, 0xf2c0, 0xffff, 0xffff, 0x6ae8, 0x6ae9, 0xf2c3, 0xffff, 0x6aea, 0x6aeb, 0xffff, 0x6aec, 0x6aed,
    0xf2c1, 0x6aee, 0xffff, 0xffff, 0xffff, 0xffff, 0xf2c4, 0x6aef, 0x6af0, 0xb8f1, 0xf2c2, 0xffff, 0xffff, 0xffff, 0x6af1, 0xf2c5,
    0x6af2, 0xf2c6, 0xf2c7, 0xffff, 0xf2cb, 0xffff, 0xbbaa, 0x6af3, 0x6af4, 0xffff, 0xffff, 0xc2e4, 0xffff, 0x6af5, 0xffff, 0x6af6,
    0xffff, 0xf2cc, 0xf2c9, 0xf2c8, 0xf2ca, 0x6af7, 0xffff, 0x6af8, 0xb7df, 0xffff, 0x6af9, 0x6afa, 0xffff, 0xffff, 0xffff, 0x6afb,
    0xf2d0, 0xf2cf, 0xf2ce, 0x6afc, 0xffff, 0xb0b3, 0xffff, 0x6afd, 0x6afe, 0x6ba1, 0x6ba2, 0xffff, 0xffff, 0x6ba3, 0xffff, 0x6ba4,

    /* 0x9c: 0x00 - 0xf9 */
    0x6ba5, 0xffff, 0x6ba6, 0xffff, 0xf2da, 0xffff, 0xf2d6, 0xffff, 0xf2d7, 0xf2d3, 0xf2d9, 0x6ba7, 0xf2d5, 0xb3e2, 0xffff, 0x6ba8,
    0xcfcc, 0x6ba9, 0xf2d8, 0xf2d4, 0xf2d2, 0xf2d1, 0x6baa, 0xffff, 0x6bab, 0x6bac, 0x6bad, 0xf2dc, 0x6bae, 0xffff, 0x6baf, 0xffff,
    0xffff, 0xf2df, 0x6bb0, 0x6bb1, 0xf2de, 0xf2dd, 0x6bb2, 0x6bb3, 0x6bb4, 0x6bb5, 0x6bb6, 0xffff, 0xffff, 0xc9c9, 0xf2db, 0xb0f3,
    0xf2e0, 0x6bb7, 0xf2e2, 0xffff, 0xffff, 0x6bb8, 0x6bb9, 0x6bba, 0xffff, 0xb3ef, 0xf2cd, 0xb1b7, 0xffff, 0x6bbb, 0xf2e4, 0xffff,
    0xffff, 0x6bbc, 0xffff, 0x6bbd, 0x6bbe, 0x6bbf, 0xf2e3, 0xf2e1, 0xc3ad, 0x6bc0, 0x6bc1, 0xffff, 0xffff, 0xffff, 0x6bc2, 0x6bc3,
    0x6bc4, 0xffff, 0xcbf0, 0x6bc5, 0x6bc6, 0xffff, 0x6bc7, 0xceda, 0x6bc8, 0xffff, 0xf2e5, 0x6bc9, 0x6bd0, 0x6bca, 0x6bcb, 0x6bcc,
    0xf2e6, 0xffff, 0xffff, 0x6bcd, 0xffff, 0xffff, 0xffff, 0xf2e7, 0x6bd2, 0x6bce, 0x6bcf, 0x6bd1, 0xffff, 0xffff, 0x6bd3, 0xffff,
    0x6bd4, 0xffff, 0x6bd5, 0xffff, 0xffff, 0x6bd6, 0xf2e8, 0x6bd7, 0xf2e9, 0xffff, 0xffff, 0x6bd8, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xc4bb, 0x6bd9, 0xf2ea, 0xffff, 0xc8b7, 0xffff, 0xf2ef, 0xf2eb, 0xffff, 0xffff, 0xffff,
    0xf2ec, 0xffff, 0x6bda, 0xcbb1, 0xccc4, 0xffff, 0xc6d0, 0x6bdb, 0xffff, 0x6bdc,

    /* 0x9d: 0x02 - 0xfe */
                    0x6bde, 0xf2f0, 0xffff, 0xffff, 0xf2f1, 0xc6be, 0xf2ee, 0xf2ed, 0xffff, 0x6bdd, 0xffff, 0xffff, 0xb2aa, 0xffff,
    0xffff, 0x6bdf, 0xf2f9, 0xffff, 0xffff, 0xf2f8, 0xffff, 0x6be0, 0x6be1, 0xffff, 0xffff, 0xb1f5, 0x6be2, 0x6be3, 0x6be4, 0xf2f6,
    0xffff, 0xffff, 0xffff, 0xf2f5, 0xffff, 0xffff, 0xf2f3, 0xffff, 0xb3fb, 0xffff, 0xf2f2, 0xbcb2, 0xb2a9, 0xffff, 0xffff, 0x6be5,
    0x6be6, 0xffff, 0x6be7, 0x6be8, 0x6be9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x6bea, 0xb9e3, 0x6beb, 0x6bed, 0xf2fc, 0xf2fb,
    0xffff, 0xf2fa, 0x6bee, 0x6bef, 0xf2f7, 0x6bec, 0xf2fd, 0x6bf0, 0xf2fe, 0xffff, 0x6bf1, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xf3a5, 0xf3a4, 0xffff, 0x6bf2, 0x6bf3, 0xffff, 0xffff, 0xffff, 0xffff, 0xf3a6, 0xffff, 0xffff, 0xb1ad, 0xf3a1, 0xf3a2, 0x6bf4,
    0xb9f4, 0xccb9, 0x6bf6, 0x6bf5, 0xf3a3, 0x6bf7, 0xffff, 0xffff, 0xffff, 0x6bf8, 0x6bf9, 0x6bfa, 0xcbb2, 0xffff, 0xffff, 0xf3ab,
    0x6bfb, 0xffff, 0xf3a7, 0xffff, 0xffff, 0xffff, 0x6bfc, 0x6bfd, 0xffff, 0xffff, 0xf3ac, 0x6bfe, 0x6ca1, 0xffff, 0x6ca2, 0xffff,
    0xffff, 0xffff, 0xffff, 0x6ca3, 0x6ca4, 0xffff, 0x6ca5, 0xf3a9, 0xffff, 0xf3a8, 0x6ca6, 0xffff, 0xffff, 0x6ca7, 0x6ca8, 0xb7dc,
    0xffff, 0xffff, 0x6ca9, 0x6caa, 0xffff, 0x6cab, 0x6cac, 0x6cad, 0x6cae, 0xffff, 0xf3ad, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x6caf, 0xffff, 0xffff, 0xf3ae, 0xffff, 0xffff, 0xffff, 0xffff, 0xf3af, 0x6cb0, 0xf3aa, 0x6cb1, 0xffff, 0x6cb2, 0xf2f4,
    0xffff, 0x6cb3, 0xf3b0, 0xffff, 0xc4e1, 0x6cb4, 0xffff, 0xffff, 0xf3b4, 0x6cb5, 0xf3b5, 0xf3b3, 0x6cb6, 0xffff, 0xffff, 0x6cb7,
    0xffff, 0xf3b2, 0xf3b8, 0x6cb8, 0xf3b1, 0xffff, 0xf3b6, 0x6cb9, 0xffff, 0x6cba, 0x6cbb, 0xffff, 0xffff, 0xffff, 0xffff, 0xf3b7,
    0xffff, 0xffff, 0xffff, 0xf3ba, 0x6cbc, 0x6cbd, 0x6cbe, 0x6cbf, 0xffff, 0xf3b9, 0x6cc0, 0xffff, 0xffff, 0xffff, 0x6cc1, 0x6cc2,
    0x6cc3, 0xffff, 0xffff, 0xffff, 0xffff, 0x6cc4, 0xf3bc, 0x6cc5, 0xffff, 0x6cc6, 0xffff, 0x6cc7, 0xffff, 0xf3bd, 0x6cc8, 0xf3be,
    0x6cc9, 0xffff, 0xcfc9, 0x6cca, 0x6ccb, 0xffff, 0xffff, 0xffff, 0xf3bb, 0xc2eb, 0xbaed, 0xffff, 0xffff, 0xf3bf, 0x6ccc,

    /* 0x9e: 0x02 - 0xff */
                    0x6cce, 0xffff, 0xffff, 0xffff, 0xffff, 0x6ccf, 0xffff, 0xffff, 0x6ccd, 0xffff, 0xffff, 0xffff, 0x6cd0, 0xffff,
    0x6cd1, 0x6cd2, 0x6cd3, 0xffff, 0xffff, 0x6cd4, 0x6cd5, 0xffff, 0xffff, 0x6cd6, 0xf3c0, 0xf3c1, 0x6cd7, 0x6cd8, 0xf3c2, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xf3c3, 0xffff, 0xffff, 0xb8b4, 0xf3c4, 0x6cd9, 0x6cda, 0x6cdb, 0xf3c5, 0xffff, 0xbcaf,
    0x6cdc, 0xf3c6, 0x6cdd, 0x6cde, 0x6cdf, 0x6ce0, 0xffff, 0x6ce1, 0xf3c7, 0xffff, 0xffff, 0xf3c8, 0xf3c9, 0xffff, 0x6ce2, 0x6ce3,
    0xffff, 0xf3cc, 0xf3ca, 0xcfbc, 0xffff, 0xf3cb, 0x6ce4, 0xceef, 0x6ce5, 0xffff, 0xffff, 0x6ce6, 0xffff, 0xf3cd, 0x6ce7, 0xcedb,
    0xffff, 0xffff, 0xffff, 0xffff, 0x6ce8, 0xf3ce, 0xc7fe, 0xffff, 0x6ce9, 0xf3cf, 0xf3d1, 0xffff, 0x6cea, 0xf3d2, 0x6ceb, 0x6cec,
    0x6ced, 0xffff, 0xffff, 0x6cee, 0x6cef, 0x6cf0, 0xffff, 0xffff, 0xf3d0, 0xb9ed, 0xcccd, 0xcbe3, 0xd6f7, 0xffff, 0xdde0, 0xcbfb,
    0xffff, 0xffff, 0xffff, 0xffff, 0xb2ab, 0xffff, 0x6cf1, 0xffff, 0x6cf2, 0xffff, 0xffff, 0x6cf3, 0xf3d4, 0xb5d0, 0xf3d5, 0xf3d6,
    0xf3d7, 0xffff, 0xb9f5, 0xffff, 0xf3d8, 0x6cf4, 0xffff, 0xffff, 0xe0d4, 0xccdb, 0xffff, 0xc2e3, 0xf3d9, 0xf3db, 0xf3da, 0x6cf5,
    0xf3dc, 0xffff, 0xffff, 0xffff, 0x6cf6, 0xf3dd, 0xffff, 0x6cf7, 0xf3de, 0xffff, 0xffff, 0xffff, 0x6cf8, 0x6cf9, 0x6cfa, 0xf3df,
    0x6cfb, 0x6cfc, 0x6cfd, 0xffff, 0xf3e0, 0x6cfe, 0xf3e1, 0xf3e2, 0x6da1, 0xf3e3, 0xffff, 0xf3e4, 0xf3e5, 0xf3e6, 0xffff, 0x6da2,

    /* 0x9f: 0x02 - 0xa5 */
                    0x6da3, 0x6da4, 0xffff, 0xffff, 0xffff, 0xf3e7, 0xf3e8, 0x6da5, 0xffff, 0xffff, 0xffff, 0xffff, 0xc5a4, 0x6da6,
    0x6da7, 0x6da8, 0x6da9, 0xb8dd, 0x6daa, 0xf3ea, 0x6dab, 0x6dac, 0xffff, 0x6dad, 0x6dae, 0x6daf, 0xffff, 0xffff, 0xffff, 0x6db0,
    0xc1cd, 0xf3eb, 0x6db1, 0xffff, 0xffff, 0xffff, 0x6db2, 0xffff, 0xffff, 0xffff, 0x6db3, 0x6db4, 0xf3ec, 0xffff, 0xffff, 0x6db5,
    0xffff, 0x6db6, 0x6db7, 0xffff, 0x6db8, 0xffff, 0xffff, 0x6db9, 0xffff, 0x6dba, 0x6dbb, 0xc9a1, 0x6dbc, 0x6dbd, 0xf3ed, 0x6dbe,
    0xffff, 0x6dbf, 0xffff, 0x6dc0, 0x6dc1, 0x6dc2, 0x6dc3, 0x6dc4, 0xffff, 0xffff, 0xf3ee, 0xe3b7, 0xffff, 0xffff, 0xecda, 0xf0ed,
    0xffff, 0xffff, 0xf3ef, 0x6dc5, 0xf3f0, 0x6dc6, 0x6dc7, 0x6dc8, 0x6dc9, 0xffff, 0x6dca, 0xffff, 0xffff, 0x6dcb, 0x6dcc, 0xf3f2,
    0xf3f3, 0xf3f4, 0xcef0, 0xf3f1, 0xffff, 0xffff, 0xf3f5, 0xf3f6, 0x6dcd, 0x6dce, 0xf3f8, 0xffff, 0xf3f7, 0x6dcf, 0x6dd0, 0x6dd1,
    0x6dd2, 0x6dd3, 0xf3fa, 0x6dd4, 0xffff, 0x6dd5, 0xf3fb, 0xf3f9, 0xffff, 0xffff, 0x6dd6, 0xffff, 0xffff, 0x6dd7, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xceb6, 0xffff, 0x6dd8,
    0x6dd9, 0x6dda, 0x6ddb, 0xffff, 0x6ddc, 0xf3fc, 0x6ddd, 0x6dde, 0xffff, 0xffff, 0xffff, 0xffff, 0xf3fd, 0xe3d4, 0x6ddf, 0xffff,
    0xf3fe, 0x6de0, 0x6de1, 0x6de2, 0xffff, 0x6de3,
};
static const struct jis_charmap __euc_jp_unicode_map[] = {
    { .first = 0xa1, .last = 0xff, .offset =     0 }, /* 0x0 */
    { .first = 0x00, .last = 0xf5, .offset =    95 }, /* 0x1 */
    { .first = 0xc7, .last = 0xdd, .offset =   341 }, /* 0x2 */
    { .first = 0x84, .last = 0xce, .offset =   364 }, /* 0x3 */
    { .first = 0x01, .last = 0x5f, .offset =   439 }, /* 0x4 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x5 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x6 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x7 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x8 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xb */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xc */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xd */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xe */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xf */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x10 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x11 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x12 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x13 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x14 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x15 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x16 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x17 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x18 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x19 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x1a */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x1b */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x1c */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x1d */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x1e */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x1f */
    { .first = 0x10, .last = 0x3e, .offset =   534 }, /* 0x20 */
    { .first = 0x03, .last = 0xd4, .offset =   581 }, /* 0x21 */
    { .first = 0x00, .last = 0xa5, .offset =   791 }, /* 0x22 */
    { .first = 0x12, .last = 0x12, .offset =   957 }, /* 0x23 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x24 */
    { .first = 0x00, .last = 0xef, .offset =   958 }, /* 0x25 */
    { .first = 0x05, .last = 0x6f, .offset =  1198 }, /* 0x26 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x27 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x28 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x29 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x2a */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x2b */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x2c */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x2d */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x2e */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x2f */
    { .first = 0x00, .last = 0xfe, .offset =  1305 }, /* 0x30 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x31 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x32 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x33 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x34 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x35 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x36 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x37 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x38 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x39 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x3a */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x3b */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x3c */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x3d */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x3e */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x3f */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x40 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x41 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x42 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x43 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x44 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x45 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x46 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x47 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x48 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x49 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x4a */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x4b */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x4c */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x4d */
    { .first = 0x00, .last = 0xff, .offset =  1560 }, /* 0x4e */
    { .first = 0x00, .last = 0xff, .offset =  1816 }, /* 0x4f */
    { .first = 0x00, .last = 0xfe, .offset =  2072 }, /* 0x50 */
    { .first = 0x00, .last = 0xfe, .offset =  2327 }, /* 0x51 */
    { .first = 0x00, .last = 0xff, .offset =  2582 }, /* 0x52 */
    { .first = 0x00, .last = 0xfa, .offset =  2838 }, /* 0x53 */
    { .first = 0x01, .last = 0xff, .offset =  3089 }, /* 0x54 */
    { .first = 0x00, .last = 0xff, .offset =  3344 }, /* 0x55 */
    { .first = 0x05, .last = 0xff, .offset =  3600 }, /* 0x56 */
    { .first = 0x00, .last = 0xff, .offset =  3851 }, /* 0x57 */
    { .first = 0x00, .last = 0xfd, .offset =  4107 }, /* 0x58 */
    { .first = 0x02, .last = 0xff, .offset =  4361 }, /* 0x59 */
    { .first = 0x00, .last = 0xfd, .offset =  4615 }, /* 0x5a */
    { .first = 0x00, .last = 0xff, .offset =  4869 }, /* 0x5b */
    { .first = 0x01, .last = 0xfd, .offset =  5125 }, /* 0x5c */
    { .first = 0x01, .last = 0xfe, .offset =  5378 }, /* 0x5d */
    { .first = 0x00, .last = 0xff, .offset =  5632 }, /* 0x5e */
    { .first = 0x01, .last = 0xff, .offset =  5888 }, /* 0x5f */
    { .first = 0x07, .last = 0xfd, .offset =  6143 }, /* 0x60 */
    { .first = 0x00, .last = 0xff, .offset =  6390 }, /* 0x61 */
    { .first = 0x00, .last = 0xff, .offset =  6646 }, /* 0x62 */
    { .first = 0x01, .last = 0xfa, .offset =  6902 }, /* 0x63 */
    { .first = 0x06, .last = 0xff, .offset =  7152 }, /* 0x64 */
    { .first = 0x00, .last = 0xff, .offset =  7402 }, /* 0x65 */
    { .first = 0x00, .last = 0xff, .offset =  7658 }, /* 0x66 */
    { .first = 0x00, .last = 0xff, .offset =  7914 }, /* 0x67 */
    { .first = 0x02, .last = 0xfd, .offset =  8170 }, /* 0x68 */
    { .first = 0x00, .last = 0xff, .offset =  8422 }, /* 0x69 */
    { .first = 0x00, .last = 0xfd, .offset =  8678 }, /* 0x6a */
    { .first = 0x02, .last = 0xff, .offset =  8932 }, /* 0x6b */
    { .first = 0x02, .last = 0xf4, .offset =  9186 }, /* 0x6c */
    { .first = 0x04, .last = 0xfc, .offset =  9429 }, /* 0x6d */
    { .first = 0x00, .last = 0xff, .offset =  9678 }, /* 0x6e */
    { .first = 0x01, .last = 0xfe, .offset =  9934 }, /* 0x6f */
    { .first = 0x00, .last = 0xfd, .offset = 10188 }, /* 0x70 */
    { .first = 0x03, .last = 0xff, .offset = 10442 }, /* 0x71 */
    { .first = 0x00, .last = 0xfe, .offset = 10695 }, /* 0x72 */
    { .first = 0x02, .last = 0xff, .offset = 10950 }, /* 0x73 */
    { .first = 0x00, .last = 0xff, .offset = 11204 }, /* 0x74 */
    { .first = 0x03, .last = 0xff, .offset = 11460 }, /* 0x75 */
    { .first = 0x00, .last = 0xfe, .offset = 11713 }, /* 0x76 */
    { .first = 0x00, .last = 0xfc, .offset = 11968 }, /* 0x77 */
    { .first = 0x02, .last = 0xff, .offset = 12221 }, /* 0x78 */
    { .first = 0x00, .last = 0xfc, .offset = 12475 }, /* 0x79 */
    { .first = 0x00, .last = 0xff, .offset = 12728 }, /* 0x7a */
    { .first = 0x02, .last = 0xfe, .offset = 12984 }, /* 0x7b */
    { .first = 0x00, .last = 0xfe, .offset = 13237 }, /* 0x7c */
    { .first = 0x00, .last = 0xfb, .offset = 13492 }, /* 0x7d */
    { .first = 0x00, .last = 0x9e, .offset = 13744 }, /* 0x7e */
    { .first = 0x36, .last = 0xff, .offset = 13903 }, /* 0x7f */
    { .first = 0x00, .last = 0xfe, .offset = 14105 }, /* 0x80 */
    { .first = 0x02, .last = 0xff, .offset = 14360 }, /* 0x81 */
    { .first = 0x00, .last = 0xfe, .offset = 14614 }, /* 0x82 */
    { .first = 0x00, .last = 0xfd, .offset = 14869 }, /* 0x83 */
    { .first = 0x01, .last = 0xff, .offset = 15123 }, /* 0x84 */
    { .first = 0x00, .last = 0xff, .offset = 15378 }, /* 0x85 */
    { .first = 0x00, .last = 0xfe, .offset = 15634 }, /* 0x86 */
    { .first = 0x00, .last = 0xff, .offset = 15889 }, /* 0x87 */
    { .first = 0x01, .last = 0xfe, .offset = 16145 + split_unicode_offset }, /* 0x88 */
    { .first = 0x01, .last = 0xff, .offset = 16399 + split_unicode_offset }, /* 0x89 */
    { .first = 0x00, .last = 0xff, .offset = 16654 + split_unicode_offset }, /* 0x8a */
    { .first = 0x00, .last = 0x9f, .offset = 16910 + split_unicode_offset }, /* 0x8b */
    { .first = 0x37, .last = 0xff, .offset = 17070 + split_unicode_offset }, /* 0x8c */
    { .first = 0x01, .last = 0xff, .offset = 17271 + split_unicode_offset }, /* 0x8d */
    { .first = 0x01, .last = 0xfe, .offset = 17526 + split_unicode_offset }, /* 0x8e */
    { .first = 0x00, .last = 0xfe, .offset = 17780 + split_unicode_offset }, /* 0x8f */
    { .first = 0x00, .last = 0xff, .offset = 18035 + split_unicode_offset }, /* 0x90 */
    { .first = 0x00, .last = 0xff, .offset = 18291 + split_unicode_offset }, /* 0x91 */
    { .first = 0x00, .last = 0xff, .offset = 18547 + split_unicode_offset }, /* 0x92 */
    { .first = 0x00, .last = 0xfd, .offset = 18803 + split_unicode_offset }, /* 0x93 */
    { .first = 0x01, .last = 0x84, .offset = 19057 + split_unicode_offset }, /* 0x94 */
    { .first = 0x77, .last = 0xe6, .offset = 19189 + split_unicode_offset }, /* 0x95 */
    { .first = 0x1c, .last = 0xfb, .offset = 19301 + split_unicode_offset }, /* 0x96 */
    { .first = 0x00, .last = 0xff, .offset = 19525 + split_unicode_offset }, /* 0x97 */
    { .first = 0x01, .last = 0xfe, .offset = 19781 + split_unicode_offset }, /* 0x98 */
    { .first = 0x02, .last = 0xff, .offset = 20035 + split_unicode_offset }, /* 0x99 */
    { .first = 0x01, .last = 0xff, .offset = 20289 + split_unicode_offset }, /* 0x9a */
    { .first = 0x00, .last = 0xff, .offset = 20544 + split_unicode_offset }, /* 0x9b */
    { .first = 0x00, .last = 0xf9, .offset = 20800 + split_unicode_offset }, /* 0x9c */
    { .first = 0x02, .last = 0xfe, .offset = 21050 + split_unicode_offset }, /* 0x9d */
    { .first = 0x02, .last = 0xff, .offset = 21303 + split_unicode_offset }, /* 0x9e */
    { .first = 0x02, .last = 0xa5, .offset = 21557 + split_unicode_offset }, /* 0x9f */
};
#endif /* unicode */

/* unicode_ff tables */
#ifdef define_unicode_ff

#define __euc_jp_unicode_ff_first_col 0x01
#define __euc_jp_unicode_ff_last_col 0xe5

#ifndef split_unicode_ff
#define split_unicode_ff_offset 0
#endif

static const uint16_t __euc_jp_unicode_ff_codes[] = {
    /* 0xff: 0x01 - 0xe5 */
            0xa1aa, 0xffff, 0xa1f4, 0xa1f0, 0xa1f3, 0xa1f5, 0xffff, 0xa1ca, 0xa1cb, 0xa1f6, 0xa1dc, 0xa1a4, 0xffff, 0xa1a5, 0xa1bf,
    0xa3b0, 0xa3b1, 0xa3b2, 0xa3b3, 0xa3b4, 0xa3b5, 0xa3b6, 0xa3b7, 0xa3b8, 0xa3b9, 0xa1a7, 0xa1a8, 0xa1e3, 0xa1e1, 0xa1e4, 0xa1a9,
    0xa1f7, 0xa3c1, 0xa3c2, 0xa3c3, 0xa3c4, 0xa3c5, 0xa3c6, 0xa3c7, 0xa3c8, 0xa3c9, 0xa3ca, 0xa3cb, 0xa3cc, 0xa3cd, 0xa3ce, 0xa3cf,
    0xa3d0, 0xa3d1, 0xa3d2, 0xa3d3, 0xa3d4, 0xa3d5, 0xa3d6, 0xa3d7, 0xa3d8, 0xa3d9, 0xa3da, 0xa1ce, 0xa1c0, 0xa1cf, 0xa1b0, 0xa1b2,
    0xa1ae, 0xa3e1, 0xa3e2, 0xa3e3, 0xa3e4, 0xa3e5, 0xa3e6, 0xa3e7, 0xa3e8, 0xa3e9, 0xa3ea, 0xa3eb, 0xa3ec, 0xa3ed, 0xa3ee, 0xa3ef,
    0xa3f0, 0xa3f1, 0xa3f2, 0xa3f3, 0xa3f4, 0xa3f5, 0xa3f6, 0xa3f7, 0xa3f8, 0xa3f9, 0xa3fa, 0xa1d0, 0xa1c3, 0xa1d1, 0x22b7, 0xffff,
    0xffff, 0x8ea1, 0x8ea2, 0x8ea3, 0x8ea4, 0x8ea5, 0x8ea6, 0x8ea7, 0x8ea8, 0x8ea9, 0x8eaa, 0x8eab, 0x8eac, 0x8ead, 0x8eae, 0x8eaf,
    0x8eb0, 0x8eb1, 0x8eb2, 0x8eb3, 0x8eb4, 0x8eb5, 0x8eb6, 0x8eb7, 0x8eb8, 0x8eb9, 0x8eba, 0x8ebb, 0x8ebc, 0x8ebd, 0x8ebe, 0x8ebf,
    0x8ec0, 0x8ec1, 0x8ec2, 0x8ec3, 0x8ec4, 0x8ec5, 0x8ec6, 0x8ec7, 0x8ec8, 0x8ec9, 0x8eca, 0x8ecb, 0x8ecc, 0x8ecd, 0x8ece, 0x8ecf,
    0x8ed0, 0x8ed1, 0x8ed2, 0x8ed3, 0x8ed4, 0x8ed5, 0x8ed6, 0x8ed7, 0x8ed8, 0x8ed9, 0x8eda, 0x8edb, 0x8edc, 0x8edd, 0x8ede, 0x8edf,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xa1b1, 0xffff, 0xa1ef,
};
#endif /* unicode_ff */

/* jis_x0208 tables */
#ifdef define_jis_x0208

#define __euc_jp_jis_x0208_first_row 0x8e
#define __euc_jp_jis_x0208_last_row 0xf4

#ifndef split_jis_x0208
#define split_jis_x0208_offset 0
#endif

static const uint16_t __euc_jp_jis_x0208_codes[] = {
    /* 0x8e: 0xa1 - 0xdf*/
            0xff61, 0xff62, 0xff63, 0xff64, 0xff65, 0xff66, 0xff67, 0xff68, 0xff69, 0xff6a, 0xff6b, 0xff6c, 0xff6d, 0xff6e, 0xff6f,
    0xff70, 0xff71, 0xff72, 0xff73, 0xff74, 0xff75, 0xff76, 0xff77, 0xff78, 0xff79, 0xff7a, 0xff7b, 0xff7c, 0xff7d, 0xff7e, 0xff7f,
    0xff80, 0xff81, 0xff82, 0xff83, 0xff84, 0xff85, 0xff86, 0xff87, 0xff88, 0xff89, 0xff8a, 0xff8b, 0xff8c, 0xff8d, 0xff8e, 0xff8f,
    0xff90, 0xff91, 0xff92, 0xff93, 0xff94, 0xff95, 0xff96, 0xff97, 0xff98, 0xff99, 0xff9a, 0xff9b, 0xff9c, 0xff9d, 0xff9e, 0xff9f,

    /* 0xa1: 0xa1 - 0xfe*/
            0x3000, 0x3001, 0x3002, 0xff0c, 0xff0e, 0x30fb, 0xff1a, 0xff1b, 0xff1f, 0xff01, 0x309b, 0x309c, 0x00b4, 0xff40, 0x00a8,
    0xff3e, 0xffe3, 0xff3f, 0x30fd, 0x30fe, 0x309d, 0x309e, 0x3003, 0x4edd, 0x3005, 0x3006, 0x3007, 0x30fc, 0x2015, 0x2010, 0xff0f,
    0xff3c, 0x301c, 0x2016, 0xff5c, 0x2026, 0x2025, 0x2018, 0x2019, 0x201c, 0x201d, 0xff08, 0xff09, 0x3014, 0x3015, 0xff3b, 0xff3d,
    0xff5b, 0xff5d, 0x3008, 0x3009, 0x300a, 0x300b, 0x300c, 0x300d, 0x300e, 0x300f, 0x3010, 0x3011, 0xff0b, 0x2212, 0x00b1, 0x00d7,
    0x00f7, 0xff1d, 0x2260, 0xff1c, 0xff1e, 0x2266, 0x2267, 0x221e, 0x2234, 0x2642, 0x2640, 0x00b0, 0x2032, 0x2033, 0x2103, 0xffe5,
    0xff04, 0x00a2, 0x00a3, 0xff05, 0xff03, 0xff06, 0xff0a, 0xff20, 0x00a7, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7,

    /* 0xa2: 0xa1 - 0xfe*/
            0x25c6, 0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x203b, 0x3012, 0x2192, 0x2190, 0x2191, 0x2193, 0x3013, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2208, 0x220b, 0x2286, 0x2287, 0x2282, 0x2283,
    0x222a, 0x2229, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2227, 0x2228, 0x00ac, 0x21d2, 0x21d4, 0x2200,
    0x2203, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x2220, 0x22a5, 0x2312, 0x2202,
    0x2207, 0x2261, 0x2252, 0x226a, 0x226b, 0x221a, 0x223d, 0x221d, 0x2235, 0x222b, 0x222c, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x212b, 0x2030, 0x266f, 0x266d, 0x266a, 0x2020, 0x2021, 0x00b6, 0xffff, 0xffff, 0xffff, 0xffff, 0x25ef,

    /* 0xa3: 0xb0 - 0xfa*/
    0xff10, 0xff11, 0xff12, 0xff13, 0xff14, 0xff15, 0xff16, 0xff17, 0xff18, 0xff19, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27, 0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f,
    0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37, 0xff38, 0xff39, 0xff3a, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47, 0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
    0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57, 0xff58, 0xff59, 0xff5a,

    /* 0xa4: 0xa1 - 0xf3*/
            0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f,
    0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f,
    0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f,
    0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f,
    0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f,
    0x3090, 0x3091, 0x3092, 0x3093,

    /* 0xa5: 0xa1 - 0xf6*/
            0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7, 0x30a8, 0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af,
    0x30b0, 0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7, 0x30b8, 0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf,
    0x30c0, 0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7, 0x30c8, 0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf,
    0x30d0, 0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7, 0x30d8, 0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df,
    0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7, 0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef,
    0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6,

    /* 0xa6: 0xa1 - 0xd8*/
            0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,
    0x03a0, 0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8, 0x03a9, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
    0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9,

    /* 0xa7: 0xa1 - 0xf1*/
            0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d,
    0x041e, 0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d,
    0x042e, 0x042f, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d,
    0x043e, 0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d,
    0x044e, 0x044f,

    /* 0xa8: 0xa1 - 0xc0*/
            0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c, 0x252c, 0x2524, 0x2534, 0x253c, 0x2501, 0x2503, 0x250f, 0x2513,
    0x251b, 0x2517, 0x2523, 0x2533, 0x252b, 0x253b, 0x254b, 0x2520, 0x252f, 0x2528, 0x2537, 0x253f, 0x251d, 0x2530, 0x2525, 0x2538,
    0x2542,

    /* 0xb0: 0xa1 - 0xfe*/
            0x4e9c, 0x5516, 0x5a03, 0x963f, 0x54c0, 0x611b, 0x6328, 0x59f6, 0x9022, 0x8475, 0x831c, 0x7a50, 0x60aa, 0x63e1, 0x6e25,
    0x65ed, 0x8466, 0x82a6, 0x9bf5, 0x6893, 0x5727, 0x65a1, 0x6271, 0x5b9b, 0x59d0, 0x867b, 0x98f4, 0x7d62, 0x7dbe, 0x9b8e, 0x6216,
    0x7c9f, 0x88b7, 0x5b89, 0x5eb5, 0x6309, 0x6697, 0x6848, 0x95c7, 0x978d, 0x674f, 0x4ee5, 0x4f0a, 0x4f4d, 0x4f9d, 0x5049, 0x56f2,
    0x5937, 0x59d4, 0x5a01, 0x5c09, 0x60df, 0x610f, 0x6170, 0x6613, 0x6905, 0x70ba, 0x754f, 0x7570, 0x79fb, 0x7dad, 0x7def, 0x80c3,
    0x840e, 0x8863, 0x8b02, 0x9055, 0x907a, 0x533b, 0x4e95, 0x4ea5, 0x57df, 0x80b2, 0x90c1, 0x78ef, 0x4e00, 0x58f1, 0x6ea2, 0x9038,
    0x7a32, 0x8328, 0x828b, 0x9c2f, 0x5141, 0x5370, 0x54bd, 0x54e1, 0x56e0, 0x59fb, 0x5f15, 0x98f2, 0x6deb, 0x80e4, 0x852d,

    /* 0xb1: 0xa1 - 0xfe*/
            0x9662, 0x9670, 0x96a0, 0x97fb, 0x540b, 0x53f3, 0x5b87, 0x70cf, 0x7fbd, 0x8fc2, 0x96e8, 0x536f, 0x9d5c, 0x7aba, 0x4e11,
    0x7893, 0x81fc, 0x6e26, 0x5618, 0x5504, 0x6b1d, 0x851a, 0x9c3b, 0x59e5, 0x53a9, 0x6d66, 0x74dc, 0x958f, 0x5642, 0x4e91, 0x904b,
    0x96f2, 0x834f, 0x990c, 0x53e1, 0x55b6, 0x5b30, 0x5f71, 0x6620, 0x66f3, 0x6804, 0x6c38, 0x6cf3, 0x6d29, 0x745b, 0x76c8, 0x7a4e,
    0x9834, 0x82f1, 0x885b, 0x8a60, 0x92ed, 0x6db2, 0x75ab, 0x76ca, 0x99c5, 0x60a6, 0x8b01, 0x8d8a, 0x95b2, 0x698e, 0x53ad, 0x5186,
    0x5712, 0x5830, 0x5944, 0x5bb4, 0x5ef6, 0x6028, 0x63a9, 0x63f4, 0x6cbf, 0x6f14, 0x708e, 0x7114, 0x7159, 0x71d5, 0x733f, 0x7e01,
    0x8276, 0x82d1, 0x8597, 0x9060, 0x925b, 0x9d1b, 0x5869, 0x65bc, 0x6c5a, 0x7525, 0x51f9, 0x592e, 0x5965, 0x5f80, 0x5fdc,

    /* 0xb2: 0xa1 - 0xfe*/
            0x62bc, 0x65fa, 0x6a2a, 0x6b27, 0x6bb4, 0x738b, 0x7fc1, 0x8956, 0x9d2c, 0x9d0e, 0x9ec4, 0x5ca1, 0x6c96, 0x837b, 0x5104,
    0x5c4b, 0x61b6, 0x81c6, 0x6876, 0x7261, 0x4e59, 0x4ffa, 0x5378, 0x6069, 0x6e29, 0x7a4f, 0x97f3, 0x4e0b, 0x5316, 0x4eee, 0x4f55,
    0x4f3d, 0x4fa1, 0x4f73, 0x52a0, 0x53ef, 0x5609, 0x590f, 0x5ac1, 0x5bb6, 0x5be1, 0x79d1, 0x6687, 0x679c, 0x67b6, 0x6b4c, 0x6cb3,
    0x706b, 0x73c2, 0x798d, 0x79be, 0x7a3c, 0x7b87, 0x82b1, 0x82db, 0x8304, 0x8377, 0x83ef, 0x83d3, 0x8766, 0x8ab2, 0x5629, 0x8ca8,
    0x8fe6, 0x904e, 0x971e, 0x868a, 0x4fc4, 0x5ce8, 0x6211, 0x7259, 0x753b, 0x81e5, 0x82bd, 0x86fe, 0x8cc0, 0x96c5, 0x9913, 0x99d5,
    0x4ecb, 0x4f1a, 0x89e3, 0x56de, 0x584a, 0x58ca, 0x5efb, 0x5feb, 0x602a, 0x6094, 0x6062, 0x61d0, 0x6212, 0x62d0, 0x6539,

    /* 0xb3: 0xa1 - 0xfe*/
            0x9b41, 0x6666, 0x68b0, 0x6d77, 0x7070, 0x754c, 0x7686, 0x7d75, 0x82a5, 0x87f9, 0x958b, 0x968e, 0x8c9d, 0x51f1, 0x52be,
    0x5916, 0x54b3, 0x5bb3, 0x5d16, 0x6168, 0x6982, 0x6daf, 0x788d, 0x84cb, 0x8857, 0x8a72, 0x93a7, 0x9ab8, 0x6d6c, 0x99a8, 0x86d9,
    0x57a3, 0x67ff, 0x86ce, 0x920e, 0x5283, 0x5687, 0x5404, 0x5ed3, 0x62e1, 0x64b9, 0x683c, 0x6838, 0x6bbb, 0x7372, 0x78ba, 0x7a6b,
    0x899a, 0x89d2, 0x8d6b, 0x8f03, 0x90ed, 0x95a3, 0x9694, 0x9769, 0x5b66, 0x5cb3, 0x697d, 0x984d, 0x984e, 0x639b, 0x7b20, 0x6a2b,
    0x6a7f, 0x68b6, 0x9c0d, 0x6f5f, 0x5272, 0x559d, 0x6070, 0x62ec, 0x6d3b, 0x6e07, 0x6ed1, 0x845b, 0x8910, 0x8f44, 0x4e14, 0x9c39,
    0x53f6, 0x691b, 0x6a3a, 0x9784, 0x682a, 0x515c, 0x7ac3, 0x84b2, 0x91dc, 0x938c, 0x565b, 0x9d28, 0x6822, 0x8305, 0x8431,

    /* 0xb4: 0xa1 - 0xfe*/
            0x7ca5, 0x5208, 0x82c5, 0x74e6, 0x4e7e, 0x4f83, 0x51a0, 0x5bd2, 0x520a, 0x52d8, 0x52e7, 0x5dfb, 0x559a, 0x582a, 0x59e6,
    0x5b8c, 0x5b98, 0x5bdb, 0x5e72, 0x5e79, 0x60a3, 0x611f, 0x6163, 0x61be, 0x63db, 0x6562, 0x67d1, 0x6853, 0x68fa, 0x6b3e, 0x6b53,
    0x6c57, 0x6f22, 0x6f97, 0x6f45, 0x74b0, 0x7518, 0x76e3, 0x770b, 0x7aff, 0x7ba1, 0x7c21, 0x7de9, 0x7f36, 0x7ff0, 0x809d, 0x8266,
    0x839e, 0x89b3, 0x8acc, 0x8cab, 0x9084, 0x9451, 0x9593, 0x9591, 0x95a2, 0x9665, 0x97d3, 0x9928, 0x8218, 0x4e38, 0x542b, 0x5cb8,
    0x5dcc, 0x73a9, 0x764c, 0x773c, 0x5ca9, 0x7feb, 0x8d0b, 0x96c1, 0x9811, 0x9854, 0x9858, 0x4f01, 0x4f0e, 0x5371, 0x559c, 0x5668,
    0x57fa, 0x5947, 0x5b09, 0x5bc4, 0x5c90, 0x5e0c, 0x5e7e, 0x5fcc, 0x63ee, 0x673a, 0x65d7, 0x65e2, 0x671f, 0x68cb, 0x68c4,

    /* 0xb5: 0xa1 - 0xfe*/
            0x6a5f, 0x5e30, 0x6bc5, 0x6c17, 0x6c7d, 0x757f, 0x7948, 0x5b63, 0x7a00, 0x7d00, 0x5fbd, 0x898f, 0x8a18, 0x8cb4, 0x8d77,
    0x8ecc, 0x8f1d, 0x98e2, 0x9a0e, 0x9b3c, 0x4e80, 0x507d, 0x5100, 0x5993, 0x5b9c, 0x622f, 0x6280, 0x64ec, 0x6b3a, 0x72a0, 0x7591,
    0x7947, 0x7fa9, 0x87fb, 0x8abc, 0x8b70, 0x63ac, 0x83ca, 0x97a0, 0x5409, 0x5403, 0x55ab, 0x6854, 0x6a58, 0x8a70, 0x7827, 0x6775,
    0x9ecd, 0x5374, 0x5ba2, 0x811a, 0x8650, 0x9006, 0x4e18, 0x4e45, 0x4ec7, 0x4f11, 0x53ca, 0x5438, 0x5bae, 0x5f13, 0x6025, 0x6551,
    0x673d, 0x6c42, 0x6c72, 0x6ce3, 0x7078, 0x7403, 0x7a76, 0x7aae, 0x7b08, 0x7d1a, 0x7cfe, 0x7d66, 0x65e7, 0x725b, 0x53bb, 0x5c45,
    0x5de8, 0x62d2, 0x62e0, 0x6319, 0x6e20, 0x865a, 0x8a31, 0x8ddd, 0x92f8, 0x6f01, 0x79a6, 0x9b5a, 0x4ea8, 0x4eab, 0x4eac,

    /* 0xb6: 0xa1 - 0xfe*/
            0x4f9b, 0x4fa0, 0x50d1, 0x5147, 0x7af6, 0x5171, 0x51f6, 0x5354, 0x5321, 0x537f, 0x53eb, 0x55ac, 0x5883, 0x5ce1, 0x5f37,
    0x5f4a, 0x602f, 0x6050, 0x606d, 0x631f, 0x6559, 0x6a4b, 0x6cc1, 0x72c2, 0x72ed, 0x77ef, 0x80f8, 0x8105, 0x8208, 0x854e, 0x90f7,
    0x93e1, 0x97ff, 0x9957, 0x9a5a, 0x4ef0, 0x51dd, 0x5c2d, 0x6681, 0x696d, 0x5c40, 0x66f2, 0x6975, 0x7389, 0x6850, 0x7c81, 0x50c5,
    0x52e4, 0x5747, 0x5dfe, 0x9326, 0x65a4, 0x6b23, 0x6b3d, 0x7434, 0x7981, 0x79bd, 0x7b4b, 0x7dca, 0x82b9, 0x83cc, 0x887f, 0x895f,
    0x8b39, 0x8fd1, 0x91d1, 0x541f, 0x9280, 0x4e5d, 0x5036, 0x53e5, 0x533a, 0x72d7, 0x7396, 0x77e9, 0x82e6, 0x8eaf, 0x99c6, 0x99c8,
    0x99d2, 0x5177, 0x611a, 0x865e, 0x55b0, 0x7a7a, 0x5076, 0x5bd3, 0x9047, 0x9685, 0x4e32, 0x6adb, 0x91e7, 0x5c51, 0x5c48,

    /* 0xb7: 0xa1 - 0xfe*/
            0x6398, 0x7a9f, 0x6c93, 0x9774, 0x8f61, 0x7aaa, 0x718a, 0x9688, 0x7c82, 0x6817, 0x7e70, 0x6851, 0x936c, 0x52f2, 0x541b,
    0x85ab, 0x8a13, 0x7fa4, 0x8ecd, 0x90e1, 0x5366, 0x8888, 0x7941, 0x4fc2, 0x50be, 0x5211, 0x5144, 0x5553, 0x572d, 0x73ea, 0x578b,
    0x5951, 0x5f62, 0x5f84, 0x6075, 0x6176, 0x6167, 0x61a9, 0x63b2, 0x643a, 0x656c, 0x666f, 0x6842, 0x6e13, 0x7566, 0x7a3d, 0x7cfb,
    0x7d4c, 0x7d99, 0x7e4b, 0x7f6b, 0x830e, 0x834a, 0x86cd, 0x8a08, 0x8a63, 0x8b66, 0x8efd, 0x981a, 0x9d8f, 0x82b8, 0x8fce, 0x9be8,
    0x5287, 0x621f, 0x6483, 0x6fc0, 0x9699, 0x6841, 0x5091, 0x6b20, 0x6c7a, 0x6f54, 0x7a74, 0x7d50, 0x8840, 0x8a23, 0x6708, 0x4ef6,
    0x5039, 0x5026, 0x5065, 0x517c, 0x5238, 0x5263, 0x55a7, 0x570f, 0x5805, 0x5acc, 0x5efa, 0x61b2, 0x61f8, 0x62f3, 0x6372,

    /* 0xb8: 0xa1 - 0xfe*/
            0x691c, 0x6a29, 0x727d, 0x72ac, 0x732e, 0x7814, 0x786f, 0x7d79, 0x770c, 0x80a9, 0x898b, 0x8b19, 0x8ce2, 0x8ed2, 0x9063,
    0x9375, 0x967a, 0x9855, 0x9a13, 0x9e78, 0x5143, 0x539f, 0x53b3, 0x5e7b, 0x5f26, 0x6e1b, 0x6e90, 0x7384, 0x73fe, 0x7d43, 0x8237,
    0x8a00, 0x8afa, 0x9650, 0x4e4e, 0x500b, 0x53e4, 0x547c, 0x56fa, 0x59d1, 0x5b64, 0x5df1, 0x5eab, 0x5f27, 0x6238, 0x6545, 0x67af,
    0x6e56, 0x72d0, 0x7cca, 0x88b4, 0x80a1, 0x80e1, 0x83f0, 0x864e, 0x8a87, 0x8de8, 0x9237, 0x96c7, 0x9867, 0x9f13, 0x4e94, 0x4e92,
    0x4f0d, 0x5348, 0x5449, 0x543e, 0x5a2f, 0x5f8c, 0x5fa1, 0x609f, 0x68a7, 0x6a8e, 0x745a, 0x7881, 0x8a9e, 0x8aa4, 0x8b77, 0x9190,
    0x4e5e, 0x9bc9, 0x4ea4, 0x4f7c, 0x4faf, 0x5019, 0x5016, 0x5149, 0x516c, 0x529f, 0x52b9, 0x52fe, 0x539a, 0x53e3, 0x5411,

    /* 0xb9: 0xa1 - 0xfe*/
            0x540e, 0x5589, 0x5751, 0x57a2, 0x597d, 0x5b54, 0x5b5d, 0x5b8f, 0x5de5, 0x5de7, 0x5df7, 0x5e78, 0x5e83, 0x5e9a, 0x5eb7,
    0x5f18, 0x6052, 0x614c, 0x6297, 0x62d8, 0x63a7, 0x653b, 0x6602, 0x6643, 0x66f4, 0x676d, 0x6821, 0x6897, 0x69cb, 0x6c5f, 0x6d2a,
    0x6d69, 0x6e2f, 0x6e9d, 0x7532, 0x7687, 0x786c, 0x7a3f, 0x7ce0, 0x7d05, 0x7d18, 0x7d5e, 0x7db1, 0x8015, 0x8003, 0x80af, 0x80b1,
    0x8154, 0x818f, 0x822a, 0x8352, 0x884c, 0x8861, 0x8b1b, 0x8ca2, 0x8cfc, 0x90ca, 0x9175, 0x9271, 0x783f, 0x92fc, 0x95a4, 0x964d,
    0x9805, 0x9999, 0x9ad8, 0x9d3b, 0x525b, 0x52ab, 0x53f7, 0x5408, 0x58d5, 0x62f7, 0x6fe0, 0x8c6a, 0x8f5f, 0x9eb9, 0x514b, 0x523b,
    0x544a, 0x56fd, 0x7a40, 0x9177, 0x9d60, 0x9ed2, 0x7344, 0x6f09, 0x8170, 0x7511, 0x5ffd, 0x60da, 0x9aa8, 0x72db, 0x8fbc,

    /* 0xba: 0xa1 - 0xfe*/
            0x6b64, 0x9803, 0x4eca, 0x56f0, 0x5764, 0x58be, 0x5a5a, 0x6068, 0x61c7, 0x660f, 0x6606, 0x6839, 0x68b1, 0x6df7, 0x75d5,
    0x7d3a, 0x826e, 0x9b42, 0x4e9b, 0x4f50, 0x53c9, 0x5506, 0x5d6f, 0x5de6, 0x5dee, 0x67fb, 0x6c99, 0x7473, 0x7802, 0x8a50, 0x9396,
    0x88df, 0x5750, 0x5ea7, 0x632b, 0x50b5, 0x50ac, 0x518d, 0x6700, 0x54c9, 0x585e, 0x59bb, 0x5bb0, 0x5f69, 0x624d, 0x63a1, 0x683d,
    0x6b73, 0x6e08, 0x707d, 0x91c7, 0x7280, 0x7815, 0x7826, 0x796d, 0x658e, 0x7d30, 0x83dc, 0x88c1, 0x8f09, 0x969b, 0x5264, 0x5728,
    0x6750, 0x7f6a, 0x8ca1, 0x51b4, 0x5742, 0x962a, 0x583a, 0x698a, 0x80b4, 0x54b2, 0x5d0e, 0x57fc, 0x7895, 0x9dfa, 0x4f5c, 0x524a,
    0x548b, 0x643e, 0x6628, 0x6714, 0x67f5, 0x7a84, 0x7b56, 0x7d22, 0x932f, 0x685c, 0x9bad, 0x7b39, 0x5319, 0x518a, 0x5237,

    /* 0xbb: 0xa1 - 0xfe*/
            0x5bdf, 0x62f6, 0x64ae, 0x64e6, 0x672d, 0x6bba, 0x85a9, 0x96d1, 0x7690, 0x9bd6, 0x634c, 0x9306, 0x9bab, 0x76bf, 0x6652,
    0x4e09, 0x5098, 0x53c2, 0x5c71, 0x60e8, 0x6492, 0x6563, 0x685f, 0x71e6, 0x73ca, 0x7523, 0x7b97, 0x7e82, 0x8695, 0x8b83, 0x8cdb,
    0x9178, 0x9910, 0x65ac, 0x66ab, 0x6b8b, 0x4ed5, 0x4ed4, 0x4f3a, 0x4f7f, 0x523a, 0x53f8, 0x53f2, 0x55e3, 0x56db, 0x58eb, 0x59cb,
    0x59c9, 0x59ff, 0x5b50, 0x5c4d, 0x5e02, 0x5e2b, 0x5fd7, 0x601d, 0x6307, 0x652f, 0x5b5c, 0x65af, 0x65bd, 0x65e8, 0x679d, 0x6b62,
    0x6b7b, 0x6c0f, 0x7345, 0x7949, 0x79c1, 0x7cf8, 0x7d19, 0x7d2b, 0x80a2, 0x8102, 0x81f3, 0x8996, 0x8a5e, 0x8a69, 0x8a66, 0x8a8c,
    0x8aee, 0x8cc7, 0x8cdc, 0x96cc, 0x98fc, 0x6b6f, 0x4e8b, 0x4f3c, 0x4f8d, 0x5150, 0x5b57, 0x5bfa, 0x6148, 0x6301, 0x6642,

    /* 0xbc: 0xa1 - 0xfe*/
            0x6b21, 0x6ecb, 0x6cbb, 0x723e, 0x74bd, 0x75d4, 0x78c1, 0x793a, 0x800c, 0x8033, 0x81ea, 0x8494, 0x8f9e, 0x6c50, 0x9e7f,
    0x5f0f, 0x8b58, 0x9d2b, 0x7afa, 0x8ef8, 0x5b8d, 0x96eb, 0x4e03, 0x53f1, 0x57f7, 0x5931, 0x5ac9, 0x5ba4, 0x6089, 0x6e7f, 0x6f06,
    0x75be, 0x8cea, 0x5b9f, 0x8500, 0x7be0, 0x5072, 0x67f4, 0x829d, 0x5c61, 0x854a, 0x7e1e, 0x820e, 0x5199, 0x5c04, 0x6368, 0x8d66,
    0x659c, 0x716e, 0x793e, 0x7d17, 0x8005, 0x8b1d, 0x8eca, 0x906e, 0x86c7, 0x90aa, 0x501f, 0x52fa, 0x5c3a, 0x6753, 0x707c, 0x7235,
    0x914c, 0x91c8, 0x932b, 0x82e5, 0x5bc2, 0x5f31, 0x60f9, 0x4e3b, 0x53d6, 0x5b88, 0x624b, 0x6731, 0x6b8a, 0x72e9, 0x73e0, 0x7a2e,
    0x816b, 0x8da3, 0x9152, 0x9996, 0x5112, 0x53d7, 0x546a, 0x5bff, 0x6388, 0x6a39, 0x7dac, 0x9700, 0x56da, 0x53ce, 0x5468,

    /* 0xbd: 0xa1 - 0xfe*/
            0x5b97, 0x5c31, 0x5dde, 0x4fee, 0x6101, 0x62fe, 0x6d32, 0x79c0, 0x79cb, 0x7d42, 0x7e4d, 0x7fd2, 0x81ed, 0x821f, 0x8490,
    0x8846, 0x8972, 0x8b90, 0x8e74, 0x8f2f, 0x9031, 0x914b, 0x916c, 0x96c6, 0x919c, 0x4ec0, 0x4f4f, 0x5145, 0x5341, 0x5f93, 0x620e,
    0x67d4, 0x6c41, 0x6e0b, 0x7363, 0x7e26, 0x91cd, 0x9283, 0x53d4, 0x5919, 0x5bbf, 0x6dd1, 0x795d, 0x7e2e, 0x7c9b, 0x587e, 0x719f,
    0x51fa, 0x8853, 0x8ff0, 0x4fca, 0x5cfb, 0x6625, 0x77ac, 0x7ae3, 0x821c, 0x99ff, 0x51c6, 0x5faa, 0x65ec, 0x696f, 0x6b89, 0x6df3,
    0x6e96, 0x6f64, 0x76fe, 0x7d14, 0x5de1, 0x9075, 0x9187, 0x9806, 0x51e6, 0x521d, 0x6240, 0x6691, 0x66d9, 0x6e1a, 0x5eb6, 0x7dd2,
    0x7f72, 0x66f8, 0x85af, 0x85f7, 0x8af8, 0x52a9, 0x53d9, 0x5973, 0x5e8f, 0x5f90, 0x6055, 0x92e4, 0x9664, 0x50b7, 0x511f,

    /* 0xbe: 0xa1 - 0xfe*/
            0x52dd, 0x5320, 0x5347, 0x53ec, 0x54e8, 0x5546, 0x5531, 0x5617, 0x5968, 0x59be, 0x5a3c, 0x5bb5, 0x5c06, 0x5c0f, 0x5c11,
    0x5c1a, 0x5e84, 0x5e8a, 0x5ee0, 0x5f70, 0x627f, 0x6284, 0x62db, 0x638c, 0x6377, 0x6607, 0x660c, 0x662d, 0x6676, 0x677e, 0x68a2,
    0x6a1f, 0x6a35, 0x6cbc, 0x6d88, 0x6e09, 0x6e58, 0x713c, 0x7126, 0x7167, 0x75c7, 0x7701, 0x785d, 0x7901, 0x7965, 0x79f0, 0x7ae0,
    0x7b11, 0x7ca7, 0x7d39, 0x8096, 0x83d6, 0x848b, 0x8549, 0x885d, 0x88f3, 0x8a1f, 0x8a3c, 0x8a54, 0x8a73, 0x8c61, 0x8cde, 0x91a4,
    0x9266, 0x937e, 0x9418, 0x969c, 0x9798, 0x4e0a, 0x4e08, 0x4e1e, 0x4e57, 0x5197, 0x5270, 0x57ce, 0x5834, 0x58cc, 0x5b22, 0x5e38,
    0x60c5, 0x64fe, 0x6761, 0x6756, 0x6d44, 0x72b6, 0x7573, 0x7a63, 0x84b8, 0x8b72, 0x91b8, 0x9320, 0x5631, 0x57f4, 0x98fe,

    /* 0xbf: 0xa1 - 0xfe*/
            0x62ed, 0x690d, 0x6b96, 0x71ed, 0x7e54, 0x8077, 0x8272, 0x89e6, 0x98df, 0x8755, 0x8fb1, 0x5c3b, 0x4f38, 0x4fe1, 0x4fb5,
    0x5507, 0x5a20, 0x5bdd, 0x5be9, 0x5fc3, 0x614e, 0x632f, 0x65b0, 0x664b, 0x68ee, 0x699b, 0x6d78, 0x6df1, 0x7533, 0x75b9, 0x771f,
    0x795e, 0x79e6, 0x7d33, 0x81e3, 0x82af, 0x85aa, 0x89aa, 0x8a3a, 0x8eab, 0x8f9b, 0x9032, 0x91dd, 0x9707, 0x4eba, 0x4ec1, 0x5203,
    0x5875, 0x58ec, 0x5c0b, 0x751a, 0x5c3d, 0x814e, 0x8a0a, 0x8fc5, 0x9663, 0x976d, 0x7b25, 0x8acf, 0x9808, 0x9162, 0x56f3, 0x53a8,
    0x9017, 0x5439, 0x5782, 0x5e25, 0x63a8, 0x6c34, 0x708a, 0x7761, 0x7c8b, 0x7fe0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318, 0x968f,
    0x745e, 0x9ac4, 0x5d07, 0x5d69, 0x6570, 0x67a2, 0x8da8, 0x96db, 0x636e, 0x6749, 0x6919, 0x83c5, 0x9817, 0x96c0, 0x88fe,

    /* 0xc0: 0xa1 - 0xfe*/
            0x6f84, 0x647a, 0x5bf8, 0x4e16, 0x702c, 0x755d, 0x662f, 0x51c4, 0x5236, 0x52e2, 0x59d3, 0x5f81, 0x6027, 0x6210, 0x653f,
    0x6574, 0x661f, 0x6674, 0x68f2, 0x6816, 0x6b63, 0x6e05, 0x7272, 0x751f, 0x76db, 0x7cbe, 0x8056, 0x58f0, 0x88fd, 0x897f, 0x8aa0,
    0x8a93, 0x8acb, 0x901d, 0x9192, 0x9752, 0x9759, 0x6589, 0x7a0e, 0x8106, 0x96bb, 0x5e2d, 0x60dc, 0x621a, 0x65a5, 0x6614, 0x6790,
    0x77f3, 0x7a4d, 0x7c4d, 0x7e3e, 0x810a, 0x8cac, 0x8d64, 0x8de1, 0x8e5f, 0x78a9, 0x5207, 0x62d9, 0x63a5, 0x6442, 0x6298, 0x8a2d,
    0x7a83, 0x7bc0, 0x8aac, 0x96ea, 0x7d76, 0x820c, 0x8749, 0x4ed9, 0x5148, 0x5343, 0x5360, 0x5ba3, 0x5c02, 0x5c16, 0x5ddd, 0x6226,
    0x6247, 0x64b0, 0x6813, 0x6834, 0x6cc9, 0x6d45, 0x6d17, 0x67d3, 0x6f5c, 0x714e, 0x717d, 0x65cb, 0x7a7f, 0x7bad, 0x7dda,

    /* 0xc1: 0xa1 - 0xfe*/
            0x7e4a, 0x7fa8, 0x817a, 0x821b, 0x8239, 0x85a6, 0x8a6e, 0x8cce, 0x8df5, 0x9078, 0x9077, 0x92ad, 0x9291, 0x9583, 0x9bae,
    0x524d, 0x5584, 0x6f38, 0x7136, 0x5168, 0x7985, 0x7e55, 0x81b3, 0x7cce, 0x564c, 0x5851, 0x5ca8, 0x63aa, 0x66fe, 0x66fd, 0x695a,
    0x72d9, 0x758f, 0x758e, 0x790e, 0x7956, 0x79df, 0x7c97, 0x7d20, 0x7d44, 0x8607, 0x8a34, 0x963b, 0x9061, 0x9f20, 0x50e7, 0x5275,
    0x53cc, 0x53e2, 0x5009, 0x55aa, 0x58ee, 0x594f, 0x723d, 0x5b8b, 0x5c64, 0x531d, 0x60e3, 0x60f3, 0x635c, 0x6383, 0x633f, 0x63bb,
    0x64cd, 0x65e9, 0x66f9, 0x5de3, 0x69cd, 0x69fd, 0x6f15, 0x71e5, 0x4e89, 0x75e9, 0x76f8, 0x7a93, 0x7cdf, 0x7dcf, 0x7d9c, 0x8061,
    0x8349, 0x8358, 0x846c, 0x84bc, 0x85fb, 0x88c5, 0x8d70, 0x9001, 0x906d, 0x9397, 0x971c, 0x9a12, 0x50cf, 0x5897, 0x618e,

    /* 0xc2: 0xa1 - 0xfe*/
            0x81d3, 0x8535, 0x8d08, 0x9020, 0x4fc3, 0x5074, 0x5247, 0x5373, 0x606f, 0x6349, 0x675f, 0x6e2c, 0x8db3, 0x901f, 0x4fd7,
    0x5c5e, 0x8cca, 0x65cf, 0x7d9a, 0x5352, 0x8896, 0x5176, 0x63c3, 0x5b58, 0x5b6b, 0x5c0a, 0x640d, 0x6751, 0x905c, 0x4ed6, 0x591a,
    0x592a, 0x6c70, 0x8a51, 0x553e, 0x5815, 0x59a5, 0x60f0, 0x6253, 0x67c1, 0x8235, 0x6955, 0x9640, 0x99c4, 0x9a28, 0x4f53, 0x5806,
    0x5bfe, 0x8010, 0x5cb1, 0x5e2f, 0x5f85, 0x6020, 0x614b, 0x6234, 0x66ff, 0x6cf0, 0x6ede, 0x80ce, 0x817f, 0x82d4, 0x888b, 0x8cb8,
    0x9000, 0x902e, 0x968a, 0x9edb, 0x9bdb, 0x4ee3, 0x53f0, 0x5927, 0x7b2c, 0x918d, 0x984c, 0x9df9, 0x6edd, 0x7027, 0x5353, 0x5544,
    0x5b85, 0x6258, 0x629e, 0x62d3, 0x6ca2, 0x6fef, 0x7422, 0x8a17, 0x9438, 0x6fc1, 0x8afe, 0x8338, 0x51e7, 0x86f8, 0x53ea,

    /* 0xc3: 0xa1 - 0xfe*/
            0x53e9, 0x4f46, 0x9054, 0x8fb0, 0x596a, 0x8131, 0x5dfd, 0x7aea, 0x8fbf, 0x68da, 0x8c37, 0x72f8, 0x9c48, 0x6a3d, 0x8ab0,
    0x4e39, 0x5358, 0x5606, 0x5766, 0x62c5, 0x63a2, 0x65e6, 0x6b4e, 0x6de1, 0x6e5b, 0x70ad, 0x77ed, 0x7aef, 0x7baa, 0x7dbb, 0x803d,
    0x80c6, 0x86cb, 0x8a95, 0x935b, 0x56e3, 0x58c7, 0x5f3e, 0x65ad, 0x6696, 0x6a80, 0x6bb5, 0x7537, 0x8ac7, 0x5024, 0x77e5, 0x5730,
    0x5f1b, 0x6065, 0x667a, 0x6c60, 0x75f4, 0x7a1a, 0x7f6e, 0x81f4, 0x8718, 0x9045, 0x99b3, 0x7bc9, 0x755c, 0x7af9, 0x7b51, 0x84c4,
    0x9010, 0x79e9, 0x7a92, 0x8336, 0x5ae1, 0x7740, 0x4e2d, 0x4ef2, 0x5b99, 0x5fe0, 0x62bd, 0x663c, 0x67f1, 0x6ce8, 0x866b, 0x8877,
    0x8a3b, 0x914e, 0x92f3, 0x99d0, 0x6a17, 0x7026, 0x732a, 0x82e7, 0x8457, 0x8caf, 0x4e01, 0x5146, 0x51cb, 0x558b, 0x5bf5,

    /* 0xc4: 0xa1 - 0xfe*/
            0x5e16, 0x5e33, 0x5e81, 0x5f14, 0x5f35, 0x5f6b, 0x5fb4, 0x61f2, 0x6311, 0x66a2, 0x671d, 0x6f6e, 0x7252, 0x753a, 0x773a,
    0x8074, 0x8139, 0x8178, 0x8776, 0x8abf, 0x8adc, 0x8d85, 0x8df3, 0x929a, 0x9577, 0x9802, 0x9ce5, 0x52c5, 0x6357, 0x76f4, 0x6715,
    0x6c88, 0x73cd, 0x8cc3, 0x93ae, 0x9673, 0x6d25, 0x589c, 0x690e, 0x69cc, 0x8ffd, 0x939a, 0x75db, 0x901a, 0x585a, 0x6802, 0x63b4,
    0x69fb, 0x4f43, 0x6f2c, 0x67d8, 0x8fbb, 0x8526, 0x7db4, 0x9354, 0x693f, 0x6f70, 0x576a, 0x58f7, 0x5b2c, 0x7d2c, 0x722a, 0x540a,
    0x91e3, 0x9db4, 0x4ead, 0x4f4e, 0x505c, 0x5075, 0x5243, 0x8c9e, 0x5448, 0x5824, 0x5b9a, 0x5e1d, 0x5e95, 0x5ead, 0x5ef7, 0x5f1f,
    0x608c, 0x62b5, 0x633a, 0x63d0, 0x68af, 0x6c40, 0x7887, 0x798e, 0x7a0b, 0x7de0, 0x8247, 0x8a02, 0x8ae6, 0x8e44, 0x9013,

    /* 0xc5: 0xa1 - 0xfe*/
            0x90b8, 0x912d, 0x91d8, 0x9f0e, 0x6ce5, 0x6458, 0x64e2, 0x6575, 0x6ef4, 0x7684, 0x7b1b, 0x9069, 0x93d1, 0x6eba, 0x54f2,
    0x5fb9, 0x64a4, 0x8f4d, 0x8fed, 0x9244, 0x5178, 0x586b, 0x5929, 0x5c55, 0x5e97, 0x6dfb, 0x7e8f, 0x751c, 0x8cbc, 0x8ee2, 0x985b,
    0x70b9, 0x4f1d, 0x6bbf, 0x6fb1, 0x7530, 0x96fb, 0x514e, 0x5410, 0x5835, 0x5857, 0x59ac, 0x5c60, 0x5f92, 0x6597, 0x675c, 0x6e21,
    0x767b, 0x83df, 0x8ced, 0x9014, 0x90fd, 0x934d, 0x7825, 0x783a, 0x52aa, 0x5ea6, 0x571f, 0x5974, 0x6012, 0x5012, 0x515a, 0x51ac,
    0x51cd, 0x5200, 0x5510, 0x5854, 0x5858, 0x5957, 0x5b95, 0x5cf6, 0x5d8b, 0x60bc, 0x6295, 0x642d, 0x6771, 0x6843, 0x68bc, 0x68df,
    0x76d7, 0x6dd8, 0x6e6f, 0x6d9b, 0x706f, 0x71c8, 0x5f53, 0x75d8, 0x7977, 0x7b49, 0x7b54, 0x7b52, 0x7cd6, 0x7d71, 0x5230,

    /* 0xc6: 0xa1 - 0xfe*/
            0x8463, 0x8569, 0x85e4, 0x8a0e, 0x8b04, 0x8c46, 0x8e0f, 0x9003, 0x900f, 0x9419, 0x9676, 0x982d, 0x9a30, 0x95d8, 0x50cd,
    0x52d5, 0x540c, 0x5802, 0x5c0e, 0x61a7, 0x649e, 0x6d1e, 0x77b3, 0x7ae5, 0x80f4, 0x8404, 0x9053, 0x9285, 0x5ce0, 0x9d07, 0x533f,
    0x5f97, 0x5fb3, 0x6d9c, 0x7279, 0x7763, 0x79bf, 0x7be4, 0x6bd2, 0x72ec, 0x8aad, 0x6803, 0x6a61, 0x51f8, 0x7a81, 0x6934, 0x5c4a,
    0x9cf6, 0x82eb, 0x5bc5, 0x9149, 0x701e, 0x5678, 0x5c6f, 0x60c7, 0x6566, 0x6c8c, 0x8c5a, 0x9041, 0x9813, 0x5451, 0x66c7, 0x920d,
    0x5948, 0x90a3, 0x5185, 0x4e4d, 0x51ea, 0x8599, 0x8b0e, 0x7058, 0x637a, 0x934b, 0x6962, 0x99b4, 0x7e04, 0x7577, 0x5357, 0x6960,
    0x8edf, 0x96e3, 0x6c5d, 0x4e8c, 0x5c3c, 0x5f10, 0x8fe9, 0x5302, 0x8cd1, 0x8089, 0x8679, 0x5eff, 0x65e5, 0x4e73, 0x5165,

    /* 0xc7: 0xa1 - 0xfe*/
            0x5982, 0x5c3f, 0x97ee, 0x4efb, 0x598a, 0x5fcd, 0x8a8d, 0x6fe1, 0x79b0, 0x7962, 0x5be7, 0x8471, 0x732b, 0x71b1, 0x5e74,
    0x5ff5, 0x637b, 0x649a, 0x71c3, 0x7c98, 0x4e43, 0x5efc, 0x4e4b, 0x57dc, 0x56a2, 0x60a9, 0x6fc3, 0x7d0d, 0x80fd, 0x8133, 0x81bf,
    0x8fb2, 0x8997, 0x86a4, 0x5df4, 0x628a, 0x64ad, 0x8987, 0x6777, 0x6ce2, 0x6d3e, 0x7436, 0x7834, 0x5a46, 0x7f75, 0x82ad, 0x99ac,
    0x4ff3, 0x5ec3, 0x62dd, 0x6392, 0x6557, 0x676f, 0x76c3, 0x724c, 0x80cc, 0x80ba, 0x8f29, 0x914d, 0x500d, 0x57f9, 0x5a92, 0x6885,
    0x6973, 0x7164, 0x72fd, 0x8cb7, 0x58f2, 0x8ce0, 0x966a, 0x9019, 0x877f, 0x79e4, 0x77e7, 0x8429, 0x4f2f, 0x5265, 0x535a, 0x62cd,
    0x67cf, 0x6cca, 0x767d, 0x7b94, 0x7c95, 0x8236, 0x8584, 0x8feb, 0x66dd, 0x6f20, 0x7206, 0x7e1b, 0x83ab, 0x99c1, 0x9ea6,

    /* 0xc8: 0xa1 - 0xfe*/
            0x51fd, 0x7bb1, 0x7872, 0x7bb8, 0x8087, 0x7b48, 0x6ae8, 0x5e61, 0x808c, 0x7551, 0x7560, 0x516b, 0x9262, 0x6e8c, 0x767a,
    0x9197, 0x9aea, 0x4f10, 0x7f70, 0x629c, 0x7b4f, 0x95a5, 0x9ce9, 0x567a, 0x5859, 0x86e4, 0x96bc, 0x4f34, 0x5224, 0x534a, 0x53cd,
    0x53db, 0x5e06, 0x642c, 0x6591, 0x677f, 0x6c3e, 0x6c4e, 0x7248, 0x72af, 0x73ed, 0x7554, 0x7e41, 0x822c, 0x85e9, 0x8ca9, 0x7bc4,
    0x91c6, 0x7169, 0x9812, 0x98ef, 0x633d, 0x6669, 0x756a, 0x76e4, 0x78d0, 0x8543, 0x86ee, 0x532a, 0x5351, 0x5426, 0x5983, 0x5e87,
    0x5f7c, 0x60b2, 0x6249, 0x6279, 0x62ab, 0x6590, 0x6bd4, 0x6ccc, 0x75b2, 0x76ae, 0x7891, 0x79d8, 0x7dcb, 0x7f77, 0x80a5, 0x88ab,
    0x8ab9, 0x8cbb, 0x907f, 0x975e, 0x98db, 0x6a0b, 0x7c38, 0x5099, 0x5c3e, 0x5fae, 0x6787, 0x6bd8, 0x7435, 0x7709, 0x7f8e,

    /* 0xc9: 0xa1 - 0xfe*/
            0x9f3b, 0x67ca, 0x7a17, 0x5339, 0x758b, 0x9aed, 0x5f66, 0x819d, 0x83f1, 0x8098, 0x5f3c, 0x5fc5, 0x7562, 0x7b46, 0x903c,
    0x6867, 0x59eb, 0x5a9b, 0x7d10, 0x767e, 0x8b2c, 0x4ff5, 0x5f6a, 0x6a19, 0x6c37, 0x6f02, 0x74e2, 0x7968, 0x8868, 0x8a55, 0x8c79,
    0x5edf, 0x63cf, 0x75c5, 0x79d2, 0x82d7, 0x9328, 0x92f2, 0x849c, 0x86ed, 0x9c2d, 0x54c1, 0x5f6c, 0x658c, 0x6d5c, 0x7015, 0x8ca7,
    0x8cd3, 0x983b, 0x654f, 0x74f6, 0x4e0d, 0x4ed8, 0x57e0, 0x592b, 0x5a66, 0x5bcc, 0x51a8, 0x5e03, 0x5e9c, 0x6016, 0x6276, 0x6577,
    0x65a7, 0x666e, 0x6d6e, 0x7236, 0x7b26, 0x8150, 0x819a, 0x8299, 0x8b5c, 0x8ca0, 0x8ce6, 0x8d74, 0x961c, 0x9644, 0x4fae, 0x64ab,
    0x6b66, 0x821e, 0x8461, 0x856a, 0x90e8, 0x5c01, 0x6953, 0x98a8, 0x847a, 0x8557, 0x4f0f, 0x526f, 0x5fa9, 0x5e45, 0x670d,

    /* 0xca: 0xa1 - 0xfe*/
            0x798f, 0x8179, 0x8907, 0x8986, 0x6df5, 0x5f17, 0x6255, 0x6cb8, 0x4ecf, 0x7269, 0x9b92, 0x5206, 0x543b, 0x5674, 0x58b3,
    0x61a4, 0x626e, 0x711a, 0x596e, 0x7c89, 0x7cde, 0x7d1b, 0x96f0, 0x6587, 0x805e, 0x4e19, 0x4f75, 0x5175, 0x5840, 0x5e63, 0x5e73,
    0x5f0a, 0x67c4, 0x4e26, 0x853d, 0x9589, 0x965b, 0x7c73, 0x9801, 0x50fb, 0x58c1, 0x7656, 0x78a7, 0x5225, 0x77a5, 0x8511, 0x7b86,
    0x504f, 0x5909, 0x7247, 0x7bc7, 0x7de8, 0x8fba, 0x8fd4, 0x904d, 0x4fbf, 0x52c9, 0x5a29, 0x5f01, 0x97ad, 0x4fdd, 0x8217, 0x92ea,
    0x5703, 0x6355, 0x6b69, 0x752b, 0x88dc, 0x8f14, 0x7a42, 0x52df, 0x5893, 0x6155, 0x620a, 0x66ae, 0x6bcd, 0x7c3f, 0x83e9, 0x5023,
    0x4ff8, 0x5305, 0x5446, 0x5831, 0x5949, 0x5b9d, 0x5cf0, 0x5cef, 0x5d29, 0x5e96, 0x62b1, 0x6367, 0x653e, 0x65b9, 0x670b,

    /* 0xcb: 0xa1 - 0xfe*/
            0x6cd5, 0x6ce1, 0x70f9, 0x7832, 0x7e2b, 0x80de, 0x82b3, 0x840c, 0x84ec, 0x8702, 0x8912, 0x8a2a, 0x8c4a, 0x90a6, 0x92d2,
    0x98fd, 0x9cf3, 0x9d6c, 0x4e4f, 0x4ea1, 0x508d, 0x5256, 0x574a, 0x59a8, 0x5e3d, 0x5fd8, 0x5fd9, 0x623f, 0x66b4, 0x671b, 0x67d0,
    0x68d2, 0x5192, 0x7d21, 0x80aa, 0x81a8, 0x8b00, 0x8c8c, 0x8cbf, 0x927e, 0x9632, 0x5420, 0x982c, 0x5317, 0x50d5, 0x535c, 0x58a8,
    0x64b2, 0x6734, 0x7267, 0x7766, 0x7a46, 0x91e6, 0x52c3, 0x6ca1, 0x6b86, 0x5800, 0x5e4c, 0x5954, 0x672c, 0x7ffb, 0x51e1, 0x76c6,
    0x6469, 0x78e8, 0x9b54, 0x9ebb, 0x57cb, 0x59b9, 0x6627, 0x679a, 0x6bce, 0x54e9, 0x69d9, 0x5e55, 0x819c, 0x6795, 0x9baa, 0x67fe,
    0x9c52, 0x685d, 0x4ea6, 0x4fe3, 0x53c8, 0x62b9, 0x672b, 0x6cab, 0x8fc4, 0x4fad, 0x7e6d, 0x9ebf, 0x4e07, 0x6162, 0x6e80,

    /* 0xcc: 0xa1 - 0xfe*/
            0x6f2b, 0x8513, 0x5473, 0x672a, 0x9b45, 0x5df3, 0x7b95, 0x5cac, 0x5bc6, 0x871c, 0x6e4a, 0x84d1, 0x7a14, 0x8108, 0x5999,
    0x7c8d, 0x6c11, 0x7720, 0x52d9, 0x5922, 0x7121, 0x725f, 0x77db, 0x9727, 0x9d61, 0x690b, 0x5a7f, 0x5a18, 0x51a5, 0x540d, 0x547d,
    0x660e, 0x76df, 0x8ff7, 0x9298, 0x9cf4, 0x59ea, 0x725d, 0x6ec5, 0x514d, 0x68c9, 0x7dbf, 0x7dec, 0x9762, 0x9eba, 0x6478, 0x6a21,
    0x8302, 0x5984, 0x5b5f, 0x6bdb, 0x731b, 0x76f2, 0x7db2, 0x8017, 0x8499, 0x5132, 0x6728, 0x9ed9, 0x76ee, 0x6762, 0x52ff, 0x9905,
    0x5c24, 0x623b, 0x7c7e, 0x8cb0, 0x554f, 0x60b6, 0x7d0b, 0x9580, 0x5301, 0x4e5f, 0x51b6, 0x591c, 0x723a, 0x8036, 0x91ce, 0x5f25,
    0x77e2, 0x5384, 0x5f79, 0x7d04, 0x85ac, 0x8a33, 0x8e8d, 0x9756, 0x67f3, 0x85ae, 0x9453, 0x6109, 0x6108, 0x6cb9, 0x7652,

    /* 0xcd: 0xa1 - 0xfe*/
            0x8aed, 0x8f38, 0x552f, 0x4f51, 0x512a, 0x52c7, 0x53cb, 0x5ba5, 0x5e7d, 0x60a0, 0x6182, 0x63d6, 0x6709, 0x67da, 0x6e67,
    0x6d8c, 0x7336, 0x7337, 0x7531, 0x7950, 0x88d5, 0x8a98, 0x904a, 0x9091, 0x90f5, 0x96c4, 0x878d, 0x5915, 0x4e88, 0x4f59, 0x4e0e,
    0x8a89, 0x8f3f, 0x9810, 0x50ad, 0x5e7c, 0x5996, 0x5bb9, 0x5eb8, 0x63da, 0x63fa, 0x64c1, 0x66dc, 0x694a, 0x69d8, 0x6d0b, 0x6eb6,
    0x7194, 0x7528, 0x7aaf, 0x7f8a, 0x8000, 0x8449, 0x84c9, 0x8981, 0x8b21, 0x8e0a, 0x9065, 0x967d, 0x990a, 0x617e, 0x6291, 0x6b32,
    0x6c83, 0x6d74, 0x7fcc, 0x7ffc, 0x6dc0, 0x7f85, 0x87ba, 0x88f8, 0x6765, 0x83b1, 0x983c, 0x96f7, 0x6d1b, 0x7d61, 0x843d, 0x916a,
    0x4e71, 0x5375, 0x5d50, 0x6b04, 0x6feb, 0x85cd, 0x862d, 0x89a7, 0x5229, 0x540f, 0x5c65, 0x674e, 0x68a8, 0x7406, 0x7483,

    /* 0xce: 0xa1 - 0xfe*/
            0x75e2, 0x88cf, 0x88e1, 0x91cc, 0x96e2, 0x9678, 0x5f8b, 0x7387, 0x7acb, 0x844e, 0x63a0, 0x7565, 0x5289, 0x6d41, 0x6e9c,
    0x7409, 0x7559, 0x786b, 0x7c92, 0x9686, 0x7adc, 0x9f8d, 0x4fb6, 0x616e, 0x65c5, 0x865c, 0x4e86, 0x4eae, 0x50da, 0x4e21, 0x51cc,
    0x5bee, 0x6599, 0x6881, 0x6dbc, 0x731f, 0x7642, 0x77ad, 0x7a1c, 0x7ce7, 0x826f, 0x8ad2, 0x907c, 0x91cf, 0x9675, 0x9818, 0x529b,
    0x7dd1, 0x502b, 0x5398, 0x6797, 0x6dcb, 0x71d0, 0x7433, 0x81e8, 0x8f2a, 0x96a3, 0x9c57, 0x9e9f, 0x7460, 0x5841, 0x6d99, 0x7d2f,
    0x985e, 0x4ee4, 0x4f36, 0x4f8b, 0x51b7, 0x52b1, 0x5dba, 0x601c, 0x73b2, 0x793c, 0x82d3, 0x9234, 0x96b7, 0x96f6, 0x970a, 0x9e97,
    0x9f62, 0x66a6, 0x6b74, 0x5217, 0x52a3, 0x70c8, 0x88c2, 0x5ec9, 0x604b, 0x6190, 0x6f23, 0x7149, 0x7c3e, 0x7df4, 0x806f,

    /* 0xcf: 0xa1 - 0xd3*/
            0x84ee, 0x9023, 0x932c, 0x5442, 0x9b6f, 0x6ad3, 0x7089, 0x8cc2, 0x8def, 0x9732, 0x52b4, 0x5a41, 0x5eca, 0x5f04, 0x6717,
    0x697c, 0x6994, 0x6d6a, 0x6f0f, 0x7262, 0x72fc, 0x7bed, 0x8001, 0x807e, 0x874b, 0x90ce, 0x516d, 0x9e93, 0x7984, 0x808b, 0x9332,
    0x8ad6, 0x502d, 0x548c, 0x8a71, 0x6b6a, 0x8cc4, 0x8107, 0x60d1, 0x67a0, 0x9df2, 0x4e99, 0x4e98, 0x9c10, 0x8a6b, 0x85c1, 0x8568,
    0x6900, 0x6e7e, 0x7897, 0x8155,

    /* 0xd0: 0xa1 - 0xfe*/
            0x5f0c, 0x4e10, 0x4e15, 0x4e2a, 0x4e31, 0x4e36, 0x4e3c, 0x4e3f, 0x4e42, 0x4e56, 0x4e58, 0x4e82, 0x4e85, 0x8c6b, 0x4e8a,
    0x8212, 0x5f0d, 0x4e8e, 0x4e9e, 0x4e9f, 0x4ea0, 0x4ea2, 0x4eb0, 0x4eb3, 0x4eb6, 0x4ece, 0x4ecd, 0x4ec4, 0x4ec6, 0x4ec2, 0x4ed7,
    0x4ede, 0x4eed, 0x4edf, 0x4ef7, 0x4f09, 0x4f5a, 0x4f30, 0x4f5b, 0x4f5d, 0x4f57, 0x4f47, 0x4f76, 0x4f88, 0x4f8f, 0x4f98, 0x4f7b,
    0x4f69, 0x4f70, 0x4f91, 0x4f6f, 0x4f86, 0x4f96, 0x5118, 0x4fd4, 0x4fdf, 0x4fce, 0x4fd8, 0x4fdb, 0x4fd1, 0x4fda, 0x4fd0, 0x4fe4,
    0x4fe5, 0x501a, 0x5028, 0x5014, 0x502a, 0x5025, 0x5005, 0x4f1c, 0x4ff6, 0x5021, 0x5029, 0x502c, 0x4ffe, 0x4fef, 0x5011, 0x5006,
    0x5043, 0x5047, 0x6703, 0x5055, 0x5050, 0x5048, 0x505a, 0x5056, 0x506c, 0x5078, 0x5080, 0x509a, 0x5085, 0x50b4, 0x50b2,

    /* 0xd1: 0xa1 - 0xfe*/
            0x50c9, 0x50ca, 0x50b3, 0x50c2, 0x50d6, 0x50de, 0x50e5, 0x50ed, 0x50e3, 0x50ee, 0x50f9, 0x50f5, 0x5109, 0x5101, 0x5102,
    0x5116, 0x5115, 0x5114, 0x511a, 0x5121, 0x513a, 0x5137, 0x513c, 0x513b, 0x513f, 0x5140, 0x5152, 0x514c, 0x5154, 0x5162, 0x7af8,
    0x5169, 0x516a, 0x516e, 0x5180, 0x5182, 0x56d8, 0x518c, 0x5189, 0x518f, 0x5191, 0x5193, 0x5195, 0x5196, 0x51a4, 0x51a6, 0x51a2,
    0x51a9, 0x51aa, 0x51ab, 0x51b3, 0x51b1, 0x51b2, 0x51b0, 0x51b5, 0x51bd, 0x51c5, 0x51c9, 0x51db, 0x51e0, 0x8655, 0x51e9, 0x51ed,
    0x51f0, 0x51f5, 0x51fe, 0x5204, 0x520b, 0x5214, 0x520e, 0x5227, 0x522a, 0x522e, 0x5233, 0x5239, 0x524f, 0x5244, 0x524b, 0x524c,
    0x525e, 0x5254, 0x526a, 0x5274, 0x5269, 0x5273, 0x527f, 0x527d, 0x528d, 0x5294, 0x5292, 0x5271, 0x5288, 0x5291, 0x8fa8,

    /* 0xd2: 0xa1 - 0xfe*/
            0x8fa7, 0x52ac, 0x52ad, 0x52bc, 0x52b5, 0x52c1, 0x52cd, 0x52d7, 0x52de, 0x52e3, 0x52e6, 0x98ed, 0x52e0, 0x52f3, 0x52f5,
    0x52f8, 0x52f9, 0x5306, 0x5308, 0x7538, 0x530d, 0x5310, 0x530f, 0x5315, 0x531a, 0x5323, 0x532f, 0x5331, 0x5333, 0x5338, 0x5340,
    0x5346, 0x5345, 0x4e17, 0x5349, 0x534d, 0x51d6, 0x535e, 0x5369, 0x536e, 0x5918, 0x537b, 0x5377, 0x5382, 0x5396, 0x53a0, 0x53a6,
    0x53a5, 0x53ae, 0x53b0, 0x53b6, 0x53c3, 0x7c12, 0x96d9, 0x53df, 0x66fc, 0x71ee, 0x53ee, 0x53e8, 0x53ed, 0x53fa, 0x5401, 0x543d,
    0x5440, 0x542c, 0x542d, 0x543c, 0x542e, 0x5436, 0x5429, 0x541d, 0x544e, 0x548f, 0x5475, 0x548e, 0x545f, 0x5471, 0x5477, 0x5470,
    0x5492, 0x547b, 0x5480, 0x5476, 0x5484, 0x5490, 0x5486, 0x54c7, 0x54a2, 0x54b8, 0x54a5, 0x54ac, 0x54c4, 0x54c8, 0x54a8,

    /* 0xd3: 0xa1 - 0xfe*/
            0x54ab, 0x54c2, 0x54a4, 0x54be, 0x54bc, 0x54d8, 0x54e5, 0x54e6, 0x550f, 0x5514, 0x54fd, 0x54ee, 0x54ed, 0x54fa, 0x54e2,
    0x5539, 0x5540, 0x5563, 0x554c, 0x552e, 0x555c, 0x5545, 0x5556, 0x5557, 0x5538, 0x5533, 0x555d, 0x5599, 0x5580, 0x54af, 0x558a,
    0x559f, 0x557b, 0x557e, 0x5598, 0x559e, 0x55ae, 0x557c, 0x5583, 0x55a9, 0x5587, 0x55a8, 0x55da, 0x55c5, 0x55df, 0x55c4, 0x55dc,
    0x55e4, 0x55d4, 0x5614, 0x55f7, 0x5616, 0x55fe, 0x55fd, 0x561b, 0x55f9, 0x564e, 0x5650, 0x71df, 0x5634, 0x5636, 0x5632, 0x5638,
    0x566b, 0x5664, 0x562f, 0x566c, 0x566a, 0x5686, 0x5680, 0x568a, 0x56a0, 0x5694, 0x568f, 0x56a5, 0x56ae, 0x56b6, 0x56b4, 0x56c2,
    0x56bc, 0x56c1, 0x56c3, 0x56c0, 0x56c8, 0x56ce, 0x56d1, 0x56d3, 0x56d7, 0x56ee, 0x56f9, 0x5700, 0x56ff, 0x5704, 0x5709,

    /* 0xd4: 0xa1 - 0xfe*/
            0x5708, 0x570b, 0x570d, 0x5713, 0x5718, 0x5716, 0x55c7, 0x571c, 0x5726, 0x5737, 0x5738, 0x574e, 0x573b, 0x5740, 0x574f,
    0x5769, 0x57c0, 0x5788, 0x5761, 0x577f, 0x5789, 0x5793, 0x57a0, 0x57b3, 0x57a4, 0x57aa, 0x57b0, 0x57c3, 0x57c6, 0x57d4, 0x57d2,
    0x57d3, 0x580a, 0x57d6, 0x57e3, 0x580b, 0x5819, 0x581d, 0x5872, 0x5821, 0x5862, 0x584b, 0x5870, 0x6bc0, 0x5852, 0x583d, 0x5879,
    0x5885, 0x58b9, 0x589f, 0x58ab, 0x58ba, 0x58de, 0x58bb, 0x58b8, 0x58ae, 0x58c5, 0x58d3, 0x58d1, 0x58d7, 0x58d9, 0x58d8, 0x58e5,
    0x58dc, 0x58e4, 0x58df, 0x58ef, 0x58fa, 0x58f9, 0x58fb, 0x58fc, 0x58fd, 0x5902, 0x590a, 0x5910, 0x591b, 0x68a6, 0x5925, 0x592c,
    0x592d, 0x5932, 0x5938, 0x593e, 0x7ad2, 0x5955, 0x5950, 0x594e, 0x595a, 0x5958, 0x5962, 0x5960, 0x5967, 0x596c, 0x5969,

    /* 0xd5: 0xa1 - 0xfe*/
            0x5978, 0x5981, 0x599d, 0x4f5e, 0x4fab, 0x59a3, 0x59b2, 0x59c6, 0x59e8, 0x59dc, 0x598d, 0x59d9, 0x59da, 0x5a25, 0x5a1f,
    0x5a11, 0x5a1c, 0x5a09, 0x5a1a, 0x5a40, 0x5a6c, 0x5a49, 0x5a35, 0x5a36, 0x5a62, 0x5a6a, 0x5a9a, 0x5abc, 0x5abe, 0x5acb, 0x5ac2,
    0x5abd, 0x5ae3, 0x5ad7, 0x5ae6, 0x5ae9, 0x5ad6, 0x5afa, 0x5afb, 0x5b0c, 0x5b0b, 0x5b16, 0x5b32, 0x5ad0, 0x5b2a, 0x5b36, 0x5b3e,
    0x5b43, 0x5b45, 0x5b40, 0x5b51, 0x5b55, 0x5b5a, 0x5b5b, 0x5b65, 0x5b69, 0x5b70, 0x5b73, 0x5b75, 0x5b78, 0x6588, 0x5b7a, 0x5b80,
    0x5b83, 0x5ba6, 0x5bb8, 0x5bc3, 0x5bc7, 0x5bc9, 0x5bd4, 0x5bd0, 0x5be4, 0x5be6, 0x5be2, 0x5bde, 0x5be5, 0x5beb, 0x5bf0, 0x5bf6,
    0x5bf3, 0x5c05, 0x5c07, 0x5c08, 0x5c0d, 0x5c13, 0x5c20, 0x5c22, 0x5c28, 0x5c38, 0x5c39, 0x5c41, 0x5c46, 0x5c4e, 0x5c53,

    /* 0xd6: 0xa1 - 0xfe*/
            0x5c50, 0x5c4f, 0x5b71, 0x5c6c, 0x5c6e, 0x4e62, 0x5c76, 0x5c79, 0x5c8c, 0x5c91, 0x5c94, 0x599b, 0x5cab, 0x5cbb, 0x5cb6,
    0x5cbc, 0x5cb7, 0x5cc5, 0x5cbe, 0x5cc7, 0x5cd9, 0x5ce9, 0x5cfd, 0x5cfa, 0x5ced, 0x5d8c, 0x5cea, 0x5d0b, 0x5d15, 0x5d17, 0x5d5c,
    0x5d1f, 0x5d1b, 0x5d11, 0x5d14, 0x5d22, 0x5d1a, 0x5d19, 0x5d18, 0x5d4c, 0x5d52, 0x5d4e, 0x5d4b, 0x5d6c, 0x5d73, 0x5d76, 0x5d87,
    0x5d84, 0x5d82, 0x5da2, 0x5d9d, 0x5dac, 0x5dae, 0x5dbd, 0x5d90, 0x5db7, 0x5dbc, 0x5dc9, 0x5dcd, 0x5dd3, 0x5dd2, 0x5dd6, 0x5ddb,
    0x5deb, 0x5df2, 0x5df5, 0x5e0b, 0x5e1a, 0x5e19, 0x5e11, 0x5e1b, 0x5e36, 0x5e37, 0x5e44, 0x5e43, 0x5e40, 0x5e4e, 0x5e57, 0x5e54,
    0x5e5f, 0x5e62, 0x5e64, 0x5e47, 0x5e75, 0x5e76, 0x5e7a, 0x9ebc, 0x5e7f, 0x5ea0, 0x5ec1, 0x5ec2, 0x5ec8, 0x5ed0, 0x5ecf,

    /* 0xd7: 0xa1 - 0xfe*/
            0x5ed6, 0x5ee3, 0x5edd, 0x5eda, 0x5edb, 0x5ee2, 0x5ee1, 0x5ee8, 0x5ee9, 0x5eec, 0x5ef1, 0x5ef3, 0x5ef0, 0x5ef4, 0x5ef8,
    0x5efe, 0x5f03, 0x5f09, 0x5f5d, 0x5f5c, 0x5f0b, 0x5f11, 0x5f16, 0x5f29, 0x5f2d, 0x5f38, 0x5f41, 0x5f48, 0x5f4c, 0x5f4e, 0x5f2f,
    0x5f51, 0x5f56, 0x5f57, 0x5f59, 0x5f61, 0x5f6d, 0x5f73, 0x5f77, 0x5f83, 0x5f82, 0x5f7f, 0x5f8a, 0x5f88, 0x5f91, 0x5f87, 0x5f9e,
    0x5f99, 0x5f98, 0x5fa0, 0x5fa8, 0x5fad, 0x5fbc, 0x5fd6, 0x5ffb, 0x5fe4, 0x5ff8, 0x5ff1, 0x5fdd, 0x60b3, 0x5fff, 0x6021, 0x6060,
    0x6019, 0x6010, 0x6029, 0x600e, 0x6031, 0x601b, 0x6015, 0x602b, 0x6026, 0x600f, 0x603a, 0x605a, 0x6041, 0x606a, 0x6077, 0x605f,
    0x604a, 0x6046, 0x604d, 0x6063, 0x6043, 0x6064, 0x6042, 0x606c, 0x606b, 0x6059, 0x6081, 0x608d, 0x60e7, 0x6083, 0x609a,

    /* 0xd8: 0xa1 - 0xfe*/
            0x6084, 0x609b, 0x6096, 0x6097, 0x6092, 0x60a7, 0x608b, 0x60e1, 0x60b8, 0x60e0, 0x60d3, 0x60b4, 0x5ff0, 0x60bd, 0x60c6,
    0x60b5, 0x60d8, 0x614d, 0x6115, 0x6106, 0x60f6, 0x60f7, 0x6100, 0x60f4, 0x60fa, 0x6103, 0x6121, 0x60fb, 0x60f1, 0x610d, 0x610e,
    0x6147, 0x613e, 0x6128, 0x6127, 0x614a, 0x613f, 0x613c, 0x612c, 0x6134, 0x613d, 0x6142, 0x6144, 0x6173, 0x6177, 0x6158, 0x6159,
    0x615a, 0x616b, 0x6174, 0x616f, 0x6165, 0x6171, 0x615f, 0x615d, 0x6153, 0x6175, 0x6199, 0x6196, 0x6187, 0x61ac, 0x6194, 0x619a,
    0x618a, 0x6191, 0x61ab, 0x61ae, 0x61cc, 0x61ca, 0x61c9, 0x61f7, 0x61c8, 0x61c3, 0x61c6, 0x61ba, 0x61cb, 0x7f79, 0x61cd, 0x61e6,
    0x61e3, 0x61f6, 0x61fa, 0x61f4, 0x61ff, 0x61fd, 0x61fc, 0x61fe, 0x6200, 0x6208, 0x6209, 0x620d, 0x620c, 0x6214, 0x621b,

    /* 0xd9: 0xa1 - 0xfe*/
            0x621e, 0x6221, 0x622a, 0x622e, 0x6230, 0x6232, 0x6233, 0x6241, 0x624e, 0x625e, 0x6263, 0x625b, 0x6260, 0x6268, 0x627c,
    0x6282, 0x6289, 0x627e, 0x6292, 0x6293, 0x6296, 0x62d4, 0x6283, 0x6294, 0x62d7, 0x62d1, 0x62bb, 0x62cf, 0x62ff, 0x62c6, 0x64d4,
    0x62c8, 0x62dc, 0x62cc, 0x62ca, 0x62c2, 0x62c7, 0x629b, 0x62c9, 0x630c, 0x62ee, 0x62f1, 0x6327, 0x6302, 0x6308, 0x62ef, 0x62f5,
    0x6350, 0x633e, 0x634d, 0x641c, 0x634f, 0x6396, 0x638e, 0x6380, 0x63ab, 0x6376, 0x63a3, 0x638f, 0x6389, 0x639f, 0x63b5, 0x636b,
    0x6369, 0x63be, 0x63e9, 0x63c0, 0x63c6, 0x63e3, 0x63c9, 0x63d2, 0x63f6, 0x63c4, 0x6416, 0x6434, 0x6406, 0x6413, 0x6426, 0x6436,
    0x651d, 0x6417, 0x6428, 0x640f, 0x6467, 0x646f, 0x6476, 0x644e, 0x652a, 0x6495, 0x6493, 0x64a5, 0x64a9, 0x6488, 0x64bc,

    /* 0xda: 0xa1 - 0xfe*/
            0x64da, 0x64d2, 0x64c5, 0x64c7, 0x64bb, 0x64d8, 0x64c2, 0x64f1, 0x64e7, 0x8209, 0x64e0, 0x64e1, 0x62ac, 0x64e3, 0x64ef,
    0x652c, 0x64f6, 0x64f4, 0x64f2, 0x64fa, 0x6500, 0x64fd, 0x6518, 0x651c, 0x6505, 0x6524, 0x6523, 0x652b, 0x6534, 0x6535, 0x6537,
    0x6536, 0x6538, 0x754b, 0x6548, 0x6556, 0x6555, 0x654d, 0x6558, 0x655e, 0x655d, 0x6572, 0x6578, 0x6582, 0x6583, 0x8b8a, 0x659b,
    0x659f, 0x65ab, 0x65b7, 0x65c3, 0x65c6, 0x65c1, 0x65c4, 0x65cc, 0x65d2, 0x65db, 0x65d9, 0x65e0, 0x65e1, 0x65f1, 0x6772, 0x660a,
    0x6603, 0x65fb, 0x6773, 0x6635, 0x6636, 0x6634, 0x661c, 0x664f, 0x6644, 0x6649, 0x6641, 0x665e, 0x665d, 0x6664, 0x6667, 0x6668,
    0x665f, 0x6662, 0x6670, 0x6683, 0x6688, 0x668e, 0x6689, 0x6684, 0x6698, 0x669d, 0x66c1, 0x66b9, 0x66c9, 0x66be, 0x66bc,

    /* 0xdb: 0xa1 - 0xfe*/
            0x66c4, 0x66b8, 0x66d6, 0x66da, 0x66e0, 0x663f, 0x66e6, 0x66e9, 0x66f0, 0x66f5, 0x66f7, 0x670f, 0x6716, 0x671e, 0x6726,
    0x6727, 0x9738, 0x672e, 0x673f, 0x6736, 0x6741, 0x6738, 0x6737, 0x6746, 0x675e, 0x6760, 0x6759, 0x6763, 0x6764, 0x6789, 0x6770,
    0x67a9, 0x677c, 0x676a, 0x678c, 0x678b, 0x67a6, 0x67a1, 0x6785, 0x67b7, 0x67ef, 0x67b4, 0x67ec, 0x67b3, 0x67e9, 0x67b8, 0x67e4,
    0x67de, 0x67dd, 0x67e2, 0x67ee, 0x67b9, 0x67ce, 0x67c6, 0x67e7, 0x6a9c, 0x681e, 0x6846, 0x6829, 0x6840, 0x684d, 0x6832, 0x684e,
    0x68b3, 0x682b, 0x6859, 0x6863, 0x6877, 0x687f, 0x689f, 0x688f, 0x68ad, 0x6894, 0x689d, 0x689b, 0x6883, 0x6aae, 0x68b9, 0x6874,
    0x68b5, 0x68a0, 0x68ba, 0x690f, 0x688d, 0x687e, 0x6901, 0x68ca, 0x6908, 0x68d8, 0x6922, 0x6926, 0x68e1, 0x690c, 0x68cd,

    /* 0xdc: 0xa1 - 0xfe*/
            0x68d4, 0x68e7, 0x68d5, 0x6936, 0x6912, 0x6904, 0x68d7, 0x68e3, 0x6925, 0x68f9, 0x68e0, 0x68ef, 0x6928, 0x692a, 0x691a,
    0x6923, 0x6921, 0x68c6, 0x6979, 0x6977, 0x695c, 0x6978, 0x696b, 0x6954, 0x697e, 0x696e, 0x6939, 0x6974, 0x693d, 0x6959, 0x6930,
    0x6961, 0x695e, 0x695d, 0x6981, 0x696a, 0x69b2, 0x69ae, 0x69d0, 0x69bf, 0x69c1, 0x69d3, 0x69be, 0x69ce, 0x5be8, 0x69ca, 0x69dd,
    0x69bb, 0x69c3, 0x69a7, 0x6a2e, 0x6991, 0x69a0, 0x699c, 0x6995, 0x69b4, 0x69de, 0x69e8, 0x6a02, 0x6a1b, 0x69ff, 0x6b0a, 0x69f9,
    0x69f2, 0x69e7, 0x6a05, 0x69b1, 0x6a1e, 0x69ed, 0x6a14, 0x69eb, 0x6a0a, 0x6a12, 0x6ac1, 0x6a23, 0x6a13, 0x6a44, 0x6a0c, 0x6a72,
    0x6a36, 0x6a78, 0x6a47, 0x6a62, 0x6a59, 0x6a66, 0x6a48, 0x6a38, 0x6a22, 0x6a90, 0x6a8d, 0x6aa0, 0x6a84, 0x6aa2, 0x6aa3,

    /* 0xdd: 0xa1 - 0xfe*/
            0x6a97, 0x8617, 0x6abb, 0x6ac3, 0x6ac2, 0x6ab8, 0x6ab3, 0x6aac, 0x6ade, 0x6ad1, 0x6adf, 0x6aaa, 0x6ada, 0x6aea, 0x6afb,
    0x6b05, 0x8616, 0x6afa, 0x6b12, 0x6b16, 0x9b31, 0x6b1f, 0x6b38, 0x6b37, 0x76dc, 0x6b39, 0x98ee, 0x6b47, 0x6b43, 0x6b49, 0x6b50,
    0x6b59, 0x6b54, 0x6b5b, 0x6b5f, 0x6b61, 0x6b78, 0x6b79, 0x6b7f, 0x6b80, 0x6b84, 0x6b83, 0x6b8d, 0x6b98, 0x6b95, 0x6b9e, 0x6ba4,
    0x6baa, 0x6bab, 0x6baf, 0x6bb2, 0x6bb1, 0x6bb3, 0x6bb7, 0x6bbc, 0x6bc6, 0x6bcb, 0x6bd3, 0x6bdf, 0x6bec, 0x6beb, 0x6bf3, 0x6bef,
    0x9ebe, 0x6c08, 0x6c13, 0x6c14, 0x6c1b, 0x6c24, 0x6c23, 0x6c5e, 0x6c55, 0x6c62, 0x6c6a, 0x6c82, 0x6c8d, 0x6c9a, 0x6c81, 0x6c9b,
    0x6c7e, 0x6c68, 0x6c73, 0x6c92, 0x6c90, 0x6cc4, 0x6cf1, 0x6cd3, 0x6cbd, 0x6cd7, 0x6cc5, 0x6cdd, 0x6cae, 0x6cb1, 0x6cbe,

    /* 0xde: 0xa1 - 0xfe*/
            0x6cba, 0x6cdb, 0x6cef, 0x6cd9, 0x6cea, 0x6d1f, 0x884d, 0x6d36, 0x6d2b, 0x6d3d, 0x6d38, 0x6d19, 0x6d35, 0x6d33, 0x6d12,
    0x6d0c, 0x6d63, 0x6d93, 0x6d64, 0x6d5a, 0x6d79, 0x6d59, 0x6d8e, 0x6d95, 0x6fe4, 0x6d85, 0x6df9, 0x6e15, 0x6e0a, 0x6db5, 0x6dc7,
    0x6de6, 0x6db8, 0x6dc6, 0x6dec, 0x6dde, 0x6dcc, 0x6de8, 0x6dd2, 0x6dc5, 0x6dfa, 0x6dd9, 0x6de4, 0x6dd5, 0x6dea, 0x6dee, 0x6e2d,
    0x6e6e, 0x6e2e, 0x6e19, 0x6e72, 0x6e5f, 0x6e3e, 0x6e23, 0x6e6b, 0x6e2b, 0x6e76, 0x6e4d, 0x6e1f, 0x6e43, 0x6e3a, 0x6e4e, 0x6e24,
    0x6eff, 0x6e1d, 0x6e38, 0x6e82, 0x6eaa, 0x6e98, 0x6ec9, 0x6eb7, 0x6ed3, 0x6ebd, 0x6eaf, 0x6ec4, 0x6eb2, 0x6ed4, 0x6ed5, 0x6e8f,
    0x6ea5, 0x6ec2, 0x6e9f, 0x6f41, 0x6f11, 0x704c, 0x6eec, 0x6ef8, 0x6efe, 0x6f3f, 0x6ef2, 0x6f31, 0x6eef, 0x6f32, 0x6ecc,

    /* 0xdf: 0xa1 - 0xfe*/
            0x6f3e, 0x6f13, 0x6ef7, 0x6f86, 0x6f7a, 0x6f78, 0x6f81, 0x6f80, 0x6f6f, 0x6f5b, 0x6ff3, 0x6f6d, 0x6f82, 0x6f7c, 0x6f58,
    0x6f8e, 0x6f91, 0x6fc2, 0x6f66, 0x6fb3, 0x6fa3, 0x6fa1, 0x6fa4, 0x6fb9, 0x6fc6, 0x6faa, 0x6fdf, 0x6fd5, 0x6fec, 0x6fd4, 0x6fd8,
    0x6ff1, 0x6fee, 0x6fdb, 0x7009, 0x700b, 0x6ffa, 0x7011, 0x7001, 0x700f, 0x6ffe, 0x701b, 0x701a, 0x6f74, 0x701d, 0x7018, 0x701f,
    0x7030, 0x703e, 0x7032, 0x7051, 0x7063, 0x7099, 0x7092, 0x70af, 0x70f1, 0x70ac, 0x70b8, 0x70b3, 0x70ae, 0x70df, 0x70cb, 0x70dd,
    0x70d9, 0x7109, 0x70fd, 0x711c, 0x7119, 0x7165, 0x7155, 0x7188, 0x7166, 0x7162, 0x714c, 0x7156, 0x716c, 0x718f, 0x71fb, 0x7184,
    0x7195, 0x71a8, 0x71ac, 0x71d7, 0x71b9, 0x71be, 0x71d2, 0x71c9, 0x71d4, 0x71ce, 0x71e0, 0x71ec, 0x71e7, 0x71f5, 0x71fc,

    /* 0xe0: 0xa1 - 0xfe*/
            0x71f9, 0x71ff, 0x720d, 0x7210, 0x721b, 0x7228, 0x722d, 0x722c, 0x7230, 0x7232, 0x723b, 0x723c, 0x723f, 0x7240, 0x7246,
    0x724b, 0x7258, 0x7274, 0x727e, 0x7282, 0x7281, 0x7287, 0x7292, 0x7296, 0x72a2, 0x72a7, 0x72b9, 0x72b2, 0x72c3, 0x72c6, 0x72c4,
    0x72ce, 0x72d2, 0x72e2, 0x72e0, 0x72e1, 0x72f9, 0x72f7, 0x500f, 0x7317, 0x730a, 0x731c, 0x7316, 0x731d, 0x7334, 0x732f, 0x7329,
    0x7325, 0x733e, 0x734e, 0x734f, 0x9ed8, 0x7357, 0x736a, 0x7368, 0x7370, 0x7378, 0x7375, 0x737b, 0x737a, 0x73c8, 0x73b3, 0x73ce,
    0x73bb, 0x73c0, 0x73e5, 0x73ee, 0x73de, 0x74a2, 0x7405, 0x746f, 0x7425, 0x73f8, 0x7432, 0x743a, 0x7455, 0x743f, 0x745f, 0x7459,
    0x7441, 0x745c, 0x7469, 0x7470, 0x7463, 0x746a, 0x7476, 0x747e, 0x748b, 0x749e, 0x74a7, 0x74ca, 0x74cf, 0x74d4, 0x73f1,

    /* 0xe1: 0xa1 - 0xfe*/
            0x74e0, 0x74e3, 0x74e7, 0x74e9, 0x74ee, 0x74f2, 0x74f0, 0x74f1, 0x74f8, 0x74f7, 0x7504, 0x7503, 0x7505, 0x750c, 0x750e,
    0x750d, 0x7515, 0x7513, 0x751e, 0x7526, 0x752c, 0x753c, 0x7544, 0x754d, 0x754a, 0x7549, 0x755b, 0x7546, 0x755a, 0x7569, 0x7564,
    0x7567, 0x756b, 0x756d, 0x7578, 0x7576, 0x7586, 0x7587, 0x7574, 0x758a, 0x7589, 0x7582, 0x7594, 0x759a, 0x759d, 0x75a5, 0x75a3,
    0x75c2, 0x75b3, 0x75c3, 0x75b5, 0x75bd, 0x75b8, 0x75bc, 0x75b1, 0x75cd, 0x75ca, 0x75d2, 0x75d9, 0x75e3, 0x75de, 0x75fe, 0x75ff,
    0x75fc, 0x7601, 0x75f0, 0x75fa, 0x75f2, 0x75f3, 0x760b, 0x760d, 0x7609, 0x761f, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624, 0x7634,
    0x7630, 0x763b, 0x7647, 0x7648, 0x7646, 0x765c, 0x7658, 0x7661, 0x7662, 0x7668, 0x7669, 0x766a, 0x7667, 0x766c, 0x7670,

    /* 0xe2: 0xa1 - 0xfe*/
            0x7672, 0x7676, 0x7678, 0x767c, 0x7680, 0x7683, 0x7688, 0x768b, 0x768e, 0x7696, 0x7693, 0x7699, 0x769a, 0x76b0, 0x76b4,
    0x76b8, 0x76b9, 0x76ba, 0x76c2, 0x76cd, 0x76d6, 0x76d2, 0x76de, 0x76e1, 0x76e5, 0x76e7, 0x76ea, 0x862f, 0x76fb, 0x7708, 0x7707,
    0x7704, 0x7729, 0x7724, 0x771e, 0x7725, 0x7726, 0x771b, 0x7737, 0x7738, 0x7747, 0x775a, 0x7768, 0x776b, 0x775b, 0x7765, 0x777f,
    0x777e, 0x7779, 0x778e, 0x778b, 0x7791, 0x77a0, 0x779e, 0x77b0, 0x77b6, 0x77b9, 0x77bf, 0x77bc, 0x77bd, 0x77bb, 0x77c7, 0x77cd,
    0x77d7, 0x77da, 0x77dc, 0x77e3, 0x77ee, 0x77fc, 0x780c, 0x7812, 0x7926, 0x7820, 0x792a, 0x7845, 0x788e, 0x7874, 0x7886, 0x787c,
    0x789a, 0x788c, 0x78a3, 0x78b5, 0x78aa, 0x78af, 0x78d1, 0x78c6, 0x78cb, 0x78d4, 0x78be, 0x78bc, 0x78c5, 0x78ca, 0x78ec,

    /* 0xe3: 0xa1 - 0xfe*/
            0x78e7, 0x78da, 0x78fd, 0x78f4, 0x7907, 0x7912, 0x7911, 0x7919, 0x792c, 0x792b, 0x7940, 0x7960, 0x7957, 0x795f, 0x795a,
    0x7955, 0x7953, 0x797a, 0x797f, 0x798a, 0x799d, 0x79a7, 0x9f4b, 0x79aa, 0x79ae, 0x79b3, 0x79b9, 0x79ba, 0x79c9, 0x79d5, 0x79e7,
    0x79ec, 0x79e1, 0x79e3, 0x7a08, 0x7a0d, 0x7a18, 0x7a19, 0x7a20, 0x7a1f, 0x7980, 0x7a31, 0x7a3b, 0x7a3e, 0x7a37, 0x7a43, 0x7a57,
    0x7a49, 0x7a61, 0x7a62, 0x7a69, 0x9f9d, 0x7a70, 0x7a79, 0x7a7d, 0x7a88, 0x7a97, 0x7a95, 0x7a98, 0x7a96, 0x7aa9, 0x7ac8, 0x7ab0,
    0x7ab6, 0x7ac5, 0x7ac4, 0x7abf, 0x9083, 0x7ac7, 0x7aca, 0x7acd, 0x7acf, 0x7ad5, 0x7ad3, 0x7ad9, 0x7ada, 0x7add, 0x7ae1, 0x7ae2,
    0x7ae6, 0x7aed, 0x7af0, 0x7b02, 0x7b0f, 0x7b0a, 0x7b06, 0x7b33, 0x7b18, 0x7b19, 0x7b1e, 0x7b35, 0x7b28, 0x7b36, 0x7b50,

    /* 0xe4: 0xa1 - 0xfe*/
            0x7b7a, 0x7b04, 0x7b4d, 0x7b0b, 0x7b4c, 0x7b45, 0x7b75, 0x7b65, 0x7b74, 0x7b67, 0x7b70, 0x7b71, 0x7b6c, 0x7b6e, 0x7b9d,
    0x7b98, 0x7b9f, 0x7b8d, 0x7b9c, 0x7b9a, 0x7b8b, 0x7b92, 0x7b8f, 0x7b5d, 0x7b99, 0x7bcb, 0x7bc1, 0x7bcc, 0x7bcf, 0x7bb4, 0x7bc6,
    0x7bdd, 0x7be9, 0x7c11, 0x7c14, 0x7be6, 0x7be5, 0x7c60, 0x7c00, 0x7c07, 0x7c13, 0x7bf3, 0x7bf7, 0x7c17, 0x7c0d, 0x7bf6, 0x7c23,
    0x7c27, 0x7c2a, 0x7c1f, 0x7c37, 0x7c2b, 0x7c3d, 0x7c4c, 0x7c43, 0x7c54, 0x7c4f, 0x7c40, 0x7c50, 0x7c58, 0x7c5f, 0x7c64, 0x7c56,
    0x7c65, 0x7c6c, 0x7c75, 0x7c83, 0x7c90, 0x7ca4, 0x7cad, 0x7ca2, 0x7cab, 0x7ca1, 0x7ca8, 0x7cb3, 0x7cb2, 0x7cb1, 0x7cae, 0x7cb9,
    0x7cbd, 0x7cc0, 0x7cc5, 0x7cc2, 0x7cd8, 0x7cd2, 0x7cdc, 0x7ce2, 0x9b3b, 0x7cef, 0x7cf2, 0x7cf4, 0x7cf6, 0x7cfa, 0x7d06,

    /* 0xe5: 0xa1 - 0xfe*/
            0x7d02, 0x7d1c, 0x7d15, 0x7d0a, 0x7d45, 0x7d4b, 0x7d2e, 0x7d32, 0x7d3f, 0x7d35, 0x7d46, 0x7d73, 0x7d56, 0x7d4e, 0x7d72,
    0x7d68, 0x7d6e, 0x7d4f, 0x7d63, 0x7d93, 0x7d89, 0x7d5b, 0x7d8f, 0x7d7d, 0x7d9b, 0x7dba, 0x7dae, 0x7da3, 0x7db5, 0x7dc7, 0x7dbd,
    0x7dab, 0x7e3d, 0x7da2, 0x7daf, 0x7ddc, 0x7db8, 0x7d9f, 0x7db0, 0x7dd8, 0x7ddd, 0x7de4, 0x7dde, 0x7dfb, 0x7df2, 0x7de1, 0x7e05,
    0x7e0a, 0x7e23, 0x7e21, 0x7e12, 0x7e31, 0x7e1f, 0x7e09, 0x7e0b, 0x7e22, 0x7e46, 0x7e66, 0x7e3b, 0x7e35, 0x7e39, 0x7e43, 0x7e37,
    0x7e32, 0x7e3a, 0x7e67, 0x7e5d, 0x7e56, 0x7e5e, 0x7e59, 0x7e5a, 0x7e79, 0x7e6a, 0x7e69, 0x7e7c, 0x7e7b, 0x7e83, 0x7dd5, 0x7e7d,
    0x8fae, 0x7e7f, 0x7e88, 0x7e89, 0x7e8c, 0x7e92, 0x7e90, 0x7e93, 0x7e94, 0x7e96, 0x7e8e, 0x7e9b, 0x7e9c, 0x7f38, 0x7f3a,

    /* 0xe6: 0xa1 - 0xfe*/
            0x7f45, 0x7f4c, 0x7f4d, 0x7f4e, 0x7f50, 0x7f51, 0x7f55, 0x7f54, 0x7f58, 0x7f5f, 0x7f60, 0x7f68, 0x7f69, 0x7f67, 0x7f78,
    0x7f82, 0x7f86, 0x7f83, 0x7f88, 0x7f87, 0x7f8c, 0x7f94, 0x7f9e, 0x7f9d, 0x7f9a, 0x7fa3, 0x7faf, 0x7fb2, 0x7fb9, 0x7fae, 0x7fb6,
    0x7fb8, 0x8b71, 0x7fc5, 0x7fc6, 0x7fca, 0x7fd5, 0x7fd4, 0x7fe1, 0x7fe6, 0x7fe9, 0x7ff3, 0x7ff9, 0x98dc, 0x8006, 0x8004, 0x800b,
    0x8012, 0x8018, 0x8019, 0x801c, 0x8021, 0x8028, 0x803f, 0x803b, 0x804a, 0x8046, 0x8052, 0x8058, 0x805a, 0x805f, 0x8062, 0x8068,
    0x8073, 0x8072, 0x8070, 0x8076, 0x8079, 0x807d, 0x807f, 0x8084, 0x8086, 0x8085, 0x809b, 0x8093, 0x809a, 0x80ad, 0x5190, 0x80ac,
    0x80db, 0x80e5, 0x80d9, 0x80dd, 0x80c4, 0x80da, 0x80d6, 0x8109, 0x80ef, 0x80f1, 0x811b, 0x8129, 0x8123, 0x812f, 0x814b,

    /* 0xe7: 0xa1 - 0xfe*/
            0x968b, 0x8146, 0x813e, 0x8153, 0x8151, 0x80fc, 0x8171, 0x816e, 0x8165, 0x8166, 0x8174, 0x8183, 0x8188, 0x818a, 0x8180,
    0x8182, 0x81a0, 0x8195, 0x81a4, 0x81a3, 0x815f, 0x8193, 0x81a9, 0x81b0, 0x81b5, 0x81be, 0x81b8, 0x81bd, 0x81c0, 0x81c2, 0x81ba,
    0x81c9, 0x81cd, 0x81d1, 0x81d9, 0x81d8, 0x81c8, 0x81da, 0x81df, 0x81e0, 0x81e7, 0x81fa, 0x81fb, 0x81fe, 0x8201, 0x8202, 0x8205,
    0x8207, 0x820a, 0x820d, 0x8210, 0x8216, 0x8229, 0x822b, 0x8238, 0x8233, 0x8240, 0x8259, 0x8258, 0x825d, 0x825a, 0x825f, 0x8264,
    0x8262, 0x8268, 0x826a, 0x826b, 0x822e, 0x8271, 0x8277, 0x8278, 0x827e, 0x828d, 0x8292, 0x82ab, 0x829f, 0x82bb, 0x82ac, 0x82e1,
    0x82e3, 0x82df, 0x82d2, 0x82f4, 0x82f3, 0x82fa, 0x8393, 0x8303, 0x82fb, 0x82f9, 0x82de, 0x8306, 0x82dc, 0x8309, 0x82d9,

    /* 0xe8: 0xa1 - 0xfe*/
            0x8335, 0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350, 0x8345, 0x832f, 0x832b, 0x8317, 0x8318, 0x8385, 0x839a,
    0x83aa, 0x839f, 0x83a2, 0x8396, 0x8323, 0x838e, 0x8387, 0x838a, 0x837c, 0x83b5, 0x8373, 0x8375, 0x83a0, 0x8389, 0x83a8, 0x83f4,
    0x8413, 0x83eb, 0x83ce, 0x83fd, 0x8403, 0x83d8, 0x840b, 0x83c1, 0x83f7, 0x8407, 0x83e0, 0x83f2, 0x840d, 0x8422, 0x8420, 0x83bd,
    0x8438, 0x8506, 0x83fb, 0x846d, 0x842a, 0x843c, 0x855a, 0x8484, 0x8477, 0x846b, 0x84ad, 0x846e, 0x8482, 0x8469, 0x8446, 0x842c,
    0x846f, 0x8479, 0x8435, 0x84ca, 0x8462, 0x84b9, 0x84bf, 0x849f, 0x84d9, 0x84cd, 0x84bb, 0x84da, 0x84d0, 0x84c1, 0x84c6, 0x84d6,
    0x84a1, 0x8521, 0x84ff, 0x84f4, 0x8517, 0x8518, 0x852c, 0x851f, 0x8515, 0x8514, 0x84fc, 0x8540, 0x8563, 0x8558, 0x8548,

    /* 0xe9: 0xa1 - 0xfe*/
            0x8541, 0x8602, 0x854b, 0x8555, 0x8580, 0x85a4, 0x8588, 0x8591, 0x858a, 0x85a8, 0x856d, 0x8594, 0x859b, 0x85ea, 0x8587,
    0x859c, 0x8577, 0x857e, 0x8590, 0x85c9, 0x85ba, 0x85cf, 0x85b9, 0x85d0, 0x85d5, 0x85dd, 0x85e5, 0x85dc, 0x85f9, 0x860a, 0x8613,
    0x860b, 0x85fe, 0x85fa, 0x8606, 0x8622, 0x861a, 0x8630, 0x863f, 0x864d, 0x4e55, 0x8654, 0x865f, 0x8667, 0x8671, 0x8693, 0x86a3,
    0x86a9, 0x86aa, 0x868b, 0x868c, 0x86b6, 0x86af, 0x86c4, 0x86c6, 0x86b0, 0x86c9, 0x8823, 0x86ab, 0x86d4, 0x86de, 0x86e9, 0x86ec,
    0x86df, 0x86db, 0x86ef, 0x8712, 0x8706, 0x8708, 0x8700, 0x8703, 0x86fb, 0x8711, 0x8709, 0x870d, 0x86f9, 0x870a, 0x8734, 0x873f,
    0x8737, 0x873b, 0x8725, 0x8729, 0x871a, 0x8760, 0x875f, 0x8778, 0x874c, 0x874e, 0x8774, 0x8757, 0x8768, 0x876e, 0x8759,

    /* 0xea: 0xa1 - 0xfe*/
            0x8753, 0x8763, 0x876a, 0x8805, 0x87a2, 0x879f, 0x8782, 0x87af, 0x87cb, 0x87bd, 0x87c0, 0x87d0, 0x96d6, 0x87ab, 0x87c4,
    0x87b3, 0x87c7, 0x87c6, 0x87bb, 0x87ef, 0x87f2, 0x87e0, 0x880f, 0x880d, 0x87fe, 0x87f6, 0x87f7, 0x880e, 0x87d2, 0x8811, 0x8816,
    0x8815, 0x8822, 0x8821, 0x8831, 0x8836, 0x8839, 0x8827, 0x883b, 0x8844, 0x8842, 0x8852, 0x8859, 0x885e, 0x8862, 0x886b, 0x8881,
    0x887e, 0x889e, 0x8875, 0x887d, 0x88b5, 0x8872, 0x8882, 0x8897, 0x8892, 0x88ae, 0x8899, 0x88a2, 0x888d, 0x88a4, 0x88b0, 0x88bf,
    0x88b1, 0x88c3, 0x88c4, 0x88d4, 0x88d8, 0x88d9, 0x88dd, 0x88f9, 0x8902, 0x88fc, 0x88f4, 0x88e8, 0x88f2, 0x8904, 0x890c, 0x890a,
    0x8913, 0x8943, 0x891e, 0x8925, 0x892a, 0x892b, 0x8941, 0x8944, 0x893b, 0x8936, 0x8938, 0x894c, 0x891d, 0x8960, 0x895e,

    /* 0xeb: 0xa1 - 0xfe*/
            0x8966, 0x8964, 0x896d, 0x896a, 0x896f, 0x8974, 0x8977, 0x897e, 0x8983, 0x8988, 0x898a, 0x8993, 0x8998, 0x89a1, 0x89a9,
    0x89a6, 0x89ac, 0x89af, 0x89b2, 0x89ba, 0x89bd, 0x89bf, 0x89c0, 0x89da, 0x89dc, 0x89dd, 0x89e7, 0x89f4, 0x89f8, 0x8a03, 0x8a16,
    0x8a10, 0x8a0c, 0x8a1b, 0x8a1d, 0x8a25, 0x8a36, 0x8a41, 0x8a5b, 0x8a52, 0x8a46, 0x8a48, 0x8a7c, 0x8a6d, 0x8a6c, 0x8a62, 0x8a85,
    0x8a82, 0x8a84, 0x8aa8, 0x8aa1, 0x8a91, 0x8aa5, 0x8aa6, 0x8a9a, 0x8aa3, 0x8ac4, 0x8acd, 0x8ac2, 0x8ada, 0x8aeb, 0x8af3, 0x8ae7,
    0x8ae4, 0x8af1, 0x8b14, 0x8ae0, 0x8ae2, 0x8af7, 0x8ade, 0x8adb, 0x8b0c, 0x8b07, 0x8b1a, 0x8ae1, 0x8b16, 0x8b10, 0x8b17, 0x8b20,
    0x8b33, 0x97ab, 0x8b26, 0x8b2b, 0x8b3e, 0x8b28, 0x8b41, 0x8b4c, 0x8b4f, 0x8b4e, 0x8b49, 0x8b56, 0x8b5b, 0x8b5a, 0x8b6b,

    /* 0xec: 0xa1 - 0xfe*/
            0x8b5f, 0x8b6c, 0x8b6f, 0x8b74, 0x8b7d, 0x8b80, 0x8b8c, 0x8b8e, 0x8b92, 0x8b93, 0x8b96, 0x8b99, 0x8b9a, 0x8c3a, 0x8c41,
    0x8c3f, 0x8c48, 0x8c4c, 0x8c4e, 0x8c50, 0x8c55, 0x8c62, 0x8c6c, 0x8c78, 0x8c7a, 0x8c82, 0x8c89, 0x8c85, 0x8c8a, 0x8c8d, 0x8c8e,
    0x8c94, 0x8c7c, 0x8c98, 0x621d, 0x8cad, 0x8caa, 0x8cbd, 0x8cb2, 0x8cb3, 0x8cae, 0x8cb6, 0x8cc8, 0x8cc1, 0x8ce4, 0x8ce3, 0x8cda,
    0x8cfd, 0x8cfa, 0x8cfb, 0x8d04, 0x8d05, 0x8d0a, 0x8d07, 0x8d0f, 0x8d0d, 0x8d10, 0x9f4e, 0x8d13, 0x8ccd, 0x8d14, 0x8d16, 0x8d67,
    0x8d6d, 0x8d71, 0x8d73, 0x8d81, 0x8d99, 0x8dc2, 0x8dbe, 0x8dba, 0x8dcf, 0x8dda, 0x8dd6, 0x8dcc, 0x8ddb, 0x8dcb, 0x8dea, 0x8deb,
    0x8ddf, 0x8de3, 0x8dfc, 0x8e08, 0x8e09, 0x8dff, 0x8e1d, 0x8e1e, 0x8e10, 0x8e1f, 0x8e42, 0x8e35, 0x8e30, 0x8e34, 0x8e4a,

    /* 0xed: 0xa1 - 0xfe*/
            0x8e47, 0x8e49, 0x8e4c, 0x8e50, 0x8e48, 0x8e59, 0x8e64, 0x8e60, 0x8e2a, 0x8e63, 0x8e55, 0x8e76, 0x8e72, 0x8e7c, 0x8e81,
    0x8e87, 0x8e85, 0x8e84, 0x8e8b, 0x8e8a, 0x8e93, 0x8e91, 0x8e94, 0x8e99, 0x8eaa, 0x8ea1, 0x8eac, 0x8eb0, 0x8ec6, 0x8eb1, 0x8ebe,
    0x8ec5, 0x8ec8, 0x8ecb, 0x8edb, 0x8ee3, 0x8efc, 0x8efb, 0x8eeb, 0x8efe, 0x8f0a, 0x8f05, 0x8f15, 0x8f12, 0x8f19, 0x8f13, 0x8f1c,
    0x8f1f, 0x8f1b, 0x8f0c, 0x8f26, 0x8f33, 0x8f3b, 0x8f39, 0x8f45, 0x8f42, 0x8f3e, 0x8f4c, 0x8f49, 0x8f46, 0x8f4e, 0x8f57, 0x8f5c,
    0x8f62, 0x8f63, 0x8f64, 0x8f9c, 0x8f9f, 0x8fa3, 0x8fad, 0x8faf, 0x8fb7, 0x8fda, 0x8fe5, 0x8fe2, 0x8fea, 0x8fef, 0x9087, 0x8ff4,
    0x9005, 0x8ff9, 0x8ffa, 0x9011, 0x9015, 0x9021, 0x900d, 0x901e, 0x9016, 0x900b, 0x9027, 0x9036, 0x9035, 0x9039, 0x8ff8,

    /* 0xee: 0xa1 - 0xfe*/
            0x904f, 0x9050, 0x9051, 0x9052, 0x900e, 0x9049, 0x903e, 0x9056, 0x9058, 0x905e, 0x9068, 0x906f, 0x9076, 0x96a8, 0x9072,
    0x9082, 0x907d, 0x9081, 0x9080, 0x908a, 0x9089, 0x908f, 0x90a8, 0x90af, 0x90b1, 0x90b5, 0x90e2, 0x90e4, 0x6248, 0x90db, 0x9102,
    0x9112, 0x9119, 0x9132, 0x9130, 0x914a, 0x9156, 0x9158, 0x9163, 0x9165, 0x9169, 0x9173, 0x9172, 0x918b, 0x9189, 0x9182, 0x91a2,
    0x91ab, 0x91af, 0x91aa, 0x91b5, 0x91b4, 0x91ba, 0x91c0, 0x91c1, 0x91c9, 0x91cb, 0x91d0, 0x91d6, 0x91df, 0x91e1, 0x91db, 0x91fc,
    0x91f5, 0x91f6, 0x921e, 0x91ff, 0x9214, 0x922c, 0x9215, 0x9211, 0x925e, 0x9257, 0x9245, 0x9249, 0x9264, 0x9248, 0x9295, 0x923f,
    0x924b, 0x9250, 0x929c, 0x9296, 0x9293, 0x929b, 0x925a, 0x92cf, 0x92b9, 0x92b7, 0x92e9, 0x930f, 0x92fa, 0x9344, 0x932e,

    /* 0xef: 0xa1 - 0xfe*/
            0x9319, 0x9322, 0x931a, 0x9323, 0x933a, 0x9335, 0x933b, 0x935c, 0x9360, 0x937c, 0x936e, 0x9356, 0x93b0, 0x93ac, 0x93ad,
    0x9394, 0x93b9, 0x93d6, 0x93d7, 0x93e8, 0x93e5, 0x93d8, 0x93c3, 0x93dd, 0x93d0, 0x93c8, 0x93e4, 0x941a, 0x9414, 0x9413, 0x9403,
    0x9407, 0x9410, 0x9436, 0x942b, 0x9435, 0x9421, 0x943a, 0x9441, 0x9452, 0x9444, 0x945b, 0x9460, 0x9462, 0x945e, 0x946a, 0x9229,
    0x9470, 0x9475, 0x9477, 0x947d, 0x945a, 0x947c, 0x947e, 0x9481, 0x947f, 0x9582, 0x9587, 0x958a, 0x9594, 0x9596, 0x9598, 0x9599,
    0x95a0, 0x95a8, 0x95a7, 0x95ad, 0x95bc, 0x95bb, 0x95b9, 0x95be, 0x95ca, 0x6ff6, 0x95c3, 0x95cd, 0x95cc, 0x95d5, 0x95d4, 0x95d6,
    0x95dc, 0x95e1, 0x95e5, 0x95e2, 0x9621, 0x9628, 0x962e, 0x962f, 0x9642, 0x964c, 0x964f, 0x964b, 0x9677, 0x965c, 0x965e,

    /* 0xf0: 0xa1 - 0xfe*/
            0x965d, 0x965f, 0x9666, 0x9672, 0x966c, 0x968d, 0x9698, 0x9695, 0x9697, 0x96aa, 0x96a7, 0x96b1, 0x96b2, 0x96b0, 0x96b4,
    0x96b6, 0x96b8, 0x96b9, 0x96ce, 0x96cb, 0x96c9, 0x96cd, 0x894d, 0x96dc, 0x970d, 0x96d5, 0x96f9, 0x9704, 0x9706, 0x9708, 0x9713,
    0x970e, 0x9711, 0x970f, 0x9716, 0x9719, 0x9724, 0x972a, 0x9730, 0x9739, 0x973d, 0x973e, 0x9744, 0x9746, 0x9748, 0x9742, 0x9749,
    0x975c, 0x9760, 0x9764, 0x9766, 0x9768, 0x52d2, 0x976b, 0x9771, 0x9779, 0x9785, 0x977c, 0x9781, 0x977a, 0x9786, 0x978b, 0x978f,
    0x9790, 0x979c, 0x97a8, 0x97a6, 0x97a3, 0x97b3, 0x97b4, 0x97c3, 0x97c6, 0x97c8, 0x97cb, 0x97dc, 0x97ed, 0x9f4f, 0x97f2, 0x7adf,
    0x97f6, 0x97f5, 0x980f, 0x980c, 0x9838, 0x9824, 0x9821, 0x9837, 0x983d, 0x9846, 0x984f, 0x984b, 0x986b, 0x986f, 0x9870,

    /* 0xf1: 0xa1 - 0xfe*/
            0x9871, 0x9874, 0x9873, 0x98aa, 0x98af, 0x98b1, 0x98b6, 0x98c4, 0x98c3, 0x98c6, 0x98e9, 0x98eb, 0x9903, 0x9909, 0x9912,
    0x9914, 0x9918, 0x9921, 0x991d, 0x991e, 0x9924, 0x9920, 0x992c, 0x992e, 0x993d, 0x993e, 0x9942, 0x9949, 0x9945, 0x9950, 0x994b,
    0x9951, 0x9952, 0x994c, 0x9955, 0x9997, 0x9998, 0x99a5, 0x99ad, 0x99ae, 0x99bc, 0x99df, 0x99db, 0x99dd, 0x99d8, 0x99d1, 0x99ed,
    0x99ee, 0x99f1, 0x99f2, 0x99fb, 0x99f8, 0x9a01, 0x9a0f, 0x9a05, 0x99e2, 0x9a19, 0x9a2b, 0x9a37, 0x9a45, 0x9a42, 0x9a40, 0x9a43,
    0x9a3e, 0x9a55, 0x9a4d, 0x9a5b, 0x9a57, 0x9a5f, 0x9a62, 0x9a65, 0x9a64, 0x9a69, 0x9a6b, 0x9a6a, 0x9aad, 0x9ab0, 0x9abc, 0x9ac0,
    0x9acf, 0x9ad1, 0x9ad3, 0x9ad4, 0x9ade, 0x9adf, 0x9ae2, 0x9ae3, 0x9ae6, 0x9aef, 0x9aeb, 0x9aee, 0x9af4, 0x9af1, 0x9af7,

    /* 0xf2: 0xa1 - 0xfe*/
            0x9afb, 0x9b06, 0x9b18, 0x9b1a, 0x9b1f, 0x9b22, 0x9b23, 0x9b25, 0x9b27, 0x9b28, 0x9b29, 0x9b2a, 0x9b2e, 0x9b2f, 0x9b32,
    0x9b44, 0x9b43, 0x9b4f, 0x9b4d, 0x9b4e, 0x9b51, 0x9b58, 0x9b74, 0x9b93, 0x9b83, 0x9b91, 0x9b96, 0x9b97, 0x9b9f, 0x9ba0, 0x9ba8,
    0x9bb4, 0x9bc0, 0x9bca, 0x9bb9, 0x9bc6, 0x9bcf, 0x9bd1, 0x9bd2, 0x9be3, 0x9be2, 0x9be4, 0x9bd4, 0x9be1, 0x9c3a, 0x9bf2, 0x9bf1,
    0x9bf0, 0x9c15, 0x9c14, 0x9c09, 0x9c13, 0x9c0c, 0x9c06, 0x9c08, 0x9c12, 0x9c0a, 0x9c04, 0x9c2e, 0x9c1b, 0x9c25, 0x9c24, 0x9c21,
    0x9c30, 0x9c47, 0x9c32, 0x9c46, 0x9c3e, 0x9c5a, 0x9c60, 0x9c67, 0x9c76, 0x9c78, 0x9ce7, 0x9cec, 0x9cf0, 0x9d09, 0x9d08, 0x9ceb,
    0x9d03, 0x9d06, 0x9d2a, 0x9d26, 0x9daf, 0x9d23, 0x9d1f, 0x9d44, 0x9d15, 0x9d12, 0x9d41, 0x9d3f, 0x9d3e, 0x9d46, 0x9d48,

    /* 0xf3: 0xa1 - 0xfe*/
            0x9d5d, 0x9d5e, 0x9d64, 0x9d51, 0x9d50, 0x9d59, 0x9d72, 0x9d89, 0x9d87, 0x9dab, 0x9d6f, 0x9d7a, 0x9d9a, 0x9da4, 0x9da9,
    0x9db2, 0x9dc4, 0x9dc1, 0x9dbb, 0x9db8, 0x9dba, 0x9dc6, 0x9dcf, 0x9dc2, 0x9dd9, 0x9dd3, 0x9df8, 0x9de6, 0x9ded, 0x9def, 0x9dfd,
    0x9e1a, 0x9e1b, 0x9e1e, 0x9e75, 0x9e79, 0x9e7d, 0x9e81, 0x9e88, 0x9e8b, 0x9e8c, 0x9e92, 0x9e95, 0x9e91, 0x9e9d, 0x9ea5, 0x9ea9,
    0x9eb8, 0x9eaa, 0x9ead, 0x9761, 0x9ecc, 0x9ece, 0x9ecf, 0x9ed0, 0x9ed4, 0x9edc, 0x9ede, 0x9edd, 0x9ee0, 0x9ee5, 0x9ee8, 0x9eef,
    0x9ef4, 0x9ef6, 0x9ef7, 0x9ef9, 0x9efb, 0x9efc, 0x9efd, 0x9f07, 0x9f08, 0x76b7, 0x9f15, 0x9f21, 0x9f2c, 0x9f3e, 0x9f4a, 0x9f52,
    0x9f54, 0x9f63, 0x9f5f, 0x9f60, 0x9f61, 0x9f66, 0x9f67, 0x9f6c, 0x9f6a, 0x9f77, 0x9f72, 0x9f76, 0x9f95, 0x9f9c, 0x9fa0,

    /* 0xf4: 0xa1 - 0xa6*/
            0x582f, 0x69c7, 0x9059, 0x7464, 0x51dc, 0x7199,
};
static const struct jis_charmap __euc_jp_jis_x0208_map[] = {
    { .first = 0xa1, .last = 0xdf, .offset =     0 }, /* 0x8e */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x8f */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x90 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x91 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x92 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x93 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x94 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x95 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x96 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x97 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x98 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x99 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9a */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9b */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9c */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9d */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9e */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0x9f */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa0 */
    { .first = 0xa1, .last = 0xfe, .offset =    63 }, /* 0xa1 */
    { .first = 0xa1, .last = 0xfe, .offset =   157 }, /* 0xa2 */
    { .first = 0xb0, .last = 0xfa, .offset =   251 }, /* 0xa3 */
    { .first = 0xa1, .last = 0xf3, .offset =   326 }, /* 0xa4 */
    { .first = 0xa1, .last = 0xf6, .offset =   409 }, /* 0xa5 */
    { .first = 0xa1, .last = 0xd8, .offset =   495 }, /* 0xa6 */
    { .first = 0xa1, .last = 0xf1, .offset =   551 }, /* 0xa7 */
    { .first = 0xa1, .last = 0xc0, .offset =   632 }, /* 0xa8 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa9 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xaa */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xab */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xac */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xad */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xae */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xaf */
    { .first = 0xa1, .last = 0xfe, .offset =   664 }, /* 0xb0 */
    { .first = 0xa1, .last = 0xfe, .offset =   758 }, /* 0xb1 */
    { .first = 0xa1, .last = 0xfe, .offset =   852 }, /* 0xb2 */
    { .first = 0xa1, .last = 0xfe, .offset =   946 }, /* 0xb3 */
    { .first = 0xa1, .last = 0xfe, .offset =  1040 }, /* 0xb4 */
    { .first = 0xa1, .last = 0xfe, .offset =  1134 }, /* 0xb5 */
    { .first = 0xa1, .last = 0xfe, .offset =  1228 }, /* 0xb6 */
    { .first = 0xa1, .last = 0xfe, .offset =  1322 }, /* 0xb7 */
    { .first = 0xa1, .last = 0xfe, .offset =  1416 }, /* 0xb8 */
    { .first = 0xa1, .last = 0xfe, .offset =  1510 }, /* 0xb9 */
    { .first = 0xa1, .last = 0xfe, .offset =  1604 }, /* 0xba */
    { .first = 0xa1, .last = 0xfe, .offset =  1698 }, /* 0xbb */
    { .first = 0xa1, .last = 0xfe, .offset =  1792 }, /* 0xbc */
    { .first = 0xa1, .last = 0xfe, .offset =  1886 }, /* 0xbd */
    { .first = 0xa1, .last = 0xfe, .offset =  1980 }, /* 0xbe */
    { .first = 0xa1, .last = 0xfe, .offset =  2074 }, /* 0xbf */
    { .first = 0xa1, .last = 0xfe, .offset =  2168 }, /* 0xc0 */
    { .first = 0xa1, .last = 0xfe, .offset =  2262 }, /* 0xc1 */
    { .first = 0xa1, .last = 0xfe, .offset =  2356 }, /* 0xc2 */
    { .first = 0xa1, .last = 0xfe, .offset =  2450 }, /* 0xc3 */
    { .first = 0xa1, .last = 0xfe, .offset =  2544 }, /* 0xc4 */
    { .first = 0xa1, .last = 0xfe, .offset =  2638 }, /* 0xc5 */
    { .first = 0xa1, .last = 0xfe, .offset =  2732 }, /* 0xc6 */
    { .first = 0xa1, .last = 0xfe, .offset =  2826 }, /* 0xc7 */
    { .first = 0xa1, .last = 0xfe, .offset =  2920 }, /* 0xc8 */
    { .first = 0xa1, .last = 0xfe, .offset =  3014 }, /* 0xc9 */
    { .first = 0xa1, .last = 0xfe, .offset =  3108 }, /* 0xca */
    { .first = 0xa1, .last = 0xfe, .offset =  3202 }, /* 0xcb */
    { .first = 0xa1, .last = 0xfe, .offset =  3296 }, /* 0xcc */
    { .first = 0xa1, .last = 0xfe, .offset =  3390 }, /* 0xcd */
    { .first = 0xa1, .last = 0xfe, .offset =  3484 }, /* 0xce */
    { .first = 0xa1, .last = 0xd3, .offset =  3578 }, /* 0xcf */
    { .first = 0xa1, .last = 0xfe, .offset =  3629 }, /* 0xd0 */
    { .first = 0xa1, .last = 0xfe, .offset =  3723 }, /* 0xd1 */
    { .first = 0xa1, .last = 0xfe, .offset =  3817 }, /* 0xd2 */
    { .first = 0xa1, .last = 0xfe, .offset =  3911 }, /* 0xd3 */
    { .first = 0xa1, .last = 0xfe, .offset =  4005 }, /* 0xd4 */
    { .first = 0xa1, .last = 0xfe, .offset =  4099 }, /* 0xd5 */
    { .first = 0xa1, .last = 0xfe, .offset =  4193 }, /* 0xd6 */
    { .first = 0xa1, .last = 0xfe, .offset =  4287 }, /* 0xd7 */
    { .first = 0xa1, .last = 0xfe, .offset =  4381 }, /* 0xd8 */
    { .first = 0xa1, .last = 0xfe, .offset =  4475 }, /* 0xd9 */
    { .first = 0xa1, .last = 0xfe, .offset =  4569 }, /* 0xda */
    { .first = 0xa1, .last = 0xfe, .offset =  4663 }, /* 0xdb */
    { .first = 0xa1, .last = 0xfe, .offset =  4757 }, /* 0xdc */
    { .first = 0xa1, .last = 0xfe, .offset =  4851 }, /* 0xdd */
    { .first = 0xa1, .last = 0xfe, .offset =  4945 }, /* 0xde */
    { .first = 0xa1, .last = 0xfe, .offset =  5039 }, /* 0xdf */
    { .first = 0xa1, .last = 0xfe, .offset =  5133 }, /* 0xe0 */
    { .first = 0xa1, .last = 0xfe, .offset =  5227 }, /* 0xe1 */
    { .first = 0xa1, .last = 0xfe, .offset =  5321 }, /* 0xe2 */
    { .first = 0xa1, .last = 0xfe, .offset =  5415 }, /* 0xe3 */
    { .first = 0xa1, .last = 0xfe, .offset =  5509 }, /* 0xe4 */
    { .first = 0xa1, .last = 0xfe, .offset =  5603 }, /* 0xe5 */
    { .first = 0xa1, .last = 0xfe, .offset =  5697 }, /* 0xe6 */
    { .first = 0xa1, .last = 0xfe, .offset =  5791 }, /* 0xe7 */
    { .first = 0xa1, .last = 0xfe, .offset =  5885 }, /* 0xe8 */
    { .first = 0xa1, .last = 0xfe, .offset =  5979 }, /* 0xe9 */
    { .first = 0xa1, .last = 0xfe, .offset =  6073 }, /* 0xea */
    { .first = 0xa1, .last = 0xfe, .offset =  6167 }, /* 0xeb */
    { .first = 0xa1, .last = 0xfe, .offset =  6261 }, /* 0xec */
    { .first = 0xa1, .last = 0xfe, .offset =  6355 }, /* 0xed */
    { .first = 0xa1, .last = 0xfe, .offset =  6449 }, /* 0xee */
    { .first = 0xa1, .last = 0xfe, .offset =  6543 }, /* 0xef */
    { .first = 0xa1, .last = 0xfe, .offset =  6637 }, /* 0xf0 */
    { .first = 0xa1, .last = 0xfe, .offset =  6731 }, /* 0xf1 */
    { .first = 0xa1, .last = 0xfe, .offset =  6825 }, /* 0xf2 */
    { .first = 0xa1, .last = 0xfe, .offset =  6919 }, /* 0xf3 */
    { .first = 0xa1, .last = 0xa6, .offset =  7013 }, /* 0xf4 */
};
#endif /* jis_x0208 */

/* jis_x0213 tables */
#ifdef define_jis_x0213

#define __euc_jp_jis_x0213_first_row 0xa2
#define __euc_jp_jis_x0213_last_row 0xed

#ifndef split_jis_x0213
#define split_jis_x0213_offset 0
#endif

static const uint16_t __euc_jp_jis_x0213_codes[] = {
    /* 0x8f 0xa2: 0xaf - 0xf1 */
                                                                                                                            0x02d8,
    0x02c7, 0x00b8, 0x02d9, 0x02dd, 0x00af, 0x02db, 0x02da, 0xff5e, 0x0384, 0x0385, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x00a1, 0x00a6, 0x00bf, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0x00ba, 0x00aa, 0x00a9, 0x00ae, 0x2122,
    0x00a4, 0x2116,

    /* 0x8f 0xa6: 0xe1 - 0xfc */
            0x0386, 0x0388, 0x0389, 0x038a, 0x03aa, 0xffff, 0x038c, 0xffff, 0x038e, 0x03ab, 0xffff, 0x038f, 0xffff, 0xffff, 0xffff,
    0xffff, 0x03ac, 0x03ad, 0x03ae, 0x03af, 0x03ca, 0x0390, 0x03cc, 0x03c2, 0x03cd, 0x03cb, 0x03b0, 0x03ce,

    /* 0x8f 0xa7: 0xc2 - 0xfe */
                    0x0402, 0x0403, 0x0404, 0x0405, 0x0406, 0x0407, 0x0408, 0x0409, 0x040a, 0x040b, 0x040c, 0x040e, 0x040f, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0xffff, 0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045a, 0x045b, 0x045c, 0x045e, 0x045f,

    /* 0x8f 0xa9: 0xa1 - 0xd0 */
            0x00c6, 0x0110, 0xffff, 0x0126, 0xffff, 0x0132, 0xffff, 0x0141, 0x013f, 0xffff, 0x014a, 0x00d8, 0x0152, 0xffff, 0x0166,
    0x00de, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff,
    0xffff, 0x00e6, 0x0111, 0x00f0, 0x0127, 0x0131, 0x0133, 0x0138, 0x0142, 0x0140, 0x0149, 0x014b, 0x00f8, 0x0153, 0x00df, 0x0167,
    0x00fe,

    /* 0x8f 0xaa: 0xa1 - 0xf7 */
            0x00c1, 0x00c0, 0x00c4, 0x00c2, 0x0102, 0x01cd, 0x0100, 0x0104, 0x00c5, 0x00c3, 0x0106, 0x0108, 0x010c, 0x00c7, 0x010a,
    0x010e, 0x00c9, 0x00c8, 0x00cb, 0x00ca, 0x011a, 0x0116, 0x0112, 0x0118, 0xffff, 0x011c, 0x011e, 0x0122, 0x0120, 0x0124, 0x00cd,
    0x00cc, 0x00cf, 0x00ce, 0x01cf, 0x0130, 0x012a, 0x012e, 0x0128, 0x0134, 0x0136, 0x0139, 0x013d, 0x013b, 0x0143, 0x0147, 0x0145,
    0x00d1, 0x00d3, 0x00d2, 0x00d6, 0x00d4, 0x01d1, 0x0150, 0x014c, 0x00d5, 0x0154, 0x0158, 0x0156, 0x015a, 0x015c, 0x0160, 0x015e,
    0x0164, 0x0162, 0x00da, 0x00d9, 0x00dc, 0x00db, 0x016c, 0x01d3, 0x0170, 0x016a, 0x0172, 0x016e, 0x0168, 0x01d7, 0x01db, 0x01d9,
    0x01d5, 0x0174, 0x00dd, 0x0178, 0x0176, 0x0179, 0x017d, 0x017b,

    /* 0x8f 0xab: 0xa1 - 0xf7 */
            0x00e1, 0x00e0, 0x00e4, 0x00e2, 0x0103, 0x01ce, 0x0101, 0x0105, 0x00e5, 0x00e3, 0x0107, 0x0109, 0x010d, 0x00e7, 0x010b,
    0x010f, 0x00e9, 0x00e8, 0x00eb, 0x00ea, 0x011b, 0x0117, 0x0113, 0x0119, 0x01f5, 0x011d, 0x011f, 0xffff, 0x0121, 0x0125, 0x00ed,
    0x00ec, 0x00ef, 0x00ee, 0x01d0, 0xffff, 0x012b, 0x012f, 0x0129, 0x0135, 0x0137, 0x013a, 0x013e, 0x013c, 0x0144, 0x0148, 0x0146,
    0x00f1, 0x00f3, 0x00f2, 0x00f6, 0x00f4, 0x01d2, 0x0151, 0x014d, 0x00f5, 0x0155, 0x0159, 0x0157, 0x015b, 0x015d, 0x0161, 0x015f,
    0x0165, 0x0163, 0x00fa, 0x00f9, 0x00fc, 0x00fb, 0x016d, 0x01d4, 0x0171, 0x016b, 0x0173, 0x016f, 0x0169, 0x01d8, 0x01dc, 0x01da,
    0x01d6, 0x0175, 0x00fd, 0x00ff, 0x0177, 0x017a, 0x017e, 0x017c,

    /* 0x8f 0xb0: 0xa1 - 0xfe */
            0x4e02, 0x4e04, 0x4e05, 0x4e0c, 0x4e12, 0x4e1f, 0x4e23, 0x4e24, 0x4e28, 0x4e2b, 0x4e2e, 0x4e2f, 0x4e30, 0x4e35, 0x4e40,
    0x4e41, 0x4e44, 0x4e47, 0x4e51, 0x4e5a, 0x4e5c, 0x4e63, 0x4e68, 0x4e69, 0x4e74, 0x4e75, 0x4e79, 0x4e7f, 0x4e8d, 0x4e96, 0x4e97,
    0x4e9d, 0x4eaf, 0x4eb9, 0x4ec3, 0x4ed0, 0x4eda, 0x4edb, 0x4ee0, 0x4ee1, 0x4ee2, 0x4ee8, 0x4eef, 0x4ef1, 0x4ef3, 0x4ef5, 0x4efd,
    0x4efe, 0x4eff, 0x4f00, 0x4f02, 0x4f03, 0x4f08, 0x4f0b, 0x4f0c, 0x4f12, 0x4f15, 0x4f16, 0x4f17, 0x4f19, 0x4f2e, 0x4f31, 0x4f60,
    0x4f33, 0x4f35, 0x4f37, 0x4f39, 0x4f3b, 0x4f3e, 0x4f40, 0x4f42, 0x4f48, 0x4f49, 0x4f4b, 0x4f4c, 0x4f52, 0x4f54, 0x4f56, 0x4f58,
    0x4f5f, 0x4f63, 0x4f6a, 0x4f6c, 0x4f6e, 0x4f71, 0x4f77, 0x4f78, 0x4f79, 0x4f7a, 0x4f7d, 0x4f7e, 0x4f81, 0x4f82, 0x4f84,

    /* 0x8f 0xb1: 0xa1 - 0xfe */
            0x4f85, 0x4f89, 0x4f8a, 0x4f8c, 0x4f8e, 0x4f90, 0x4f92, 0x4f93, 0x4f94, 0x4f97, 0x4f99, 0x4f9a, 0x4f9e, 0x4f9f, 0x4fb2,
    0x4fb7, 0x4fb9, 0x4fbb, 0x4fbc, 0x4fbd, 0x4fbe, 0x4fc0, 0x4fc1, 0x4fc5, 0x4fc6, 0x4fc8, 0x4fc9, 0x4fcb, 0x4fcc, 0x4fcd, 0x4fcf,
    0x4fd2, 0x4fdc, 0x4fe0, 0x4fe2, 0x4ff0, 0x4ff2, 0x4ffc, 0x4ffd, 0x4fff, 0x5000, 0x5001, 0x5004, 0x5007, 0x500a, 0x500c, 0x500e,
    0x5010, 0x5013, 0x5017, 0x5018, 0x501b, 0x501c, 0x501d, 0x501e, 0x5022, 0x5027, 0x502e, 0x5030, 0x5032, 0x5033, 0x5035, 0x5040,
    0x5041, 0x5042, 0x5045, 0x5046, 0x504a, 0x504c, 0x504e, 0x5051, 0x5052, 0x5053, 0x5057, 0x5059, 0x505f, 0x5060, 0x5062, 0x5063,
    0x5066, 0x5067, 0x506a, 0x506d, 0x5070, 0x5071, 0x503b, 0x5081, 0x5083, 0x5084, 0x5086, 0x508a, 0x508e, 0x508f, 0x5090,

    /* 0x8f 0xb2: 0xa1 - 0xfe */
            0x5092, 0x5093, 0x5094, 0x5096, 0x509b, 0x509c, 0x509e, 0x509f, 0x50a0, 0x50a1, 0x50a2, 0x50aa, 0x50af, 0x50b0, 0x50b9,
    0x50ba, 0x50bd, 0x50c0, 0x50c3, 0x50c4, 0x50c7, 0x50cc, 0x50ce, 0x50d0, 0x50d3, 0x50d4, 0x50d8, 0x50dc, 0x50dd, 0x50df, 0x50e2,
    0x50e4, 0x50e6, 0x50e8, 0x50e9, 0x50ef, 0x50f1, 0x50f6, 0x50fa, 0x50fe, 0x5103, 0x5106, 0x5107, 0x5108, 0x510b, 0x510c, 0x510d,
    0x510e, 0x50f2, 0x5110, 0x5117, 0x5119, 0x511b, 0x511c, 0x511d, 0x511e, 0x5123, 0x5127, 0x5128, 0x512c, 0x512d, 0x512f, 0x5131,
    0x5133, 0x5134, 0x5135, 0x5138, 0x5139, 0x5142, 0x514a, 0x514f, 0x5153, 0x5155, 0x5157, 0x5158, 0x515f, 0x5164, 0x5166, 0x517e,
    0x5183, 0x5184, 0x518b, 0x518e, 0x5198, 0x519d, 0x51a1, 0x51a3, 0x51ad, 0x51b8, 0x51ba, 0x51bc, 0x51be, 0x51bf, 0x51c2,

    /* 0x8f 0xb3: 0xa1 - 0xfe */
            0x51c8, 0x51cf, 0x51d1, 0x51d2, 0x51d3, 0x51d5, 0x51d8, 0x51de, 0x51e2, 0x51e5, 0x51ee, 0x51f2, 0x51f3, 0x51f4, 0x51f7,
    0x5201, 0x5202, 0x5205, 0x5212, 0x5213, 0x5215, 0x5216, 0x5218, 0x5222, 0x5228, 0x5231, 0x5232, 0x5235, 0x523c, 0x5245, 0x5249,
    0x5255, 0x5257, 0x5258, 0x525a, 0x525c, 0x525f, 0x5260, 0x5261, 0x5266, 0x526e, 0x5277, 0x5278, 0x5279, 0x5280, 0x5282, 0x5285,
    0x528a, 0x528c, 0x5293, 0x5295, 0x5296, 0x5297, 0x5298, 0x529a, 0x529c, 0x52a4, 0x52a5, 0x52a6, 0x52a7, 0x52af, 0x52b0, 0x52b6,
    0x52b7, 0x52b8, 0x52ba, 0x52bb, 0x52bd, 0x52c0, 0x52c4, 0x52c6, 0x52c8, 0x52cc, 0x52cf, 0x52d1, 0x52d4, 0x52d6, 0x52db, 0x52dc,
    0x52e1, 0x52e5, 0x52e8, 0x52e9, 0x52ea, 0x52ec, 0x52f0, 0x52f1, 0x52f4, 0x52f6, 0x52f7, 0x5300, 0x5303, 0x530a, 0x530b,

    /* 0x8f 0xb4: 0xa1 - 0xfe */
            0x530c, 0x5311, 0x5313, 0x5318, 0x531b, 0x531c, 0x531e, 0x531f, 0x5325, 0x5327, 0x5328, 0x5329, 0x532b, 0x532c, 0x532d,
    0x5330, 0x5332, 0x5335, 0x533c, 0x533d, 0x533e, 0x5342, 0x534c, 0x534b, 0x5359, 0x535b, 0x5361, 0x5363, 0x5365, 0x536c, 0x536d,
    0x5372, 0x5379, 0x537e, 0x5383, 0x5387, 0x5388, 0x538e, 0x5393, 0x5394, 0x5399, 0x539d, 0x53a1, 0x53a4, 0x53aa, 0x53ab, 0x53af,
    0x53b2, 0x53b4, 0x53b5, 0x53b7, 0x53b8, 0x53ba, 0x53bd, 0x53c0, 0x53c5, 0x53cf, 0x53d2, 0x53d3, 0x53d5, 0x53da, 0x53dd, 0x53de,
    0x53e0, 0x53e6, 0x53e7, 0x53f5, 0x5402, 0x5413, 0x541a, 0x5421, 0x5427, 0x5428, 0x542a, 0x542f, 0x5431, 0x5434, 0x5435, 0x5443,
    0x5444, 0x5447, 0x544d, 0x544f, 0x545e, 0x5462, 0x5464, 0x5466, 0x5467, 0x5469, 0x546b, 0x546d, 0x546e, 0x5474, 0x547f,

    /* 0x8f 0xb5: 0xa1 - 0xfe */
            0x5481, 0x5483, 0x5485, 0x5488, 0x5489, 0x548d, 0x5491, 0x5495, 0x5496, 0x549c, 0x549f, 0x54a1, 0x54a6, 0x54a7, 0x54a9,
    0x54aa, 0x54ad, 0x54ae, 0x54b1, 0x54b7, 0x54b9, 0x54ba, 0x54bb, 0x54bf, 0x54c6, 0x54ca, 0x54cd, 0x54ce, 0x54e0, 0x54ea, 0x54ec,
    0x54ef, 0x54f6, 0x54fc, 0x54fe, 0x54ff, 0x5500, 0x5501, 0x5505, 0x5508, 0x5509, 0x550c, 0x550d, 0x550e, 0x5515, 0x552a, 0x552b,
    0x5532, 0x5535, 0x5536, 0x553b, 0x553c, 0x553d, 0x5541, 0x5547, 0x5549, 0x554a, 0x554d, 0x5550, 0x5551, 0x5558, 0x555a, 0x555b,
    0x555e, 0x5560, 0x5561, 0x5564, 0x5566, 0x557f, 0x5581, 0x5582, 0x5586, 0x5588, 0x558e, 0x558f, 0x5591, 0x5592, 0x5593, 0x5594,
    0x5597, 0x55a3, 0x55a4, 0x55ad, 0x55b2, 0x55bf, 0x55c1, 0x55c3, 0x55c6, 0x55c9, 0x55cb, 0x55cc, 0x55ce, 0x55d1, 0x55d2,

    /* 0x8f 0xb6: 0xa1 - 0xfe */
            0x55d3, 0x55d7, 0x55d8, 0x55db, 0x55de, 0x55e2, 0x55e9, 0x55f6, 0x55ff, 0x5605, 0x5608, 0x560a, 0x560d, 0x560e, 0x560f,
    0x5610, 0x5611, 0x5612, 0x5619, 0x562c, 0x5630, 0x5633, 0x5635, 0x5637, 0x5639, 0x563b, 0x563c, 0x563d, 0x563f, 0x5640, 0x5641,
    0x5643, 0x5644, 0x5646, 0x5649, 0x564b, 0x564d, 0x564f, 0x5654, 0x565e, 0x5660, 0x5661, 0x5662, 0x5663, 0x5666, 0x5669, 0x566d,
    0x566f, 0x5671, 0x5672, 0x5675, 0x5684, 0x5685, 0x5688, 0x568b, 0x568c, 0x5695, 0x5699, 0x569a, 0x569d, 0x569e, 0x569f, 0x56a6,
    0x56a7, 0x56a8, 0x56a9, 0x56ab, 0x56ac, 0x56ad, 0x56b1, 0x56b3, 0x56b7, 0x56be, 0x56c5, 0x56c9, 0x56ca, 0x56cb, 0x56cf, 0x56d0,
    0x56cc, 0x56cd, 0x56d9, 0x56dc, 0x56dd, 0x56df, 0x56e1, 0x56e4, 0x56e5, 0x56e6, 0x56e7, 0x56e8, 0x56f1, 0x56eb, 0x56ed,

    /* 0x8f 0xb7: 0xa1 - 0xfe */
            0x56f6, 0x56f7, 0x5701, 0x5702, 0x5707, 0x570a, 0x570c, 0x5711, 0x5715, 0x571a, 0x571b, 0x571d, 0x5720, 0x5722, 0x5723,
    0x5724, 0x5725, 0x5729, 0x572a, 0x572c, 0x572e, 0x572f, 0x5733, 0x5734, 0x573d, 0x573e, 0x573f, 0x5745, 0x5746, 0x574c, 0x574d,
    0x5752, 0x5762, 0x5765, 0x5767, 0x5768, 0x576b, 0x576d, 0x576e, 0x576f, 0x5770, 0x5771, 0x5773, 0x5774, 0x5775, 0x5777, 0x5779,
    0x577a, 0x577b, 0x577c, 0x577e, 0x5781, 0x5783, 0x578c, 0x5794, 0x5797, 0x5799, 0x579a, 0x579c, 0x579d, 0x579e, 0x579f, 0x57a1,
    0x5795, 0x57a7, 0x57a8, 0x57a9, 0x57ac, 0x57b8, 0x57bd, 0x57c7, 0x57c8, 0x57cc, 0x57cf, 0x57d5, 0x57dd, 0x57de, 0x57e4, 0x57e6,
    0x57e7, 0x57e9, 0x57ed, 0x57f0, 0x57f5, 0x57f6, 0x57f8, 0x57fd, 0x57fe, 0x57ff, 0x5803, 0x5804, 0x5808, 0x5809, 0x57e1,

    /* 0x8f 0xb8: 0xa1 - 0xfe */
            0x580c, 0x580d, 0x581b, 0x581e, 0x581f, 0x5820, 0x5826, 0x5827, 0x582d, 0x5832, 0x5839, 0x583f, 0x5849, 0x584c, 0x584d,
    0x584f, 0x5850, 0x5855, 0x585f, 0x5861, 0x5864, 0x5867, 0x5868, 0x5878, 0x587c, 0x587f, 0x5880, 0x5881, 0x5887, 0x5888, 0x5889,
    0x588a, 0x588c, 0x588d, 0x588f, 0x5890, 0x5894, 0x5896, 0x589d, 0x58a0, 0x58a1, 0x58a2, 0x58a6, 0x58a9, 0x58b1, 0x58b2, 0x58c4,
    0x58bc, 0x58c2, 0x58c8, 0x58cd, 0x58ce, 0x58d0, 0x58d2, 0x58d4, 0x58d6, 0x58da, 0x58dd, 0x58e1, 0x58e2, 0x58e9, 0x58f3, 0x5905,
    0x5906, 0x590b, 0x590c, 0x5912, 0x5913, 0x5914, 0x8641, 0x591d, 0x5921, 0x5923, 0x5924, 0x5928, 0x592f, 0x5930, 0x5933, 0x5935,
    0x5936, 0x593f, 0x5943, 0x5946, 0x5952, 0x5953, 0x5959, 0x595b, 0x595d, 0x595e, 0x595f, 0x5961, 0x5963, 0x596b, 0x596d,

    /* 0x8f 0xb9: 0xa1 - 0xfe */
            0x596f, 0x5972, 0x5975, 0x5976, 0x5979, 0x597b, 0x597c, 0x598b, 0x598c, 0x598e, 0x5992, 0x5995, 0x5997, 0x599f, 0x59a4,
    0x59a7, 0x59ad, 0x59ae, 0x59af, 0x59b0, 0x59b3, 0x59b7, 0x59ba, 0x59bc, 0x59c1, 0x59c3, 0x59c4, 0x59c8, 0x59ca, 0x59cd, 0x59d2,
    0x59dd, 0x59de, 0x59df, 0x59e3, 0x59e4, 0x59e7, 0x59ee, 0x59ef, 0x59f1, 0x59f2, 0x59f4, 0x59f7, 0x5a00, 0x5a04, 0x5a0c, 0x5a0d,
    0x5a0e, 0x5a12, 0x5a13, 0x5a1e, 0x5a23, 0x5a24, 0x5a27, 0x5a28, 0x5a2a, 0x5a2d, 0x5a30, 0x5a44, 0x5a45, 0x5a47, 0x5a48, 0x5a4c,
    0x5a50, 0x5a55, 0x5a5e, 0x5a63, 0x5a65, 0x5a67, 0x5a6d, 0x5a77, 0x5a7a, 0x5a7b, 0x5a7e, 0x5a8b, 0x5a90, 0x5a93, 0x5a96, 0x5a99,
    0x5a9c, 0x5a9e, 0x5a9f, 0x5aa0, 0x5aa2, 0x5aa7, 0x5aac, 0x5ab1, 0x5ab2, 0x5ab3, 0x5ab5, 0x5ab8, 0x5aba, 0x5abb, 0x5abf,

    /* 0x8f 0xba: 0xa1 - 0xfe */
            0x5ac4, 0x5ac6, 0x5ac8, 0x5acf, 0x5ada, 0x5adc, 0x5ae0, 0x5ae5, 0x5aea, 0x5aee, 0x5af5, 0x5af6, 0x5afd, 0x5b00, 0x5b01,
    0x5b08, 0x5b17, 0x5b34, 0x5b19, 0x5b1b, 0x5b1d, 0x5b21, 0x5b25, 0x5b2d, 0x5b38, 0x5b41, 0x5b4b, 0x5b4c, 0x5b52, 0x5b56, 0x5b5e,
    0x5b68, 0x5b6e, 0x5b6f, 0x5b7c, 0x5b7d, 0x5b7e, 0x5b7f, 0x5b81, 0x5b84, 0x5b86, 0x5b8a, 0x5b8e, 0x5b90, 0x5b91, 0x5b93, 0x5b94,
    0x5b96, 0x5ba8, 0x5ba9, 0x5bac, 0x5bad, 0x5baf, 0x5bb1, 0x5bb2, 0x5bb7, 0x5bba, 0x5bbc, 0x5bc0, 0x5bc1, 0x5bcd, 0x5bcf, 0x5bd6,
    0x5bd7, 0x5bd8, 0x5bd9, 0x5bda, 0x5be0, 0x5bef, 0x5bf1, 0x5bf4, 0x5bfd, 0x5c0c, 0x5c17, 0x5c1e, 0x5c1f, 0x5c23, 0x5c26, 0x5c29,
    0x5c2b, 0x5c2c, 0x5c2e, 0x5c30, 0x5c32, 0x5c35, 0x5c36, 0x5c59, 0x5c5a, 0x5c5c, 0x5c62, 0x5c63, 0x5c67, 0x5c68, 0x5c69,

    /* 0x8f 0xbb: 0xa1 - 0xfe */
            0x5c6d, 0x5c70, 0x5c74, 0x5c75, 0x5c7a, 0x5c7b, 0x5c7c, 0x5c7d, 0x5c87, 0x5c88, 0x5c8a, 0x5c8f, 0x5c92, 0x5c9d, 0x5c9f,
    0x5ca0, 0x5ca2, 0x5ca3, 0x5ca6, 0x5caa, 0x5cb2, 0x5cb4, 0x5cb5, 0x5cba, 0x5cc9, 0x5ccb, 0x5cd2, 0x5cdd, 0x5cd7, 0x5cee, 0x5cf1,
    0x5cf2, 0x5cf4, 0x5d01, 0x5d06, 0x5d0d, 0x5d12, 0x5d2b, 0x5d23, 0x5d24, 0x5d26, 0x5d27, 0x5d31, 0x5d34, 0x5d39, 0x5d3d, 0x5d3f,
    0x5d42, 0x5d43, 0x5d46, 0x5d48, 0x5d55, 0x5d51, 0x5d59, 0x5d4a, 0x5d5f, 0x5d60, 0x5d61, 0x5d62, 0x5d64, 0x5d6a, 0x5d6d, 0x5d70,
    0x5d79, 0x5d7a, 0x5d7e, 0x5d7f, 0x5d81, 0x5d83, 0x5d88, 0x5d8a, 0x5d92, 0x5d93, 0x5d94, 0x5d95, 0x5d99, 0x5d9b, 0x5d9f, 0x5da0,
    0x5da7, 0x5dab, 0x5db0, 0x5db4, 0x5db8, 0x5db9, 0x5dc3, 0x5dc7, 0x5dcb, 0x5dd0, 0x5dce, 0x5dd8, 0x5dd9, 0x5de0, 0x5de4,

    /* 0x8f 0xbc: 0xa1 - 0xfe */
            0x5de9, 0x5df8, 0x5df9, 0x5e00, 0x5e07, 0x5e0d, 0x5e12, 0x5e14, 0x5e15, 0x5e18, 0x5e1f, 0x5e20, 0x5e2e, 0x5e28, 0x5e32,
    0x5e35, 0x5e3e, 0x5e4b, 0x5e50, 0x5e49, 0x5e51, 0x5e56, 0x5e58, 0x5e5b, 0x5e5c, 0x5e5e, 0x5e68, 0x5e6a, 0x5e6b, 0x5e6c, 0x5e6d,
    0x5e6e, 0x5e70, 0x5e80, 0x5e8b, 0x5e8e, 0x5ea2, 0x5ea4, 0x5ea5, 0x5ea8, 0x5eaa, 0x5eac, 0x5eb1, 0x5eb3, 0x5ebd, 0x5ebe, 0x5ebf,
    0x5ec6, 0x5ecc, 0x5ecb, 0x5ece, 0x5ed1, 0x5ed2, 0x5ed4, 0x5ed5, 0x5edc, 0x5ede, 0x5ee5, 0x5eeb, 0x5f02, 0x5f06, 0x5f07, 0x5f08,
    0x5f0e, 0x5f19, 0x5f1c, 0x5f1d, 0x5f21, 0x5f22, 0x5f23, 0x5f24, 0x5f28, 0x5f2b, 0x5f2c, 0x5f2e, 0x5f30, 0x5f34, 0x5f36, 0x5f3b,
    0x5f3d, 0x5f3f, 0x5f40, 0x5f44, 0x5f45, 0x5f47, 0x5f4d, 0x5f50, 0x5f54, 0x5f58, 0x5f5b, 0x5f60, 0x5f63, 0x5f64, 0x5f67,

    /* 0x8f 0xbd: 0xa1 - 0xfe */
            0x5f6f, 0x5f72, 0x5f74, 0x5f75, 0x5f78, 0x5f7a, 0x5f7d, 0x5f7e, 0x5f89, 0x5f8d, 0x5f8f, 0x5f96, 0x5f9c, 0x5f9d, 0x5fa2,
    0x5fa7, 0x5fab, 0x5fa4, 0x5fac, 0x5faf, 0x5fb0, 0x5fb1, 0x5fb8, 0x5fc4, 0x5fc7, 0x5fc8, 0x5fc9, 0x5fcb, 0x5fd0, 0x5fd1, 0x5fd2,
    0x5fd3, 0x5fd4, 0x5fde, 0x5fe1, 0x5fe2, 0x5fe8, 0x5fe9, 0x5fea, 0x5fec, 0x5fed, 0x5fee, 0x5fef, 0x5ff2, 0x5ff3, 0x5ff6, 0x5ffa,
    0x5ffc, 0x6007, 0x600a, 0x600d, 0x6013, 0x6014, 0x6017, 0x6018, 0x601a, 0x601f, 0x6024, 0x602d, 0x6033, 0x6035, 0x6040, 0x6047,
    0x6048, 0x6049, 0x604c, 0x6051, 0x6054, 0x6056, 0x6057, 0x605d, 0x6061, 0x6067, 0x6071, 0x607e, 0x607f, 0x6082, 0x6086, 0x6088,
    0x608a, 0x608e, 0x6091, 0x6093, 0x6095, 0x6098, 0x609d, 0x609e, 0x60a2, 0x60a4, 0x60a5, 0x60a8, 0x60b0, 0x60b1, 0x60b7,

    /* 0x8f 0xbe: 0xa1 - 0xfe */
            0x60bb, 0x60be, 0x60c2, 0x60c4, 0x60c8, 0x60c9, 0x60ca, 0x60cb, 0x60ce, 0x60cf, 0x60d4, 0x60d5, 0x60d9, 0x60db, 0x60dd,
    0x60de, 0x60e2, 0x60e5, 0x60f2, 0x60f5, 0x60f8, 0x60fc, 0x60fd, 0x6102, 0x6107, 0x610a, 0x610c, 0x6110, 0x6111, 0x6112, 0x6113,
    0x6114, 0x6116, 0x6117, 0x6119, 0x611c, 0x611e, 0x6122, 0x612a, 0x612b, 0x6130, 0x6131, 0x6135, 0x6136, 0x6137, 0x6139, 0x6141,
    0x6145, 0x6146, 0x6149, 0x615e, 0x6160, 0x616c, 0x6172, 0x6178, 0x617b, 0x617c, 0x617f, 0x6180, 0x6181, 0x6183, 0x6184, 0x618b,
    0x618d, 0x6192, 0x6193, 0x6197, 0x6198, 0x619c, 0x619d, 0x619f, 0x61a0, 0x61a5, 0x61a8, 0x61aa, 0x61ad, 0x61b8, 0x61b9, 0x61bc,
    0x61c0, 0x61c1, 0x61c2, 0x61ce, 0x61cf, 0x61d5, 0x61dc, 0x61dd, 0x61de, 0x61df, 0x61e1, 0x61e2, 0x61e7, 0x61e9, 0x61e5,

    /* 0x8f 0xbf: 0xa1 - 0xfe */
            0x61ec, 0x61ed, 0x61ef, 0x6201, 0x6203, 0x6204, 0x6207, 0x6213, 0x6215, 0x621c, 0x6220, 0x6222, 0x6223, 0x6227, 0x6229,
    0x622b, 0x6239, 0x623d, 0x6242, 0x6243, 0x6244, 0x6246, 0x624c, 0x6250, 0x6251, 0x6252, 0x6254, 0x6256, 0x625a, 0x625c, 0x6264,
    0x626d, 0x626f, 0x6273, 0x627a, 0x627d, 0x628d, 0x628e, 0x628f, 0x6290, 0x62a6, 0x62a8, 0x62b3, 0x62b6, 0x62b7, 0x62ba, 0x62be,
    0x62bf, 0x62c4, 0x62ce, 0x62d5, 0x62d6, 0x62da, 0x62ea, 0x62f2, 0x62f4, 0x62fc, 0x62fd, 0x6303, 0x6304, 0x630a, 0x630b, 0x630d,
    0x6310, 0x6313, 0x6316, 0x6318, 0x6329, 0x632a, 0x632d, 0x6335, 0x6336, 0x6339, 0x633c, 0x6341, 0x6342, 0x6343, 0x6344, 0x6346,
    0x634a, 0x634b, 0x634e, 0x6352, 0x6353, 0x6354, 0x6358, 0x635b, 0x6365, 0x6366, 0x636c, 0x636d, 0x6371, 0x6374, 0x6375,

    /* 0x8f 0xc0: 0xa1 - 0xfe */
            0x6378, 0x637c, 0x637d, 0x637f, 0x6382, 0x6384, 0x6387, 0x638a, 0x6390, 0x6394, 0x6395, 0x6399, 0x639a, 0x639e, 0x63a4,
    0x63a6, 0x63ad, 0x63ae, 0x63af, 0x63bd, 0x63c1, 0x63c5, 0x63c8, 0x63ce, 0x63d1, 0x63d3, 0x63d4, 0x63d5, 0x63dc, 0x63e0, 0x63e5,
    0x63ea, 0x63ec, 0x63f2, 0x63f3, 0x63f5, 0x63f8, 0x63f9, 0x6409, 0x640a, 0x6410, 0x6412, 0x6414, 0x6418, 0x641e, 0x6420, 0x6422,
    0x6424, 0x6425, 0x6429, 0x642a, 0x642f, 0x6430, 0x6435, 0x643d, 0x643f, 0x644b, 0x644f, 0x6451, 0x6452, 0x6453, 0x6454, 0x645a,
    0x645b, 0x645c, 0x645d, 0x645f, 0x6460, 0x6461, 0x6463, 0x646d, 0x6473, 0x6474, 0x647b, 0x647d, 0x6485, 0x6487, 0x648f, 0x6490,
    0x6491, 0x6498, 0x6499, 0x649b, 0x649d, 0x649f, 0x64a1, 0x64a3, 0x64a6, 0x64a8, 0x64ac, 0x64b3, 0x64bd, 0x64be, 0x64bf,

    /* 0x8f 0xc1: 0xa1 - 0xfe */
            0x64c4, 0x64c9, 0x64ca, 0x64cb, 0x64cc, 0x64ce, 0x64d0, 0x64d1, 0x64d5, 0x64d7, 0x64e4, 0x64e5, 0x64e9, 0x64ea, 0x64ed,
    0x64f0, 0x64f5, 0x64f7, 0x64fb, 0x64ff, 0x6501, 0x6504, 0x6508, 0x6509, 0x650a, 0x650f, 0x6513, 0x6514, 0x6516, 0x6519, 0x651b,
    0x651e, 0x651f, 0x6522, 0x6526, 0x6529, 0x652e, 0x6531, 0x653a, 0x653c, 0x653d, 0x6543, 0x6547, 0x6549, 0x6550, 0x6552, 0x6554,
    0x655f, 0x6560, 0x6567, 0x656b, 0x657a, 0x657d, 0x6581, 0x6585, 0x658a, 0x6592, 0x6595, 0x6598, 0x659d, 0x65a0, 0x65a3, 0x65a6,
    0x65ae, 0x65b2, 0x65b3, 0x65b4, 0x65bf, 0x65c2, 0x65c8, 0x65c9, 0x65ce, 0x65d0, 0x65d4, 0x65d6, 0x65d8, 0x65df, 0x65f0, 0x65f2,
    0x65f4, 0x65f5, 0x65f9, 0x65fe, 0x65ff, 0x6600, 0x6604, 0x6608, 0x6609, 0x660d, 0x6611, 0x6612, 0x6615, 0x6616, 0x661d,

    /* 0x8f 0xc2: 0xa1 - 0xfe */
            0x661e, 0x6621, 0x6622, 0x6623, 0x6624, 0x6626, 0x6629, 0x662a, 0x662b, 0x662c, 0x662e, 0x6630, 0x6631, 0x6633, 0x6639,
    0x6637, 0x6640, 0x6645, 0x6646, 0x664a, 0x664c, 0x6651, 0x664e, 0x6657, 0x6658, 0x6659, 0x665b, 0x665c, 0x6660, 0x6661, 0x66fb,
    0x666a, 0x666b, 0x666c, 0x667e, 0x6673, 0x6675, 0x667f, 0x6677, 0x6678, 0x6679, 0x667b, 0x6680, 0x667c, 0x668b, 0x668c, 0x668d,
    0x6690, 0x6692, 0x6699, 0x669a, 0x669b, 0x669c, 0x669f, 0x66a0, 0x66a4, 0x66ad, 0x66b1, 0x66b2, 0x66b5, 0x66bb, 0x66bf, 0x66c0,
    0x66c2, 0x66c3, 0x66c8, 0x66cc, 0x66ce, 0x66cf, 0x66d4, 0x66db, 0x66df, 0x66e8, 0x66eb, 0x66ec, 0x66ee, 0x66fa, 0x6705, 0x6707,
    0x670e, 0x6713, 0x6719, 0x671c, 0x6720, 0x6722, 0x6733, 0x673e, 0x6745, 0x6747, 0x6748, 0x674c, 0x6754, 0x6755, 0x675d,

    /* 0x8f 0xc3: 0xa1 - 0xfe */
            0x6766, 0x676c, 0x676e, 0x6774, 0x6776, 0x677b, 0x6781, 0x6784, 0x678e, 0x678f, 0x6791, 0x6793, 0x6796, 0x6798, 0x6799,
    0x679b, 0x67b0, 0x67b1, 0x67b2, 0x67b5, 0x67bb, 0x67bc, 0x67bd, 0x67f9, 0x67c0, 0x67c2, 0x67c3, 0x67c5, 0x67c8, 0x67c9, 0x67d2,
    0x67d7, 0x67d9, 0x67dc, 0x67e1, 0x67e6, 0x67f0, 0x67f2, 0x67f6, 0x67f7, 0x6852, 0x6814, 0x6819, 0x681d, 0x681f, 0x6828, 0x6827,
    0x682c, 0x682d, 0x682f, 0x6830, 0x6831, 0x6833, 0x683b, 0x683f, 0x6844, 0x6845, 0x684a, 0x684c, 0x6855, 0x6857, 0x6858, 0x685b,
    0x686b, 0x686e, 0x686f, 0x6870, 0x6871, 0x6872, 0x6875, 0x6879, 0x687a, 0x687b, 0x687c, 0x6882, 0x6884, 0x6886, 0x6888, 0x6896,
    0x6898, 0x689a, 0x689c, 0x68a1, 0x68a3, 0x68a5, 0x68a9, 0x68aa, 0x68ae, 0x68b2, 0x68bb, 0x68c5, 0x68c8, 0x68cc, 0x68cf,

    /* 0x8f 0xc4: 0xa1 - 0xfe */
            0x68d0, 0x68d1, 0x68d3, 0x68d6, 0x68d9, 0x68dc, 0x68dd, 0x68e5, 0x68e8, 0x68ea, 0x68eb, 0x68ec, 0x68ed, 0x68f0, 0x68f1,
    0x68f5, 0x68f6, 0x68fb, 0x68fc, 0x68fd, 0x6906, 0x6909, 0x690a, 0x6910, 0x6911, 0x6913, 0x6916, 0x6917, 0x6931, 0x6933, 0x6935,
    0x6938, 0x693b, 0x6942, 0x6945, 0x6949, 0x694e, 0x6957, 0x695b, 0x6963, 0x6964, 0x6965, 0x6966, 0x6968, 0x6969, 0x696c, 0x6970,
    0x6971, 0x6972, 0x697a, 0x697b, 0x697f, 0x6980, 0x698d, 0x6992, 0x6996, 0x6998, 0x69a1, 0x69a5, 0x69a6, 0x69a8, 0x69ab, 0x69ad,
    0x69af, 0x69b7, 0x69b8, 0x69ba, 0x69bc, 0x69c5, 0x69c8, 0x69d1, 0x69d6, 0x69d7, 0x69e2, 0x69e5, 0x69ee, 0x69ef, 0x69f1, 0x69f3,
    0x69f5, 0x69fe, 0x6a00, 0x6a01, 0x6a03, 0x6a0f, 0x6a11, 0x6a15, 0x6a1a, 0x6a1d, 0x6a20, 0x6a24, 0x6a28, 0x6a30, 0x6a32,

    /* 0x8f 0xc5: 0xa1 - 0xfe */
            0x6a34, 0x6a37, 0x6a3b, 0x6a3e, 0x6a3f, 0x6a45, 0x6a46, 0x6a49, 0x6a4a, 0x6a4e, 0x6a50, 0x6a51, 0x6a52, 0x6a55, 0x6a56,
    0x6a5b, 0x6a64, 0x6a67, 0x6a6a, 0x6a71, 0x6a73, 0x6a7e, 0x6a81, 0x6a83, 0x6a86, 0x6a87, 0x6a89, 0x6a8b, 0x6a91, 0x6a9b, 0x6a9d,
    0x6a9e, 0x6a9f, 0x6aa5, 0x6aab, 0x6aaf, 0x6ab0, 0x6ab1, 0x6ab4, 0x6abd, 0x6abe, 0x6abf, 0x6ac6, 0x6ac9, 0x6ac8, 0x6acc, 0x6ad0,
    0x6ad4, 0x6ad5, 0x6ad6, 0x6adc, 0x6add, 0x6ae4, 0x6ae7, 0x6aec, 0x6af0, 0x6af1, 0x6af2, 0x6afc, 0x6afd, 0x6b02, 0x6b03, 0x6b06,
    0x6b07, 0x6b09, 0x6b0f, 0x6b10, 0x6b11, 0x6b17, 0x6b1b, 0x6b1e, 0x6b24, 0x6b28, 0x6b2b, 0x6b2c, 0x6b2f, 0x6b35, 0x6b36, 0x6b3b,
    0x6b3f, 0x6b46, 0x6b4a, 0x6b4d, 0x6b52, 0x6b56, 0x6b58, 0x6b5d, 0x6b60, 0x6b67, 0x6b6b, 0x6b6e, 0x6b70, 0x6b75, 0x6b7d,

    /* 0x8f 0xc6: 0xa1 - 0xfe */
            0x6b7e, 0x6b82, 0x6b85, 0x6b97, 0x6b9b, 0x6b9f, 0x6ba0, 0x6ba2, 0x6ba3, 0x6ba8, 0x6ba9, 0x6bac, 0x6bad, 0x6bae, 0x6bb0,
    0x6bb8, 0x6bb9, 0x6bbd, 0x6bbe, 0x6bc3, 0x6bc4, 0x6bc9, 0x6bcc, 0x6bd6, 0x6bda, 0x6be1, 0x6be3, 0x6be6, 0x6be7, 0x6bee, 0x6bf1,
    0x6bf7, 0x6bf9, 0x6bff, 0x6c02, 0x6c04, 0x6c05, 0x6c09, 0x6c0d, 0x6c0e, 0x6c10, 0x6c12, 0x6c19, 0x6c1f, 0x6c26, 0x6c27, 0x6c28,
    0x6c2c, 0x6c2e, 0x6c33, 0x6c35, 0x6c36, 0x6c3a, 0x6c3b, 0x6c3f, 0x6c4a, 0x6c4b, 0x6c4d, 0x6c4f, 0x6c52, 0x6c54, 0x6c59, 0x6c5b,
    0x6c5c, 0x6c6b, 0x6c6d, 0x6c6f, 0x6c74, 0x6c76, 0x6c78, 0x6c79, 0x6c7b, 0x6c85, 0x6c86, 0x6c87, 0x6c89, 0x6c94, 0x6c95, 0x6c97,
    0x6c98, 0x6c9c, 0x6c9f, 0x6cb0, 0x6cb2, 0x6cb4, 0x6cc2, 0x6cc6, 0x6ccd, 0x6ccf, 0x6cd0, 0x6cd1, 0x6cd2, 0x6cd4, 0x6cd6,

    /* 0x8f 0xc7: 0xa1 - 0xfe */
            0x6cda, 0x6cdc, 0x6ce0, 0x6ce7, 0x6ce9, 0x6ceb, 0x6cec, 0x6cee, 0x6cf2, 0x6cf4, 0x6d04, 0x6d07, 0x6d0a, 0x6d0e, 0x6d0f,
    0x6d11, 0x6d13, 0x6d1a, 0x6d26, 0x6d27, 0x6d28, 0x6c67, 0x6d2e, 0x6d2f, 0x6d31, 0x6d39, 0x6d3c, 0x6d3f, 0x6d57, 0x6d5e, 0x6d5f,
    0x6d61, 0x6d65, 0x6d67, 0x6d6f, 0x6d70, 0x6d7c, 0x6d82, 0x6d87, 0x6d91, 0x6d92, 0x6d94, 0x6d96, 0x6d97, 0x6d98, 0x6daa, 0x6dac,
    0x6db4, 0x6db7, 0x6db9, 0x6dbd, 0x6dbf, 0x6dc4, 0x6dc8, 0x6dca, 0x6dce, 0x6dcf, 0x6dd6, 0x6ddb, 0x6ddd, 0x6ddf, 0x6de0, 0x6de2,
    0x6de5, 0x6de9, 0x6def, 0x6df0, 0x6df4, 0x6df6, 0x6dfc, 0x6e00, 0x6e04, 0x6e1e, 0x6e22, 0x6e27, 0x6e32, 0x6e36, 0x6e39, 0x6e3b,
    0x6e3c, 0x6e44, 0x6e45, 0x6e48, 0x6e49, 0x6e4b, 0x6e4f, 0x6e51, 0x6e52, 0x6e53, 0x6e54, 0x6e57, 0x6e5c, 0x6e5d, 0x6e5e,

    /* 0x8f 0xc8: 0xa1 - 0xfe */
            0x6e62, 0x6e63, 0x6e68, 0x6e73, 0x6e7b, 0x6e7d, 0x6e8d, 0x6e93, 0x6e99, 0x6ea0, 0x6ea7, 0x6ead, 0x6eae, 0x6eb1, 0x6eb3,
    0x6ebb, 0x6ebf, 0x6ec0, 0x6ec1, 0x6ec3, 0x6ec7, 0x6ec8, 0x6eca, 0x6ecd, 0x6ece, 0x6ecf, 0x6eeb, 0x6eed, 0x6eee, 0x6ef9, 0x6efb,
    0x6efd, 0x6f04, 0x6f08, 0x6f0a, 0x6f0c, 0x6f0d, 0x6f16, 0x6f18, 0x6f1a, 0x6f1b, 0x6f26, 0x6f29, 0x6f2a, 0x6f2f, 0x6f30, 0x6f33,
    0x6f36, 0x6f3b, 0x6f3c, 0x6f2d, 0x6f4f, 0x6f51, 0x6f52, 0x6f53, 0x6f57, 0x6f59, 0x6f5a, 0x6f5d, 0x6f5e, 0x6f61, 0x6f62, 0x6f68,
    0x6f6c, 0x6f7d, 0x6f7e, 0x6f83, 0x6f87, 0x6f88, 0x6f8b, 0x6f8c, 0x6f8d, 0x6f90, 0x6f92, 0x6f93, 0x6f94, 0x6f96, 0x6f9a, 0x6f9f,
    0x6fa0, 0x6fa5, 0x6fa6, 0x6fa7, 0x6fa8, 0x6fae, 0x6faf, 0x6fb0, 0x6fb5, 0x6fb6, 0x6fbc, 0x6fc5, 0x6fc7, 0x6fc8, 0x6fca,

    /* 0x8f 0xc9: 0xa1 - 0xfe */
            0x6fda, 0x6fde, 0x6fe8, 0x6fe9, 0x6ff0, 0x6ff5, 0x6ff9, 0x6ffc, 0x6ffd, 0x7000, 0x7005, 0x7006, 0x7007, 0x700d, 0x7017,
    0x7020, 0x7023, 0x702f, 0x7034, 0x7037, 0x7039, 0x703c, 0x7043, 0x7044, 0x7048, 0x7049, 0x704a, 0x704b, 0x7054, 0x7055, 0x705d,
    0x705e, 0x704e, 0x7064, 0x7065, 0x706c, 0x706e, 0x7075, 0x7076, 0x707e, 0x7081, 0x7085, 0x7086, 0x7094, 0x7095, 0x7096, 0x7097,
    0x7098, 0x709b, 0x70a4, 0x70ab, 0x70b0, 0x70b1, 0x70b4, 0x70b7, 0x70ca, 0x70d1, 0x70d3, 0x70d4, 0x70d5, 0x70d6, 0x70d8, 0x70dc,
    0x70e4, 0x70fa, 0x7103, 0x7104, 0x7105, 0x7106, 0x7107, 0x710b, 0x710c, 0x710f, 0x711e, 0x7120, 0x712b, 0x712d, 0x712f, 0x7130,
    0x7131, 0x7138, 0x7141, 0x7145, 0x7146, 0x7147, 0x714a, 0x714b, 0x7150, 0x7152, 0x7157, 0x715a, 0x715c, 0x715e, 0x7160,

    /* 0x8f 0xca: 0xa1 - 0xfe */
            0x7168, 0x7179, 0x7180, 0x7185, 0x7187, 0x718c, 0x7192, 0x719a, 0x719b, 0x71a0, 0x71a2, 0x71af, 0x71b0, 0x71b2, 0x71b3,
    0x71ba, 0x71bf, 0x71c0, 0x71c1, 0x71c4, 0x71cb, 0x71cc, 0x71d3, 0x71d6, 0x71d9, 0x71da, 0x71dc, 0x71f8, 0x71fe, 0x7200, 0x7207,
    0x7208, 0x7209, 0x7213, 0x7217, 0x721a, 0x721d, 0x721f, 0x7224, 0x722b, 0x722f, 0x7234, 0x7238, 0x7239, 0x7241, 0x7242, 0x7243,
    0x7245, 0x724e, 0x724f, 0x7250, 0x7253, 0x7255, 0x7256, 0x725a, 0x725c, 0x725e, 0x7260, 0x7263, 0x7268, 0x726b, 0x726e, 0x726f,
    0x7271, 0x7277, 0x7278, 0x727b, 0x727c, 0x727f, 0x7284, 0x7289, 0x728d, 0x728e, 0x7293, 0x729b, 0x72a8, 0x72ad, 0x72ae, 0x72b1,
    0x72b4, 0x72be, 0x72c1, 0x72c7, 0x72c9, 0x72cc, 0x72d5, 0x72d6, 0x72d8, 0x72df, 0x72e5, 0x72f3, 0x72f4, 0x72fa, 0x72fb,

    /* 0x8f 0xcb: 0xa1 - 0xfe */
            0x72fe, 0x7302, 0x7304, 0x7305, 0x7307, 0x730b, 0x730d, 0x7312, 0x7313, 0x7318, 0x7319, 0x731e, 0x7322, 0x7324, 0x7327,
    0x7328, 0x732c, 0x7331, 0x7332, 0x7335, 0x733a, 0x733b, 0x733d, 0x7343, 0x734d, 0x7350, 0x7352, 0x7356, 0x7358, 0x735d, 0x735e,
    0x735f, 0x7360, 0x7366, 0x7367, 0x7369, 0x736b, 0x736c, 0x736e, 0x736f, 0x7371, 0x7377, 0x7379, 0x737c, 0x7380, 0x7381, 0x7383,
    0x7385, 0x7386, 0x738e, 0x7390, 0x7393, 0x7395, 0x7397, 0x7398, 0x739c, 0x739e, 0x739f, 0x73a0, 0x73a2, 0x73a5, 0x73a6, 0x73aa,
    0x73ab, 0x73ad, 0x73b5, 0x73b7, 0x73b9, 0x73bc, 0x73bd, 0x73bf, 0x73c5, 0x73c6, 0x73c9, 0x73cb, 0x73cc, 0x73cf, 0x73d2, 0x73d3,
    0x73d6, 0x73d9, 0x73dd, 0x73e1, 0x73e3, 0x73e6, 0x73e7, 0x73e9, 0x73f4, 0x73f5, 0x73f7, 0x73f9, 0x73fa, 0x73fb, 0x73fd,

    /* 0x8f 0xcc: 0xa1 - 0xfe */
            0x73ff, 0x7400, 0x7401, 0x7404, 0x7407, 0x740a, 0x7411, 0x741a, 0x741b, 0x7424, 0x7426, 0x7428, 0x7429, 0x742a, 0x742b,
    0x742c, 0x742d, 0x742e, 0x742f, 0x7430, 0x7431, 0x7439, 0x7440, 0x7443, 0x7444, 0x7446, 0x7447, 0x744b, 0x744d, 0x7451, 0x7452,
    0x7457, 0x745d, 0x7462, 0x7466, 0x7467, 0x7468, 0x746b, 0x746d, 0x746e, 0x7471, 0x7472, 0x7480, 0x7481, 0x7485, 0x7486, 0x7487,
    0x7489, 0x748f, 0x7490, 0x7491, 0x7492, 0x7498, 0x7499, 0x749a, 0x749c, 0x749f, 0x74a0, 0x74a1, 0x74a3, 0x74a6, 0x74a8, 0x74a9,
    0x74aa, 0x74ab, 0x74ae, 0x74af, 0x74b1, 0x74b2, 0x74b5, 0x74b9, 0x74bb, 0x74bf, 0x74c8, 0x74c9, 0x74cc, 0x74d0, 0x74d3, 0x74d8,
    0x74da, 0x74db, 0x74de, 0x74df, 0x74e4, 0x74e8, 0x74ea, 0x74eb, 0x74ef, 0x74f4, 0x74fa, 0x74fb, 0x74fc, 0x74ff, 0x7506,

    /* 0x8f 0xcd: 0xa1 - 0xfe */
            0x7512, 0x7516, 0x7517, 0x7520, 0x7521, 0x7524, 0x7527, 0x7529, 0x752a, 0x752f, 0x7536, 0x7539, 0x753d, 0x753e, 0x753f,
    0x7540, 0x7543, 0x7547, 0x7548, 0x754e, 0x7550, 0x7552, 0x7557, 0x755e, 0x755f, 0x7561, 0x756f, 0x7571, 0x7579, 0x757a, 0x757b,
    0x757c, 0x757d, 0x757e, 0x7581, 0x7585, 0x7590, 0x7592, 0x7593, 0x7595, 0x7599, 0x759c, 0x75a2, 0x75a4, 0x75b4, 0x75ba, 0x75bf,
    0x75c0, 0x75c1, 0x75c4, 0x75c6, 0x75cc, 0x75ce, 0x75cf, 0x75d7, 0x75dc, 0x75df, 0x75e0, 0x75e1, 0x75e4, 0x75e7, 0x75ec, 0x75ee,
    0x75ef, 0x75f1, 0x75f9, 0x7600, 0x7602, 0x7603, 0x7604, 0x7607, 0x7608, 0x760a, 0x760c, 0x760f, 0x7612, 0x7613, 0x7615, 0x7616,
    0x7619, 0x761b, 0x761c, 0x761d, 0x761e, 0x7623, 0x7625, 0x7626, 0x7629, 0x762d, 0x7632, 0x7633, 0x7635, 0x7638, 0x7639,

    /* 0x8f 0xce: 0xa1 - 0xfe */
            0x763a, 0x763c, 0x764a, 0x7640, 0x7641, 0x7643, 0x7644, 0x7645, 0x7649, 0x764b, 0x7655, 0x7659, 0x765f, 0x7664, 0x7665,
    0x766d, 0x766e, 0x766f, 0x7671, 0x7674, 0x7681, 0x7685, 0x768c, 0x768d, 0x7695, 0x769b, 0x769c, 0x769d, 0x769f, 0x76a0, 0x76a2,
    0x76a3, 0x76a4, 0x76a5, 0x76a6, 0x76a7, 0x76a8, 0x76aa, 0x76ad, 0x76bd, 0x76c1, 0x76c5, 0x76c9, 0x76cb, 0x76cc, 0x76ce, 0x76d4,
    0x76d9, 0x76e0, 0x76e6, 0x76e8, 0x76ec, 0x76f0, 0x76f1, 0x76f6, 0x76f9, 0x76fc, 0x7700, 0x7706, 0x770a, 0x770e, 0x7712, 0x7714,
    0x7715, 0x7717, 0x7719, 0x771a, 0x771c, 0x7722, 0x7728, 0x772d, 0x772e, 0x772f, 0x7734, 0x7735, 0x7736, 0x7739, 0x773d, 0x773e,
    0x7742, 0x7745, 0x7746, 0x774a, 0x774d, 0x774e, 0x774f, 0x7752, 0x7756, 0x7757, 0x775c, 0x775e, 0x775f, 0x7760, 0x7762,

    /* 0x8f 0xcf: 0xa1 - 0xfe */
            0x7764, 0x7767, 0x776a, 0x776c, 0x7770, 0x7772, 0x7773, 0x7774, 0x777a, 0x777d, 0x7780, 0x7784, 0x778c, 0x778d, 0x7794,
    0x7795, 0x7796, 0x779a, 0x779f, 0x77a2, 0x77a7, 0x77aa, 0x77ae, 0x77af, 0x77b1, 0x77b5, 0x77be, 0x77c3, 0x77c9, 0x77d1, 0x77d2,
    0x77d5, 0x77d9, 0x77de, 0x77df, 0x77e0, 0x77e4, 0x77e6, 0x77ea, 0x77ec, 0x77f0, 0x77f1, 0x77f4, 0x77f8, 0x77fb, 0x7805, 0x7806,
    0x7809, 0x780d, 0x780e, 0x7811, 0x781d, 0x7821, 0x7822, 0x7823, 0x782d, 0x782e, 0x7830, 0x7835, 0x7837, 0x7843, 0x7844, 0x7847,
    0x7848, 0x784c, 0x784e, 0x7852, 0x785c, 0x785e, 0x7860, 0x7861, 0x7863, 0x7864, 0x7868, 0x786a, 0x786e, 0x787a, 0x787e, 0x788a,
    0x788f, 0x7894, 0x7898, 0x78a1, 0x789d, 0x789e, 0x789f, 0x78a4, 0x78a8, 0x78ac, 0x78ad, 0x78b0, 0x78b1, 0x78b2, 0x78b3,

    /* 0x8f 0xd0: 0xa1 - 0xfe */
            0x78bb, 0x78bd, 0x78bf, 0x78c7, 0x78c8, 0x78c9, 0x78cc, 0x78ce, 0x78d2, 0x78d3, 0x78d5, 0x78d6, 0x78e4, 0x78db, 0x78df,
    0x78e0, 0x78e1, 0x78e6, 0x78ea, 0x78f2, 0x78f3, 0x7900, 0x78f6, 0x78f7, 0x78fa, 0x78fb, 0x78ff, 0x7906, 0x790c, 0x7910, 0x791a,
    0x791c, 0x791e, 0x791f, 0x7920, 0x7925, 0x7927, 0x7929, 0x792d, 0x7931, 0x7934, 0x7935, 0x793b, 0x793d, 0x793f, 0x7944, 0x7945,
    0x7946, 0x794a, 0x794b, 0x794f, 0x7951, 0x7954, 0x7958, 0x795b, 0x795c, 0x7967, 0x7969, 0x796b, 0x7972, 0x7979, 0x797b, 0x797c,
    0x797e, 0x798b, 0x798c, 0x7991, 0x7993, 0x7994, 0x7995, 0x7996, 0x7998, 0x799b, 0x799c, 0x79a1, 0x79a8, 0x79a9, 0x79ab, 0x79af,
    0x79b1, 0x79b4, 0x79b8, 0x79bb, 0x79c2, 0x79c4, 0x79c7, 0x79c8, 0x79ca, 0x79cf, 0x79d4, 0x79d6, 0x79da, 0x79dd, 0x79de,

    /* 0x8f 0xd1: 0xa1 - 0xfe */
            0x79e0, 0x79e2, 0x79e5, 0x79ea, 0x79eb, 0x79ed, 0x79f1, 0x79f8, 0x79fc, 0x7a02, 0x7a03, 0x7a07, 0x7a09, 0x7a0a, 0x7a0c,
    0x7a11, 0x7a15, 0x7a1b, 0x7a1e, 0x7a21, 0x7a27, 0x7a2b, 0x7a2d, 0x7a2f, 0x7a30, 0x7a34, 0x7a35, 0x7a38, 0x7a39, 0x7a3a, 0x7a44,
    0x7a45, 0x7a47, 0x7a48, 0x7a4c, 0x7a55, 0x7a56, 0x7a59, 0x7a5c, 0x7a5d, 0x7a5f, 0x7a60, 0x7a65, 0x7a67, 0x7a6a, 0x7a6d, 0x7a75,
    0x7a78, 0x7a7e, 0x7a80, 0x7a82, 0x7a85, 0x7a86, 0x7a8a, 0x7a8b, 0x7a90, 0x7a91, 0x7a94, 0x7a9e, 0x7aa0, 0x7aa3, 0x7aac, 0x7ab3,
    0x7ab5, 0x7ab9, 0x7abb, 0x7abc, 0x7ac6, 0x7ac9, 0x7acc, 0x7ace, 0x7ad1, 0x7adb, 0x7ae8, 0x7ae9, 0x7aeb, 0x7aec, 0x7af1, 0x7af4,
    0x7afb, 0x7afd, 0x7afe, 0x7b07, 0x7b14, 0x7b1f, 0x7b23, 0x7b27, 0x7b29, 0x7b2a, 0x7b2b, 0x7b2d, 0x7b2e, 0x7b2f, 0x7b30,

    /* 0x8f 0xd2: 0xa1 - 0xfe */
            0x7b31, 0x7b34, 0x7b3d, 0x7b3f, 0x7b40, 0x7b41, 0x7b47, 0x7b4e, 0x7b55, 0x7b60, 0x7b64, 0x7b66, 0x7b69, 0x7b6a, 0x7b6d,
    0x7b6f, 0x7b72, 0x7b73, 0x7b77, 0x7b84, 0x7b89, 0x7b8e, 0x7b90, 0x7b91, 0x7b96, 0x7b9b, 0x7b9e, 0x7ba0, 0x7ba5, 0x7bac, 0x7baf,
    0x7bb0, 0x7bb2, 0x7bb5, 0x7bb6, 0x7bba, 0x7bbb, 0x7bbc, 0x7bbd, 0x7bc2, 0x7bc5, 0x7bc8, 0x7bca, 0x7bd4, 0x7bd6, 0x7bd7, 0x7bd9,
    0x7bda, 0x7bdb, 0x7be8, 0x7bea, 0x7bf2, 0x7bf4, 0x7bf5, 0x7bf8, 0x7bf9, 0x7bfa, 0x7bfc, 0x7bfe, 0x7c01, 0x7c02, 0x7c03, 0x7c04,
    0x7c06, 0x7c09, 0x7c0b, 0x7c0c, 0x7c0e, 0x7c0f, 0x7c19, 0x7c1b, 0x7c20, 0x7c25, 0x7c26, 0x7c28, 0x7c2c, 0x7c31, 0x7c33, 0x7c34,
    0x7c36, 0x7c39, 0x7c3a, 0x7c46, 0x7c4a, 0x7c55, 0x7c51, 0x7c52, 0x7c53, 0x7c59, 0x7c5a, 0x7c5b, 0x7c5c, 0x7c5d, 0x7c5e,

    /* 0x8f 0xd3: 0xa1 - 0xfe */
            0x7c61, 0x7c63, 0x7c67, 0x7c69, 0x7c6d, 0x7c6e, 0x7c70, 0x7c72, 0x7c79, 0x7c7c, 0x7c7d, 0x7c86, 0x7c87, 0x7c8f, 0x7c94,
    0x7c9e, 0x7ca0, 0x7ca6, 0x7cb0, 0x7cb6, 0x7cb7, 0x7cba, 0x7cbb, 0x7cbc, 0x7cbf, 0x7cc4, 0x7cc7, 0x7cc8, 0x7cc9, 0x7ccd, 0x7ccf,
    0x7cd3, 0x7cd4, 0x7cd5, 0x7cd7, 0x7cd9, 0x7cda, 0x7cdd, 0x7ce6, 0x7ce9, 0x7ceb, 0x7cf5, 0x7d03, 0x7d07, 0x7d08, 0x7d09, 0x7d0f,
    0x7d11, 0x7d12, 0x7d13, 0x7d16, 0x7d1d, 0x7d1e, 0x7d23, 0x7d26, 0x7d2a, 0x7d2d, 0x7d31, 0x7d3c, 0x7d3d, 0x7d3e, 0x7d40, 0x7d41,
    0x7d47, 0x7d48, 0x7d4d, 0x7d51, 0x7d53, 0x7d57, 0x7d59, 0x7d5a, 0x7d5c, 0x7d5d, 0x7d65, 0x7d67, 0x7d6a, 0x7d70, 0x7d78, 0x7d7a,
    0x7d7b, 0x7d7f, 0x7d81, 0x7d82, 0x7d83, 0x7d85, 0x7d86, 0x7d88, 0x7d8b, 0x7d8c, 0x7d8d, 0x7d91, 0x7d96, 0x7d97, 0x7d9d,

    /* 0x8f 0xd4: 0xa1 - 0xfe */
            0x7d9e, 0x7da6, 0x7da7, 0x7daa, 0x7db3, 0x7db6, 0x7db7, 0x7db9, 0x7dc2, 0x7dc3, 0x7dc4, 0x7dc5, 0x7dc6, 0x7dcc, 0x7dcd,
    0x7dce, 0x7dd7, 0x7dd9, 0x7e00, 0x7de2, 0x7de5, 0x7de6, 0x7dea, 0x7deb, 0x7ded, 0x7df1, 0x7df5, 0x7df6, 0x7df9, 0x7dfa, 0x7e08,
    0x7e10, 0x7e11, 0x7e15, 0x7e17, 0x7e1c, 0x7e1d, 0x7e20, 0x7e27, 0x7e28, 0x7e2c, 0x7e2d, 0x7e2f, 0x7e33, 0x7e36, 0x7e3f, 0x7e44,
    0x7e45, 0x7e47, 0x7e4e, 0x7e50, 0x7e52, 0x7e58, 0x7e5f, 0x7e61, 0x7e62, 0x7e65, 0x7e6b, 0x7e6e, 0x7e6f, 0x7e73, 0x7e78, 0x7e7e,
    0x7e81, 0x7e86, 0x7e87, 0x7e8a, 0x7e8d, 0x7e91, 0x7e95, 0x7e98, 0x7e9a, 0x7e9d, 0x7e9e, 0x7f3c, 0x7f3b, 0x7f3d, 0x7f3e, 0x7f3f,
    0x7f43, 0x7f44, 0x7f47, 0x7f4f, 0x7f52, 0x7f53, 0x7f5b, 0x7f5c, 0x7f5d, 0x7f61, 0x7f63, 0x7f64, 0x7f65, 0x7f66, 0x7f6d,

    /* 0x8f 0xd5: 0xa1 - 0xfe */
            0x7f71, 0x7f7d, 0x7f7e, 0x7f7f, 0x7f80, 0x7f8b, 0x7f8d, 0x7f8f, 0x7f90, 0x7f91, 0x7f96, 0x7f97, 0x7f9c, 0x7fa1, 0x7fa2,
    0x7fa6, 0x7faa, 0x7fad, 0x7fb4, 0x7fbc, 0x7fbf, 0x7fc0, 0x7fc3, 0x7fc8, 0x7fce, 0x7fcf, 0x7fdb, 0x7fdf, 0x7fe3, 0x7fe5, 0x7fe8,
    0x7fec, 0x7fee, 0x7fef, 0x7ff2, 0x7ffa, 0x7ffd, 0x7ffe, 0x7fff, 0x8007, 0x8008, 0x800a, 0x800d, 0x800e, 0x800f, 0x8011, 0x8013,
    0x8014, 0x8016, 0x801d, 0x801e, 0x801f, 0x8020, 0x8024, 0x8026, 0x802c, 0x802e, 0x8030, 0x8034, 0x8035, 0x8037, 0x8039, 0x803a,
    0x803c, 0x803e, 0x8040, 0x8044, 0x8060, 0x8064, 0x8066, 0x806d, 0x8071, 0x8075, 0x8081, 0x8088, 0x808e, 0x809c, 0x809e, 0x80a6,
    0x80a7, 0x80ab, 0x80b8, 0x80b9, 0x80c8, 0x80cd, 0x80cf, 0x80d2, 0x80d4, 0x80d5, 0x80d7, 0x80d8, 0x80e0, 0x80ed, 0x80ee,

    /* 0x8f 0xd6: 0xa1 - 0xfe */
            0x80f0, 0x80f2, 0x80f3, 0x80f6, 0x80f9, 0x80fa, 0x80fe, 0x8103, 0x810b, 0x8116, 0x8117, 0x8118, 0x811c, 0x811e, 0x8120,
    0x8124, 0x8127, 0x812c, 0x8130, 0x8135, 0x813a, 0x813c, 0x8145, 0x8147, 0x814a, 0x814c, 0x8152, 0x8157, 0x8160, 0x8161, 0x8167,
    0x8168, 0x8169, 0x816d, 0x816f, 0x8177, 0x8181, 0x8190, 0x8184, 0x8185, 0x8186, 0x818b, 0x818e, 0x8196, 0x8198, 0x819b, 0x819e,
    0x81a2, 0x81ae, 0x81b2, 0x81b4, 0x81bb, 0x81cb, 0x81c3, 0x81c5, 0x81ca, 0x81ce, 0x81cf, 0x81d5, 0x81d7, 0x81db, 0x81dd, 0x81de,
    0x81e1, 0x81e4, 0x81eb, 0x81ec, 0x81f0, 0x81f1, 0x81f2, 0x81f5, 0x81f6, 0x81f8, 0x81f9, 0x81fd, 0x81ff, 0x8200, 0x8203, 0x820f,
    0x8213, 0x8214, 0x8219, 0x821a, 0x821d, 0x8221, 0x8222, 0x8228, 0x8232, 0x8234, 0x823a, 0x8243, 0x8244, 0x8245, 0x8246,

    /* 0x8f 0xd7: 0xa1 - 0xfe */
            0x824b, 0x824e, 0x824f, 0x8251, 0x8256, 0x825c, 0x8260, 0x8263, 0x8267, 0x826d, 0x8274, 0x827b, 0x827d, 0x827f, 0x8280,
    0x8281, 0x8283, 0x8284, 0x8287, 0x8289, 0x828a, 0x828e, 0x8291, 0x8294, 0x8296, 0x8298, 0x829a, 0x829b, 0x82a0, 0x82a1, 0x82a3,
    0x82a4, 0x82a7, 0x82a8, 0x82a9, 0x82aa, 0x82ae, 0x82b0, 0x82b2, 0x82b4, 0x82b7, 0x82ba, 0x82bc, 0x82be, 0x82bf, 0x82c6, 0x82d0,
    0x82d5, 0x82da, 0x82e0, 0x82e2, 0x82e4, 0x82e8, 0x82ea, 0x82ed, 0x82ef, 0x82f6, 0x82f7, 0x82fd, 0x82fe, 0x8300, 0x8301, 0x8307,
    0x8308, 0x830a, 0x830b, 0x8354, 0x831b, 0x831d, 0x831e, 0x831f, 0x8321, 0x8322, 0x832c, 0x832d, 0x832e, 0x8330, 0x8333, 0x8337,
    0x833a, 0x833c, 0x833d, 0x8342, 0x8343, 0x8344, 0x8347, 0x834d, 0x834e, 0x8351, 0x8355, 0x8356, 0x8357, 0x8370, 0x8378,

    /* 0x8f 0xd8: 0xa1 - 0xfe */
            0x837d, 0x837f, 0x8380, 0x8382, 0x8384, 0x8386, 0x838d, 0x8392, 0x8394, 0x8395, 0x8398, 0x8399, 0x839b, 0x839c, 0x839d,
    0x83a6, 0x83a7, 0x83a9, 0x83ac, 0x83be, 0x83bf, 0x83c0, 0x83c7, 0x83c9, 0x83cf, 0x83d0, 0x83d1, 0x83d4, 0x83dd, 0x8353, 0x83e8,
    0x83ea, 0x83f6, 0x83f8, 0x83f9, 0x83fc, 0x8401, 0x8406, 0x840a, 0x840f, 0x8411, 0x8415, 0x8419, 0x83ad, 0x842f, 0x8439, 0x8445,
    0x8447, 0x8448, 0x844a, 0x844d, 0x844f, 0x8451, 0x8452, 0x8456, 0x8458, 0x8459, 0x845a, 0x845c, 0x8460, 0x8464, 0x8465, 0x8467,
    0x846a, 0x8470, 0x8473, 0x8474, 0x8476, 0x8478, 0x847c, 0x847d, 0x8481, 0x8485, 0x8492, 0x8493, 0x8495, 0x849e, 0x84a6, 0x84a8,
    0x84a9, 0x84aa, 0x84af, 0x84b1, 0x84b4, 0x84ba, 0x84bd, 0x84be, 0x84c0, 0x84c2, 0x84c7, 0x84c8, 0x84cc, 0x84cf, 0x84d3,

    /* 0x8f 0xd9: 0xa1 - 0xfe */
            0x84dc, 0x84e7, 0x84ea, 0x84ef, 0x84f0, 0x84f1, 0x84f2, 0x84f7, 0x8532, 0x84fa, 0x84fb, 0x84fd, 0x8502, 0x8503, 0x8507,
    0x850c, 0x850e, 0x8510, 0x851c, 0x851e, 0x8522, 0x8523, 0x8524, 0x8525, 0x8527, 0x852a, 0x852b, 0x852f, 0x8533, 0x8534, 0x8536,
    0x853f, 0x8546, 0x854f, 0x8550, 0x8551, 0x8552, 0x8553, 0x8556, 0x8559, 0x855c, 0x855d, 0x855e, 0x855f, 0x8560, 0x8561, 0x8562,
    0x8564, 0x856b, 0x856f, 0x8579, 0x857a, 0x857b, 0x857d, 0x857f, 0x8581, 0x8585, 0x8586, 0x8589, 0x858b, 0x858c, 0x858f, 0x8593,
    0x8598, 0x859d, 0x859f, 0x85a0, 0x85a2, 0x85a5, 0x85a7, 0x85b4, 0x85b6, 0x85b7, 0x85b8, 0x85bc, 0x85bd, 0x85be, 0x85bf, 0x85c2,
    0x85c7, 0x85ca, 0x85cb, 0x85ce, 0x85ad, 0x85d8, 0x85da, 0x85df, 0x85e0, 0x85e6, 0x85e8, 0x85ed, 0x85f3, 0x85f6, 0x85fc,

    /* 0x8f 0xda: 0xa1 - 0xfe */
            0x85ff, 0x8600, 0x8604, 0x8605, 0x860d, 0x860e, 0x8610, 0x8611, 0x8612, 0x8618, 0x8619, 0x861b, 0x861e, 0x8621, 0x8627,
    0x8629, 0x8636, 0x8638, 0x863a, 0x863c, 0x863d, 0x8640, 0x8642, 0x8646, 0x8652, 0x8653, 0x8656, 0x8657, 0x8658, 0x8659, 0x865d,
    0x8660, 0x8661, 0x8662, 0x8663, 0x8664, 0x8669, 0x866c, 0x866f, 0x8675, 0x8676, 0x8677, 0x867a, 0x868d, 0x8691, 0x8696, 0x8698,
    0x869a, 0x869c, 0x86a1, 0x86a6, 0x86a7, 0x86a8, 0x86ad, 0x86b1, 0x86b3, 0x86b4, 0x86b5, 0x86b7, 0x86b8, 0x86b9, 0x86bf, 0x86c0,
    0x86c1, 0x86c3, 0x86c5, 0x86d1, 0x86d2, 0x86d5, 0x86d7, 0x86da, 0x86dc, 0x86e0, 0x86e3, 0x86e5, 0x86e7, 0x8688, 0x86fa, 0x86fc,
    0x86fd, 0x8704, 0x8705, 0x8707, 0x870b, 0x870e, 0x870f, 0x8710, 0x8713, 0x8714, 0x8719, 0x871e, 0x871f, 0x8721, 0x8723,

    /* 0x8f 0xdb: 0xa1 - 0xfe */
            0x8728, 0x872e, 0x872f, 0x8731, 0x8732, 0x8739, 0x873a, 0x873c, 0x873d, 0x873e, 0x8740, 0x8743, 0x8745, 0x874d, 0x8758,
    0x875d, 0x8761, 0x8764, 0x8765, 0x876f, 0x8771, 0x8772, 0x877b, 0x8783, 0x8784, 0x8785, 0x8786, 0x8787, 0x8788, 0x8789, 0x878b,
    0x878c, 0x8790, 0x8793, 0x8795, 0x8797, 0x8798, 0x8799, 0x879e, 0x87a0, 0x87a3, 0x87a7, 0x87ac, 0x87ad, 0x87ae, 0x87b1, 0x87b5,
    0x87be, 0x87bf, 0x87c1, 0x87c8, 0x87c9, 0x87ca, 0x87ce, 0x87d5, 0x87d6, 0x87d9, 0x87da, 0x87dc, 0x87df, 0x87e2, 0x87e3, 0x87e4,
    0x87ea, 0x87eb, 0x87ed, 0x87f1, 0x87f3, 0x87f8, 0x87fa, 0x87ff, 0x8801, 0x8803, 0x8806, 0x8809, 0x880a, 0x880b, 0x8810, 0x8819,
    0x8812, 0x8813, 0x8814, 0x8818, 0x881a, 0x881b, 0x881c, 0x881e, 0x881f, 0x8828, 0x882d, 0x882e, 0x8830, 0x8832, 0x8835,

    /* 0x8f 0xdc: 0xa1 - 0xfe */
            0x883a, 0x883c, 0x8841, 0x8843, 0x8845, 0x8848, 0x8849, 0x884a, 0x884b, 0x884e, 0x8851, 0x8855, 0x8856, 0x8858, 0x885a,
    0x885c, 0x885f, 0x8860, 0x8864, 0x8869, 0x8871, 0x8879, 0x887b, 0x8880, 0x8898, 0x889a, 0x889b, 0x889c, 0x889f, 0x88a0, 0x88a8,
    0x88aa, 0x88ba, 0x88bd, 0x88be, 0x88c0, 0x88ca, 0x88cb, 0x88cc, 0x88cd, 0x88ce, 0x88d1, 0x88d2, 0x88d3, 0x88db, 0x88de, 0x88e7,
    0x88ef, 0x88f0, 0x88f1, 0x88f5, 0x88f7, 0x8901, 0x8906, 0x890d, 0x890e, 0x890f, 0x8915, 0x8916, 0x8918, 0x8919, 0x891a, 0x891c,
    0x8920, 0x8926, 0x8927, 0x8928, 0x8930, 0x8931, 0x8932, 0x8935, 0x8939, 0x893a, 0x893e, 0x8940, 0x8942, 0x8945, 0x8946, 0x8949,
    0x894f, 0x8952, 0x8957, 0x895a, 0x895b, 0x895c, 0x8961, 0x8962, 0x8963, 0x896b, 0x896e, 0x8970, 0x8973, 0x8975, 0x897a,

    /* 0x8f 0xdd: 0xa1 - 0xfe */
            0x897b, 0x897c, 0x897d, 0x8989, 0x898d, 0x8990, 0x8994, 0x8995, 0x899b, 0x899c, 0x899f, 0x89a0, 0x89a5, 0x89b0, 0x89b4,
    0x89b5, 0x89b6, 0x89b7, 0x89bc, 0x89d4, 0x89d5, 0x89d6, 0x89d7, 0x89d8, 0x89e5, 0x89e9, 0x89eb, 0x89ed, 0x89f1, 0x89f3, 0x89f6,
    0x89f9, 0x89fd, 0x89ff, 0x8a04, 0x8a05, 0x8a07, 0x8a0f, 0x8a11, 0x8a12, 0x8a14, 0x8a15, 0x8a1e, 0x8a20, 0x8a22, 0x8a24, 0x8a26,
    0x8a2b, 0x8a2c, 0x8a2f, 0x8a35, 0x8a37, 0x8a3d, 0x8a3e, 0x8a40, 0x8a43, 0x8a45, 0x8a47, 0x8a49, 0x8a4d, 0x8a4e, 0x8a53, 0x8a56,
    0x8a57, 0x8a58, 0x8a5c, 0x8a5d, 0x8a61, 0x8a65, 0x8a67, 0x8a75, 0x8a76, 0x8a77, 0x8a79, 0x8a7a, 0x8a7b, 0x8a7e, 0x8a7f, 0x8a80,
    0x8a83, 0x8a86, 0x8a8b, 0x8a8f, 0x8a90, 0x8a92, 0x8a96, 0x8a97, 0x8a99, 0x8a9f, 0x8aa7, 0x8aa9, 0x8aae, 0x8aaf, 0x8ab3,

    /* 0x8f 0xde: 0xa1 - 0xfe */
            0x8ab6, 0x8ab7, 0x8abb, 0x8abe, 0x8ac3, 0x8ac6, 0x8ac8, 0x8ac9, 0x8aca, 0x8ad1, 0x8ad3, 0x8ad4, 0x8ad5, 0x8ad7, 0x8add,
    0x8adf, 0x8aec, 0x8af0, 0x8af4, 0x8af5, 0x8af6, 0x8afc, 0x8aff, 0x8b05, 0x8b06, 0x8b0b, 0x8b11, 0x8b1c, 0x8b1e, 0x8b1f, 0x8b0a,
    0x8b2d, 0x8b30, 0x8b37, 0x8b3c, 0x8b42, 0x8b43, 0x8b44, 0x8b45, 0x8b46, 0x8b48, 0x8b52, 0x8b53, 0x8b54, 0x8b59, 0x8b4d, 0x8b5e,
    0x8b63, 0x8b6d, 0x8b76, 0x8b78, 0x8b79, 0x8b7c, 0x8b7e, 0x8b81, 0x8b84, 0x8b85, 0x8b8b, 0x8b8d, 0x8b8f, 0x8b94, 0x8b95, 0x8b9c,
    0x8b9e, 0x8b9f, 0x8c38, 0x8c39, 0x8c3d, 0x8c3e, 0x8c45, 0x8c47, 0x8c49, 0x8c4b, 0x8c4f, 0x8c51, 0x8c53, 0x8c54, 0x8c57, 0x8c58,
    0x8c5b, 0x8c5d, 0x8c59, 0x8c63, 0x8c64, 0x8c66, 0x8c68, 0x8c69, 0x8c6d, 0x8c73, 0x8c75, 0x8c76, 0x8c7b, 0x8c7e, 0x8c86,

    /* 0x8f 0xdf: 0xa1 - 0xfe */
            0x8c87, 0x8c8b, 0x8c90, 0x8c92, 0x8c93, 0x8c99, 0x8c9b, 0x8c9c, 0x8ca4, 0x8cb9, 0x8cba, 0x8cc5, 0x8cc6, 0x8cc9, 0x8ccb,
    0x8ccf, 0x8cd6, 0x8cd5, 0x8cd9, 0x8cdd, 0x8ce1, 0x8ce8, 0x8cec, 0x8cef, 0x8cf0, 0x8cf2, 0x8cf5, 0x8cf7, 0x8cf8, 0x8cfe, 0x8cff,
    0x8d01, 0x8d03, 0x8d09, 0x8d12, 0x8d17, 0x8d1b, 0x8d65, 0x8d69, 0x8d6c, 0x8d6e, 0x8d7f, 0x8d82, 0x8d84, 0x8d88, 0x8d8d, 0x8d90,
    0x8d91, 0x8d95, 0x8d9e, 0x8d9f, 0x8da0, 0x8da6, 0x8dab, 0x8dac, 0x8daf, 0x8db2, 0x8db5, 0x8db7, 0x8db9, 0x8dbb, 0x8dc0, 0x8dc5,
    0x8dc6, 0x8dc7, 0x8dc8, 0x8dca, 0x8dce, 0x8dd1, 0x8dd4, 0x8dd5, 0x8dd7, 0x8dd9, 0x8de4, 0x8de5, 0x8de7, 0x8dec, 0x8df0, 0x8dbc,
    0x8df1, 0x8df2, 0x8df4, 0x8dfd, 0x8e01, 0x8e04, 0x8e05, 0x8e06, 0x8e0b, 0x8e11, 0x8e14, 0x8e16, 0x8e20, 0x8e21, 0x8e22,

    /* 0x8f 0xe0: 0xa1 - 0xfe */
            0x8e23, 0x8e26, 0x8e27, 0x8e31, 0x8e33, 0x8e36, 0x8e37, 0x8e38, 0x8e39, 0x8e3d, 0x8e40, 0x8e41, 0x8e4b, 0x8e4d, 0x8e4e,
    0x8e4f, 0x8e54, 0x8e5b, 0x8e5c, 0x8e5d, 0x8e5e, 0x8e61, 0x8e62, 0x8e69, 0x8e6c, 0x8e6d, 0x8e6f, 0x8e70, 0x8e71, 0x8e79, 0x8e7a,
    0x8e7b, 0x8e82, 0x8e83, 0x8e89, 0x8e90, 0x8e92, 0x8e95, 0x8e9a, 0x8e9b, 0x8e9d, 0x8e9e, 0x8ea2, 0x8ea7, 0x8ea9, 0x8ead, 0x8eae,
    0x8eb3, 0x8eb5, 0x8eba, 0x8ebb, 0x8ec0, 0x8ec1, 0x8ec3, 0x8ec4, 0x8ec7, 0x8ecf, 0x8ed1, 0x8ed4, 0x8edc, 0x8ee8, 0x8eee, 0x8ef0,
    0x8ef1, 0x8ef7, 0x8ef9, 0x8efa, 0x8eed, 0x8f00, 0x8f02, 0x8f07, 0x8f08, 0x8f0f, 0x8f10, 0x8f16, 0x8f17, 0x8f18, 0x8f1e, 0x8f20,
    0x8f21, 0x8f23, 0x8f25, 0x8f27, 0x8f28, 0x8f2c, 0x8f2d, 0x8f2e, 0x8f34, 0x8f35, 0x8f36, 0x8f37, 0x8f3a, 0x8f40, 0x8f41,

    /* 0x8f 0xe1: 0xa1 - 0xfe */
            0x8f43, 0x8f47, 0x8f4f, 0x8f51, 0x8f52, 0x8f53, 0x8f54, 0x8f55, 0x8f58, 0x8f5d, 0x8f5e, 0x8f65, 0x8f9d, 0x8fa0, 0x8fa1,
    0x8fa4, 0x8fa5, 0x8fa6, 0x8fb5, 0x8fb6, 0x8fb8, 0x8fbe, 0x8fc0, 0x8fc1, 0x8fc6, 0x8fca, 0x8fcb, 0x8fcd, 0x8fd0, 0x8fd2, 0x8fd3,
    0x8fd5, 0x8fe0, 0x8fe3, 0x8fe4, 0x8fe8, 0x8fee, 0x8ff1, 0x8ff5, 0x8ff6, 0x8ffb, 0x8ffe, 0x9002, 0x9004, 0x9008, 0x900c, 0x9018,
    0x901b, 0x9028, 0x9029, 0x902f, 0x902a, 0x902c, 0x902d, 0x9033, 0x9034, 0x9037, 0x903f, 0x9043, 0x9044, 0x904c, 0x905b, 0x905d,
    0x9062, 0x9066, 0x9067, 0x906c, 0x9070, 0x9074, 0x9079, 0x9085, 0x9088, 0x908b, 0x908c, 0x908e, 0x9090, 0x9095, 0x9097, 0x9098,
    0x9099, 0x909b, 0x90a0, 0x90a1, 0x90a2, 0x90a5, 0x90b0, 0x90b2, 0x90b3, 0x90b4, 0x90b6, 0x90bd, 0x90cc, 0x90be, 0x90c3,

    /* 0x8f 0xe2: 0xa1 - 0xfe */
            0x90c4, 0x90c5, 0x90c7, 0x90c8, 0x90d5, 0x90d7, 0x90d8, 0x90d9, 0x90dc, 0x90dd, 0x90df, 0x90e5, 0x90d2, 0x90f6, 0x90eb,
    0x90ef, 0x90f0, 0x90f4, 0x90fe, 0x90ff, 0x9100, 0x9104, 0x9105, 0x9106, 0x9108, 0x910d, 0x9110, 0x9114, 0x9116, 0x9117, 0x9118,
    0x911a, 0x911c, 0x911e, 0x9120, 0x9125, 0x9122, 0x9123, 0x9127, 0x9129, 0x912e, 0x912f, 0x9131, 0x9134, 0x9136, 0x9137, 0x9139,
    0x913a, 0x913c, 0x913d, 0x9143, 0x9147, 0x9148, 0x914f, 0x9153, 0x9157, 0x9159, 0x915a, 0x915b, 0x9161, 0x9164, 0x9167, 0x916d,
    0x9174, 0x9179, 0x917a, 0x917b, 0x9181, 0x9183, 0x9185, 0x9186, 0x918a, 0x918e, 0x9191, 0x9193, 0x9194, 0x9195, 0x9198, 0x919e,
    0x91a1, 0x91a6, 0x91a8, 0x91ac, 0x91ad, 0x91ae, 0x91b0, 0x91b1, 0x91b2, 0x91b3, 0x91b6, 0x91bb, 0x91bc, 0x91bd, 0x91bf,

    /* 0x8f 0xe3: 0xa1 - 0xfe */
            0x91c2, 0x91c3, 0x91c5, 0x91d3, 0x91d4, 0x91d7, 0x91d9, 0x91da, 0x91de, 0x91e4, 0x91e5, 0x91e9, 0x91ea, 0x91ec, 0x91ed,
    0x91ee, 0x91ef, 0x91f0, 0x91f1, 0x91f7, 0x91f9, 0x91fb, 0x91fd, 0x9200, 0x9201, 0x9204, 0x9205, 0x9206, 0x9207, 0x9209, 0x920a,
    0x920c, 0x9210, 0x9212, 0x9213, 0x9216, 0x9218, 0x921c, 0x921d, 0x9223, 0x9224, 0x9225, 0x9226, 0x9228, 0x922e, 0x922f, 0x9230,
    0x9233, 0x9235, 0x9236, 0x9238, 0x9239, 0x923a, 0x923c, 0x923e, 0x9240, 0x9242, 0x9243, 0x9246, 0x9247, 0x924a, 0x924d, 0x924e,
    0x924f, 0x9251, 0x9258, 0x9259, 0x925c, 0x925d, 0x9260, 0x9261, 0x9265, 0x9267, 0x9268, 0x9269, 0x926e, 0x926f, 0x9270, 0x9275,
    0x9276, 0x9277, 0x9278, 0x9279, 0x927b, 0x927c, 0x927d, 0x927f, 0x9288, 0x9289, 0x928a, 0x928d, 0x928e, 0x9292, 0x9297,

    /* 0x8f 0xe4: 0xa1 - 0xfe */
            0x9299, 0x929f, 0x92a0, 0x92a4, 0x92a5, 0x92a7, 0x92a8, 0x92ab, 0x92af, 0x92b2, 0x92b6, 0x92b8, 0x92ba, 0x92bb, 0x92bc,
    0x92bd, 0x92bf, 0x92c0, 0x92c1, 0x92c2, 0x92c3, 0x92c5, 0x92c6, 0x92c7, 0x92c8, 0x92cb, 0x92cc, 0x92cd, 0x92ce, 0x92d0, 0x92d3,
    0x92d5, 0x92d7, 0x92d8, 0x92d9, 0x92dc, 0x92dd, 0x92df, 0x92e0, 0x92e1, 0x92e3, 0x92e5, 0x92e7, 0x92e8, 0x92ec, 0x92ee, 0x92f0,
    0x92f9, 0x92fb, 0x92ff, 0x9300, 0x9302, 0x9308, 0x930d, 0x9311, 0x9314, 0x9315, 0x931c, 0x931d, 0x931e, 0x931f, 0x9321, 0x9324,
    0x9325, 0x9327, 0x9329, 0x932a, 0x9333, 0x9334, 0x9336, 0x9337, 0x9347, 0x9348, 0x9349, 0x9350, 0x9351, 0x9352, 0x9355, 0x9357,
    0x9358, 0x935a, 0x935e, 0x9364, 0x9365, 0x9367, 0x9369, 0x936a, 0x936d, 0x936f, 0x9370, 0x9371, 0x9373, 0x9374, 0x9376,

    /* 0x8f 0xe5: 0xa1 - 0xfe */
            0x937a, 0x937d, 0x937f, 0x9380, 0x9381, 0x9382, 0x9388, 0x938a, 0x938b, 0x938d, 0x938f, 0x9392, 0x9395, 0x9398, 0x939b,
    0x939e, 0x93a1, 0x93a3, 0x93a4, 0x93a6, 0x93a8, 0x93ab, 0x93b4, 0x93b5, 0x93b6, 0x93ba, 0x93a9, 0x93c1, 0x93c4, 0x93c5, 0x93c6,
    0x93c7, 0x93c9, 0x93ca, 0x93cb, 0x93cc, 0x93cd, 0x93d3, 0x93d9, 0x93dc, 0x93de, 0x93df, 0x93e2, 0x93e6, 0x93e7, 0x93f9, 0x93f7,
    0x93f8, 0x93fa, 0x93fb, 0x93fd, 0x9401, 0x9402, 0x9404, 0x9408, 0x9409, 0x940d, 0x940e, 0x940f, 0x9415, 0x9416, 0x9417, 0x941f,
    0x942e, 0x942f, 0x9431, 0x9432, 0x9433, 0x9434, 0x943b, 0x943f, 0x943d, 0x9443, 0x9445, 0x9448, 0x944a, 0x944c, 0x9455, 0x9459,
    0x945c, 0x945f, 0x9461, 0x9463, 0x9468, 0x946b, 0x946d, 0x946e, 0x946f, 0x9471, 0x9472, 0x9484, 0x9483, 0x9578, 0x9579,

    /* 0x8f 0xe6: 0xa1 - 0xfe */
            0x957e, 0x9584, 0x9588, 0x958c, 0x958d, 0x958e, 0x959d, 0x959e, 0x959f, 0x95a1, 0x95a6, 0x95a9, 0x95ab, 0x95ac, 0x95b4,
    0x95b6, 0x95ba, 0x95bd, 0x95bf, 0x95c6, 0x95c8, 0x95c9, 0x95cb, 0x95d0, 0x95d1, 0x95d2, 0x95d3, 0x95d9, 0x95da, 0x95dd, 0x95de,
    0x95df, 0x95e0, 0x95e4, 0x95e6, 0x961d, 0x961e, 0x9622, 0x9624, 0x9625, 0x9626, 0x962c, 0x9631, 0x9633, 0x9637, 0x9638, 0x9639,
    0x963a, 0x963c, 0x963d, 0x9641, 0x9652, 0x9654, 0x9656, 0x9657, 0x9658, 0x9661, 0x966e, 0x9674, 0x967b, 0x967c, 0x967e, 0x967f,
    0x9681, 0x9682, 0x9683, 0x9684, 0x9689, 0x9691, 0x9696, 0x969a, 0x969d, 0x969f, 0x96a4, 0x96a5, 0x96a6, 0x96a9, 0x96ae, 0x96af,
    0x96b3, 0x96ba, 0x96ca, 0x96d2, 0x5db2, 0x96d8, 0x96da, 0x96dd, 0x96de, 0x96df, 0x96e9, 0x96ef, 0x96f1, 0x96fa, 0x9702,

    /* 0x8f 0xe7: 0xa1 - 0xfe */
            0x9703, 0x9705, 0x9709, 0x971a, 0x971b, 0x971d, 0x9721, 0x9722, 0x9723, 0x9728, 0x9731, 0x9733, 0x9741, 0x9743, 0x974a,
    0x974e, 0x974f, 0x9755, 0x9757, 0x9758, 0x975a, 0x975b, 0x9763, 0x9767, 0x976a, 0x976e, 0x9773, 0x9776, 0x9777, 0x9778, 0x977b,
    0x977d, 0x977f, 0x9780, 0x9789, 0x9795, 0x9796, 0x9797, 0x9799, 0x979a, 0x979e, 0x979f, 0x97a2, 0x97ac, 0x97ae, 0x97b1, 0x97b2,
    0x97b5, 0x97b6, 0x97b8, 0x97b9, 0x97ba, 0x97bc, 0x97be, 0x97bf, 0x97c1, 0x97c4, 0x97c5, 0x97c7, 0x97c9, 0x97ca, 0x97cc, 0x97cd,
    0x97ce, 0x97d0, 0x97d1, 0x97d4, 0x97d7, 0x97d8, 0x97d9, 0x97dd, 0x97de, 0x97e0, 0x97db, 0x97e1, 0x97e4, 0x97ef, 0x97f1, 0x97f4,
    0x97f7, 0x97f8, 0x97fa, 0x9807, 0x980a, 0x9819, 0x980d, 0x980e, 0x9814, 0x9816, 0x981c, 0x981e, 0x9820, 0x9823, 0x9826,

    /* 0x8f 0xe8: 0xa1 - 0xfe */
            0x982b, 0x982e, 0x982f, 0x9830, 0x9832, 0x9833, 0x9835, 0x9825, 0x983e, 0x9844, 0x9847, 0x984a, 0x9851, 0x9852, 0x9853,
    0x9856, 0x9857, 0x9859, 0x985a, 0x9862, 0x9863, 0x9865, 0x9866, 0x986a, 0x986c, 0x98ab, 0x98ad, 0x98ae, 0x98b0, 0x98b4, 0x98b7,
    0x98b8, 0x98ba, 0x98bb, 0x98bf, 0x98c2, 0x98c5, 0x98c8, 0x98cc, 0x98e1, 0x98e3, 0x98e5, 0x98e6, 0x98e7, 0x98ea, 0x98f3, 0x98f6,
    0x9902, 0x9907, 0x9908, 0x9911, 0x9915, 0x9916, 0x9917, 0x991a, 0x991b, 0x991c, 0x991f, 0x9922, 0x9926, 0x9927, 0x992b, 0x9931,
    0x9932, 0x9933, 0x9934, 0x9935, 0x9939, 0x993a, 0x993b, 0x993c, 0x9940, 0x9941, 0x9946, 0x9947, 0x9948, 0x994d, 0x994e, 0x9954,
    0x9958, 0x9959, 0x995b, 0x995c, 0x995e, 0x995f, 0x9960, 0x999b, 0x999d, 0x999f, 0x99a6, 0x99b0, 0x99b1, 0x99b2, 0x99b5,

    /* 0x8f 0xe9: 0xa1 - 0xfe */
            0x99b9, 0x99ba, 0x99bd, 0x99bf, 0x99c3, 0x99c9, 0x99d3, 0x99d4, 0x99d9, 0x99da, 0x99dc, 0x99de, 0x99e7, 0x99ea, 0x99eb,
    0x99ec, 0x99f0, 0x99f4, 0x99f5, 0x99f9, 0x99fd, 0x99fe, 0x9a02, 0x9a03, 0x9a04, 0x9a0b, 0x9a0c, 0x9a10, 0x9a11, 0x9a16, 0x9a1e,
    0x9a20, 0x9a22, 0x9a23, 0x9a24, 0x9a27, 0x9a2d, 0x9a2e, 0x9a33, 0x9a35, 0x9a36, 0x9a38, 0x9a47, 0x9a41, 0x9a44, 0x9a4a, 0x9a4b,
    0x9a4c, 0x9a4e, 0x9a51, 0x9a54, 0x9a56, 0x9a5d, 0x9aaa, 0x9aac, 0x9aae, 0x9aaf, 0x9ab2, 0x9ab4, 0x9ab5, 0x9ab6, 0x9ab9, 0x9abb,
    0x9abe, 0x9abf, 0x9ac1, 0x9ac3, 0x9ac6, 0x9ac8, 0x9ace, 0x9ad0, 0x9ad2, 0x9ad5, 0x9ad6, 0x9ad7, 0x9adb, 0x9adc, 0x9ae0, 0x9ae4,
    0x9ae5, 0x9ae7, 0x9ae9, 0x9aec, 0x9af2, 0x9af3, 0x9af5, 0x9af9, 0x9afa, 0x9afd, 0x9aff, 0x9b00, 0x9b01, 0x9b02, 0x9b03,

    /* 0x8f 0xea: 0xa1 - 0xfe */
            0x9b04, 0x9b05, 0x9b08, 0x9b09, 0x9b0b, 0x9b0c, 0x9b0d, 0x9b0e, 0x9b10, 0x9b12, 0x9b16, 0x9b19, 0x9b1b, 0x9b1c, 0x9b20,
    0x9b26, 0x9b2b, 0x9b2d, 0x9b33, 0x9b34, 0x9b35, 0x9b37, 0x9b39, 0x9b3a, 0x9b3d, 0x9b48, 0x9b4b, 0x9b4c, 0x9b55, 0x9b56, 0x9b57,
    0x9b5b, 0x9b5e, 0x9b61, 0x9b63, 0x9b65, 0x9b66, 0x9b68, 0x9b6a, 0x9b6b, 0x9b6c, 0x9b6d, 0x9b6e, 0x9b73, 0x9b75, 0x9b77, 0x9b78,
    0x9b79, 0x9b7f, 0x9b80, 0x9b84, 0x9b85, 0x9b86, 0x9b87, 0x9b89, 0x9b8a, 0x9b8b, 0x9b8d, 0x9b8f, 0x9b90, 0x9b94, 0x9b9a, 0x9b9d,
    0x9b9e, 0x9ba6, 0x9ba7, 0x9ba9, 0x9bac, 0x9bb0, 0x9bb1, 0x9bb2, 0x9bb7, 0x9bb8, 0x9bbb, 0x9bbc, 0x9bbe, 0x9bbf, 0x9bc1, 0x9bc7,
    0x9bc8, 0x9bce, 0x9bd0, 0x9bd7, 0x9bd8, 0x9bdd, 0x9bdf, 0x9be5, 0x9be7, 0x9bea, 0x9beb, 0x9bef, 0x9bf3, 0x9bf7, 0x9bf8,

    /* 0x8f 0xeb: 0xa1 - 0xfe */
            0x9bf9, 0x9bfa, 0x9bfd, 0x9bff, 0x9c00, 0x9c02, 0x9c0b, 0x9c0f, 0x9c11, 0x9c16, 0x9c18, 0x9c19, 0x9c1a, 0x9c1c, 0x9c1e,
    0x9c22, 0x9c23, 0x9c26, 0x9c27, 0x9c28, 0x9c29, 0x9c2a, 0x9c31, 0x9c35, 0x9c36, 0x9c37, 0x9c3d, 0x9c41, 0x9c43, 0x9c44, 0x9c45,
    0x9c49, 0x9c4a, 0x9c4e, 0x9c4f, 0x9c50, 0x9c53, 0x9c54, 0x9c56, 0x9c58, 0x9c5b, 0x9c5d, 0x9c5e, 0x9c5f, 0x9c63, 0x9c69, 0x9c6a,
    0x9c5c, 0x9c6b, 0x9c68, 0x9c6e, 0x9c70, 0x9c72, 0x9c75, 0x9c77, 0x9c7b, 0x9ce6, 0x9cf2, 0x9cf7, 0x9cf9, 0x9d0b, 0x9d02, 0x9d11,
    0x9d17, 0x9d18, 0x9d1c, 0x9d1d, 0x9d1e, 0x9d2f, 0x9d30, 0x9d32, 0x9d33, 0x9d34, 0x9d3a, 0x9d3c, 0x9d45, 0x9d3d, 0x9d42, 0x9d43,
    0x9d47, 0x9d4a, 0x9d53, 0x9d54, 0x9d5f, 0x9d63, 0x9d62, 0x9d65, 0x9d69, 0x9d6a, 0x9d6b, 0x9d70, 0x9d76, 0x9d77, 0x9d7b,

    /* 0x8f 0xec: 0xa1 - 0xfe */
            0x9d7c, 0x9d7e, 0x9d83, 0x9d84, 0x9d86, 0x9d8a, 0x9d8d, 0x9d8e, 0x9d92, 0x9d93, 0x9d95, 0x9d96, 0x9d97, 0x9d98, 0x9da1,
    0x9daa, 0x9dac, 0x9dae, 0x9db1, 0x9db5, 0x9db9, 0x9dbc, 0x9dbf, 0x9dc3, 0x9dc7, 0x9dc9, 0x9dca, 0x9dd4, 0x9dd5, 0x9dd6, 0x9dd7,
    0x9dda, 0x9dde, 0x9ddf, 0x9de0, 0x9de5, 0x9de7, 0x9de9, 0x9deb, 0x9dee, 0x9df0, 0x9df3, 0x9df4, 0x9dfe, 0x9e0a, 0x9e02, 0x9e07,
    0x9e0e, 0x9e10, 0x9e11, 0x9e12, 0x9e15, 0x9e16, 0x9e19, 0x9e1c, 0x9e1d, 0x9e7a, 0x9e7b, 0x9e7c, 0x9e80, 0x9e82, 0x9e83, 0x9e84,
    0x9e85, 0x9e87, 0x9e8e, 0x9e8f, 0x9e96, 0x9e98, 0x9e9b, 0x9e9e, 0x9ea4, 0x9ea8, 0x9eac, 0x9eae, 0x9eaf, 0x9eb0, 0x9eb3, 0x9eb4,
    0x9eb5, 0x9ec6, 0x9ec8, 0x9ecb, 0x9ed5, 0x9edf, 0x9ee4, 0x9ee7, 0x9eec, 0x9eed, 0x9eee, 0x9ef0, 0x9ef1, 0x9ef2, 0x9ef5,

    /* 0x8f 0xed: 0xa1 - 0xe3 */
            0x9ef8, 0x9eff, 0x9f02, 0x9f03, 0x9f09, 0x9f0f, 0x9f10, 0x9f11, 0x9f12, 0x9f14, 0x9f16, 0x9f17, 0x9f19, 0x9f1a, 0x9f1b,
    0x9f1f, 0x9f22, 0x9f26, 0x9f2a, 0x9f2b, 0x9f2f, 0x9f31, 0x9f32, 0x9f34, 0x9f37, 0x9f39, 0x9f3a, 0x9f3c, 0x9f3d, 0x9f3f, 0x9f41,
    0x9f43, 0x9f44, 0x9f45, 0x9f46, 0x9f47, 0x9f53, 0x9f55, 0x9f56, 0x9f57, 0x9f58, 0x9f5a, 0x9f5d, 0x9f5e, 0x9f68, 0x9f69, 0x9f6d,
    0x9f6e, 0x9f6f, 0x9f70, 0x9f71, 0x9f73, 0x9f75, 0x9f7a, 0x9f7d, 0x9f8f, 0x9f90, 0x9f91, 0x9f92, 0x9f94, 0x9f96, 0x9f97, 0x9f9e,
    0x9fa1, 0x9fa2, 0x9fa3, 0x9fa5,
};
static const struct jis_charmap __euc_jp_jis_x0213_map[] = {
    { .first = 0xaf, .last = 0xf1, .offset =     0 }, /* 0xa2 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa3 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa4 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa5 */
    { .first = 0xe1, .last = 0xfc, .offset =    67 }, /* 0xa6 */
    { .first = 0xc2, .last = 0xfe, .offset =    95 }, /* 0xa7 */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xa8 */
    { .first = 0xa1, .last = 0xd0, .offset =   156 }, /* 0xa9 */
    { .first = 0xa1, .last = 0xf7, .offset =   204 }, /* 0xaa */
    { .first = 0xa1, .last = 0xf7, .offset =   291 }, /* 0xab */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xac */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xad */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xae */
    { .first = 0x01, .last = 0x00, .offset = 0xffff }, /* 0xaf */
    { .first = 0xa1, .last = 0xfe, .offset =   378 }, /* 0xb0 */
    { .first = 0xa1, .last = 0xfe, .offset =   472 }, /* 0xb1 */
    { .first = 0xa1, .last = 0xfe, .offset =   566 }, /* 0xb2 */
    { .first = 0xa1, .last = 0xfe, .offset =   660 }, /* 0xb3 */
    { .first = 0xa1, .last = 0xfe, .offset =   754 }, /* 0xb4 */
    { .first = 0xa1, .last = 0xfe, .offset =   848 }, /* 0xb5 */
    { .first = 0xa1, .last = 0xfe, .offset =   942 }, /* 0xb6 */
    { .first = 0xa1, .last = 0xfe, .offset =  1036 }, /* 0xb7 */
    { .first = 0xa1, .last = 0xfe, .offset =  1130 }, /* 0xb8 */
    { .first = 0xa1, .last = 0xfe, .offset =  1224 }, /* 0xb9 */
    { .first = 0xa1, .last = 0xfe, .offset =  1318 }, /* 0xba */
    { .first = 0xa1, .last = 0xfe, .offset =  1412 }, /* 0xbb */
    { .first = 0xa1, .last = 0xfe, .offset =  1506 }, /* 0xbc */
    { .first = 0xa1, .last = 0xfe, .offset =  1600 }, /* 0xbd */
    { .first = 0xa1, .last = 0xfe, .offset =  1694 }, /* 0xbe */
    { .first = 0xa1, .last = 0xfe, .offset =  1788 }, /* 0xbf */
    { .first = 0xa1, .last = 0xfe, .offset =  1882 }, /* 0xc0 */
    { .first = 0xa1, .last = 0xfe, .offset =  1976 }, /* 0xc1 */
    { .first = 0xa1, .last = 0xfe, .offset =  2070 }, /* 0xc2 */
    { .first = 0xa1, .last = 0xfe, .offset =  2164 }, /* 0xc3 */
    { .first = 0xa1, .last = 0xfe, .offset =  2258 }, /* 0xc4 */
    { .first = 0xa1, .last = 0xfe, .offset =  2352 }, /* 0xc5 */
    { .first = 0xa1, .last = 0xfe, .offset =  2446 }, /* 0xc6 */
    { .first = 0xa1, .last = 0xfe, .offset =  2540 }, /* 0xc7 */
    { .first = 0xa1, .last = 0xfe, .offset =  2634 }, /* 0xc8 */
    { .first = 0xa1, .last = 0xfe, .offset =  2728 }, /* 0xc9 */
    { .first = 0xa1, .last = 0xfe, .offset =  2822 }, /* 0xca */
    { .first = 0xa1, .last = 0xfe, .offset =  2916 }, /* 0xcb */
    { .first = 0xa1, .last = 0xfe, .offset =  3010 }, /* 0xcc */
    { .first = 0xa1, .last = 0xfe, .offset =  3104 }, /* 0xcd */
    { .first = 0xa1, .last = 0xfe, .offset =  3198 }, /* 0xce */
    { .first = 0xa1, .last = 0xfe, .offset =  3292 }, /* 0xcf */
    { .first = 0xa1, .last = 0xfe, .offset =  3386 }, /* 0xd0 */
    { .first = 0xa1, .last = 0xfe, .offset =  3480 }, /* 0xd1 */
    { .first = 0xa1, .last = 0xfe, .offset =  3574 }, /* 0xd2 */
    { .first = 0xa1, .last = 0xfe, .offset =  3668 }, /* 0xd3 */
    { .first = 0xa1, .last = 0xfe, .offset =  3762 }, /* 0xd4 */
    { .first = 0xa1, .last = 0xfe, .offset =  3856 }, /* 0xd5 */
    { .first = 0xa1, .last = 0xfe, .offset =  3950 }, /* 0xd6 */
    { .first = 0xa1, .last = 0xfe, .offset =  4044 }, /* 0xd7 */
    { .first = 0xa1, .last = 0xfe, .offset =  4138 }, /* 0xd8 */
    { .first = 0xa1, .last = 0xfe, .offset =  4232 }, /* 0xd9 */
    { .first = 0xa1, .last = 0xfe, .offset =  4326 }, /* 0xda */
    { .first = 0xa1, .last = 0xfe, .offset =  4420 }, /* 0xdb */
    { .first = 0xa1, .last = 0xfe, .offset =  4514 }, /* 0xdc */
    { .first = 0xa1, .last = 0xfe, .offset =  4608 }, /* 0xdd */
    { .first = 0xa1, .last = 0xfe, .offset =  4702 }, /* 0xde */
    { .first = 0xa1, .last = 0xfe, .offset =  4796 }, /* 0xdf */
    { .first = 0xa1, .last = 0xfe, .offset =  4890 }, /* 0xe0 */
    { .first = 0xa1, .last = 0xfe, .offset =  4984 }, /* 0xe1 */
    { .first = 0xa1, .last = 0xfe, .offset =  5078 }, /* 0xe2 */
    { .first = 0xa1, .last = 0xfe, .offset =  5172 }, /* 0xe3 */
    { .first = 0xa1, .last = 0xfe, .offset =  5266 }, /* 0xe4 */
    { .first = 0xa1, .last = 0xfe, .offset =  5360 }, /* 0xe5 */
    { .first = 0xa1, .last = 0xfe, .offset =  5454 }, /* 0xe6 */
    { .first = 0xa1, .last = 0xfe, .offset =  5548 }, /* 0xe7 */
    { .first = 0xa1, .last = 0xfe, .offset =  5642 }, /* 0xe8 */
    { .first = 0xa1, .last = 0xfe, .offset =  5736 }, /* 0xe9 */
    { .first = 0xa1, .last = 0xfe, .offset =  5830 }, /* 0xea */
    { .first = 0xa1, .last = 0xfe, .offset =  5924 }, /* 0xeb */
    { .first = 0xa1, .last = 0xfe, .offset =  6018 }, /* 0xec */
    { .first = 0xa1, .last = 0xe3, .offset =  6112 }, /* 0xed */
};
#endif /* jis_x0213 */

#endif /* _JIS_CHARSETS_H_ */
