% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{delete_part}
\alias{delete_part}
\title{Delete flextable part}
\usage{
delete_part(x, part = "header")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}
}
\description{
indicate to not print a part of
the flextable, i.e. an header, footer or the body.
}
\examples{
ft <- flextable(head(iris))
ft <- delete_part(x = ft, part = "header")
ft
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
