//! A prelude module for ergonomic imports.
//!
//! This module provides commonly used types and traits from the indieweb crate.
//! Include this in your code to avoid typing long import paths.
//!
//! # Example
//!
//! ```rust
//! use indieweb::prelude::*;
//!
//! fn example() -> Result<(), Error> {
//!     // Use Error, Result, Client, etc. directly
//!     Ok(())
//! }
//! ```

// Core types
pub use crate::error::Error;
pub use crate::http::Client;
pub use crate::Result;

// Microformats types (commonly used with this library)
pub use crate::mf2::types::{Document, Item, PropertyValue};
pub use crate::mf2::parse as parser;

// Common types from algorithms
pub use crate::algorithms::Properties;
pub use crate::algorithms::ptd::Type as PostType;

// Common types from standards - IndieAuth
pub use crate::standards::indieauth::{AccessToken, Scope, Scopes};
pub use crate::standards::indieauth::EndpointDiscovery;
pub use crate::standards::indieauth::Client as IndieAuthClient;

// Common types from standards - Micropub
pub use crate::standards::micropub::Parameters;
pub use crate::standards::micropub::action::Action;
pub use crate::standards::micropub::action::ActionResponse;
pub use crate::standards::micropub::query::{Query, Response as MicropubQueryResponse};

// Common types from standards - Webmention
pub use crate::standards::webmention::{endpoint_for, send, Request, Response, Status};
pub use crate::standards::webmention::Relationship;
